#include <QDebug>
#include <QGraphicsScene>
#include <QGraphicsSceneMouseEvent>
#include <QPainter>

#include "mapelement.h"
#include "maproute.h"
#include "mapnode.h"
#include "mapedge.h"
#include "mapview.h"

TMapElement::TMapElement(ElementType type,QRectF rect,QString text)
{
 eType=type;
 eRect=rect;
 setZValue(1);
 FadeOpacity=0.6;
 //if(type==elScreen) setEnabled(0);

// setAcceptHoverEvents(0);
// setAcceptTouchEvents(0);
// setAcceptedMouseButtons(0);

}

QRectF TMapElement::boundingRect() const
{
 return eRect;
}

int TMapElement::type() const
{ return eType; }

//void TMapElement::mousePressEvent(QGraphicsSceneMouseEvent *event)
//{

// QGraphicsItem::mousePressEvent(event);
//}


void TMapElement::paint(QPainter *p, const QStyleOptionGraphicsItem *option, QWidget *widget)
{

 switch(eType)
 {
  case elFade:
  {
//   QList<TPaintCmd> paintTrack;
   TMapView *map=(TMapView*)scene()->parent();

   // fade rect
   p->setOpacity(FadeOpacity);
   p->setPen(Qt::NoPen);
   p->setBrush(map->params.mapColorBack);
   p->drawRect(eRect);

   // draw stroking track
   p->translate(QPoint(100,100)); // fade screen rect more than scene rect
   p->setOpacity(1);

   if(map->selectedNode.count()) // nodes
   {
    int width=map->params.nodeWidth*1.3;
    p->setPen(Qt::NoPen);
    p->setBrush(Qt::black);
    foreach(TMapNode *node,map->selectedNode)
      p->drawEllipse(node->pos(),width,width);
   }

   if(map->selectedEdge.count()) // edges
   {
    QPainterPath tPath;
    QColor color=QColor(0,0,0,0);
    int width;
    p->setBrush(Qt::NoBrush);
    foreach(TMapEdge *edge, map->selectedEdge)
     if(edge->type==TMapEdge::etTransfer)
     {
      qreal w=map->params.routeWidth/1.7;
      tPath.addEllipse(edge->node[0]->pos(),w,w);
      tPath.addEllipse(edge->node[1]->pos(),w,w);
      tPath.addPath(edge->path);
     }

    // black border for transfers
    p->setPen(QPen(Qt::black,map->params.routeWidth*1.5,Qt::SolidLine,Qt::FlatCap,Qt::RoundJoin));
    p->drawPath(tPath);
    foreach(TMapEdge *edge, map->selectedEdge)
    {
     if(edge->route && edge->type!=TMapEdge::etTransfer)
     {
      color=edge->route->color;
      width=edge->route->width;
     }
     else continue;

     // black border for lines
     p->setPen(QPen(Qt::black,width*1.3,Qt::SolidLine,Qt::FlatCap,Qt::RoundJoin));
     p->drawPath(edge->path);
     p->setPen(QPen(color,width,Qt::SolidLine,Qt::FlatCap,Qt::RoundJoin));
     p->drawPath(edge->path);
     //qDebug() << edge->node[0]->ID << edge->node[1]->ID;
    }
    p->setPen(QPen(map->params.mapColorBack.lighter(150),map->params.routeWidth*1.2,Qt::SolidLine,Qt::FlatCap,Qt::MiterJoin));
    p->drawPath(tPath);
   }

   break;
  }
 }

}
