#include <QDebug>
#include <QSettings>
#include <QFileDialog>
#include <QKeyEvent>
#include <QMessageBox>

#include <QTranslator>
#include <QLocale>
#include <QLibraryInfo>
#include <QDir>

#include "ui_mainwindow.h"
#include "mainwindow.h"
#include "ui_settings.h"
#include "settings.h"
#include "ui_details.h"
#include "details.h"
#include "about.h"

#include "mapview/mapview.h"
#include "mapview/mapnode.h"
#include "completer.h"
#include "mobileui.h"
#include "flickcharm.h"

//#if defined(Q_WS_MAEMO_5)
//#include "fullscreenexitbutton.h"
//#endif

QString VERSION=" 0.5.1";
QString URL_MAPS="http://pmetro.su/Maps.html";
QString URL_TRANSLATE="http://translate.google.com/translate?sl=ru&tl=%1&u=%2";

char ICONSIZE=24; // begin size 100% scale
QString TOOLBAR_STYLE=
  "QToolButton,QToolButton:pressed,QLabel,QLineEdit{border:2px solid grey;border-radius:5px;background-color:qlineargradient(x1:0,y1:0,x2:0,y2:1,stop:0 #dadbde,stop:1 #f6f7fa);} "
  "QToolButton{height:%1px;width:%1px;background-color:transparent;margin-top:4px;margin-left:4px;} "
  "QToolButton:pressed{margin-top:5px;margin-left:5px;} "
  "QLabel{color:black;font-weight:bold;padding:2px;} "
  "QLineEdit{height:%1px;font-weight:bold;margin-top:2px;margin-left:2px;} ";

MainWindow *mainWnd;

FlickCharm charm;

IniSettingMap AppConfig;

QString appPath, appConfigFile, cachePath;

QTranslator appTranslator;

extern QTime testTimer;

QVector <QString> IniGroupStr;
QVector <QString> IniKeyStr;

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent), ui(new Ui::MainWindow),Completer(NULL),SettingWindow(NULL)
{
#if defined(Q_OS_WINCE) || defined(Q_OS_SYMBIAN) || defined(Q_WS_MAEMO_5) || defined(Q_OS_ANDROID)
 MobileVersion=1;
#else
 MobileVersion=0;
#endif

 //MobileVersion=1;
 mainWnd=this;
 IniGroupStr << "MapView"<<"Main"<<"Other";
 IniKeyStr << "StationCustomFont"<<"StationFont"<<"StationBack"<<"StationShadow"<<"StationBackColor"<<"StationShadowColor"<<
              "StationUpperCase"<<"StationWordWrap"<<"StationTransparency"<<
              "MapShowScrollbar"<<"WindowFullScreen"<<"MapShowTime"<<"MapShowBackground"<<"MapAntialiasing"<<"MapFastScrolling"<<
              "MapBackColor"<<"MapSimpleTransfers"<<"MapCleanCache"<<"MapLastFile"<<"MapCaching"<<"UiScale";


 Config.appFont=qApp->font();
 appPath=qApp->applicationDirPath()+"/";
 appConfigFile=cachePath="";
#ifdef Q_WS_MAEMO_5
 setAttribute(Qt::WA_Maemo5AutoOrientation);
 setAttribute(Qt::WA_Maemo5StackedWindow);
 appPath="/home/user/MyDocs/Data/qMetro/";
 cachePath=appPath+".cache/";
 appConfigFile="/home/user/qMetro.ini";
 ICONSIZE=64;
#endif
#ifdef Q_OS_ANDROID
 appPath="/sdcard/Android/data/qMetro/";
 cachePath=appPath+".cache/";
 setScaleForUi(2.6);
#endif
#ifdef Q_OS_SYMBIAN
 appPath="e:/Data/qMetro/";
 ICONSIZE=48;
#endif

 if(appConfigFile.isEmpty()) appConfigFile=appPath+"config.ini";
 if(cachePath.isEmpty()) cachePath=appPath+"cache/";
 Config.appIconSize=ICONSIZE;

 QSettings *ini=new QSettings(appConfigFile,QSettings::IniFormat);
 QString key;
 ini->beginGroup("Main");
 Config.locale=ini->value("Locale","").toString();
 Config.dockWidth=ini->value("DockWidth",0).toInt();
 key="MapZoomFactor";
 Config.mapZoomFactor=ini->value(key).toFloat();
 Config.mapZoomFactorCheck=ini->contains(key);
 key="MapPosition";
 Config.mapPosition=ini->value(key).toPoint();
 Config.mapPositionCheck=ini->contains(key);
 key="Mobile";
 if(ini->contains(key)) MobileVersion=ini->value(key).toInt();
 key="Font";
 if(ini->contains(key))
 {
  Config.appFont.fromString(ini->value(key).toString());
  qApp->setFont(Config.appFont);
 }
 TOOLBAR_STYLE=ini->value("Styles",TOOLBAR_STYLE).toString();

 if(Config.locale.isEmpty()) Config.locale=QLocale::system().name().section("_",0,0);


 ui->setupUi(this);

 ui->mSaveScale->setChecked(Config.mapZoomFactorCheck);
 ui->mSavePosition->setChecked(Config.mapPositionCheck);
 if(!Config.dockWidth) Config.dockWidth=ui->dock->width();
 ui->dock->setVisible(0);
 //ui->eSearch->setText(tr("Find"));
 //ui->eSearch->installEventFilter(this);

 setWindowTitle(windowTitle()+VERSION);

 toggleLang(Config.locale);
 map = new TMapView(appPath,cachePath);
 map->config.MobileVersion=MobileVersion;
 map->config.locale=Config.locale;
 //if(MobileVersion) map->setStyleSheet(TOOLBAR_STYLE.arg(Config.appIconSize));

 connect(map,SIGNAL(trackText(QString)),ui->textDescription,SLOT(setText(QString)));
 if(!MobileVersion)
   connect(map,SIGNAL(trackFinded(bool)),ui->mFind,SLOT(setChecked(bool)));
 connect(map,SIGNAL(delayNames(QStringList)),this,SLOT(setDelayNames(QStringList)));

 //map->config.enableCaching=1;
 Config.mapKineticScrollCheck=0;
 if(Config.mapKineticScrollCheck)
 {
  charm.activateOn(map);
  connect(&charm,SIGNAL(started()),map,SLOT(mapStartDragging()));
  connect(&charm,SIGNAL(finished()),map,SLOT(mapStopDragging()));
 }

 loadSettings();

 ui->toolBar->setIconSize(QSize(Config.appIconSize,Config.appIconSize));
 QSplitter *splitter = new QSplitter;
 splitter->addWidget(ui->dock);
 splitter->addWidget(map);
 splitter->setStretchFactor(0, 0);
 splitter->setStretchFactor(1, 1);
 splitter->setChildrenCollapsible(0);
 splitter->setOpaqueResize(0);
 setCentralWidget(splitter);


#ifdef Q_OS_SYMBIAN
 // Remove context menu from all widgets
 QWidgetList widgets=QApplication::allWidgets();
 QWidget* w=0;
 foreach(w,widgets) w->setContextMenuPolicy(Qt::NoContextMenu);
#endif

#ifdef QT_NO_DEBUG
 ui->menuView->menuAction()->setVisible(0);
 ui->menuInfo->menuAction()->setVisible(0);
 //ui->menuSetting->menuAction()->setVisible(0);
 //ui->menuHelp->addAction(ui->menuLanguage->menuAction());
#endif

 QLabel *label = new QLabel("");
 label->setMinimumWidth(0);
 label->setMinimumHeight(0);
 label->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
 ui->toolBar->addWidget(label);
 ui->toolBar->addAction(ui->mPreference);

 if(MobileVersion)
 {
  setFixedWidth(qApp->desktop()->width());
  setFixedHeight(qApp->desktop()->height());
  mUi = new TMobileUi(this,map);
 }

 ui->dock->resize(QSize(Config.dockWidth,ui->dock->height()));

 if(Config.mapZoomFactorCheck) // first
 {
  map->scaleMap(Config.mapZoomFactor);
  map->centerOn(map->scene->itemsBoundingRect().center());
 }else
  map->fitMap();

 if(Config.mapPositionCheck) // second
 {
  map->horizontalScrollBar()->setValue(Config.mapPosition.x());
  map->verticalScrollBar()->setValue(Config.mapPosition.y());
 }

 if(AppConfig.value(igMain).value(ikWFullScreen).toInt())
      ui->mFullScreen->setChecked(1);
 else showMaximized();

 map->show();

 connect(ui->cbDelay,SIGNAL(currentIndexChanged(int)),map,SLOT(setDelayIndex(int)));
 connect(ui->sbDelay,SIGNAL(valueChanged(int)),map,SLOT(setDelayMetro(int)));

 connect(ui->mZoomIn,SIGNAL(triggered()),map,SLOT(zoomIn()));
 connect(ui->mZoomOut,SIGNAL(triggered()),map,SLOT(zoomOut()));
 connect(ui->mFit,SIGNAL(triggered()),map,SLOT(fitMap()));

 connect(map->nodeAInfo, SIGNAL(triggered()),this, SLOT(nodeInformation()));

 if(map->nodeByID.count()) Completer= new TCompleter(map,ui->eSearch);

 installEventFilter(this);

 QDir localeDir=QDir(appPath+"locale","*.lng",QDir::Name,QDir::Files);
 QStringList langNames=localeDir.entryList();

 langNames.prepend("ru.lng");
 langNames.prepend("en.lng");

 QActionGroup *langGroup = new QActionGroup(ui->menuLanguage);
 QMutableStringListIterator i(langNames);
 while (i.hasNext()) {
  i.next();
  QRegExp rx("(.+)\\.lng");
  rx.indexIn(i.value());
  QLocale locale(rx.cap(1));
  QAction *langAction = new QAction(QLocale::languageToString(locale.language()), this);
  langAction->setCheckable(true);
  if(locale.name().section("_",0,0)==Config.locale) langAction->setChecked(1);
  langAction->setData(locale.name().section("_",0,0));
  ui->menuLanguage->addAction(langAction);
  langGroup->addAction(langAction);
  connect(langAction, SIGNAL(triggered()),this, SLOT(toggleLang()));
 }
 if(MobileVersion) toggleLang(Config.locale);
}

MainWindow::~MainWindow()
{
 delete ui;
}

//bool MainWindow::eventFilter(QObject *obj, QEvent *ev)
//{
// if(obj==ui->eSearch && ui->eSearch->isVisible() && ev->type()==QEvent::FocusIn)
// {
//  ui->eSearch->selectAll();
//  return 1;
// }else
//  return MainWindow::eventFilter(obj,ev);
//}

//bool MainWindow::event(QEvent *e)
bool MainWindow::eventFilter(QObject *obj, QEvent *e)
{

 QMainWindow::event(e);
 switch (e->type()) {
 case QEvent::LanguageChange:
  {
   ui->retranslateUi(this);
   if(SettingWindow) SettingWindow->ui->retranslateUi(SettingWindow);
#ifdef Q_WS_MAEMO_5
   ui->mPreference->setText(ui->menuSetting->title());
#endif
   return 1;
  }
  break;
 case QEvent::Resize:
  {
   if(map->selectedNode.count()) map->selectedNodesToFront(1);
   //map->fitMap();
   return 1;
  }
  break;
 case QEvent::KeyPress:
  {
   QKeyEvent* event = (QKeyEvent*)e;
   Qt::Key key = (Qt::Key)event->key();

   if(key==Qt::Key_Escape)
   {
    //if(windowState()==Qt::WindowFullScreen)
    ui->mFullScreen->setChecked(0); //showMaximized();
   }
   if(key==Qt::Key_F11)
   {
    ui->mFullScreen->setChecked(windowState()!=Qt::WindowFullScreen);
   }

   return 1;
  }
  break;
  //    case QEvent::FocusIn:
  //        {
  //         if(obj==ui->eSearch)
  //         {
  //          ((QLineEdit *)obj)->selectAll();
  //          return 0;
  //         }
  //         else
  //         if(e->type()==QEvent::MouseButtonPress || e->type()==QEvent::MouseButtonRelease)  return 1;



  //        }
  //        break;
 default: ;
 }


 if (obj == ui->eSearch && e->type()==QEvent::FocusIn)
 {
  qDebug("QEvent::FocusIn event intercepted");
  ((QLineEdit *)obj)->selectAll();
  return 0;
 }
 else
  if (obj == ui->eSearch && e->type()==QEvent::FocusOut)
  {
  qDebug("QEvent::FocusOut event intercepted");
  return 0;
 }

 return 0;
}

void MainWindow::on_mExit_triggered()
{
 close();
}

void MainWindow::on_mOpen_triggered()
{
 QFileDialog::Options options;
#ifdef Q_OS_WINCE
 options=QFileDialog::DontUseNativeDialog;
#endif
 QString MapPath=QString("%1Map/").arg(appPath);

// ZIPed maps will be unpacked
 QDir Dir(MapPath);
 if (Dir.exists())
  foreach(QFileInfo info, Dir.entryInfoList(QDir::NoDotAndDotDot | QDir::Files))
  {
   QRegExp regExp=QRegExp("*.zip",Qt::CaseInsensitive,QRegExp::Wildcard);
   if(info.isFile() && info.fileName().contains(regExp))
   {
    map->extractFiles(info.absoluteFilePath(),"*.pmz",MapPath);
    QFile::remove(info.absoluteFilePath());
   }
  }

 QString fileName = QFileDialog::getOpenFileName(this,
            tr("Open file"),MapPath,QString("%1 pMetro (*.pmz)").arg(tr("Map")),0,options);

 if (fileName.isEmpty()) return;

//#ifndef QT_NO_CURSOR
// QApplication::setOverrideCursor(Qt::WaitCursor);
//#endif

//testTimer.start();
 if(Completer) delete Completer;
 map->loadMap(fileName);
 map->fitMap();
 map->viewport()->update();
 ui->eSearch->setText("");
 Completer= new TCompleter(map,ui->eSearch);
//qDebug() << "Load time: " << testTimer.elapsed();

//#ifndef QT_NO_CURSOR
// QApplication::restoreOverrideCursor();
//#endif
}

void MainWindow::on_mSave_triggered()
{
 map->saveToFile();
}

void MainWindow::on_mTest_triggered()
{
 qDebug() << map->horizontalScrollBar()->value();
}

void MainWindow::on_eSearch_returnPressed()
{
 ui->eSearch->selectAll();
}

void MainWindow::on_mFind_toggled(bool checked)
{
 if(!MobileVersion)
 {
  if(!checked) Config.dockWidth=ui->dock->width();
  ui->dock->setVisible(checked);
 }else
 {
  //map->setUpdatesEnabled(0);
  ui->eSearch->setVisible(checked);
  //(checked ? ui->eSearch->setMaximumWidth(maximumWidth()):ui->eSearch->setFixedWidth(0));
  //map->setUpdatesEnabled(1);
 }

 ui->eSearch->setFocus();
 ui->eSearch->selectAll();
}

void MainWindow::on_bClear_clicked()
{
 map->clearTrack();
 ui->eSearch->clear();
 ui->eSearch->setFocus();
 ui->cbDelay->setCurrentIndex(0);
}

void MainWindow::setDelayNames(QStringList list)
{
 ui->cbDelay->clear();
 ui->cbDelay->addItems(list);
 ui->cbDelay->setCurrentIndex(0);
}

void MainWindow::on_mAbout_triggered()
{
 About *a=new About(this);
 if(MobileVersion)
      a->showMaximized();
 else a->exec();
// QDialog *About = new QDialog(this);
// QPushButton OK(About);
// QHBoxLayout HLayout;
// QVBoxLayout VLayout;
// QLabel Logo(About);
// QTextBrowser Info(About);

//#ifdef Q_WS_MAEMO_5
// About->setAttribute(Qt::WA_Maemo5StackedWindow);
// About->setWindowFlags(Qt::Window);
// About->setAttribute(Qt::WA_Maemo5AutoOrientation);
//#else
// FlickCharm fcharm;
// fcharm.activateOn(&Info);
//#endif
// //About->setWindowFlags(Qt::Tool);
// About->setWindowFlags(About->windowFlags() & (~Qt::WindowContextHelpButtonHint));
// About->setFixedWidth(500);
// About->setMinimumHeight(155);
// About->setFixedHeight(400);
// About->setWindowTitle(tr("About")+" qMetro");
// About->setLayout(&HLayout);

// HLayout.addWidget(&Logo);
// //HLayout.setContentsMargins(5,5,0,0);
// HLayout.setAlignment(&Logo,Qt::AlignTop);
// Logo.setFixedWidth(64);
// Logo.setContentsMargins(0,5,0,0);
// Logo.setPixmap(QPixmap(":/qmetro.png"));

// QString hr=QString("<p><table height=2 width=100% bgcolor=%1><tr><td></table></p>")
//            .arg(palette().color(QPalette::Mid).name());
// QString text=
// QString("<p><font size=6><b>qMetro</b></font> - %4.</p>"
//         "<p>%5 %1 &copy; 2011 <a href=\"mailto:guuleon@gmail.com\">Gusak Leonid</a>"
//         " - <a href=\"http://qmetro.sf.net\">qmetro.sf.net</a></p>"
//         "<p>%6: <a href=\"mailto:Boris@pMetro.su\">Muradov Boris</a>"
//         " - <a href=\"%10\">pMetro</a></p>"
//         "<p>%11</p>"
//         "<hr><b>%7:</b>"
//         "<p>%3</p>"
//         "<hr><b>%8:</b><ul type=\"circle\"><li>&nbsp;Qt %2<li>&nbsp;zlib + OSDaB</ul>"
//         "<hr>%9")
// .arg(VERSION).arg(QT_VERSION_STR).arg((map->params.mapAuthors.isEmpty() ? tr("Unknown author"):map->params.mapAuthors)) // 1
// .arg(tr("transit system map")).arg(tr("Version")).arg(tr("Author of map file format")) // 3
// .arg(tr("About current map file")).arg(tr("This program uses")) // 6
// .arg(tr("This program is distributed in the hope that it will be useful, "
//         "but WITHOUT ANY WARRANTY; without even the implied warranty of "
//         "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
//         "GNU General Public License for more details.")).arg(URL_MAPS).arg(tr("Author of translation: Gusak Leonid"));

// text.replace("<hr>",hr);
// HLayout.addLayout(&VLayout);
// VLayout.addWidget(&Info);
// QPalette pal = Info.palette();
// pal.setBrush(QPalette::Base, Qt::transparent);
// pal.setColor(QPalette::Text,palette().color(QPalette::Text));
// Info.setPalette(pal);
// Info.setAttribute(Qt::WA_NoSystemBackground,1);
// Info.setTextInteractionFlags(Qt::LinksAccessibleByMouse | Qt::TextSelectableByMouse);
// Info.setOpenExternalLinks(1);
// Info.setReadOnly(1);
// Info.setFrameShape(QFrame::NoFrame);
// Info.setText(text);
// //Info.setStyleSheet("hr{color:palette(text)");

// VLayout.addWidget(&OK);
// VLayout.setAlignment(&OK,Qt::AlignRight);
// OK.setText(tr("OK"));
// OK.setDefault(1);
// OK.setMaximumWidth(75);
// connect(&OK,SIGNAL(pressed()),About,SLOT(accept()));

// if(MobileVersion)
//      About->showFullScreen();
// else About->exec();
}

void MainWindow::on_mPreference_triggered()
{
 if(!SettingWindow)
 {
  SettingWindow = new Settings(this);

#ifdef Q_WS_MAEMO_5
  SettingWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
  SettingWindow->setWindowFlags(Qt::Window);
  SettingWindow->setAttribute(Qt::WA_Maemo5AutoOrientation);
#endif
 }

 SettingWindow->loadSettings(AppConfig);

 if(MobileVersion)
      SettingWindow->showMaximized();
 else SettingWindow->show();
}

void MainWindow::toggleLang(QString locale)
{
 QAction *action = qobject_cast<QAction *>(sender());

 qApp->removeTranslator(&appTranslator);

 if(action || locale.isEmpty()) locale=action->data().toString();

 if(locale=="ru")
      appTranslator.load("ru.qm",":/locale");
 else appTranslator.load(locale+".lng",appPath+"locale");

 qApp->installTranslator(&appTranslator);
 Config.locale=locale;
}

void infoAddTab(QWidget *widget, const QString &Caption,const QString &Text)
{
 QTextBrowser *TextEdit=new QTextBrowser();

#ifndef Q_WS_MAEMO_5
 FlickCharm *fcharm = new FlickCharm(TextEdit);
 fcharm->activateOn(TextEdit);
#endif
 TextEdit->setTextInteractionFlags(Qt::LinksAccessibleByMouse | Qt::TextSelectableByMouse);
 TextEdit->setText(Text); 
 TextEdit->setReadOnly(1);
 TextEdit->setOpenExternalLinks(1);
 //TextEdit->setMinimumHeight(200);
 // FIX IT: double scroll. need something better then that
 TextEdit->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Ignored);

 if(widget->metaObject()->className()==QString("QTabWidget").toAscii())
 {
  ((QTabWidget*)widget)->addTab(TextEdit,Caption);
  if(!mainWnd->MobileVersion) TextEdit->setVerticalScrollBarPolicy(Qt::ScrollBarAsNeeded);
 }
 else
 {
  ((QToolBox*)widget)->addItem(TextEdit,QIcon(":/img/bullet.png"),Caption);

 }

}

void MainWindow::nodeInformation()
{
 if(!map->nodeClick) return;

//testTimer.start();
 Details *DetailsWindow = new Details(this);

#ifdef Q_WS_MAEMO_5
 DetailsWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
 DetailsWindow->setWindowFlags(Qt::Window);
 DetailsWindow->setAttribute(Qt::WA_Maemo5AutoOrientation);
#endif


 DetailsWindow->setWindowTitle((MobileVersion ? "":DetailsWindow->windowTitle()+" ")+map->nodeClick->DisplayName);

 map->loadNodeInfo(map->nodeClick);

 TMapView *MapScheme;
 QVBoxLayout *layout;
 QToolBar *Bar;
 QTabWidget *Tabs=DetailsWindow->ui->tabs;
 QString AllText="";
 foreach(QString key,map->nodeClick->Info.keys())
 {
  TMapNode::InfoItem Info=map->nodeClick->Info.value(key);
  if(Info.Type==TMapNode::itImage)
  {
   QStringList Value=Info.Value.split("\n");
   foreach(QString FileName,Value)
   {
    layout = new QVBoxLayout;
    layout->setMargin(2);
    MapScheme = new TMapView(appPath,cachePath);
    MapScheme->state.mapLoaded=0;
    MapScheme->config=map->config;
    MapScheme->setAlignment(Qt::AlignCenter);
    MapScheme->params.mapColorBack=Qt::white;
    MapScheme->params.mapPath=map->params.mapPath;
    MapScheme->config.enableDrawBackground=1;
    MapScheme->config.mapLastFile="";
    MapScheme->applyConfig();

    if(MapScheme->config.enableCaching)
    {
     FlickCharm *fcharm=new FlickCharm(MapScheme);
     fcharm->activateOn(MapScheme);
     connect(fcharm,SIGNAL(started()),MapScheme,SLOT(mapStartDragging()));
     connect(fcharm,SIGNAL(finished()),MapScheme,SLOT(mapStopDragging()));
    }

    //MapScheme->setStyleSheet(TOOLBAR_STYLE.arg(Config.appIconSize));

    map->extractFiles(map->params.mapFile,FileName,map->params.mapPath);
    MapScheme->loadMapImageToPaintCmd(FileName,MapScheme->paintBkg);
    MapScheme->state.mapLoaded=1;
    Tabs->addTab(MapScheme,key);
    TMobileUi *toolbars = new TMobileUi(this,MapScheme,1);
   }
  }else
   AllText+=QString("<h3>%1</h3><br>%2<br>").arg(key).arg(Info.Value);
 }

 int TextLength=AllText.length();
 if(TextLength>0) infoAddTab(Tabs,(MobileVersion ? tr("Information"):tr("All")),AllText);

 if(TextLength>200 && !MobileVersion)
 {
  QToolBox *Cats = new QToolBox(DetailsWindow);
  QScrollArea *Scroll=new QScrollArea(DetailsWindow);
  Tabs->addTab(Scroll,tr("Categories"));
  Scroll->setWidgetResizable(1);
  Scroll->setWidget(Cats);

  foreach(QString key,map->nodeClick->Info.keys())
  {
   TMapNode::InfoItem Info=map->nodeClick->Info.value(key);
   if(Info.Type==TMapNode::itText)
        infoAddTab(Cats,key,Info.Value);
   else continue;
  }
 }
 if(Tabs->count()) DetailsWindow->showMaximized();

//qDebug() << testTimer.elapsed();
}

void MainWindow::closeEvent(QCloseEvent * e)
{
 if(!isVisible()) { e->accept(); return;} // FIX: double exec dont know why
 map->state.mapLoaded=0;
 setVisible(0);
 QSettings cfg(appConfigFile,QSettings::IniFormat);
 QString key;
 cfg.beginGroup("Main");
 cfg.setValue("MapLastFile",map->params.mapFile);
 cfg.setValue("Locale",Config.locale);
 if(ui->dock->isVisible()) Config.dockWidth=ui->dock->width();
 cfg.setValue("DockWidth",Config.dockWidth);
 key="MapZoomFactor";
 if(ui->mSaveScale->isChecked())
      cfg.setValue(key,map->params.mapZoomFactor);
 else cfg.remove(key);
 key="MapPosition";
 if(ui->mSavePosition->isChecked())
      cfg.setValue(key,QPoint(map->horizontalScrollBar()->value(),map->verticalScrollBar()->value()));
 else cfg.remove(key);
 if(MobileVersion) cfg.setValue("Styles",TOOLBAR_STYLE);

 if(AppConfig.value(igOther).value(ikMCleanCache).toInt()) removeDir(cachePath);

 if(map->config.enableCaching && !QFile::exists(map->params.mapPath+".cache"))
  map->CachedMap->save(map->params.mapPath+".cache","PNG");
 map->clearMap();

 //setVisible(0);
 e->accept();
}

void applySettings(const IniSettingMap &settings)
{
 TMapView *map=mainWnd->map;
 if(!settings.count()) return;

 QFont nodeFont;
 QMapIterator<IniGroup,IniKeyMap> i(settings);
 while (i.hasNext())
 {
  i.next();
  QMapIterator<IniKey,QString> j(i.value());
  while (j.hasNext())
  {
   j.next();
   QString value=j.value();
   //qDebug() << value;
   if(value.isEmpty()) continue;

   switch(j.key())
   {
   case ikStationCustomFont: map->config.enableCustomFont=value.toInt(); break;
   case ikStationFont: nodeFont.fromString(value); break;
   case ikStationBack: map->config.enableStationBackColor=value.toInt(); break;
   case ikStationShadow: map->config.enableStationShadowColor=value.toInt(); break;
   case ikSBackColor: map->params.nodeColorBack.setNamedColor(value); break;
   case ikSShadowColor: map->params.nodeColorShadow.setNamedColor(value); break;
   case ikSUpperCase: nodeFont.setCapitalization(( value.toInt() ? QFont::AllUppercase:QFont::MixedCase)); break;
   case ikSWordWrap: map->params.nodeFontStyle=(value.toInt() ? Qt::TextWordWrap:Qt::TextSingleLine)+Qt::TextDontClip; break;
   case ikMBackColor:
   {
    map->params.mapColorBack.setNamedColor(value);
    QPalette palette;
    palette.setColor(map->backgroundRole(), map->params.mapColorBack);
    map->setPalette(palette);
   } break;
   case ikSTransparency: map->config.valueTransparency=value.toInt(); break;
   case ikMShowScrollbar: map->config.enableShowScrollBar=value.toInt(); break;
   case ikMShowTime: map->config.enableWriteTime=value.toInt(); break;
   case ikMShowBackground: map->config.enableDrawBackground=value.toInt(); break;
   case ikMAntialiasing: map->config.enableAntialiasing=value.toInt(); break;
   case ikMFastScrolling: map->config.enableLowqDrag=value.toInt(); break;
   case ikMSimpleTransfers: map->config.enableSimpleTransfer=value.toInt(); break;
   case ikMLastFile: map->config.mapLastFile=value; break;
   case ikMCaching: map->config.enableCaching=value.toInt(); break;
   case ikWUiScale: mainWnd->setScaleForUi((qreal)value.toFloat()); break;
   default: break;
   }
  }
 }

 map->applyConfig(); // + load last map

 if(map->config.enableCustomFont)
      map->params.nodeFont=nodeFont;
 else map->params.nodeFont=map->params.nodeFontDefault;

 //map->show();
}

void saveSettings(const IniSettingMap &settings)
{
 QSettings cfg(appConfigFile,QSettings::IniFormat);

 if(AppConfig.count())
 {
  QMapIterator<IniGroup,IniKeyMap> i(AppConfig);
  while (i.hasNext())
  {
   i.next();
   AppConfig.remove(i.key());
  }
  AppConfig.clear();
 }

 if(settings.count())
 {
  QMapIterator<IniGroup,IniKeyMap> i(settings);
  while (i.hasNext())
  {
   i.next();
   AppConfig.insert(i.key(),i.value());
  }
 }


 QMapIterator<IniGroup,IniKeyMap> i(AppConfig);
 while (i.hasNext())
 {
  i.next();
  cfg.beginGroup(IniGroupStr[i.key()]);
  //qDebug() << IniGroupStr[i.key()];
  QMapIterator<IniKey,QString> j(i.value());
  while (j.hasNext())
  {
   j.next();
   cfg.setValue(IniKeyStr[j.key()],j.value());
   //qDebug() << IniKeyStr[j.key()]+"="+j.value();
  }
  cfg.endGroup();
 }
}

void loadSettings()
{
 TMapView *map=mainWnd->map;
 map->defaultConfig();

 QSettings cfg(appConfigFile,QSettings::IniFormat);

 foreach(QString group, cfg.childGroups())
 {
  IniKeyMap keys;
  cfg.beginGroup(group);
  //qDebug() << ">>" << group << IniGroupStr.indexOf(group);
  foreach(QString key, cfg.allKeys())
  {
   //qDebug() << key << (IniKey)IniKeyStr.indexOf(key) << cfg.value(key).toString();
   keys.insert((IniKey)IniKeyStr.indexOf(key),cfg.value(key).toString());
  }
  AppConfig.insert((IniGroup)IniGroupStr.indexOf(group),keys);
  cfg.endGroup();
 }

 applySettings(AppConfig);
 if(AppConfig.value(igMapView).value(ikStationFont).isEmpty())
 {
  IniKeyMap FontKey;
  FontKey.insert(ikStationFont,map->params.nodeFont.toString());
  AppConfig.insert(igMapView,FontKey);
 }
 map->applyConfig();
}

bool removeDir(const QString &DirName)
{
 bool Result=1;
 QDir Dir(DirName);

 if (Dir.exists(DirName))
 {
  foreach(QFileInfo info, Dir.entryInfoList(QDir::NoDotAndDotDot | QDir::System | QDir::Hidden  | QDir::AllDirs | QDir::Files, QDir::DirsFirst))
  {
   if (info.isDir())
        Result=removeDir(info.absoluteFilePath());
   else Result=QFile::remove(info.absoluteFilePath());

   if (!Result) return Result;
  }
  Result=Dir.rmdir(DirName);
 }

 return Result;
}

qint64 sizeOfDir(const QString &DirName)
{
 qint64 Result=0;
 QDir Dir(DirName);

 if (Dir.exists())
  foreach(QFileInfo info, Dir.entryInfoList(QDir::NoDotAndDotDot | QDir::System | QDir::Hidden  | QDir::AllDirs | QDir::Files, QDir::DirsFirst))
  {
   if (info.isDir())
        Result+=sizeOfDir(info.absoluteFilePath());
   else Result+=info.size();
  }

 return Result;
}

void MainWindow::on_mAddMap_triggered()
{
 QString MapPath=appPath+"Map/";
 if(Config.locale!="ru")
      QDesktopServices::openUrl(QUrl(URL_TRANSLATE.arg(Config.locale).arg(URL_MAPS)));
 else QDesktopServices::openUrl(QUrl(URL_MAPS));
 MapPath=QDir::toNativeSeparators(MapPath);
 QMessageBox::information(this,tr("Add maps"),tr("1. Wait until loaded site...\n2. Select map\n3. Save file map here:")+"\n     "+MapPath);
}


void MainWindow::on_mFullScreen_toggled(bool checked)
{
 //bool b=windowState()!=Qt::WindowFullScreen;
 if(MobileVersion) ui->mExit->setVisible(checked);
 else (checked ? ui->toolBar->addAction(ui->mExit):ui->toolBar->removeAction(ui->mExit));

 if(checked) showFullScreen();
 else        showMaximized();
}

void MainWindow::setScaleForUi(qreal UiScale)
{
 if(UiScale<=0.0) return;

 QFont font=Config.appFont;
 Config.appIconSize=ICONSIZE*UiScale;
 font.setPointSizeF(font.pointSizeF()*UiScale);
 qApp->setFont(font);
 if(MobileVersion && mUi)
      mUi->setToolbarIconSize(Config.appIconSize);
 else ui->toolBar->setIconSize(QSize(Config.appIconSize,Config.appIconSize));
 Config.appUiScale=UiScale;
}
