/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_phonon_python.h"

#include "phonon_wrapper.h"
#include "phonon_backendcapabilities_wrapper.h"
#include "phonon_audiochanneldescription_wrapper.h"
#include "phonon_audiooutputdevice_wrapper.h"
#include "phonon_audiocapturedevice_wrapper.h"
#include "phonon_subtitledescription_wrapper.h"
#include "phonon_effectdescriptionmodel_wrapper.h"
#include "phonon_effectdescription_wrapper.h"
#include "phonon_audiooutputdevicemodel_wrapper.h"
#include "phonon_volumefaderinterface_wrapper.h"
#include "phonon_backendinterface_wrapper.h"
#include "phonon_effectinterface_wrapper.h"
#include "phonon_addoninterface_wrapper.h"
#include "phonon_effectparameter_wrapper.h"
#include "phonon_mediaobjectinterface_wrapper.h"
#include "phonon_path_wrapper.h"
#include "phonon_mediasource_wrapper.h"
#include "phonon_medianode_wrapper.h"
#include "phonon_abstractvideooutput_wrapper.h"
#include "phonon_videowidgetinterface_wrapper.h"
#include "phonon_platformplugin_wrapper.h"
#include "phonon_streaminterface_wrapper.h"
#include "phonon_abstractaudiooutput_wrapper.h"
#include "phonon_audiooutput_wrapper.h"
#include "phonon_videoplayer_wrapper.h"
#include "phonon_seekslider_wrapper.h"
#include "phonon_effect_wrapper.h"
#include "phonon_volumefadereffect_wrapper.h"
#include "phonon_effectwidget_wrapper.h"
#include "phonon_abstractmediastream_wrapper.h"
#include "phonon_videowidget_wrapper.h"
#include "phonon_volumeslider_wrapper.h"
#include "phonon_mediacontroller_wrapper.h"
#include "phonon_mediaobject_wrapper.h"

// Extra includes
#include <effectparameter.h>
#include <medianode.h>
#include <mediaobject.h>
#include <mediasource.h>
#include <path.h>
#include <phononnamespace.h>
#include <qstring.h>

using namespace Shiboken;

static PyObject* SbkPhononFunc_categoryToString(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<Phonon::Category >::isConvertible(arg)) {
        Phonon::Category cpp_arg0 = Shiboken::Converter<Phonon::Category >::toCpp(arg);
        // categoryToString(Phonon::Category)
        QString cpp_result = Phonon::categoryToString(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhononFunc_categoryToString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhononFunc_categoryToString_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon.Category", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.Phonon.categoryToString", overloads);
        return 0;
}

static PyObject* SbkPhononFunc_createPath(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "createPath", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<Phonon::MediaNode * >::isConvertible(pyargs[0]) && Shiboken::Converter<Phonon::MediaNode * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        Phonon::MediaNode* cpp_arg0 = Shiboken::Converter<Phonon::MediaNode* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        Phonon::MediaNode* cpp_arg1 = Shiboken::Converter<Phonon::MediaNode* >::toCpp(pyargs[1]);
        // createPath(Phonon::MediaNode*,Phonon::MediaNode*)
        Phonon::Path cpp_result = Phonon::createPath(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<Phonon::Path >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhononFunc_createPath_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhononFunc_createPath_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::MediaNode, PySide.phonon.Phonon::MediaNode", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.Phonon.createPath", overloads);
        return 0;
}

static PyObject* SbkPhononFunc_createPlayer(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "createPlayer", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<Phonon::Category >::isConvertible(pyargs[0])) {
        Phonon::Category cpp_arg0 = Shiboken::Converter<Phonon::Category >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // createPlayer(Phonon::Category,Phonon::MediaSource)
            Phonon::MediaObject * cpp_result = Phonon::createPlayer(cpp_arg0);
            py_result = Shiboken::Converter<Phonon::MediaObject * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Phonon::MediaSource & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<Phonon::MediaSource > cpp_arg1_auto_ptr;
            Phonon::MediaSource* cpp_arg1 = Shiboken::Converter<Phonon::MediaSource* >::toCpp(pyargs[1]);
            if (!SbkPhonon_MediaSource_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<Phonon::MediaSource >(cpp_arg1);
            // createPlayer(Phonon::Category,Phonon::MediaSource)
            Phonon::MediaObject * cpp_result = Phonon::createPlayer(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<Phonon::MediaObject * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkPhononFunc_createPlayer_TypeError;
    } else goto SbkPhononFunc_createPlayer_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhononFunc_createPlayer_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon.Category, PySide.phonon.Phonon::MediaSource = Phonon.MediaSource()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.Phonon.createPlayer", overloads);
        return 0;
}

static PyObject* SbkPhononFunc_phononVersion(PyObject* self)
{
    PyObject* py_result = 0;

    // phononVersion()
    const char * cpp_result = Phonon::phononVersion();
    py_result = Shiboken::Converter<const char * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhononFunc_qHash(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<Phonon::EffectParameter & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        Phonon::EffectParameter* cpp_arg0 = Shiboken::Converter<Phonon::EffectParameter* >::toCpp(arg);
        // qHash(Phonon::EffectParameter)
        uint cpp_result = Phonon::qHash(*cpp_arg0);
        py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhononFunc_qHash_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhononFunc_qHash_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::EffectParameter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.Phonon.qHash", overloads);
        return 0;
}

static PyMethodDef SbkPhonon_methods[] = {
    {"categoryToString", (PyCFunction)SbkPhononFunc_categoryToString, METH_O|METH_STATIC},
    {"createPath", (PyCFunction)SbkPhononFunc_createPath, METH_VARARGS|METH_STATIC},
    {"createPlayer", (PyCFunction)SbkPhononFunc_createPlayer, METH_VARARGS|METH_STATIC},
    {"phononVersion", (PyCFunction)SbkPhononFunc_phononVersion, METH_NOARGS|METH_STATIC},
    {"qHash", (PyCFunction)SbkPhononFunc_qHash, METH_O|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.Phonon",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            0,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_phonon_Phonon_DiscType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_DiscType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_DiscType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DiscType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_DiscType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_DiscType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_DiscType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_phonon_Phonon_MetaData_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_MetaData_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_MetaData_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MetaData",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_MetaData_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_MetaData_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_MetaData_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_phonon_Phonon_Category_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_Category_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_Category_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Category",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_Category_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_Category_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_Category_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_phonon_Phonon_ObjectDescriptionType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_ObjectDescriptionType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_ObjectDescriptionType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ObjectDescriptionType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_ObjectDescriptionType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_ObjectDescriptionType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_ObjectDescriptionType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_phonon_Phonon_State_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_State_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_State_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "State",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_State_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_State_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_State_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_phonon_Phonon_ErrorType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_ErrorType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_ErrorType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ErrorType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_ErrorType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_ErrorType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_ErrorType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_Phonon(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_Type);

    if (PyType_Ready((PyTypeObject*)&SbkPhonon_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkPhonon_Type));
    PyModule_AddObject(module, "Phonon",
        ((PyObject*)&SbkPhonon_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: DiscType
    SbkPySide_phononTypes[SBK_PHONON_DISCTYPE_IDX] = &SbkPySide_phonon_Phonon_DiscType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_DiscType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_DiscType_Type);
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
            "DiscType",((PyObject*)&SbkPySide_phonon_Phonon_DiscType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_DiscType_Type,
        (long) Phonon::NoDisc, "NoDisc");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "NoDisc", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_DiscType_Type.tp_dict,
        "NoDisc", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_DiscType_Type,
        (long) Phonon::Cd, "Cd");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "Cd", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_DiscType_Type.tp_dict,
        "Cd", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_DiscType_Type,
        (long) Phonon::Dvd, "Dvd");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "Dvd", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_DiscType_Type.tp_dict,
        "Dvd", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_DiscType_Type,
        (long) Phonon::Vcd, "Vcd");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "Vcd", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_DiscType_Type.tp_dict,
        "Vcd", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::DiscType");

    // init enum class: MetaData
    SbkPySide_phononTypes[SBK_PHONON_METADATA_IDX] = &SbkPySide_phonon_Phonon_MetaData_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_MetaData_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_MetaData_Type);
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
            "MetaData",((PyObject*)&SbkPySide_phonon_Phonon_MetaData_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_MetaData_Type,
        (long) Phonon::ArtistMetaData, "ArtistMetaData");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "ArtistMetaData", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_MetaData_Type.tp_dict,
        "ArtistMetaData", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_MetaData_Type,
        (long) Phonon::AlbumMetaData, "AlbumMetaData");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "AlbumMetaData", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_MetaData_Type.tp_dict,
        "AlbumMetaData", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_MetaData_Type,
        (long) Phonon::TitleMetaData, "TitleMetaData");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "TitleMetaData", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_MetaData_Type.tp_dict,
        "TitleMetaData", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_MetaData_Type,
        (long) Phonon::DateMetaData, "DateMetaData");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "DateMetaData", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_MetaData_Type.tp_dict,
        "DateMetaData", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_MetaData_Type,
        (long) Phonon::GenreMetaData, "GenreMetaData");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "GenreMetaData", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_MetaData_Type.tp_dict,
        "GenreMetaData", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_MetaData_Type,
        (long) Phonon::TracknumberMetaData, "TracknumberMetaData");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "TracknumberMetaData", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_MetaData_Type.tp_dict,
        "TracknumberMetaData", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_MetaData_Type,
        (long) Phonon::DescriptionMetaData, "DescriptionMetaData");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "DescriptionMetaData", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_MetaData_Type.tp_dict,
        "DescriptionMetaData", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_MetaData_Type,
        (long) Phonon::MusicBrainzDiscIdMetaData, "MusicBrainzDiscIdMetaData");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "MusicBrainzDiscIdMetaData", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_MetaData_Type.tp_dict,
        "MusicBrainzDiscIdMetaData", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::MetaData");

    // init enum class: Category
    SbkPySide_phononTypes[SBK_PHONON_CATEGORY_IDX] = &SbkPySide_phonon_Phonon_Category_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_Category_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_Category_Type);
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
            "Category",((PyObject*)&SbkPySide_phonon_Phonon_Category_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_Category_Type,
        (long) Phonon::NoCategory, "NoCategory");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "NoCategory", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_Category_Type.tp_dict,
        "NoCategory", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_Category_Type,
        (long) Phonon::NotificationCategory, "NotificationCategory");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "NotificationCategory", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_Category_Type.tp_dict,
        "NotificationCategory", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_Category_Type,
        (long) Phonon::MusicCategory, "MusicCategory");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "MusicCategory", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_Category_Type.tp_dict,
        "MusicCategory", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_Category_Type,
        (long) Phonon::VideoCategory, "VideoCategory");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "VideoCategory", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_Category_Type.tp_dict,
        "VideoCategory", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_Category_Type,
        (long) Phonon::CommunicationCategory, "CommunicationCategory");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "CommunicationCategory", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_Category_Type.tp_dict,
        "CommunicationCategory", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_Category_Type,
        (long) Phonon::GameCategory, "GameCategory");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "GameCategory", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_Category_Type.tp_dict,
        "GameCategory", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_Category_Type,
        (long) Phonon::AccessibilityCategory, "AccessibilityCategory");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "AccessibilityCategory", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_Category_Type.tp_dict,
        "AccessibilityCategory", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_Category_Type,
        (long) Phonon::LastCategory, "LastCategory");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "LastCategory", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_Category_Type.tp_dict,
        "LastCategory", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::Category");

    // init enum class: ObjectDescriptionType
    SbkPySide_phononTypes[SBK_PHONON_OBJECTDESCRIPTIONTYPE_IDX] = &SbkPySide_phonon_Phonon_ObjectDescriptionType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_ObjectDescriptionType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_ObjectDescriptionType_Type);
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
            "ObjectDescriptionType",((PyObject*)&SbkPySide_phonon_Phonon_ObjectDescriptionType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_ObjectDescriptionType_Type,
        (long) Phonon::AudioOutputDeviceType, "AudioOutputDeviceType");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "AudioOutputDeviceType", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_ObjectDescriptionType_Type.tp_dict,
        "AudioOutputDeviceType", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_ObjectDescriptionType_Type,
        (long) Phonon::EffectType, "EffectType");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "EffectType", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_ObjectDescriptionType_Type.tp_dict,
        "EffectType", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_ObjectDescriptionType_Type,
        (long) Phonon::AudioChannelType, "AudioChannelType");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "AudioChannelType", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_ObjectDescriptionType_Type.tp_dict,
        "AudioChannelType", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_ObjectDescriptionType_Type,
        (long) Phonon::SubtitleType, "SubtitleType");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "SubtitleType", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_ObjectDescriptionType_Type.tp_dict,
        "SubtitleType", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_ObjectDescriptionType_Type,
        (long) Phonon::AudioCaptureDeviceType, "AudioCaptureDeviceType");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "AudioCaptureDeviceType", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_ObjectDescriptionType_Type.tp_dict,
        "AudioCaptureDeviceType", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::ObjectDescriptionType");

    // init enum class: State
    SbkPySide_phononTypes[SBK_PHONON_STATE_IDX] = &SbkPySide_phonon_Phonon_State_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_State_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_State_Type);
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
            "State",((PyObject*)&SbkPySide_phonon_Phonon_State_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_State_Type,
        (long) Phonon::LoadingState, "LoadingState");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "LoadingState", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_State_Type.tp_dict,
        "LoadingState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_State_Type,
        (long) Phonon::StoppedState, "StoppedState");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "StoppedState", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_State_Type.tp_dict,
        "StoppedState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_State_Type,
        (long) Phonon::PlayingState, "PlayingState");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "PlayingState", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_State_Type.tp_dict,
        "PlayingState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_State_Type,
        (long) Phonon::BufferingState, "BufferingState");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "BufferingState", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_State_Type.tp_dict,
        "BufferingState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_State_Type,
        (long) Phonon::PausedState, "PausedState");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "PausedState", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_State_Type.tp_dict,
        "PausedState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_State_Type,
        (long) Phonon::ErrorState, "ErrorState");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "ErrorState", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_State_Type.tp_dict,
        "ErrorState", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::State");

    // init enum class: ErrorType
    SbkPySide_phononTypes[SBK_PHONON_ERRORTYPE_IDX] = &SbkPySide_phonon_Phonon_ErrorType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_ErrorType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_ErrorType_Type);
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
            "ErrorType",((PyObject*)&SbkPySide_phonon_Phonon_ErrorType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_ErrorType_Type,
        (long) Phonon::NoError, "NoError");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_ErrorType_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_ErrorType_Type,
        (long) Phonon::NormalError, "NormalError");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "NormalError", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_ErrorType_Type.tp_dict,
        "NormalError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_ErrorType_Type,
        (long) Phonon::FatalError, "FatalError");
    PyDict_SetItemString(SbkPhonon_Type.super.ht_type.tp_dict,
        "FatalError", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_ErrorType_Type.tp_dict,
        "FatalError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::ErrorType");

}


} // extern "C"

