/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_phonon_python.h"

#include "phonon_volumefaderinterface_wrapper.h"

// Extra includes

using namespace Shiboken;

// Native ---------------------------------------------------------

VolumeFaderInterfaceWrapper::VolumeFaderInterfaceWrapper() : Phonon::VolumeFaderInterface() {
    // ... middle
}

Phonon::VolumeFaderEffect::FadeCurve VolumeFaderInterfaceWrapper::fadeCurve() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fadeCurve"));
    if (py_override.isNull()) {
        return this->Phonon::VolumeFaderInterface::fadeCurve();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return Phonon::VolumeFaderEffect::FadeCurve();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<Phonon::VolumeFaderEffect::FadeCurve >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "VolumeFaderInterface.fadeCurve", SbkType<Phonon::VolumeFaderEffect::FadeCurve >()->tp_name, py_result->ob_type->tp_name);
        return Phonon::VolumeFaderEffect::FadeCurve();
    }
    Phonon::VolumeFaderEffect::FadeCurve cpp_result(Shiboken::Converter<Phonon::VolumeFaderEffect::FadeCurve >::toCpp(py_result));
    return cpp_result;
}

void VolumeFaderInterfaceWrapper::fadeTo(float arg__1, int arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fadeTo"));
    if (py_override.isNull()) {
        return this->Phonon::VolumeFaderInterface::fadeTo(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(fi)",
        arg__1,
        arg__2
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void VolumeFaderInterfaceWrapper::setFadeCurve(Phonon::VolumeFaderEffect::FadeCurve arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setFadeCurve"));
    if (py_override.isNull()) {
        return this->Phonon::VolumeFaderInterface::setFadeCurve(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Phonon::VolumeFaderEffect::FadeCurve >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void VolumeFaderInterfaceWrapper::setVolume(float arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVolume"));
    if (py_override.isNull()) {
        return this->Phonon::VolumeFaderInterface::setVolume(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(f)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

float VolumeFaderInterfaceWrapper::volume() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "volume"));
    if (py_override.isNull()) {
        return this->Phonon::VolumeFaderInterface::volume();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return float(0);
    }
    // Check return type
    bool typeIsValid = PyFloat_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "VolumeFaderInterface.volume", SbkType<float >()->tp_name, py_result->ob_type->tp_name);
        return float(0);
    }
    float cpp_result(Shiboken::Converter<float >::toCpp(py_result));
    return cpp_result;
}

VolumeFaderInterfaceWrapper::~VolumeFaderInterfaceWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkPhonon_VolumeFaderInterface_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    VolumeFaderInterfaceWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    // VolumeFaderInterface()
    cptr = new VolumeFaderInterfaceWrapper();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<Phonon::VolumeFaderInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkPhonon_VolumeFaderInterfaceFunc_fadeCurve(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fadeCurve()const
    Phonon::VolumeFaderInterface* cppSelf = Shiboken::Converter<Phonon::VolumeFaderInterface* >::toCpp((PyObject*)self);
    Phonon::VolumeFaderEffect::FadeCurve cpp_result = cppSelf->Phonon::VolumeFaderInterface::fadeCurve();
    py_result = Shiboken::Converter<Phonon::VolumeFaderEffect::FadeCurve >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_VolumeFaderInterfaceFunc_fadeTo(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fadeTo", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        float cpp_arg0 = Shiboken::Converter<float >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // fadeTo(float,int)
        Phonon::VolumeFaderInterface* cppSelf = Shiboken::Converter<Phonon::VolumeFaderInterface* >::toCpp((PyObject*)self);
        cppSelf->Phonon::VolumeFaderInterface::fadeTo(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_VolumeFaderInterfaceFunc_fadeTo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_VolumeFaderInterfaceFunc_fadeTo_TypeError:
        const char* overloads[] = {"float, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.VolumeFaderInterface.fadeTo", overloads);
        return 0;
}

static PyObject* SbkPhonon_VolumeFaderInterfaceFunc_setFadeCurve(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Phonon::VolumeFaderEffect::FadeCurve >::isConvertible(arg)) {
        Phonon::VolumeFaderEffect::FadeCurve cpp_arg0 = Shiboken::Converter<Phonon::VolumeFaderEffect::FadeCurve >::toCpp(arg);
        // setFadeCurve(Phonon::VolumeFaderEffect::FadeCurve)
        Phonon::VolumeFaderInterface* cppSelf = Shiboken::Converter<Phonon::VolumeFaderInterface* >::toCpp((PyObject*)self);
        cppSelf->Phonon::VolumeFaderInterface::setFadeCurve(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_VolumeFaderInterfaceFunc_setFadeCurve_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_VolumeFaderInterfaceFunc_setFadeCurve_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::VolumeFaderEffect.FadeCurve", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.VolumeFaderInterface.setFadeCurve", overloads);
        return 0;
}

static PyObject* SbkPhonon_VolumeFaderInterfaceFunc_setVolume(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        float cpp_arg0 = Shiboken::Converter<float >::toCpp(arg);
        // setVolume(float)
        Phonon::VolumeFaderInterface* cppSelf = Shiboken::Converter<Phonon::VolumeFaderInterface* >::toCpp((PyObject*)self);
        cppSelf->Phonon::VolumeFaderInterface::setVolume(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_VolumeFaderInterfaceFunc_setVolume_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_VolumeFaderInterfaceFunc_setVolume_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.VolumeFaderInterface.setVolume", overloads);
        return 0;
}

static PyObject* SbkPhonon_VolumeFaderInterfaceFunc_volume(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // volume()const
    Phonon::VolumeFaderInterface* cppSelf = Shiboken::Converter<Phonon::VolumeFaderInterface* >::toCpp((PyObject*)self);
    float cpp_result = cppSelf->Phonon::VolumeFaderInterface::volume();
    py_result = Shiboken::Converter<float >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkPhonon_VolumeFaderInterface_methods[] = {
    {"fadeCurve", (PyCFunction)SbkPhonon_VolumeFaderInterfaceFunc_fadeCurve, METH_NOARGS},
    {"fadeTo", (PyCFunction)SbkPhonon_VolumeFaderInterfaceFunc_fadeTo, METH_VARARGS},
    {"setFadeCurve", (PyCFunction)SbkPhonon_VolumeFaderInterfaceFunc_setFadeCurve, METH_O},
    {"setVolume", (PyCFunction)SbkPhonon_VolumeFaderInterfaceFunc_setVolume, METH_O},
    {"volume", (PyCFunction)SbkPhonon_VolumeFaderInterfaceFunc_volume, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_VolumeFaderInterface_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.VolumeFaderInterface",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_VolumeFaderInterface_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkPhonon_VolumeFaderInterface_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<Phonon::VolumeFaderInterface >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkPhonon_VolumeFaderInterface_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkPhonon_VolumeFaderInterface_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<Phonon::VolumeFaderInterface*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void) init_Phonon_VolumeFaderInterface(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_VOLUMEFADERINTERFACE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_VolumeFaderInterface_Type);

    // Fill type discovery information
    SbkPhonon_VolumeFaderInterface_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkPhonon_VolumeFaderInterface_Type.type_discovery->addTypeDiscoveryFunction(&SbkPhonon_VolumeFaderInterface_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkPhonon_VolumeFaderInterface_Type) < 0)
        return;

    PyDict_SetItemString(module,"VolumeFaderInterface", (PyObject*)&SbkPhonon_VolumeFaderInterface_Type);
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::VolumeFaderInterface >("Phonon::VolumeFaderInterface*");
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::VolumeFaderInterface >(typeid(Phonon::VolumeFaderInterface).name());
}


} // extern "C"

