/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_phonon_python.h"

#include "phonon_medianode_wrapper.h"

// Extra includes
#include <QList>
#include <path.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

MediaNodeWrapper::~MediaNodeWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static PyObject* SbkPhonon_MediaNodeFunc_inputPaths(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // inputPaths()const
    Phonon::MediaNode* cppSelf = Shiboken::Converter<Phonon::MediaNode* >::toCpp((PyObject*)self);
    QList<Phonon::Path > cpp_result = cppSelf->Phonon::MediaNode::inputPaths();
    py_result = Shiboken::Converter<QList<Phonon::Path > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaNodeFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    Phonon::MediaNode* cppSelf = Shiboken::Converter<Phonon::MediaNode* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->Phonon::MediaNode::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaNodeFunc_outputPaths(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // outputPaths()const
    Phonon::MediaNode* cppSelf = Shiboken::Converter<Phonon::MediaNode* >::toCpp((PyObject*)self);
    QList<Phonon::Path > cpp_result = cppSelf->Phonon::MediaNode::outputPaths();
    py_result = Shiboken::Converter<QList<Phonon::Path > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkPhonon_MediaNode_methods[] = {
    {"inputPaths", (PyCFunction)SbkPhonon_MediaNodeFunc_inputPaths, METH_NOARGS},
    {"isValid", (PyCFunction)SbkPhonon_MediaNodeFunc_isValid, METH_NOARGS},
    {"outputPaths", (PyCFunction)SbkPhonon_MediaNodeFunc_outputPaths, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_MediaNode_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.MediaNode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_MediaNode_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<Phonon::MediaNode >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkPhonon_MediaNode_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkPhonon_MediaNode_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<Phonon::MediaNode*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void) init_Phonon_MediaNode(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_MEDIANODE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_MediaNode_Type);

    // Fill type discovery information
    SbkPhonon_MediaNode_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkPhonon_MediaNode_Type.type_discovery->addTypeDiscoveryFunction(&SbkPhonon_MediaNode_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkPhonon_MediaNode_Type) < 0)
        return;

    PyDict_SetItemString(module,"MediaNode", (PyObject*)&SbkPhonon_MediaNode_Type);
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::MediaNode >("Phonon::MediaNode*");
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::MediaNode >(typeid(Phonon::MediaNode).name());
}


} // extern "C"

