/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qdomcharacterdata_wrapper.h"

// Extra includes
#include <qdom.h>
#include <qstring.h>
#include <qtextstream.h>

using namespace Shiboken;

static int
SbkQDomCharacterData_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDomCharacterData* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QDomCharacterData", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QDomCharacterData()
        cptr = new QDomCharacterData();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QDomCharacterData & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QDomCharacterData* cpp_arg0 = Shiboken::Converter<QDomCharacterData* >::toCpp(pyargs[0]);
        // QDomCharacterData(QDomCharacterData)
        cptr = new QDomCharacterData(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomCharacterData_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QDomCharacterData >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDomCharacterData_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQDomCharacterData_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtXml.QDomCharacterData", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomCharacterData", overloads);
        return -1;
}

static PyObject* SbkQDomCharacterDataFunc_appendData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // appendData(QString)
        QDomCharacterData* cppSelf = Shiboken::Converter<QDomCharacterData* >::toCpp((PyObject*)self);
        cppSelf->QDomCharacterData::appendData(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomCharacterDataFunc_appendData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDomCharacterDataFunc_appendData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomCharacterData.appendData", overloads);
        return 0;
}

static PyObject* SbkQDomCharacterDataFunc_data(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // data()const
    QDomCharacterData* cppSelf = Shiboken::Converter<QDomCharacterData* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDomCharacterData::data();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDomCharacterDataFunc_deleteData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "deleteData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        unsigned long cpp_arg0 = Shiboken::Converter<unsigned long >::toCpp(pyargs[0]);
        unsigned long cpp_arg1 = Shiboken::Converter<unsigned long >::toCpp(pyargs[1]);
        // deleteData(ulong,ulong)
        QDomCharacterData* cppSelf = Shiboken::Converter<QDomCharacterData* >::toCpp((PyObject*)self);
        cppSelf->QDomCharacterData::deleteData(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomCharacterDataFunc_deleteData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDomCharacterDataFunc_deleteData_TypeError:
        const char* overloads[] = {"unsigned long, unsigned long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomCharacterData.deleteData", overloads);
        return 0;
}

static PyObject* SbkQDomCharacterDataFunc_insertData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        unsigned long cpp_arg0 = Shiboken::Converter<unsigned long >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // insertData(ulong,QString)
        QDomCharacterData* cppSelf = Shiboken::Converter<QDomCharacterData* >::toCpp((PyObject*)self);
        cppSelf->QDomCharacterData::insertData(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomCharacterDataFunc_insertData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDomCharacterDataFunc_insertData_TypeError:
        const char* overloads[] = {"unsigned long, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomCharacterData.insertData", overloads);
        return 0;
}

static PyObject* SbkQDomCharacterDataFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QDomCharacterData* cppSelf = Shiboken::Converter<QDomCharacterData* >::toCpp((PyObject*)self);
    uint cpp_result = cppSelf->QDomCharacterData::length();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDomCharacterDataFunc_replaceData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "replaceData", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
        unsigned long cpp_arg0 = Shiboken::Converter<unsigned long >::toCpp(pyargs[0]);
        unsigned long cpp_arg1 = Shiboken::Converter<unsigned long >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!SbkQString_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        // replaceData(ulong,ulong,QString)
        QDomCharacterData* cppSelf = Shiboken::Converter<QDomCharacterData* >::toCpp((PyObject*)self);
        cppSelf->QDomCharacterData::replaceData(cpp_arg0, cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomCharacterDataFunc_replaceData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDomCharacterDataFunc_replaceData_TypeError:
        const char* overloads[] = {"unsigned long, unsigned long, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomCharacterData.replaceData", overloads);
        return 0;
}

static PyObject* SbkQDomCharacterDataFunc_setData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setData(QString)
        QDomCharacterData* cppSelf = Shiboken::Converter<QDomCharacterData* >::toCpp((PyObject*)self);
        cppSelf->QDomCharacterData::setData(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomCharacterDataFunc_setData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDomCharacterDataFunc_setData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomCharacterData.setData", overloads);
        return 0;
}

static PyObject* SbkQDomCharacterDataFunc_substringData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "substringData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        unsigned long cpp_arg0 = Shiboken::Converter<unsigned long >::toCpp(pyargs[0]);
        unsigned long cpp_arg1 = Shiboken::Converter<unsigned long >::toCpp(pyargs[1]);
        // substringData(ulong,ulong)
        QDomCharacterData* cppSelf = Shiboken::Converter<QDomCharacterData* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QDomCharacterData::substringData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomCharacterDataFunc_substringData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomCharacterDataFunc_substringData_TypeError:
        const char* overloads[] = {"unsigned long, unsigned long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomCharacterData.substringData", overloads);
        return 0;
}

static PyMethodDef SbkQDomCharacterData_methods[] = {
    {"appendData", (PyCFunction)SbkQDomCharacterDataFunc_appendData, METH_O},
    {"data", (PyCFunction)SbkQDomCharacterDataFunc_data, METH_NOARGS},
    {"deleteData", (PyCFunction)SbkQDomCharacterDataFunc_deleteData, METH_VARARGS},
    {"insertData", (PyCFunction)SbkQDomCharacterDataFunc_insertData, METH_VARARGS},
    {"length", (PyCFunction)SbkQDomCharacterDataFunc_length, METH_NOARGS},
    {"replaceData", (PyCFunction)SbkQDomCharacterDataFunc_replaceData, METH_VARARGS},
    {"setData", (PyCFunction)SbkQDomCharacterDataFunc_setData, METH_O},
    {"substringData", (PyCFunction)SbkQDomCharacterDataFunc_substringData, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDomCharacterData_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QDomCharacterData",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDomCharacterData_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDomCharacterData_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QDomCharacterData >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QDomCharacterData(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QDOMCHARACTERDATA_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDomCharacterData_Type);

    SbkQDomCharacterData_Type.super.ht_type.tp_base = SbkPySide_QtXmlTypes[SBK_QDOMNODE_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQDomCharacterData_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDomCharacterData_Type));
    PyModule_AddObject(module, "QDomCharacterData",
        ((PyObject*)&SbkQDomCharacterData_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QDomCharacterData >("QDomCharacterData");
    Shiboken::TypeResolver::createValueTypeResolver<QDomCharacterData >(typeid(QDomCharacterData).name());
}


} // extern "C"

