/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qdomattr_wrapper.h"

// Extra includes
#include <qdom.h>
#include <qstring.h>
#include <qtextstream.h>

using namespace Shiboken;

static int
SbkQDomAttr_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDomAttr* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QDomAttr", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QDomAttr()
        cptr = new QDomAttr();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QDomAttr & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QDomAttr* cpp_arg0 = Shiboken::Converter<QDomAttr* >::toCpp(pyargs[0]);
        // QDomAttr(QDomAttr)
        cptr = new QDomAttr(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomAttr_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QDomAttr >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDomAttr_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQDomAttr_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtXml.QDomAttr", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomAttr", overloads);
        return -1;
}

static PyObject* SbkQDomAttrFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QDomAttr* cppSelf = Shiboken::Converter<QDomAttr* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDomAttr::name();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDomAttrFunc_ownerElement(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // ownerElement()const
    QDomAttr* cppSelf = Shiboken::Converter<QDomAttr* >::toCpp((PyObject*)self);
    QDomElement cpp_result = cppSelf->QDomAttr::ownerElement();
    py_result = Shiboken::Converter<QDomElement >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDomAttrFunc_setValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setValue(QString)
        QDomAttr* cppSelf = Shiboken::Converter<QDomAttr* >::toCpp((PyObject*)self);
        cppSelf->QDomAttr::setValue(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomAttrFunc_setValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDomAttrFunc_setValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomAttr.setValue", overloads);
        return 0;
}

static PyObject* SbkQDomAttrFunc_specified(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // specified()const
    QDomAttr* cppSelf = Shiboken::Converter<QDomAttr* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomAttr::specified();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDomAttrFunc_value(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // value()const
    QDomAttr* cppSelf = Shiboken::Converter<QDomAttr* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDomAttr::value();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQDomAttr_methods[] = {
    {"name", (PyCFunction)SbkQDomAttrFunc_name, METH_NOARGS},
    {"ownerElement", (PyCFunction)SbkQDomAttrFunc_ownerElement, METH_NOARGS},
    {"setValue", (PyCFunction)SbkQDomAttrFunc_setValue, METH_O},
    {"specified", (PyCFunction)SbkQDomAttrFunc_specified, METH_NOARGS},
    {"value", (PyCFunction)SbkQDomAttrFunc_value, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDomAttr_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QDomAttr",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDomAttr_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDomAttr_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QDomAttr >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QDomAttr(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QDOMATTR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDomAttr_Type);

    SbkQDomAttr_Type.super.ht_type.tp_base = SbkPySide_QtXmlTypes[SBK_QDOMNODE_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQDomAttr_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDomAttr_Type));
    PyModule_AddObject(module, "QDomAttr",
        ((PyObject*)&SbkQDomAttr_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QDomAttr >("QDomAttr");
    Shiboken::TypeResolver::createValueTypeResolver<QDomAttr >(typeid(QDomAttr).name());
}


} // extern "C"

