/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtwebkit_python.h"

#include "qwebsettings_wrapper.h"

// Extra includes
#include <qicon.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qurl.h>
#include <qwebsettings.h>

using namespace Shiboken;

static PyObject* SbkQWebSettingsFunc_clearIconDatabase(PyObject* self)
{

    // clearIconDatabase()
    QWebSettings::clearIconDatabase();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQWebSettingsFunc_clearMemoryCaches(PyObject* self)
{

    // clearMemoryCaches()
    QWebSettings::clearMemoryCaches();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQWebSettingsFunc_defaultTextEncoding(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // defaultTextEncoding()const
    QWebSettings* cppSelf = Shiboken::Converter<QWebSettings* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebSettings::defaultTextEncoding();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebSettingsFunc_enablePersistentStorage(PyObject* self, PyObject* arg)
{

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // enablePersistentStorage(QString)
        QWebSettings::enablePersistentStorage();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // enablePersistentStorage(QString)
        QWebSettings::enablePersistentStorage(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_enablePersistentStorage_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_enablePersistentStorage_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.enablePersistentStorage", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_fontFamily(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWebSettings::FontFamily >::isConvertible(arg)) {
        QWebSettings::FontFamily cpp_arg0 = Shiboken::Converter<QWebSettings::FontFamily >::toCpp(arg);
        // fontFamily(QWebSettings::FontFamily)const
        QWebSettings* cppSelf = Shiboken::Converter<QWebSettings* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QWebSettings::fontFamily(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_fontFamily_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebSettingsFunc_fontFamily_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebSettings.FontFamily", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.fontFamily", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_fontSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWebSettings::FontSize >::isConvertible(arg)) {
        QWebSettings::FontSize cpp_arg0 = Shiboken::Converter<QWebSettings::FontSize >::toCpp(arg);
        // fontSize(QWebSettings::FontSize)const
        QWebSettings* cppSelf = Shiboken::Converter<QWebSettings* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QWebSettings::fontSize(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_fontSize_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebSettingsFunc_fontSize_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebSettings.FontSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.fontSize", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_globalSettings(PyObject* self)
{
    PyObject* py_result = 0;

    // globalSettings()
    QWebSettings * cpp_result = QWebSettings::globalSettings();
    py_result = Shiboken::Converter<QWebSettings * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebSettingsFunc_iconDatabasePath(PyObject* self)
{
    PyObject* py_result = 0;

    // iconDatabasePath()
    QString cpp_result = QWebSettings::iconDatabasePath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebSettingsFunc_iconForUrl(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QUrl & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
        if (!SbkQUrl_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // iconForUrl(QUrl)
        QIcon cpp_result = QWebSettings::iconForUrl(*cpp_arg0);
        py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_iconForUrl_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebSettingsFunc_iconForUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.iconForUrl", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_localStoragePath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // localStoragePath()const
    QWebSettings* cppSelf = Shiboken::Converter<QWebSettings* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebSettings::localStoragePath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebSettingsFunc_maximumPagesInCache(PyObject* self)
{
    PyObject* py_result = 0;

    // maximumPagesInCache()
    int cpp_result = QWebSettings::maximumPagesInCache();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebSettingsFunc_offlineStorageDefaultQuota(PyObject* self)
{
    PyObject* py_result = 0;

    // offlineStorageDefaultQuota()
    qint64 cpp_result = QWebSettings::offlineStorageDefaultQuota();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebSettingsFunc_offlineStoragePath(PyObject* self)
{
    PyObject* py_result = 0;

    // offlineStoragePath()
    QString cpp_result = QWebSettings::offlineStoragePath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebSettingsFunc_offlineWebApplicationCachePath(PyObject* self)
{
    PyObject* py_result = 0;

    // offlineWebApplicationCachePath()
    QString cpp_result = QWebSettings::offlineWebApplicationCachePath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebSettingsFunc_offlineWebApplicationCacheQuota(PyObject* self)
{
    PyObject* py_result = 0;

    // offlineWebApplicationCacheQuota()
    qint64 cpp_result = QWebSettings::offlineWebApplicationCacheQuota();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebSettingsFunc_resetAttribute(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWebSettings::WebAttribute >::isConvertible(arg)) {
        QWebSettings::WebAttribute cpp_arg0 = Shiboken::Converter<QWebSettings::WebAttribute >::toCpp(arg);
        // resetAttribute(QWebSettings::WebAttribute)
        QWebSettings* cppSelf = Shiboken::Converter<QWebSettings* >::toCpp((PyObject*)self);
        cppSelf->QWebSettings::resetAttribute(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_resetAttribute_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_resetAttribute_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebSettings.WebAttribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.resetAttribute", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_resetFontFamily(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWebSettings::FontFamily >::isConvertible(arg)) {
        QWebSettings::FontFamily cpp_arg0 = Shiboken::Converter<QWebSettings::FontFamily >::toCpp(arg);
        // resetFontFamily(QWebSettings::FontFamily)
        QWebSettings* cppSelf = Shiboken::Converter<QWebSettings* >::toCpp((PyObject*)self);
        cppSelf->QWebSettings::resetFontFamily(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_resetFontFamily_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_resetFontFamily_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebSettings.FontFamily", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.resetFontFamily", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_resetFontSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWebSettings::FontSize >::isConvertible(arg)) {
        QWebSettings::FontSize cpp_arg0 = Shiboken::Converter<QWebSettings::FontSize >::toCpp(arg);
        // resetFontSize(QWebSettings::FontSize)
        QWebSettings* cppSelf = Shiboken::Converter<QWebSettings* >::toCpp((PyObject*)self);
        cppSelf->QWebSettings::resetFontSize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_resetFontSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_resetFontSize_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebSettings.FontSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.resetFontSize", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_setAttribute(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setAttribute", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWebSettings::WebAttribute >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        QWebSettings::WebAttribute cpp_arg0 = Shiboken::Converter<QWebSettings::WebAttribute >::toCpp(pyargs[0]);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // setAttribute(QWebSettings::WebAttribute,bool)
        QWebSettings* cppSelf = Shiboken::Converter<QWebSettings* >::toCpp((PyObject*)self);
        cppSelf->QWebSettings::setAttribute(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_setAttribute_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_setAttribute_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebSettings.WebAttribute, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebSettings.setAttribute", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_setDefaultTextEncoding(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setDefaultTextEncoding(QString)
        QWebSettings* cppSelf = Shiboken::Converter<QWebSettings* >::toCpp((PyObject*)self);
        cppSelf->QWebSettings::setDefaultTextEncoding(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_setDefaultTextEncoding_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_setDefaultTextEncoding_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.setDefaultTextEncoding", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_setFontFamily(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setFontFamily", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWebSettings::FontFamily >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        QWebSettings::FontFamily cpp_arg0 = Shiboken::Converter<QWebSettings::FontFamily >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setFontFamily(QWebSettings::FontFamily,QString)
        QWebSettings* cppSelf = Shiboken::Converter<QWebSettings* >::toCpp((PyObject*)self);
        cppSelf->QWebSettings::setFontFamily(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_setFontFamily_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_setFontFamily_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebSettings.FontFamily, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebSettings.setFontFamily", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_setFontSize(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setFontSize", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWebSettings::FontSize >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        QWebSettings::FontSize cpp_arg0 = Shiboken::Converter<QWebSettings::FontSize >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setFontSize(QWebSettings::FontSize,int)
        QWebSettings* cppSelf = Shiboken::Converter<QWebSettings* >::toCpp((PyObject*)self);
        cppSelf->QWebSettings::setFontSize(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_setFontSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_setFontSize_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebSettings.FontSize, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebSettings.setFontSize", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_setIconDatabasePath(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setIconDatabasePath(QString)
        QWebSettings::setIconDatabasePath(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_setIconDatabasePath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_setIconDatabasePath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.setIconDatabasePath", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_setLocalStoragePath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setLocalStoragePath(QString)
        QWebSettings* cppSelf = Shiboken::Converter<QWebSettings* >::toCpp((PyObject*)self);
        cppSelf->QWebSettings::setLocalStoragePath(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_setLocalStoragePath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_setLocalStoragePath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.setLocalStoragePath", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_setMaximumPagesInCache(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMaximumPagesInCache(int)
        QWebSettings::setMaximumPagesInCache(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_setMaximumPagesInCache_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_setMaximumPagesInCache_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.setMaximumPagesInCache", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_setObjectCacheCapacities(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setObjectCacheCapacities", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // setObjectCacheCapacities(int,int,int)
        QWebSettings::setObjectCacheCapacities(cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_setObjectCacheCapacities_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_setObjectCacheCapacities_TypeError:
        const char* overloads[] = {"int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebSettings.setObjectCacheCapacities", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_setOfflineStorageDefaultQuota(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // setOfflineStorageDefaultQuota(qint64)
        QWebSettings::setOfflineStorageDefaultQuota(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_setOfflineStorageDefaultQuota_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_setOfflineStorageDefaultQuota_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.setOfflineStorageDefaultQuota", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_setOfflineStoragePath(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setOfflineStoragePath(QString)
        QWebSettings::setOfflineStoragePath(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_setOfflineStoragePath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_setOfflineStoragePath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.setOfflineStoragePath", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_setOfflineWebApplicationCachePath(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setOfflineWebApplicationCachePath(QString)
        QWebSettings::setOfflineWebApplicationCachePath(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_setOfflineWebApplicationCachePath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_setOfflineWebApplicationCachePath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.setOfflineWebApplicationCachePath", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_setOfflineWebApplicationCacheQuota(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // setOfflineWebApplicationCacheQuota(qint64)
        QWebSettings::setOfflineWebApplicationCacheQuota(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_setOfflineWebApplicationCacheQuota_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_setOfflineWebApplicationCacheQuota_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.setOfflineWebApplicationCacheQuota", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_setUserStyleSheetUrl(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QUrl & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
        if (!SbkQUrl_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // setUserStyleSheetUrl(QUrl)
        QWebSettings* cppSelf = Shiboken::Converter<QWebSettings* >::toCpp((PyObject*)self);
        cppSelf->QWebSettings::setUserStyleSheetUrl(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_setUserStyleSheetUrl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_setUserStyleSheetUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.setUserStyleSheetUrl", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_setWebGraphic(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setWebGraphic", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWebSettings::WebGraphic >::isConvertible(pyargs[0]) && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[1])) {
        QWebSettings::WebGraphic cpp_arg0 = Shiboken::Converter<QWebSettings::WebGraphic >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg1_auto_ptr;
        QPixmap* cpp_arg1 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[1]);
        if (!SbkQPixmap_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg1);
        // setWebGraphic(QWebSettings::WebGraphic,QPixmap)
        QWebSettings::setWebGraphic(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_setWebGraphic_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebSettingsFunc_setWebGraphic_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebSettings.WebGraphic, PySide.QtGui.QPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebSettings.setWebGraphic", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_testAttribute(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWebSettings::WebAttribute >::isConvertible(arg)) {
        QWebSettings::WebAttribute cpp_arg0 = Shiboken::Converter<QWebSettings::WebAttribute >::toCpp(arg);
        // testAttribute(QWebSettings::WebAttribute)const
        QWebSettings* cppSelf = Shiboken::Converter<QWebSettings* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWebSettings::testAttribute(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_testAttribute_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebSettingsFunc_testAttribute_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebSettings.WebAttribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.testAttribute", overloads);
        return 0;
}

static PyObject* SbkQWebSettingsFunc_userStyleSheetUrl(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // userStyleSheetUrl()const
    QWebSettings* cppSelf = Shiboken::Converter<QWebSettings* >::toCpp((PyObject*)self);
    QUrl cpp_result = cppSelf->QWebSettings::userStyleSheetUrl();
    py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebSettingsFunc_webGraphic(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QWebSettings::WebGraphic >::isConvertible(arg)) {
        QWebSettings::WebGraphic cpp_arg0 = Shiboken::Converter<QWebSettings::WebGraphic >::toCpp(arg);
        // webGraphic(QWebSettings::WebGraphic)
        QPixmap cpp_result = QWebSettings::webGraphic(cpp_arg0);
        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebSettingsFunc_webGraphic_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebSettingsFunc_webGraphic_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebSettings.WebGraphic", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebSettings.webGraphic", overloads);
        return 0;
}

static PyMethodDef SbkQWebSettings_methods[] = {
    {"clearIconDatabase", (PyCFunction)SbkQWebSettingsFunc_clearIconDatabase, METH_NOARGS|METH_STATIC},
    {"clearMemoryCaches", (PyCFunction)SbkQWebSettingsFunc_clearMemoryCaches, METH_NOARGS|METH_STATIC},
    {"defaultTextEncoding", (PyCFunction)SbkQWebSettingsFunc_defaultTextEncoding, METH_NOARGS},
    {"enablePersistentStorage", (PyCFunction)SbkQWebSettingsFunc_enablePersistentStorage, METH_NOARGS|METH_O|METH_STATIC},
    {"fontFamily", (PyCFunction)SbkQWebSettingsFunc_fontFamily, METH_O},
    {"fontSize", (PyCFunction)SbkQWebSettingsFunc_fontSize, METH_O},
    {"globalSettings", (PyCFunction)SbkQWebSettingsFunc_globalSettings, METH_NOARGS|METH_STATIC},
    {"iconDatabasePath", (PyCFunction)SbkQWebSettingsFunc_iconDatabasePath, METH_NOARGS|METH_STATIC},
    {"iconForUrl", (PyCFunction)SbkQWebSettingsFunc_iconForUrl, METH_O|METH_STATIC},
    {"localStoragePath", (PyCFunction)SbkQWebSettingsFunc_localStoragePath, METH_NOARGS},
    {"maximumPagesInCache", (PyCFunction)SbkQWebSettingsFunc_maximumPagesInCache, METH_NOARGS|METH_STATIC},
    {"offlineStorageDefaultQuota", (PyCFunction)SbkQWebSettingsFunc_offlineStorageDefaultQuota, METH_NOARGS|METH_STATIC},
    {"offlineStoragePath", (PyCFunction)SbkQWebSettingsFunc_offlineStoragePath, METH_NOARGS|METH_STATIC},
    {"offlineWebApplicationCachePath", (PyCFunction)SbkQWebSettingsFunc_offlineWebApplicationCachePath, METH_NOARGS|METH_STATIC},
    {"offlineWebApplicationCacheQuota", (PyCFunction)SbkQWebSettingsFunc_offlineWebApplicationCacheQuota, METH_NOARGS|METH_STATIC},
    {"resetAttribute", (PyCFunction)SbkQWebSettingsFunc_resetAttribute, METH_O},
    {"resetFontFamily", (PyCFunction)SbkQWebSettingsFunc_resetFontFamily, METH_O},
    {"resetFontSize", (PyCFunction)SbkQWebSettingsFunc_resetFontSize, METH_O},
    {"setAttribute", (PyCFunction)SbkQWebSettingsFunc_setAttribute, METH_VARARGS},
    {"setDefaultTextEncoding", (PyCFunction)SbkQWebSettingsFunc_setDefaultTextEncoding, METH_O},
    {"setFontFamily", (PyCFunction)SbkQWebSettingsFunc_setFontFamily, METH_VARARGS},
    {"setFontSize", (PyCFunction)SbkQWebSettingsFunc_setFontSize, METH_VARARGS},
    {"setIconDatabasePath", (PyCFunction)SbkQWebSettingsFunc_setIconDatabasePath, METH_O|METH_STATIC},
    {"setLocalStoragePath", (PyCFunction)SbkQWebSettingsFunc_setLocalStoragePath, METH_O},
    {"setMaximumPagesInCache", (PyCFunction)SbkQWebSettingsFunc_setMaximumPagesInCache, METH_O|METH_STATIC},
    {"setObjectCacheCapacities", (PyCFunction)SbkQWebSettingsFunc_setObjectCacheCapacities, METH_VARARGS|METH_STATIC},
    {"setOfflineStorageDefaultQuota", (PyCFunction)SbkQWebSettingsFunc_setOfflineStorageDefaultQuota, METH_O|METH_STATIC},
    {"setOfflineStoragePath", (PyCFunction)SbkQWebSettingsFunc_setOfflineStoragePath, METH_O|METH_STATIC},
    {"setOfflineWebApplicationCachePath", (PyCFunction)SbkQWebSettingsFunc_setOfflineWebApplicationCachePath, METH_O|METH_STATIC},
    {"setOfflineWebApplicationCacheQuota", (PyCFunction)SbkQWebSettingsFunc_setOfflineWebApplicationCacheQuota, METH_O|METH_STATIC},
    {"setUserStyleSheetUrl", (PyCFunction)SbkQWebSettingsFunc_setUserStyleSheetUrl, METH_O},
    {"setWebGraphic", (PyCFunction)SbkQWebSettingsFunc_setWebGraphic, METH_VARARGS|METH_STATIC},
    {"testAttribute", (PyCFunction)SbkQWebSettingsFunc_testAttribute, METH_O},
    {"userStyleSheetUrl", (PyCFunction)SbkQWebSettingsFunc_userStyleSheetUrl, METH_NOARGS},
    {"webGraphic", (PyCFunction)SbkQWebSettingsFunc_webGraphic, METH_O|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWebSettings_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtWebKit.QWebSettings",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          Shiboken::deallocWrapperWithPrivateDtor,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWebSettings_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            0,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtWebKit_QWebSettings_FontSize_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtWebKit_QWebSettings_FontSize_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtWebKit_QWebSettings_FontSize_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FontSize",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtWebKit_QWebSettings_FontSize_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtWebKit_QWebSettings_FontSize_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtWebKit_QWebSettings_FontSize_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtWebKit_QWebSettings_WebGraphic_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtWebKit_QWebSettings_WebGraphic_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtWebKit_QWebSettings_WebGraphic_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WebGraphic",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtWebKit_QWebSettings_WebGraphic_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtWebKit_QWebSettings_WebGraphic_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtWebKit_QWebSettings_WebGraphic_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtWebKit_QWebSettings_FontFamily_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtWebKit_QWebSettings_FontFamily_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtWebKit_QWebSettings_FontFamily_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FontFamily",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtWebKit_QWebSettings_FontFamily_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtWebKit_QWebSettings_FontFamily_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtWebKit_QWebSettings_FontFamily_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtWebKit_QWebSettings_WebAttribute_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtWebKit_QWebSettings_WebAttribute_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WebAttribute",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtWebKit_QWebSettings_WebAttribute_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtWebKit_QWebSettings_WebAttribute_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtWebKit_QWebSettings_WebAttribute_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QWebSettings(PyObject* module)
{
    SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWebSettings_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQWebSettings_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQWebSettings_Type));
    PyModule_AddObject(module, "QWebSettings",
        ((PyObject*)&SbkQWebSettings_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: FontSize
    SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_FONTSIZE_IDX] = &SbkPySide_QtWebKit_QWebSettings_FontSize_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtWebKit_QWebSettings_FontSize_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtWebKit_QWebSettings_FontSize_Type);
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
            "FontSize",((PyObject*)&SbkPySide_QtWebKit_QWebSettings_FontSize_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_FontSize_Type,
        (long) QWebSettings::MinimumFontSize, "MinimumFontSize");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "MinimumFontSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_FontSize_Type.tp_dict,
        "MinimumFontSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_FontSize_Type,
        (long) QWebSettings::MinimumLogicalFontSize, "MinimumLogicalFontSize");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "MinimumLogicalFontSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_FontSize_Type.tp_dict,
        "MinimumLogicalFontSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_FontSize_Type,
        (long) QWebSettings::DefaultFontSize, "DefaultFontSize");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "DefaultFontSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_FontSize_Type.tp_dict,
        "DefaultFontSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_FontSize_Type,
        (long) QWebSettings::DefaultFixedFontSize, "DefaultFixedFontSize");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "DefaultFixedFontSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_FontSize_Type.tp_dict,
        "DefaultFixedFontSize", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWebSettings::FontSize");

    // init enum class: WebGraphic
    SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_WEBGRAPHIC_IDX] = &SbkPySide_QtWebKit_QWebSettings_WebGraphic_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtWebKit_QWebSettings_WebGraphic_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtWebKit_QWebSettings_WebGraphic_Type);
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
            "WebGraphic",((PyObject*)&SbkPySide_QtWebKit_QWebSettings_WebGraphic_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebGraphic_Type,
        (long) QWebSettings::MissingImageGraphic, "MissingImageGraphic");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "MissingImageGraphic", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebGraphic_Type.tp_dict,
        "MissingImageGraphic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebGraphic_Type,
        (long) QWebSettings::MissingPluginGraphic, "MissingPluginGraphic");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "MissingPluginGraphic", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebGraphic_Type.tp_dict,
        "MissingPluginGraphic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebGraphic_Type,
        (long) QWebSettings::DefaultFrameIconGraphic, "DefaultFrameIconGraphic");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "DefaultFrameIconGraphic", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebGraphic_Type.tp_dict,
        "DefaultFrameIconGraphic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebGraphic_Type,
        (long) QWebSettings::TextAreaSizeGripCornerGraphic, "TextAreaSizeGripCornerGraphic");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "TextAreaSizeGripCornerGraphic", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebGraphic_Type.tp_dict,
        "TextAreaSizeGripCornerGraphic", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWebSettings::WebGraphic");

    // init enum class: FontFamily
    SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_FONTFAMILY_IDX] = &SbkPySide_QtWebKit_QWebSettings_FontFamily_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtWebKit_QWebSettings_FontFamily_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtWebKit_QWebSettings_FontFamily_Type);
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
            "FontFamily",((PyObject*)&SbkPySide_QtWebKit_QWebSettings_FontFamily_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_FontFamily_Type,
        (long) QWebSettings::StandardFont, "StandardFont");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "StandardFont", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_FontFamily_Type.tp_dict,
        "StandardFont", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_FontFamily_Type,
        (long) QWebSettings::FixedFont, "FixedFont");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "FixedFont", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_FontFamily_Type.tp_dict,
        "FixedFont", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_FontFamily_Type,
        (long) QWebSettings::SerifFont, "SerifFont");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "SerifFont", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_FontFamily_Type.tp_dict,
        "SerifFont", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_FontFamily_Type,
        (long) QWebSettings::SansSerifFont, "SansSerifFont");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "SansSerifFont", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_FontFamily_Type.tp_dict,
        "SansSerifFont", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_FontFamily_Type,
        (long) QWebSettings::CursiveFont, "CursiveFont");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "CursiveFont", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_FontFamily_Type.tp_dict,
        "CursiveFont", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_FontFamily_Type,
        (long) QWebSettings::FantasyFont, "FantasyFont");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "FantasyFont", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_FontFamily_Type.tp_dict,
        "FantasyFont", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWebSettings::FontFamily");

    // init enum class: WebAttribute
    SbkPySide_QtWebKitTypes[SBK_QWEBSETTINGS_WEBATTRIBUTE_IDX] = &SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type);
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
            "WebAttribute",((PyObject*)&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type,
        (long) QWebSettings::AutoLoadImages, "AutoLoadImages");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "AutoLoadImages", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type.tp_dict,
        "AutoLoadImages", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type,
        (long) QWebSettings::JavascriptEnabled, "JavascriptEnabled");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "JavascriptEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type.tp_dict,
        "JavascriptEnabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type,
        (long) QWebSettings::JavaEnabled, "JavaEnabled");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "JavaEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type.tp_dict,
        "JavaEnabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type,
        (long) QWebSettings::PluginsEnabled, "PluginsEnabled");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "PluginsEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type.tp_dict,
        "PluginsEnabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type,
        (long) QWebSettings::PrivateBrowsingEnabled, "PrivateBrowsingEnabled");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "PrivateBrowsingEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type.tp_dict,
        "PrivateBrowsingEnabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type,
        (long) QWebSettings::JavascriptCanOpenWindows, "JavascriptCanOpenWindows");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "JavascriptCanOpenWindows", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type.tp_dict,
        "JavascriptCanOpenWindows", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type,
        (long) QWebSettings::JavascriptCanAccessClipboard, "JavascriptCanAccessClipboard");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "JavascriptCanAccessClipboard", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type.tp_dict,
        "JavascriptCanAccessClipboard", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type,
        (long) QWebSettings::DeveloperExtrasEnabled, "DeveloperExtrasEnabled");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "DeveloperExtrasEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type.tp_dict,
        "DeveloperExtrasEnabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type,
        (long) QWebSettings::LinksIncludedInFocusChain, "LinksIncludedInFocusChain");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "LinksIncludedInFocusChain", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type.tp_dict,
        "LinksIncludedInFocusChain", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type,
        (long) QWebSettings::ZoomTextOnly, "ZoomTextOnly");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "ZoomTextOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type.tp_dict,
        "ZoomTextOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type,
        (long) QWebSettings::PrintElementBackgrounds, "PrintElementBackgrounds");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "PrintElementBackgrounds", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type.tp_dict,
        "PrintElementBackgrounds", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type,
        (long) QWebSettings::OfflineStorageDatabaseEnabled, "OfflineStorageDatabaseEnabled");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "OfflineStorageDatabaseEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type.tp_dict,
        "OfflineStorageDatabaseEnabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type,
        (long) QWebSettings::OfflineWebApplicationCacheEnabled, "OfflineWebApplicationCacheEnabled");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "OfflineWebApplicationCacheEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type.tp_dict,
        "OfflineWebApplicationCacheEnabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type,
        (long) QWebSettings::LocalStorageEnabled, "LocalStorageEnabled");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "LocalStorageEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type.tp_dict,
        "LocalStorageEnabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type,
        (long) QWebSettings::LocalStorageDatabaseEnabled, "LocalStorageDatabaseEnabled");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "LocalStorageDatabaseEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type.tp_dict,
        "LocalStorageDatabaseEnabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type,
        (long) QWebSettings::LocalContentCanAccessRemoteUrls, "LocalContentCanAccessRemoteUrls");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "LocalContentCanAccessRemoteUrls", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type.tp_dict,
        "LocalContentCanAccessRemoteUrls", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type,
        (long) QWebSettings::DnsPrefetchEnabled, "DnsPrefetchEnabled");
    PyDict_SetItemString(SbkQWebSettings_Type.super.ht_type.tp_dict,
        "DnsPrefetchEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtWebKit_QWebSettings_WebAttribute_Type.tp_dict,
        "DnsPrefetchEnabled", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWebSettings::WebAttribute");

    Shiboken::TypeResolver::createObjectTypeResolver<QWebSettings >("QWebSettings*");
    Shiboken::TypeResolver::createObjectTypeResolver<QWebSettings >(typeid(QWebSettings).name());
}


} // extern "C"

