/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_QTTEST_PYTHON_H
#define SBK_QTTEST_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#if defined _WIN32 || defined __CYGWIN__
    #define SHIBOKEN_QTTEST_API __declspec(dllexport)
#else
#if __GNUC__ >= 4
    #define SHIBOKEN_QTTEST_API __attribute__ ((visibility("default")))
#else
    #define SHIBOKEN_QTTEST_API
#endif
#endif

// Module Includes
#include <pyside_qtgui_python.h>
#include <pyside_qtcore_python.h>

// Binded library includes
#include <qtestelementattribute.h>
#include <qtestmouse.h>
#include <qtest_global.h>
#include <qtestkeyboard.h>
// Conversion Includes - Primitive Types
#include <QTextDocument>
#include <QtConcurrentFilter>

// Conversion Includes - Container Types
#include <QMap>
#include <QVector>
#include <QSet>
#include <QPair>
#include <pysideconversions.h>
#include <qqueue.h>
#include <QList>
#include <QMultiMap>

// Type indices
#define SBK_QTEST_IDX                                                0
#define SBK_QTEST_LOGELEMENTTYPE_IDX                                 1
#define SBK_QTEST_ATTRIBUTEINDEX_IDX                                 2
#define SBK_QTEST_TESTFAILMODE_IDX                                   3
#define SBK_QTEST_MOUSEACTION_IDX                                    4
#define SBK_QTEST_SKIPMODE_IDX                                       5
#define SBK_QTEST_KEYACTION_IDX                                      6
#define SBK_QtTest_IDX_COUNT                                         7

// This variable stores all python types exported by this module
extern PyTypeObject** SbkPySide_QtTestTypes;

// Macros for type check
#define SbkPySide_QtTest_QTest_LogElementType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtTestTypes[SBK_QTEST_LOGELEMENTTYPE_IDX])
#define SbkPySide_QtTest_QTest_AttributeIndex_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtTestTypes[SBK_QTEST_ATTRIBUTEINDEX_IDX])
#define SbkPySide_QtTest_QTest_TestFailMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtTestTypes[SBK_QTEST_TESTFAILMODE_IDX])
#define SbkPySide_QtTest_QTest_MouseAction_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtTestTypes[SBK_QTEST_MOUSEACTION_IDX])
#define SbkPySide_QtTest_QTest_SkipMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtTestTypes[SBK_QTEST_SKIPMODE_IDX])
#define SbkPySide_QtTest_QTest_KeyAction_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtTestTypes[SBK_QTEST_KEYACTION_IDX])

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QTest::LogElementType >() { return SbkPySide_QtTestTypes[SBK_QTEST_LOGELEMENTTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QTest::AttributeIndex >() { return SbkPySide_QtTestTypes[SBK_QTEST_ATTRIBUTEINDEX_IDX]; }
template<> inline PyTypeObject* SbkType<QTest::TestFailMode >() { return SbkPySide_QtTestTypes[SBK_QTEST_TESTFAILMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QTest::MouseAction >() { return SbkPySide_QtTestTypes[SBK_QTEST_MOUSEACTION_IDX]; }
template<> inline PyTypeObject* SbkType<QTest::SkipMode >() { return SbkPySide_QtTestTypes[SBK_QTEST_SKIPMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QTest::KeyAction >() { return SbkPySide_QtTestTypes[SBK_QTEST_KEYACTION_IDX]; }

// Generated converters declarations ----------------------------------

template<>
struct Converter<QTest::LogElementType > : EnumConverter<QTest::LogElementType >
{
};

template<>
struct Converter<QTest::AttributeIndex > : EnumConverter<QTest::AttributeIndex >
{
};

template<>
struct Converter<QTest::TestFailMode > : EnumConverter<QTest::TestFailMode >
{
};

template<>
struct Converter<QTest::MouseAction > : EnumConverter<QTest::MouseAction >
{
};

template<>
struct Converter<QTest::SkipMode > : EnumConverter<QTest::SkipMode >
{
};

template<>
struct Converter<QTest::KeyAction > : EnumConverter<QTest::KeyAction >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------


#endif // SBK_QTTEST_PYTHON_H

