/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtsql_python.h"

#include "qsqlrecord_wrapper.h"

// Extra includes
#include <QSqlField>
#include <qsqlfield.h>
#include <qsqlrecord.h>
#include <qstring.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QSqlRecordWrapper::QSqlRecordWrapper() : QSqlRecord() {
    // ... middle
}

QSqlRecordWrapper::~QSqlRecordWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQSqlRecord_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSqlRecordWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QSqlRecord", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QSqlRecord()
        cptr = new QSqlRecordWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QSqlRecord & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSqlRecord* cpp_arg0 = Shiboken::Converter<QSqlRecord* >::toCpp(pyargs[0]);
        // QSqlRecord(QSqlRecord)
        cptr = new QSqlRecordWrapper(*reinterpret_cast<QSqlRecordWrapper*>(cpp_arg0));
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlRecord_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QSqlRecord >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSqlRecord_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQSqlRecord_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtSql.QSqlRecord", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlRecord", overloads);
        return -1;
}

static PyObject* SbkQSqlRecordFunc_append(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSqlField & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSqlField* cpp_arg0 = Shiboken::Converter<QSqlField* >::toCpp(arg);
        // append(QSqlField)
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        cppSelf->QSqlRecord::append(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlRecordFunc_append_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlRecordFunc_append_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlField", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlRecord.append", overloads);
        return 0;
}

static PyObject* SbkQSqlRecordFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
    cppSelf->QSqlRecord::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQSqlRecordFunc_clearValues(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearValues()
    QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
    cppSelf->QSqlRecord::clearValues();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQSqlRecordFunc_contains(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // contains(QString)const
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlRecord::contains(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlRecordFunc_contains_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSqlRecordFunc_contains_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlRecord.contains", overloads);
        return 0;
}

static PyObject* SbkQSqlRecordFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSqlRecord::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSqlRecordFunc_field(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // field(int)const
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        QSqlField cpp_result = cppSelf->QSqlRecord::field(cpp_arg0);
        py_result = Shiboken::Converter<QSqlField >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // field(QString)const
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        QSqlField cpp_result = cppSelf->QSqlRecord::field(*cpp_arg0);
        py_result = Shiboken::Converter<QSqlField >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlRecordFunc_field_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSqlRecordFunc_field_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlRecord.field", overloads);
        return 0;
}

static PyObject* SbkQSqlRecordFunc_fieldName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // fieldName(int)const
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QSqlRecord::fieldName(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlRecordFunc_fieldName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSqlRecordFunc_fieldName_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlRecord.fieldName", overloads);
        return 0;
}

static PyObject* SbkQSqlRecordFunc_indexOf(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // indexOf(QString)const
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QSqlRecord::indexOf(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlRecordFunc_indexOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSqlRecordFunc_indexOf_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlRecord.indexOf", overloads);
        return 0;
}

static PyObject* SbkQSqlRecordFunc_insert(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insert", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QSqlField & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QSqlField* cpp_arg1 = Shiboken::Converter<QSqlField* >::toCpp(pyargs[1]);
        // insert(int,QSqlField)
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        cppSelf->QSqlRecord::insert(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlRecordFunc_insert_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlRecordFunc_insert_TypeError:
        const char* overloads[] = {"int, PySide.QtSql.QSqlField", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlRecord.insert", overloads);
        return 0;
}

static PyObject* SbkQSqlRecordFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlRecord::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSqlRecordFunc_isGenerated(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // isGenerated(int)const
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlRecord::isGenerated(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // isGenerated(QString)const
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlRecord::isGenerated(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlRecordFunc_isGenerated_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSqlRecordFunc_isGenerated_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlRecord.isGenerated", overloads);
        return 0;
}

static PyObject* SbkQSqlRecordFunc_isNull(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // isNull(int)const
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlRecord::isNull(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // isNull(QString)const
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlRecord::isNull(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlRecordFunc_isNull_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSqlRecordFunc_isNull_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlRecord.isNull", overloads);
        return 0;
}

static PyObject* SbkQSqlRecordFunc_remove(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // remove(int)
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        cppSelf->QSqlRecord::remove(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlRecordFunc_remove_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlRecordFunc_remove_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlRecord.remove", overloads);
        return 0;
}

static PyObject* SbkQSqlRecordFunc_replace(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "replace", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QSqlField & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QSqlField* cpp_arg1 = Shiboken::Converter<QSqlField* >::toCpp(pyargs[1]);
        // replace(int,QSqlField)
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        cppSelf->QSqlRecord::replace(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlRecordFunc_replace_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlRecordFunc_replace_TypeError:
        const char* overloads[] = {"int, PySide.QtSql.QSqlField", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlRecord.replace", overloads);
        return 0;
}

static PyObject* SbkQSqlRecordFunc_setGenerated(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setGenerated", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // setGenerated(int,bool)
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        cppSelf->QSqlRecord::setGenerated(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // setGenerated(QString,bool)
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        cppSelf->QSqlRecord::setGenerated(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlRecordFunc_setGenerated_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlRecordFunc_setGenerated_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool", "int, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlRecord.setGenerated", overloads);
        return 0;
}

static PyObject* SbkQSqlRecordFunc_setNull(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setNull(int)
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        cppSelf->QSqlRecord::setNull(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setNull(QString)
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        cppSelf->QSqlRecord::setNull(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlRecordFunc_setNull_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlRecordFunc_setNull_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlRecord.setNull", overloads);
        return 0;
}

static PyObject* SbkQSqlRecordFunc_setValue(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setValue", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // setValue(int,QVariant)
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        cppSelf->QSqlRecord::setValue(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // setValue(QString,QVariant)
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        cppSelf->QSqlRecord::setValue(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlRecordFunc_setValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlRecordFunc_setValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QVariant", "int, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlRecord.setValue", overloads);
        return 0;
}

static PyObject* SbkQSqlRecordFunc_value(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // value(int)const
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QSqlRecord::value(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // value(QString)const
        QSqlRecord* cppSelf = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QSqlRecord::value(*cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlRecordFunc_value_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSqlRecordFunc_value_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlRecord.value", overloads);
        return 0;
}

static PyMethodDef SbkQSqlRecord_methods[] = {
    {"append", (PyCFunction)SbkQSqlRecordFunc_append, METH_O},
    {"clear", (PyCFunction)SbkQSqlRecordFunc_clear, METH_NOARGS},
    {"clearValues", (PyCFunction)SbkQSqlRecordFunc_clearValues, METH_NOARGS},
    {"contains", (PyCFunction)SbkQSqlRecordFunc_contains, METH_O},
    {"count", (PyCFunction)SbkQSqlRecordFunc_count, METH_NOARGS},
    {"field", (PyCFunction)SbkQSqlRecordFunc_field, METH_O},
    {"fieldName", (PyCFunction)SbkQSqlRecordFunc_fieldName, METH_O},
    {"indexOf", (PyCFunction)SbkQSqlRecordFunc_indexOf, METH_O},
    {"insert", (PyCFunction)SbkQSqlRecordFunc_insert, METH_VARARGS},
    {"isEmpty", (PyCFunction)SbkQSqlRecordFunc_isEmpty, METH_NOARGS},
    {"isGenerated", (PyCFunction)SbkQSqlRecordFunc_isGenerated, METH_O},
    {"isNull", (PyCFunction)SbkQSqlRecordFunc_isNull, METH_O},
    {"remove", (PyCFunction)SbkQSqlRecordFunc_remove, METH_O},
    {"replace", (PyCFunction)SbkQSqlRecordFunc_replace, METH_VARARGS},
    {"setGenerated", (PyCFunction)SbkQSqlRecordFunc_setGenerated, METH_VARARGS},
    {"setNull", (PyCFunction)SbkQSqlRecordFunc_setNull, METH_O},
    {"setValue", (PyCFunction)SbkQSqlRecordFunc_setValue, METH_VARARGS},
    {"value", (PyCFunction)SbkQSqlRecordFunc_value, METH_O},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQSqlRecord_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QSqlRecord& cpp_self = *Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QSqlRecord & >::isConvertible(other)) {
                // operator!=(const QSqlRecord & other) const
                QSqlRecord* cpp_other = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QSqlRecord  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQSqlRecord_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QSqlRecord & >::isConvertible(other)) {
                // operator==(const QSqlRecord & other) const
                QSqlRecord* cpp_other = Shiboken::Converter<QSqlRecord* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QSqlRecord  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQSqlRecord_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQSqlRecord_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

static void* SbkQSqlRecord_ObjCopierFunc(const void* ptr){
    return new QSqlRecordWrapper(*reinterpret_cast<const QSqlRecord*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSqlRecord_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtSql.QSqlRecord",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQSqlRecord_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSqlRecord_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSqlRecord_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQSqlRecord_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QSqlRecord >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQSqlRecord_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQSqlRecord_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QSqlRecord*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void) init_QSqlRecord(PyObject* module)
{
    SbkPySide_QtSqlTypes[SBK_QSQLRECORD_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSqlRecord_Type);

    // Fill type discovery information
    SbkQSqlRecord_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQSqlRecord_Type.type_discovery->addTypeDiscoveryFunction(&SbkQSqlRecord_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQSqlRecord_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSqlRecord_Type));
    PyModule_AddObject(module, "QSqlRecord",
        ((PyObject*)&SbkQSqlRecord_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QSqlRecord >("QSqlRecord");
    Shiboken::TypeResolver::createValueTypeResolver<QSqlRecord >(typeid(QSqlRecord).name());
}


} // extern "C"

