/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtsql_python.h"

#include "qsqlindex_wrapper.h"

// Extra includes
#include <qsqlfield.h>
#include <qsqlindex.h>
#include <qsqlrecord.h>
#include <qstring.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QSqlIndexWrapper::QSqlIndexWrapper(const QString & cursorName, const QString & name) : QSqlIndex(cursorName, name) {
    // ... middle
}

QSqlIndexWrapper::~QSqlIndexWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQSqlIndex_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSqlIndexWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QSqlIndex", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QSqlIndex(QString,QString)
        cptr = new QSqlIndexWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QSqlIndex(QString,QString)
            cptr = new QSqlIndexWrapper(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // QSqlIndex(QString,QString)
            cptr = new QSqlIndexWrapper(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQSqlIndex_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QSqlIndex & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSqlIndex* cpp_arg0 = Shiboken::Converter<QSqlIndex* >::toCpp(pyargs[0]);
        // QSqlIndex(QSqlIndex)
        cptr = new QSqlIndexWrapper(*reinterpret_cast<QSqlIndexWrapper*>(cpp_arg0));
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlIndex_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QSqlIndex >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSqlIndex_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQSqlIndex_Init_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlIndex", "PySide.QtCore.QString = QString(), PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlIndex", overloads);
        return -1;
}

static PyObject* SbkQSqlIndexFunc_append(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "append", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QSqlField & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSqlField* cpp_arg0 = Shiboken::Converter<QSqlField* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // append(QSqlField)
            QSqlIndex* cppSelf = Shiboken::Converter<QSqlIndex* >::toCpp((PyObject*)self);
            cppSelf->QSqlIndex::append(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // append(QSqlField,bool)
            QSqlIndex* cppSelf = Shiboken::Converter<QSqlIndex* >::toCpp((PyObject*)self);
            cppSelf->QSqlIndex::append(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQSqlIndexFunc_append_TypeError;
    } else goto SbkQSqlIndexFunc_append_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlIndexFunc_append_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlField", "PySide.QtSql.QSqlField, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlIndex.append", overloads);
        return 0;
}

static PyObject* SbkQSqlIndexFunc_cursorName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cursorName()const
    QSqlIndex* cppSelf = Shiboken::Converter<QSqlIndex* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSqlIndex::cursorName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSqlIndexFunc_isDescending(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // isDescending(int)const
        QSqlIndex* cppSelf = Shiboken::Converter<QSqlIndex* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlIndex::isDescending(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlIndexFunc_isDescending_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSqlIndexFunc_isDescending_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlIndex.isDescending", overloads);
        return 0;
}

static PyObject* SbkQSqlIndexFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QSqlIndex* cppSelf = Shiboken::Converter<QSqlIndex* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSqlIndex::name();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSqlIndexFunc_setCursorName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setCursorName(QString)
        QSqlIndex* cppSelf = Shiboken::Converter<QSqlIndex* >::toCpp((PyObject*)self);
        cppSelf->QSqlIndex::setCursorName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlIndexFunc_setCursorName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlIndexFunc_setCursorName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlIndex.setCursorName", overloads);
        return 0;
}

static PyObject* SbkQSqlIndexFunc_setDescending(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setDescending", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // setDescending(int,bool)
        QSqlIndex* cppSelf = Shiboken::Converter<QSqlIndex* >::toCpp((PyObject*)self);
        cppSelf->QSqlIndex::setDescending(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlIndexFunc_setDescending_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlIndexFunc_setDescending_TypeError:
        const char* overloads[] = {"int, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlIndex.setDescending", overloads);
        return 0;
}

static PyObject* SbkQSqlIndexFunc_setName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setName(QString)
        QSqlIndex* cppSelf = Shiboken::Converter<QSqlIndex* >::toCpp((PyObject*)self);
        cppSelf->QSqlIndex::setName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSqlIndexFunc_setName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlIndexFunc_setName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlIndex.setName", overloads);
        return 0;
}

static PyMethodDef SbkQSqlIndex_methods[] = {
    {"append", (PyCFunction)SbkQSqlIndexFunc_append, METH_VARARGS},
    {"cursorName", (PyCFunction)SbkQSqlIndexFunc_cursorName, METH_NOARGS},
    {"isDescending", (PyCFunction)SbkQSqlIndexFunc_isDescending, METH_O},
    {"name", (PyCFunction)SbkQSqlIndexFunc_name, METH_NOARGS},
    {"setCursorName", (PyCFunction)SbkQSqlIndexFunc_setCursorName, METH_O},
    {"setDescending", (PyCFunction)SbkQSqlIndexFunc_setDescending, METH_VARARGS},
    {"setName", (PyCFunction)SbkQSqlIndexFunc_setName, METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQSqlIndex_ObjCopierFunc(const void* ptr){
    return new QSqlIndexWrapper(*reinterpret_cast<const QSqlIndex*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSqlIndex_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtSql.QSqlIndex",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSqlIndex_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSqlIndex_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQSqlIndex_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QSqlIndex >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QSqlIndex(PyObject* module)
{
    SbkPySide_QtSqlTypes[SBK_QSQLINDEX_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSqlIndex_Type);

    SbkQSqlIndex_Type.super.ht_type.tp_base = SbkPySide_QtSqlTypes[SBK_QSQLRECORD_IDX];
    // Fill type discovery information
    SbkQSqlIndex_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtSqlTypes[SBK_QSQLRECORD_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQSqlIndex_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSqlIndex_Type));
    PyModule_AddObject(module, "QSqlIndex",
        ((PyObject*)&SbkQSqlIndex_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QSqlIndex >("QSqlIndex");
    Shiboken::TypeResolver::createValueTypeResolver<QSqlIndex >(typeid(QSqlIndex).name());
}


} // extern "C"

