/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef PyMODINIT_FUNC  /* declarations for DLL import/export */
#define PyMODINIT_FUNC void
#endif

#include <Python.h>
#include <shiboken.h>
#include "pyside_qtscript_python.h"


// Global functions ------------------------------------------------------------

static PyMethodDef QtScript_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
extern "C" PyAPI_FUNC(void) init_QScriptable(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QScriptClass(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QScriptValue(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QScriptEngineAgent(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QScriptContextInfo(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QScriptClassPropertyIterator(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QScriptExtensionInterface(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QScriptExtensionPlugin(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QScriptContext(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QScriptValueIterator(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QScriptString(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QScriptEngine(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QScriptProgram(PyObject* module);

PyTypeObject** SbkPySide_QtScriptTypes;

PyTypeObject** SbkPySide_QtCoreTypes;

// Module initialization ------------------------------------------------------------
// Extended Converters
static bool ExtendedIsConvertible_PySide_QtCore_QString(PyObject* pyobj)
{
    return SbkQScriptString_Check(pyobj);
}
static void* ExtendedToCpp_PySide_QtCore_QString(PyObject* pyobj)
{
    void* cptr = 0;
    if (SbkQScriptString_Check(pyobj))
        cptr = new QString(Shiboken::Converter<QScriptString >::toCpp(pyobj));
    return cptr;
}


extern "C" {

SHIBOKEN_QTSCRIPT_API PyMODINIT_FUNC
initQtScript()
{
    if (!Shiboken::importModule("PySide.QtCore", &SbkPySide_QtCoreTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtCore");
        return;
    }

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("QtScript", QtScript_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_QtScript_IDX_COUNT];
    SbkPySide_QtScriptTypes = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system
    init_QScriptable(module);
    init_QScriptClass(module);
    init_QScriptValue(module);
    init_QScriptEngineAgent(module);
    init_QScriptContextInfo(module);
    init_QScriptClassPropertyIterator(module);
    init_QScriptExtensionInterface(module);
    init_QScriptExtensionPlugin(module);
    init_QScriptContext(module);
    init_QScriptValueIterator(module);
    init_QScriptString(module);
    init_QScriptEngine(module);
    init_QScriptProgram(module);
    // Initialize extended Converters
    Shiboken::SbkBaseWrapperType* shiboType;

    // Extended implicit conversions for PySide.QtCore.QString
    shiboType = reinterpret_cast<Shiboken::SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QSTRING_IDX]);
    shiboType->ext_isconvertible = ExtendedIsConvertible_PySide_QtCore_QString;
    shiboType->ext_tocpp = ExtendedToCpp_PySide_QtCore_QString;


    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtScript");
    }
}

} // extern "C"

