/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_QTSCRIPT_PYTHON_H
#define SBK_QTSCRIPT_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#if defined _WIN32 || defined __CYGWIN__
    #define SHIBOKEN_QTSCRIPT_API __declspec(dllexport)
#else
#if __GNUC__ >= 4
    #define SHIBOKEN_QTSCRIPT_API __attribute__ ((visibility("default")))
#else
    #define SHIBOKEN_QTSCRIPT_API
#endif
#endif

// Module Includes
#include <pyside_qtcore_python.h>

// Binded library includes
#include <qscriptvalueiterator.h>
#include <qscriptclass.h>
#include <qscriptvalue.h>
#include <qscriptcontext.h>
#include <qscriptprogram.h>
#include <qscriptextensioninterface.h>
#include <qscriptengineagent.h>
#include <qscriptclasspropertyiterator.h>
#include <qscriptextensionplugin.h>
#include <qscriptengine.h>
#include <qscriptcontextinfo.h>
#include <qscriptable.h>
#include <qscriptstring.h>
// Conversion Includes - Primitive Types
#include <QTextDocument>
#include <QtConcurrentFilter>

// Conversion Includes - Container Types
#include <QList>
#include <QMap>
#include <QMultiMap>
#include <QVector>
#include <QPair>
#include <pysideconversions.h>
#include <QSet>
#include <qqueue.h>

// Type indices
#define SBK_QSCRIPTABLE_IDX                                          0
#define SBK_QSCRIPTCLASS_IDX                                         1
#define SBK_QSCRIPTCLASS_QUERYFLAG_IDX                               2
#define SBK_QSCRIPTCLASS_EXTENSION_IDX                               3
#define SBK_QSCRIPTVALUE_IDX                                         4
#define SBK_QSCRIPTVALUE_RESOLVEFLAG_IDX                             5
#define SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX                            6
#define SBK_QSCRIPTVALUE_SPECIALVALUE_IDX                            7
#define SBK_QSCRIPTENGINEAGENT_IDX                                   8
#define SBK_QSCRIPTENGINEAGENT_EXTENSION_IDX                         9
#define SBK_QSCRIPTCONTEXTINFO_IDX                                   10
#define SBK_QSCRIPTCONTEXTINFO_FUNCTIONTYPE_IDX                      11
#define SBK_QSCRIPTCLASSPROPERTYITERATOR_IDX                         12
#define SBK_QSCRIPTEXTENSIONINTERFACE_IDX                            13
#define SBK_QSCRIPTEXTENSIONPLUGIN_IDX                               14
#define SBK_QSCRIPTCONTEXT_IDX                                       15
#define SBK_QSCRIPTCONTEXT_ERROR_IDX                                 16
#define SBK_QSCRIPTCONTEXT_EXECUTIONSTATE_IDX                        17
#define SBK_QSCRIPTVALUEITERATOR_IDX                                 18
#define SBK_QSCRIPTSTRING_IDX                                        19
#define SBK_QSCRIPTENGINE_IDX                                        20
#define SBK_QSCRIPTENGINE_VALUEOWNERSHIP_IDX                         21
#define SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX                      22
#define SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION__IDX              23
#define SBK_QSCRIPTPROGRAM_IDX                                       24
#define SBK_QtScript_IDX_COUNT                                       25

// This variable stores all python types exported by this module
extern PyTypeObject** SbkPySide_QtScriptTypes;

// Macros for type check
#define SbkQScriptable_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTABLE_IDX])
#define SbkPySide_QtScript_QScriptClass_QueryFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTCLASS_QUERYFLAG_IDX])
#define SbkPySide_QtScript_QScriptClass_Extension_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTCLASS_EXTENSION_IDX])
#define SbkQScriptClass_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTCLASS_IDX])
#define SbkPySide_QtScript_QScriptValue_ResolveFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTVALUE_RESOLVEFLAG_IDX])
#define SbkPySide_QtScript_QScriptValue_PropertyFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX])
#define SbkPySide_QtScript_QScriptValue_SpecialValue_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTVALUE_SPECIALVALUE_IDX])
#define SbkQScriptValue_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTVALUE_IDX])
#define SbkPySide_QtScript_QScriptEngineAgent_Extension_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_EXTENSION_IDX])
#define SbkQScriptEngineAgent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX])
#define SbkPySide_QtScript_QScriptContextInfo_FunctionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_FUNCTIONTYPE_IDX])
#define SbkQScriptContextInfo_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX])
#define SbkQScriptClassPropertyIterator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTCLASSPROPERTYITERATOR_IDX])
#define SbkQScriptExtensionInterface_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTEXTENSIONINTERFACE_IDX])
#define SbkQScriptExtensionPlugin_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTEXTENSIONPLUGIN_IDX])
#define SbkPySide_QtScript_QScriptContext_Error_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTCONTEXT_ERROR_IDX])
#define SbkPySide_QtScript_QScriptContext_ExecutionState_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTCONTEXT_EXECUTIONSTATE_IDX])
#define SbkQScriptContext_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX])
#define SbkQScriptValueIterator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX])
#define SbkQScriptString_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTSTRING_IDX])
#define SbkPySide_QtScript_QScriptEngine_ValueOwnership_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTENGINE_VALUEOWNERSHIP_IDX])
#define SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX])
#define SbkPySide_QtScript_QScriptEngine_QObjectWrapOptions_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION__IDX])
#define SbkQScriptEngine_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTENGINE_IDX])
#define SbkQScriptProgram_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTPROGRAM_IDX])

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QScriptable >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtScriptTypes[SBK_QSCRIPTABLE_IDX]); }
template<> inline PyTypeObject* SbkType<QScriptClass::QueryFlag >() { return SbkPySide_QtScriptTypes[SBK_QSCRIPTCLASS_QUERYFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QScriptClass::Extension >() { return SbkPySide_QtScriptTypes[SBK_QSCRIPTCLASS_EXTENSION_IDX]; }
template<> inline PyTypeObject* SbkType<QScriptClass >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtScriptTypes[SBK_QSCRIPTCLASS_IDX]); }
template<> inline PyTypeObject* SbkType<QScriptValue::ResolveFlag >() { return SbkPySide_QtScriptTypes[SBK_QSCRIPTVALUE_RESOLVEFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QScriptValue::PropertyFlag >() { return SbkPySide_QtScriptTypes[SBK_QSCRIPTVALUE_PROPERTYFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QScriptValue::SpecialValue >() { return SbkPySide_QtScriptTypes[SBK_QSCRIPTVALUE_SPECIALVALUE_IDX]; }
template<> inline PyTypeObject* SbkType<QScriptValue >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]); }
template<> inline PyTypeObject* SbkType<QScriptEngineAgent::Extension >() { return SbkPySide_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_EXTENSION_IDX]; }
template<> inline PyTypeObject* SbkType<QScriptEngineAgent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX]); }
template<> inline PyTypeObject* SbkType<QScriptContextInfo::FunctionType >() { return SbkPySide_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_FUNCTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QScriptContextInfo >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX]); }
template<> inline PyTypeObject* SbkType<QScriptClassPropertyIterator >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtScriptTypes[SBK_QSCRIPTCLASSPROPERTYITERATOR_IDX]); }
template<> inline PyTypeObject* SbkType<QScriptExtensionInterface >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtScriptTypes[SBK_QSCRIPTEXTENSIONINTERFACE_IDX]); }
template<> inline PyTypeObject* SbkType<QScriptExtensionPlugin >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtScriptTypes[SBK_QSCRIPTEXTENSIONPLUGIN_IDX]); }
template<> inline PyTypeObject* SbkType<QScriptContext::Error >() { return SbkPySide_QtScriptTypes[SBK_QSCRIPTCONTEXT_ERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QScriptContext::ExecutionState >() { return SbkPySide_QtScriptTypes[SBK_QSCRIPTCONTEXT_EXECUTIONSTATE_IDX]; }
template<> inline PyTypeObject* SbkType<QScriptContext >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX]); }
template<> inline PyTypeObject* SbkType<QScriptValueIterator >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX]); }
template<> inline PyTypeObject* SbkType<QScriptString >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]); }
template<> inline PyTypeObject* SbkType<QScriptEngine::ValueOwnership >() { return SbkPySide_QtScriptTypes[SBK_QSCRIPTENGINE_VALUEOWNERSHIP_IDX]; }
template<> inline PyTypeObject* SbkType<QScriptEngine::QObjectWrapOption >() { return SbkPySide_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QScriptEngine::QObjectWrapOption> >() { return SbkPySide_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION__IDX]; }
template<> inline PyTypeObject* SbkType<QScriptEngine >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtScriptTypes[SBK_QSCRIPTENGINE_IDX]); }
template<> inline PyTypeObject* SbkType<QScriptProgram >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtScriptTypes[SBK_QSCRIPTPROGRAM_IDX]); }

// Generated converters declarations ----------------------------------

template<>
struct Converter<QScriptable* > : ObjectTypeConverter<QScriptable >
{
};

template<>
struct Converter<QScriptable& > : ObjectTypeReferenceConverter<QScriptable >
{
};

template<>
struct Converter<QScriptClass::QueryFlag > : EnumConverter<QScriptClass::QueryFlag >
{
};

template<>
struct Converter<QScriptClass::Extension > : EnumConverter<QScriptClass::Extension >
{
};

template<>
struct Converter<QScriptClass* > : ObjectTypeConverter<QScriptClass >
{
};

template<>
struct Converter<QScriptClass& > : ObjectTypeReferenceConverter<QScriptClass >
{
};

template<>
struct Converter<QScriptValue::ResolveFlag > : EnumConverter<QScriptValue::ResolveFlag >
{
};

template<>
struct Converter<QScriptValue::PropertyFlag > : EnumConverter<QScriptValue::PropertyFlag >
{
};

template<>
struct Converter<QScriptValue::SpecialValue > : EnumConverter<QScriptValue::SpecialValue >
{
};

template<>
struct Converter<QScriptValue > : ValueTypeConverter<QScriptValue >
{
    static QScriptValue toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QScriptEngineAgent::Extension > : EnumConverter<QScriptEngineAgent::Extension >
{
};

template<>
struct Converter<QScriptEngineAgent* > : ObjectTypeConverter<QScriptEngineAgent >
{
};

template<>
struct Converter<QScriptEngineAgent& > : ObjectTypeReferenceConverter<QScriptEngineAgent >
{
};

template<>
struct Converter<QScriptContextInfo::FunctionType > : EnumConverter<QScriptContextInfo::FunctionType >
{
};

template<>
struct Converter<QScriptContextInfo > : ValueTypeConverter<QScriptContextInfo >
{
    static QScriptContextInfo toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QScriptClassPropertyIterator* > : ObjectTypeConverter<QScriptClassPropertyIterator >
{
};

template<>
struct Converter<QScriptClassPropertyIterator& > : ObjectTypeReferenceConverter<QScriptClassPropertyIterator >
{
};

template<>
struct Converter<QScriptExtensionInterface* > : ObjectTypeConverter<QScriptExtensionInterface >
{
};

template<>
struct Converter<QScriptExtensionInterface& > : ObjectTypeReferenceConverter<QScriptExtensionInterface >
{
};

template<>
struct Converter<QScriptExtensionPlugin* > : ObjectTypeConverter<QScriptExtensionPlugin >
{
};

template<>
struct Converter<QScriptExtensionPlugin& > : ObjectTypeReferenceConverter<QScriptExtensionPlugin >
{
};

template<>
struct Converter<QScriptContext::Error > : EnumConverter<QScriptContext::Error >
{
};

template<>
struct Converter<QScriptContext::ExecutionState > : EnumConverter<QScriptContext::ExecutionState >
{
};

template<>
struct Converter<QScriptContext* > : ObjectTypeConverter<QScriptContext >
{
};

template<>
struct Converter<QScriptContext& > : ObjectTypeReferenceConverter<QScriptContext >
{
};

template<>
struct Converter<QScriptValueIterator* > : ObjectTypeConverter<QScriptValueIterator >
{
};

template<>
struct Converter<QScriptValueIterator& > : ObjectTypeReferenceConverter<QScriptValueIterator >
{
};

template<>
struct Converter<QScriptString > : ValueTypeConverter<QScriptString >
{
};

template<>
struct Converter<QScriptEngine::ValueOwnership > : EnumConverter<QScriptEngine::ValueOwnership >
{
};

template<>
struct Converter<QScriptEngine::QObjectWrapOption > : EnumConverter<QScriptEngine::QObjectWrapOption >
{
};
template<>
struct Converter<QFlags<QScriptEngine::QObjectWrapOption> > : EnumConverter<QFlags<QScriptEngine::QObjectWrapOption> >
{
};

template<>
struct Converter<QScriptEngine* > : ObjectTypeConverter<QScriptEngine >
{
};

template<>
struct Converter<QScriptEngine& > : ObjectTypeReferenceConverter<QScriptEngine >
{
};

template<>
struct Converter<QScriptProgram* > : ObjectTypeConverter<QScriptProgram >
{
};

template<>
struct Converter<QScriptProgram& > : ObjectTypeReferenceConverter<QScriptProgram >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------

inline bool Shiboken::Converter<QScriptValue >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QScriptValue >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QScriptValue >());
    return Shiboken::Converter<QScriptValue::SpecialValue >::isConvertible(pyobj)
         || PyBool_Check(pyobj)
         || Shiboken::Converter<QLatin1String & >::isConvertible(pyobj)
         || Shiboken::Converter<QString & >::isConvertible(pyobj)
         || Shiboken::Converter<const char * >::isConvertible(pyobj)
         || PyFloat_Check(pyobj)
         || PyInt_Check(pyobj)
         || PyInt_Check(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QScriptValue Shiboken::Converter<QScriptValue >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QScriptValue)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QScriptValue >());
        if (Shiboken::Converter<QScriptValue::SpecialValue >::isConvertible(pyobj))
            return QScriptValue(Shiboken::Converter<QScriptValue::SpecialValue >::toCpp(pyobj));
        else if (PyBool_Check(pyobj))
            return QScriptValue(Shiboken::Converter<bool >::toCpp(pyobj));
        else if (Shiboken::Converter<QLatin1String & >::isConvertible(pyobj))
            return QScriptValue(Shiboken::Converter<QLatin1String & >::toCpp(pyobj));
        else if (Shiboken::Converter<QString & >::isConvertible(pyobj))
            return QScriptValue(Shiboken::Converter<QString & >::toCpp(pyobj));
        else if (Shiboken::Converter<const char * >::isConvertible(pyobj))
            return QScriptValue(Shiboken::Converter<const char * >::toCpp(pyobj));
        else if (PyFloat_Check(pyobj))
            return QScriptValue(Shiboken::Converter<double >::toCpp(pyobj));
        else if (PyInt_Check(pyobj))
            return QScriptValue(Shiboken::Converter<int >::toCpp(pyobj));
        else if (PyInt_Check(pyobj))
            return QScriptValue(Shiboken::Converter<unsigned int >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QScriptValue* cptr = reinterpret_cast<QScriptValue*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QScriptValue > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QScriptValue* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QScriptContextInfo >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QScriptContextInfo >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QScriptContextInfo >());
    return Shiboken::Converter<QScriptContext * >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QScriptContextInfo Shiboken::Converter<QScriptContextInfo >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QScriptContextInfo)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QScriptContextInfo >());
        if (Shiboken::Converter<QScriptContext * >::isConvertible(pyobj))
            return QScriptContextInfo(Shiboken::Converter<QScriptContext * >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QScriptContextInfo* cptr = reinterpret_cast<QScriptContextInfo*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QScriptContextInfo > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QScriptContextInfo* >::toCpp((PyObject*)pyobj);
}


#endif // SBK_QTSCRIPT_PYTHON_H

