/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtopengl_python.h"

#include "qglshaderprogram_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcolor.h>
#include <qcoreevent.h>
#include <qgenericmatrix.h>
#include <qgl.h>
#include <qglshaderprogram.h>
#include <qmatrix4x4.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpoint.h>
#include <qsize.h>
#include <qstring.h>
#include <qthread.h>
#include <qtransform.h>
#include <qvariant.h>
#include <qvector2d.h>
#include <qvector3d.h>
#include <qvector4d.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGLShaderProgramWrapper::QGLShaderProgramWrapper(QObject * parent) : QGLShaderProgram(parent), m_metaObject(0) {
    // ... middle
}

QGLShaderProgramWrapper::QGLShaderProgramWrapper(const QGLContext * context, QObject * parent) : QGLShaderProgram(context, parent), m_metaObject(0) {
    // ... middle
}

void QGLShaderProgramWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLShaderProgramWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGLShaderProgramWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGLShaderProgramWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGLShaderProgramWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGLShaderProgram.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QGLShaderProgramWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGLShaderProgram.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

bool QGLShaderProgramWrapper::link()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "link"));
    if (py_override.isNull()) {
        return this->QGLShaderProgram::link();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGLShaderProgram.link", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGLShaderProgramWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QGLShaderProgramWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QGLShaderProgram::staticMetaObject);
}
    return m_metaObject;
}

int QGLShaderProgramWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QGLShaderProgram::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QGLShaderProgramWrapper::~QGLShaderProgramWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQGLShaderProgram_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGLShaderProgramWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QGLShaderProgram", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QGLShaderProgram(QObject*)
        cptr = new QGLShaderProgramWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QGLContext * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QGLContext* cpp_arg0 = Shiboken::Converter<QGLContext* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QGLShaderProgram(const QGLContext*,QObject*)
            cptr = new QGLShaderProgramWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // QGLShaderProgram(const QGLContext*,QObject*)
            cptr = new QGLShaderProgramWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQGLShaderProgram_Init_TypeError;
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QGLShaderProgram(QObject*)
        cptr = new QGLShaderProgramWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQGLShaderProgram_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QGLShaderProgram >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGLShaderProgram_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQGLShaderProgram_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", "PySide.QtOpenGL.QGLContext, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLShaderProgram", overloads);
        return -1;
}

static PyObject* SbkQGLShaderProgramFunc_addShader(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QGLShader * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGLShader* cpp_arg0 = Shiboken::Converter<QGLShader* >::toCpp(arg);
        // addShader(QGLShader*)
        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGLShaderProgram::addShader(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLShaderProgramFunc_addShader_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGLShaderProgramFunc_addShader_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGLShader", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLShaderProgram.addShader", overloads);
        return 0;
}

static PyObject* SbkQGLShaderProgramFunc_addShaderFromSourceCode(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addShaderFromSourceCode", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (SbkPySide_QtOpenGL_QGLShader_ShaderTypeBit_Check(pyargs[0])) {
        QFlags<QGLShader::ShaderTypeBit> cpp_arg0 = Shiboken::Converter<QFlags<QGLShader::ShaderTypeBit> >::toCpp(pyargs[0]);
        if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
            const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
            // addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit>,const char*)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QGLShaderProgram::addShaderFromSourceCode(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QByteArray & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!SbkQByteArray_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            // addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit>,QByteArray)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QGLShaderProgram::addShaderFromSourceCode(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit>,QString)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QGLShaderProgram::addShaderFromSourceCode(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGLShaderProgramFunc_addShaderFromSourceCode_TypeError;
    } else goto SbkQGLShaderProgramFunc_addShaderFromSourceCode_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGLShaderProgramFunc_addShaderFromSourceCode_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGLShader.ShaderType, PySide.QtCore.QByteArray", "PySide.QtOpenGL.QGLShader.ShaderType, PySide.QtCore.QString", "PySide.QtOpenGL.QGLShader.ShaderType, str", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLShaderProgram.addShaderFromSourceCode", overloads);
        return 0;
}

static PyObject* SbkQGLShaderProgramFunc_addShaderFromSourceFile(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addShaderFromSourceFile", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && SbkPySide_QtOpenGL_QGLShader_ShaderTypeBit_Check(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        QFlags<QGLShader::ShaderTypeBit> cpp_arg0 = Shiboken::Converter<QFlags<QGLShader::ShaderTypeBit> >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // addShaderFromSourceFile(QFlags<QGLShader::ShaderTypeBit>,QString)
        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGLShaderProgram::addShaderFromSourceFile(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLShaderProgramFunc_addShaderFromSourceFile_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGLShaderProgramFunc_addShaderFromSourceFile_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGLShader.ShaderType, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLShaderProgram.addShaderFromSourceFile", overloads);
        return 0;
}

static PyObject* SbkQGLShaderProgramFunc_attributeLocation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // attributeLocation(const char*)const
        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGLShaderProgram::attributeLocation(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // attributeLocation(QByteArray)const
        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGLShaderProgram::attributeLocation(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // attributeLocation(QString)const
        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGLShaderProgram::attributeLocation(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLShaderProgramFunc_attributeLocation_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGLShaderProgramFunc_attributeLocation_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", "PySide.QtCore.QString", "str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLShaderProgram.attributeLocation", overloads);
        return 0;
}

static PyObject* SbkQGLShaderProgramFunc_bind(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bind()
    QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLShaderProgram::bind();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLShaderProgramFunc_bindAttributeLocation(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "bindAttributeLocation", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // bindAttributeLocation(const char*,int)
        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
        cppSelf->QGLShaderProgram::bindAttributeLocation(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QByteArray & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!SbkQByteArray_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // bindAttributeLocation(QByteArray,int)
        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
        cppSelf->QGLShaderProgram::bindAttributeLocation(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // bindAttributeLocation(QString,int)
        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
        cppSelf->QGLShaderProgram::bindAttributeLocation(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLShaderProgramFunc_bindAttributeLocation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLShaderProgramFunc_bindAttributeLocation_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, int", "PySide.QtCore.QString, int", "str, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLShaderProgram.bindAttributeLocation", overloads);
        return 0;
}

static PyObject* SbkQGLShaderProgramFunc_disableAttributeArray(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // disableAttributeArray(int)
        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
        cppSelf->QGLShaderProgram::disableAttributeArray(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // disableAttributeArray(const char*)
        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
        cppSelf->QGLShaderProgram::disableAttributeArray(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLShaderProgramFunc_disableAttributeArray_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLShaderProgramFunc_disableAttributeArray_TypeError:
        const char* overloads[] = {"str", "int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLShaderProgram.disableAttributeArray", overloads);
        return 0;
}

static PyObject* SbkQGLShaderProgramFunc_enableAttributeArray(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // enableAttributeArray(int)
        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
        cppSelf->QGLShaderProgram::enableAttributeArray(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // enableAttributeArray(const char*)
        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
        cppSelf->QGLShaderProgram::enableAttributeArray(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLShaderProgramFunc_enableAttributeArray_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLShaderProgramFunc_enableAttributeArray_TypeError:
        const char* overloads[] = {"str", "int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLShaderProgram.enableAttributeArray", overloads);
        return 0;
}

static PyObject* SbkQGLShaderProgramFunc_hasOpenGLShaderPrograms(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // hasOpenGLShaderPrograms(const QGLContext*)
        bool cpp_result = QGLShaderProgram::hasOpenGLShaderPrograms();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QGLContext * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGLContext* cpp_arg0 = Shiboken::Converter<QGLContext* >::toCpp(arg);
        // hasOpenGLShaderPrograms(const QGLContext*)
        bool cpp_result = QGLShaderProgram::hasOpenGLShaderPrograms(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLShaderProgramFunc_hasOpenGLShaderPrograms_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGLShaderProgramFunc_hasOpenGLShaderPrograms_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGLContext = None", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLShaderProgram.hasOpenGLShaderPrograms", overloads);
        return 0;
}

static PyObject* SbkQGLShaderProgramFunc_isLinked(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isLinked()const
    QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLShaderProgram::isLinked();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLShaderProgramFunc_link(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // link()
    QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLShaderProgram::link();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLShaderProgramFunc_log(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // log()const
    QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QGLShaderProgram::log();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLShaderProgramFunc_programId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // programId()const
    QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
    unsigned int cpp_result = cppSelf->QGLShaderProgram::programId();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLShaderProgramFunc_release(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // release()
    QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
    cppSelf->QGLShaderProgram::release();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGLShaderProgramFunc_removeAllShaders(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // removeAllShaders()
    QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
    cppSelf->QGLShaderProgram::removeAllShaders();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGLShaderProgramFunc_removeShader(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGLShader * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGLShader* cpp_arg0 = Shiboken::Converter<QGLShader* >::toCpp(arg);
        // removeShader(QGLShader*)
        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
        cppSelf->QGLShaderProgram::removeShader(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLShaderProgramFunc_removeShader_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLShaderProgramFunc_removeShader_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGLShader", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLShaderProgram.removeShader", overloads);
        return 0;
}

static PyObject* SbkQGLShaderProgramFunc_setAttributeArray(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setAttributeArray", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (PyFloat_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            float * cpp_arg1 = Shiboken::Converter<float * >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // setAttributeArray(int,const float*,int,int)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeArray(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[3])) {
                int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                // setAttributeArray(int,const float*,int,int)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeArray(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQGLShaderProgramFunc_setAttributeArray_TypeError;
        } else if (Shiboken::Converter<QVector2D * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QVector2D* cpp_arg1 = Shiboken::Converter<QVector2D* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // setAttributeArray(int,const QVector2D*,int)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeArray(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // setAttributeArray(int,const QVector2D*,int)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeArray(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQGLShaderProgramFunc_setAttributeArray_TypeError;
        } else if (Shiboken::Converter<QVector3D * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVector3D > cpp_arg1_auto_ptr;
            QVector3D* cpp_arg1 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[1]);
            if (!SbkQVector3D_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg1);
            if (numArgs == 2) {
                // setAttributeArray(int,const QVector3D*,int)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeArray(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // setAttributeArray(int,const QVector3D*,int)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeArray(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQGLShaderProgramFunc_setAttributeArray_TypeError;
        } else if (Shiboken::Converter<QVector4D * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVector4D > cpp_arg1_auto_ptr;
            QVector4D* cpp_arg1 = Shiboken::Converter<QVector4D* >::toCpp(pyargs[1]);
            if (!SbkQVector4D_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg1);
            if (numArgs == 2) {
                // setAttributeArray(int,const QVector4D*,int)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeArray(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // setAttributeArray(int,const QVector4D*,int)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeArray(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQGLShaderProgramFunc_setAttributeArray_TypeError;
        } else goto SbkQGLShaderProgramFunc_setAttributeArray_TypeError;
    } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[0])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        if (PyFloat_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            float * cpp_arg1 = Shiboken::Converter<float * >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // setAttributeArray(const char*,const float*,int,int)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeArray(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[3])) {
                int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                // setAttributeArray(const char*,const float*,int,int)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeArray(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQGLShaderProgramFunc_setAttributeArray_TypeError;
        } else if (Shiboken::Converter<QVector2D * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QVector2D* cpp_arg1 = Shiboken::Converter<QVector2D* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // setAttributeArray(const char*,const QVector2D*,int)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeArray(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // setAttributeArray(const char*,const QVector2D*,int)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeArray(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQGLShaderProgramFunc_setAttributeArray_TypeError;
        } else if (Shiboken::Converter<QVector3D * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVector3D > cpp_arg1_auto_ptr;
            QVector3D* cpp_arg1 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[1]);
            if (!SbkQVector3D_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg1);
            if (numArgs == 2) {
                // setAttributeArray(const char*,const QVector3D*,int)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeArray(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // setAttributeArray(const char*,const QVector3D*,int)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeArray(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQGLShaderProgramFunc_setAttributeArray_TypeError;
        } else if (Shiboken::Converter<QVector4D * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVector4D > cpp_arg1_auto_ptr;
            QVector4D* cpp_arg1 = Shiboken::Converter<QVector4D* >::toCpp(pyargs[1]);
            if (!SbkQVector4D_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg1);
            if (numArgs == 2) {
                // setAttributeArray(const char*,const QVector4D*,int)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeArray(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // setAttributeArray(const char*,const QVector4D*,int)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeArray(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQGLShaderProgramFunc_setAttributeArray_TypeError;
        } else goto SbkQGLShaderProgramFunc_setAttributeArray_TypeError;
    } else goto SbkQGLShaderProgramFunc_setAttributeArray_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLShaderProgramFunc_setAttributeArray_TypeError:
        const char* overloads[] = {"str, PySide.QtGui.QVector2D, int = 0", "str, PySide.QtGui.QVector3D, int = 0", "str, PySide.QtGui.QVector4D, int = 0", "str, float, int, int = 0", "int, PySide.QtGui.QVector2D, int = 0", "int, PySide.QtGui.QVector3D, int = 0", "int, PySide.QtGui.QVector4D, int = 0", "int, float, int, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLShaderProgram.setAttributeArray", overloads);
        return 0;
}

static PyObject* SbkQGLShaderProgramFunc_setAttributeValue(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setAttributeValue", 2, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (PyNumber_Check(pyargs[1])) {
            float cpp_arg1 = Shiboken::Converter<float >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // setAttributeValue(int,float)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeValue(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                float cpp_arg2 = Shiboken::Converter<float >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // setAttributeValue(int,float,float)
                    QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                    cppSelf->QGLShaderProgram::setAttributeValue(cpp_arg0, cpp_arg1, cpp_arg2);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[3])) {
                    float cpp_arg3 = Shiboken::Converter<float >::toCpp(pyargs[3]);
                    if (numArgs == 4) {
                        // setAttributeValue(int,float,float,float)
                        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                        cppSelf->QGLShaderProgram::setAttributeValue(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                        //CppGenerator::writeParentChildManagement
                    } else if (numArgs == 5 && PyNumber_Check(pyargs[4])) {
                        float cpp_arg4 = Shiboken::Converter<float >::toCpp(pyargs[4]);
                        // setAttributeValue(int,float,float,float,float)
                        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                        cppSelf->QGLShaderProgram::setAttributeValue(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                        //CppGenerator::writeParentChildManagement
                    } else goto SbkQGLShaderProgramFunc_setAttributeValue_TypeError;
                } else goto SbkQGLShaderProgramFunc_setAttributeValue_TypeError;
            } else goto SbkQGLShaderProgramFunc_setAttributeValue_TypeError;
        } else if (numArgs == 2 && Shiboken::Converter<QVector2D & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QVector2D* cpp_arg1 = Shiboken::Converter<QVector2D* >::toCpp(pyargs[1]);
            // setAttributeValue(int,QVector2D)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setAttributeValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QVector3D & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVector3D > cpp_arg1_auto_ptr;
            QVector3D* cpp_arg1 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[1]);
            if (!SbkQVector3D_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg1);
            // setAttributeValue(int,QVector3D)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setAttributeValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QVector4D & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVector4D > cpp_arg1_auto_ptr;
            QVector4D* cpp_arg1 = Shiboken::Converter<QVector4D* >::toCpp(pyargs[1]);
            if (!SbkQVector4D_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg1);
            // setAttributeValue(int,QVector4D)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setAttributeValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QColor & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QColor > cpp_arg1_auto_ptr;
            QColor* cpp_arg1 = Shiboken::Converter<QColor* >::toCpp(pyargs[1]);
            if (!SbkQColor_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QColor >(cpp_arg1);
            // setAttributeValue(int,QColor)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setAttributeValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGLShaderProgramFunc_setAttributeValue_TypeError;
    } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[0])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        if (PyNumber_Check(pyargs[1])) {
            float cpp_arg1 = Shiboken::Converter<float >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // setAttributeValue(const char*,float)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setAttributeValue(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                float cpp_arg2 = Shiboken::Converter<float >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // setAttributeValue(const char*,float,float)
                    QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                    cppSelf->QGLShaderProgram::setAttributeValue(cpp_arg0, cpp_arg1, cpp_arg2);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[3])) {
                    float cpp_arg3 = Shiboken::Converter<float >::toCpp(pyargs[3]);
                    if (numArgs == 4) {
                        // setAttributeValue(const char*,float,float,float)
                        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                        cppSelf->QGLShaderProgram::setAttributeValue(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                        //CppGenerator::writeParentChildManagement
                    } else if (numArgs == 5 && PyNumber_Check(pyargs[4])) {
                        float cpp_arg4 = Shiboken::Converter<float >::toCpp(pyargs[4]);
                        // setAttributeValue(const char*,float,float,float,float)
                        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                        cppSelf->QGLShaderProgram::setAttributeValue(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                        //CppGenerator::writeParentChildManagement
                    } else goto SbkQGLShaderProgramFunc_setAttributeValue_TypeError;
                } else goto SbkQGLShaderProgramFunc_setAttributeValue_TypeError;
            } else goto SbkQGLShaderProgramFunc_setAttributeValue_TypeError;
        } else if (numArgs == 2 && Shiboken::Converter<QVector2D & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QVector2D* cpp_arg1 = Shiboken::Converter<QVector2D* >::toCpp(pyargs[1]);
            // setAttributeValue(const char*,QVector2D)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setAttributeValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QVector3D & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVector3D > cpp_arg1_auto_ptr;
            QVector3D* cpp_arg1 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[1]);
            if (!SbkQVector3D_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg1);
            // setAttributeValue(const char*,QVector3D)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setAttributeValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QVector4D & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVector4D > cpp_arg1_auto_ptr;
            QVector4D* cpp_arg1 = Shiboken::Converter<QVector4D* >::toCpp(pyargs[1]);
            if (!SbkQVector4D_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg1);
            // setAttributeValue(const char*,QVector4D)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setAttributeValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QColor & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QColor > cpp_arg1_auto_ptr;
            QColor* cpp_arg1 = Shiboken::Converter<QColor* >::toCpp(pyargs[1]);
            if (!SbkQColor_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QColor >(cpp_arg1);
            // setAttributeValue(const char*,QColor)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setAttributeValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGLShaderProgramFunc_setAttributeValue_TypeError;
    } else goto SbkQGLShaderProgramFunc_setAttributeValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLShaderProgramFunc_setAttributeValue_TypeError:
        const char* overloads[] = {"str, PySide.QtGui.QColor", "str, PySide.QtGui.QVector2D", "str, PySide.QtGui.QVector3D", "str, PySide.QtGui.QVector4D", "str, float", "str, float, float", "str, float, float, float", "str, float, float, float, float", "int, PySide.QtGui.QColor", "int, PySide.QtGui.QVector2D", "int, PySide.QtGui.QVector3D", "int, PySide.QtGui.QVector4D", "int, float", "int, float, float", "int, float, float, float", "int, float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLShaderProgram.setAttributeValue", overloads);
        return 0;
}

static PyObject* SbkQGLShaderProgramFunc_setUniformValue(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setUniformValue", 2, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
            // setUniformValue(int,uint)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (PyFloat_Check(pyargs[1])) {
            float cpp_arg1 = Shiboken::Converter<float >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // setUniformValue(int,float)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                float cpp_arg2 = Shiboken::Converter<float >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // setUniformValue(int,float,float)
                    QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                    cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, cpp_arg1, cpp_arg2);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[3])) {
                    float cpp_arg3 = Shiboken::Converter<float >::toCpp(pyargs[3]);
                    if (numArgs == 4) {
                        // setUniformValue(int,float,float,float)
                        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                        cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                        //CppGenerator::writeParentChildManagement
                    } else if (numArgs == 5 && PyNumber_Check(pyargs[4])) {
                        float cpp_arg4 = Shiboken::Converter<float >::toCpp(pyargs[4]);
                        // setUniformValue(int,float,float,float,float)
                        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                        cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                        //CppGenerator::writeParentChildManagement
                    } else goto SbkQGLShaderProgramFunc_setUniformValue_TypeError;
                } else goto SbkQGLShaderProgramFunc_setUniformValue_TypeError;
            } else goto SbkQGLShaderProgramFunc_setUniformValue_TypeError;
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // setUniformValue(int,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QVector2D & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QVector2D* cpp_arg1 = Shiboken::Converter<QVector2D* >::toCpp(pyargs[1]);
            // setUniformValue(int,QVector2D)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QVector3D & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVector3D > cpp_arg1_auto_ptr;
            QVector3D* cpp_arg1 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[1]);
            if (!SbkQVector3D_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg1);
            // setUniformValue(int,QVector3D)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QVector4D & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVector4D > cpp_arg1_auto_ptr;
            QVector4D* cpp_arg1 = Shiboken::Converter<QVector4D* >::toCpp(pyargs[1]);
            if (!SbkQVector4D_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg1);
            // setUniformValue(int,QVector4D)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QTransform & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QTransform* cpp_arg1 = Shiboken::Converter<QTransform* >::toCpp(pyargs[1]);
            // setUniformValue(int,QTransform)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QSize & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QSize* cpp_arg1 = Shiboken::Converter<QSize* >::toCpp(pyargs[1]);
            // setUniformValue(int,QSize)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QSizeF & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QSizeF > cpp_arg1_auto_ptr;
            QSizeF* cpp_arg1 = Shiboken::Converter<QSizeF* >::toCpp(pyargs[1]);
            if (!SbkQSizeF_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg1);
            // setUniformValue(int,QSizeF)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
            // setUniformValue(int,QPoint)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
            QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
            if (!SbkQPointF_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
            // setUniformValue(int,QPointF)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix4x4 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QMatrix4x4 > cpp_arg1_auto_ptr;
            QMatrix4x4* cpp_arg1 = Shiboken::Converter<QMatrix4x4* >::toCpp(pyargs[1]);
            if (!SbkQMatrix4x4_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QMatrix4x4 >(cpp_arg1);
            // setUniformValue(int,QMatrix4x4)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix4x3 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix4x3* cpp_arg1 = Shiboken::Converter<QMatrix4x3* >::toCpp(pyargs[1]);
            // setUniformValue(int,QMatrix4x3)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix4x2 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix4x2* cpp_arg1 = Shiboken::Converter<QMatrix4x2* >::toCpp(pyargs[1]);
            // setUniformValue(int,QMatrix4x2)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix3x4 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix3x4* cpp_arg1 = Shiboken::Converter<QMatrix3x4* >::toCpp(pyargs[1]);
            // setUniformValue(int,QMatrix3x4)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix3x3 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix3x3* cpp_arg1 = Shiboken::Converter<QMatrix3x3* >::toCpp(pyargs[1]);
            // setUniformValue(int,QMatrix3x3)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix3x2 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix3x2* cpp_arg1 = Shiboken::Converter<QMatrix3x2* >::toCpp(pyargs[1]);
            // setUniformValue(int,QMatrix3x2)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix2x4 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix2x4* cpp_arg1 = Shiboken::Converter<QMatrix2x4* >::toCpp(pyargs[1]);
            // setUniformValue(int,QMatrix2x4)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix2x3 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix2x3* cpp_arg1 = Shiboken::Converter<QMatrix2x3* >::toCpp(pyargs[1]);
            // setUniformValue(int,QMatrix2x3)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix2x2 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix2x2* cpp_arg1 = Shiboken::Converter<QMatrix2x2* >::toCpp(pyargs[1]);
            // setUniformValue(int,QMatrix2x2)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QColor & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QColor > cpp_arg1_auto_ptr;
            QColor* cpp_arg1 = Shiboken::Converter<QColor* >::toCpp(pyargs[1]);
            if (!SbkQColor_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QColor >(cpp_arg1);
            // setUniformValue(int,QColor)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGLShaderProgramFunc_setUniformValue_TypeError;
    } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[0])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
            // setUniformValue(const char*,uint)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (PyFloat_Check(pyargs[1])) {
            float cpp_arg1 = Shiboken::Converter<float >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // setUniformValue(const char*,float)
                QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                float cpp_arg2 = Shiboken::Converter<float >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // setUniformValue(const char*,float,float)
                    QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                    cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, cpp_arg1, cpp_arg2);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[3])) {
                    float cpp_arg3 = Shiboken::Converter<float >::toCpp(pyargs[3]);
                    if (numArgs == 4) {
                        // setUniformValue(const char*,float,float,float)
                        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                        cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                        //CppGenerator::writeParentChildManagement
                    } else if (numArgs == 5 && PyNumber_Check(pyargs[4])) {
                        float cpp_arg4 = Shiboken::Converter<float >::toCpp(pyargs[4]);
                        // setUniformValue(const char*,float,float,float,float)
                        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
                        cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                        //CppGenerator::writeParentChildManagement
                    } else goto SbkQGLShaderProgramFunc_setUniformValue_TypeError;
                } else goto SbkQGLShaderProgramFunc_setUniformValue_TypeError;
            } else goto SbkQGLShaderProgramFunc_setUniformValue_TypeError;
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // setUniformValue(const char*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QVector2D & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QVector2D* cpp_arg1 = Shiboken::Converter<QVector2D* >::toCpp(pyargs[1]);
            // setUniformValue(const char*,QVector2D)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QVector3D & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVector3D > cpp_arg1_auto_ptr;
            QVector3D* cpp_arg1 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[1]);
            if (!SbkQVector3D_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg1);
            // setUniformValue(const char*,QVector3D)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QVector4D & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVector4D > cpp_arg1_auto_ptr;
            QVector4D* cpp_arg1 = Shiboken::Converter<QVector4D* >::toCpp(pyargs[1]);
            if (!SbkQVector4D_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg1);
            // setUniformValue(const char*,QVector4D)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QTransform & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QTransform* cpp_arg1 = Shiboken::Converter<QTransform* >::toCpp(pyargs[1]);
            // setUniformValue(const char*,QTransform)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QSize & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QSize* cpp_arg1 = Shiboken::Converter<QSize* >::toCpp(pyargs[1]);
            // setUniformValue(const char*,QSize)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QSizeF & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QSizeF > cpp_arg1_auto_ptr;
            QSizeF* cpp_arg1 = Shiboken::Converter<QSizeF* >::toCpp(pyargs[1]);
            if (!SbkQSizeF_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg1);
            // setUniformValue(const char*,QSizeF)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
            // setUniformValue(const char*,QPoint)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
            QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
            if (!SbkQPointF_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
            // setUniformValue(const char*,QPointF)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix4x4 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QMatrix4x4 > cpp_arg1_auto_ptr;
            QMatrix4x4* cpp_arg1 = Shiboken::Converter<QMatrix4x4* >::toCpp(pyargs[1]);
            if (!SbkQMatrix4x4_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QMatrix4x4 >(cpp_arg1);
            // setUniformValue(const char*,QMatrix4x4)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix4x3 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix4x3* cpp_arg1 = Shiboken::Converter<QMatrix4x3* >::toCpp(pyargs[1]);
            // setUniformValue(const char*,QMatrix4x3)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix4x2 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix4x2* cpp_arg1 = Shiboken::Converter<QMatrix4x2* >::toCpp(pyargs[1]);
            // setUniformValue(const char*,QMatrix4x2)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix3x4 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix3x4* cpp_arg1 = Shiboken::Converter<QMatrix3x4* >::toCpp(pyargs[1]);
            // setUniformValue(const char*,QMatrix3x4)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix3x3 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix3x3* cpp_arg1 = Shiboken::Converter<QMatrix3x3* >::toCpp(pyargs[1]);
            // setUniformValue(const char*,QMatrix3x3)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix3x2 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix3x2* cpp_arg1 = Shiboken::Converter<QMatrix3x2* >::toCpp(pyargs[1]);
            // setUniformValue(const char*,QMatrix3x2)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix2x4 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix2x4* cpp_arg1 = Shiboken::Converter<QMatrix2x4* >::toCpp(pyargs[1]);
            // setUniformValue(const char*,QMatrix2x4)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix2x3 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix2x3* cpp_arg1 = Shiboken::Converter<QMatrix2x3* >::toCpp(pyargs[1]);
            // setUniformValue(const char*,QMatrix2x3)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QMatrix2x2 & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix2x2* cpp_arg1 = Shiboken::Converter<QMatrix2x2* >::toCpp(pyargs[1]);
            // setUniformValue(const char*,QMatrix2x2)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QColor & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QColor > cpp_arg1_auto_ptr;
            QColor* cpp_arg1 = Shiboken::Converter<QColor* >::toCpp(pyargs[1]);
            if (!SbkQColor_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QColor >(cpp_arg1);
            // setUniformValue(const char*,QColor)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValue(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGLShaderProgramFunc_setUniformValue_TypeError;
    } else goto SbkQGLShaderProgramFunc_setUniformValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLShaderProgramFunc_setUniformValue_TypeError:
        const char* overloads[] = {"str, PySide.QtGui.QColor", "str, PySide.QtGui.QMatrix2x2", "str, PySide.QtGui.QMatrix2x3", "str, PySide.QtGui.QMatrix2x4", "str, PySide.QtGui.QMatrix3x2", "str, PySide.QtGui.QMatrix3x3", "str, PySide.QtGui.QMatrix3x4", "str, PySide.QtGui.QMatrix4x2", "str, PySide.QtGui.QMatrix4x3", "str, PySide.QtGui.QMatrix4x4", "str, PySide.QtCore.QPoint", "str, PySide.QtCore.QPointF", "str, PySide.QtCore.QSize", "str, PySide.QtCore.QSizeF", "str, PySide.QtGui.QTransform", "str, PySide.QtGui.QVector2D", "str, PySide.QtGui.QVector3D", "str, PySide.QtGui.QVector4D", "str, float", "str, float, float", "str, float, float, float", "str, float, float, float, float", "str, int", "str, unsigned int", "int, PySide.QtGui.QColor", "int, PySide.QtGui.QMatrix2x2", "int, PySide.QtGui.QMatrix2x3", "int, PySide.QtGui.QMatrix2x4", "int, PySide.QtGui.QMatrix3x2", "int, PySide.QtGui.QMatrix3x3", "int, PySide.QtGui.QMatrix3x4", "int, PySide.QtGui.QMatrix4x2", "int, PySide.QtGui.QMatrix4x3", "int, PySide.QtGui.QMatrix4x4", "int, PySide.QtCore.QPoint", "int, PySide.QtCore.QPointF", "int, PySide.QtCore.QSize", "int, PySide.QtCore.QSizeF", "int, PySide.QtGui.QTransform", "int, PySide.QtGui.QVector2D", "int, PySide.QtGui.QVector3D", "int, PySide.QtGui.QVector4D", "int, float", "int, float, float", "int, float, float, float", "int, float, float, float, float", "int, int", "int, unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLShaderProgram.setUniformValue", overloads);
        return 0;
}

static PyObject* SbkQGLShaderProgramFunc_setUniformValueArray(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setUniformValueArray", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 3 && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            unsigned int * cpp_arg1 = Shiboken::Converter<unsigned int * >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(int,const uint*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 4 && PyFloat_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
            float * cpp_arg1 = Shiboken::Converter<float * >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // setUniformValueArray(int,const float*,int,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            int * cpp_arg1 = Shiboken::Converter<int * >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(int,const int*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QVector2D * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QVector2D* cpp_arg1 = Shiboken::Converter<QVector2D* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(int,const QVector2D*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QVector3D * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVector3D > cpp_arg1_auto_ptr;
            QVector3D* cpp_arg1 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[1]);
            if (!SbkQVector3D_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg1);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(int,const QVector3D*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QVector4D * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVector4D > cpp_arg1_auto_ptr;
            QVector4D* cpp_arg1 = Shiboken::Converter<QVector4D* >::toCpp(pyargs[1]);
            if (!SbkQVector4D_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg1);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(int,const QVector4D*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix4x4 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QMatrix4x4 > cpp_arg1_auto_ptr;
            QMatrix4x4* cpp_arg1 = Shiboken::Converter<QMatrix4x4* >::toCpp(pyargs[1]);
            if (!SbkQMatrix4x4_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QMatrix4x4 >(cpp_arg1);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(int,const QMatrix4x4*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix4x3 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix4x3* cpp_arg1 = Shiboken::Converter<QMatrix4x3* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(int,const QMatrix4x3*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix4x2 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix4x2* cpp_arg1 = Shiboken::Converter<QMatrix4x2* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(int,const QMatrix4x2*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix3x4 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix3x4* cpp_arg1 = Shiboken::Converter<QMatrix3x4* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(int,const QMatrix3x4*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix3x3 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix3x3* cpp_arg1 = Shiboken::Converter<QMatrix3x3* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(int,const QMatrix3x3*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix3x2 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix3x2* cpp_arg1 = Shiboken::Converter<QMatrix3x2* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(int,const QMatrix3x2*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix2x4 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix2x4* cpp_arg1 = Shiboken::Converter<QMatrix2x4* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(int,const QMatrix2x4*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix2x3 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix2x3* cpp_arg1 = Shiboken::Converter<QMatrix2x3* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(int,const QMatrix2x3*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix2x2 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix2x2* cpp_arg1 = Shiboken::Converter<QMatrix2x2* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(int,const QMatrix2x2*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGLShaderProgramFunc_setUniformValueArray_TypeError;
    } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[0])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        if (numArgs == 3 && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            unsigned int * cpp_arg1 = Shiboken::Converter<unsigned int * >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(const char*,const uint*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 4 && PyFloat_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
            float * cpp_arg1 = Shiboken::Converter<float * >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // setUniformValueArray(const char*,const float*,int,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            int * cpp_arg1 = Shiboken::Converter<int * >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(const char*,const int*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QVector2D * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QVector2D* cpp_arg1 = Shiboken::Converter<QVector2D* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(const char*,const QVector2D*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QVector3D * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVector3D > cpp_arg1_auto_ptr;
            QVector3D* cpp_arg1 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[1]);
            if (!SbkQVector3D_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg1);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(const char*,const QVector3D*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QVector4D * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVector4D > cpp_arg1_auto_ptr;
            QVector4D* cpp_arg1 = Shiboken::Converter<QVector4D* >::toCpp(pyargs[1]);
            if (!SbkQVector4D_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg1);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(const char*,const QVector4D*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix4x4 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QMatrix4x4 > cpp_arg1_auto_ptr;
            QMatrix4x4* cpp_arg1 = Shiboken::Converter<QMatrix4x4* >::toCpp(pyargs[1]);
            if (!SbkQMatrix4x4_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QMatrix4x4 >(cpp_arg1);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(const char*,const QMatrix4x4*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix4x3 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix4x3* cpp_arg1 = Shiboken::Converter<QMatrix4x3* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(const char*,const QMatrix4x3*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix4x2 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix4x2* cpp_arg1 = Shiboken::Converter<QMatrix4x2* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(const char*,const QMatrix4x2*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix3x4 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix3x4* cpp_arg1 = Shiboken::Converter<QMatrix3x4* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(const char*,const QMatrix3x4*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix3x3 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix3x3* cpp_arg1 = Shiboken::Converter<QMatrix3x3* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(const char*,const QMatrix3x3*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix3x2 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix3x2* cpp_arg1 = Shiboken::Converter<QMatrix3x2* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(const char*,const QMatrix3x2*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix2x4 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix2x4* cpp_arg1 = Shiboken::Converter<QMatrix2x4* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(const char*,const QMatrix2x4*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix2x3 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix2x3* cpp_arg1 = Shiboken::Converter<QMatrix2x3* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(const char*,const QMatrix2x3*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QMatrix2x2 * >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QMatrix2x2* cpp_arg1 = Shiboken::Converter<QMatrix2x2* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setUniformValueArray(const char*,const QMatrix2x2*,int)
            QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
            cppSelf->QGLShaderProgram::setUniformValueArray(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGLShaderProgramFunc_setUniformValueArray_TypeError;
    } else goto SbkQGLShaderProgramFunc_setUniformValueArray_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLShaderProgramFunc_setUniformValueArray_TypeError:
        const char* overloads[] = {"str, PySide.QtGui.QMatrix2x2, int", "str, PySide.QtGui.QMatrix2x3, int", "str, PySide.QtGui.QMatrix2x4, int", "str, PySide.QtGui.QMatrix3x2, int", "str, PySide.QtGui.QMatrix3x3, int", "str, PySide.QtGui.QMatrix3x4, int", "str, PySide.QtGui.QMatrix4x2, int", "str, PySide.QtGui.QMatrix4x3, int", "str, PySide.QtGui.QMatrix4x4, int", "str, PySide.QtGui.QVector2D, int", "str, PySide.QtGui.QVector3D, int", "str, PySide.QtGui.QVector4D, int", "str, float, int, int", "str, int, int", "str, unsigned int, int", "int, PySide.QtGui.QMatrix2x2, int", "int, PySide.QtGui.QMatrix2x3, int", "int, PySide.QtGui.QMatrix2x4, int", "int, PySide.QtGui.QMatrix3x2, int", "int, PySide.QtGui.QMatrix3x3, int", "int, PySide.QtGui.QMatrix3x4, int", "int, PySide.QtGui.QMatrix4x2, int", "int, PySide.QtGui.QMatrix4x3, int", "int, PySide.QtGui.QMatrix4x4, int", "int, PySide.QtGui.QVector2D, int", "int, PySide.QtGui.QVector3D, int", "int, PySide.QtGui.QVector4D, int", "int, float, int, int", "int, int, int", "int, unsigned int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLShaderProgram.setUniformValueArray", overloads);
        return 0;
}

static PyObject* SbkQGLShaderProgramFunc_shaders(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // shaders()const
    QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
    QList<QGLShader * > cpp_result = cppSelf->QGLShaderProgram::shaders();
    py_result = Shiboken::Converter<QList<QGLShader * > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLShaderProgramFunc_uniformLocation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // uniformLocation(const char*)const
        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGLShaderProgram::uniformLocation(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // uniformLocation(QByteArray)const
        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGLShaderProgram::uniformLocation(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // uniformLocation(QString)const
        QGLShaderProgram* cppSelf = Shiboken::Converter<QGLShaderProgram* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGLShaderProgram::uniformLocation(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLShaderProgramFunc_uniformLocation_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGLShaderProgramFunc_uniformLocation_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", "PySide.QtCore.QString", "str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLShaderProgram.uniformLocation", overloads);
        return 0;
}

static PyMethodDef SbkQGLShaderProgram_methods[] = {
    {"addShader", (PyCFunction)SbkQGLShaderProgramFunc_addShader, METH_O},
    {"addShaderFromSourceCode", (PyCFunction)SbkQGLShaderProgramFunc_addShaderFromSourceCode, METH_VARARGS},
    {"addShaderFromSourceFile", (PyCFunction)SbkQGLShaderProgramFunc_addShaderFromSourceFile, METH_VARARGS},
    {"attributeLocation", (PyCFunction)SbkQGLShaderProgramFunc_attributeLocation, METH_O},
    {"bind", (PyCFunction)SbkQGLShaderProgramFunc_bind, METH_NOARGS},
    {"bindAttributeLocation", (PyCFunction)SbkQGLShaderProgramFunc_bindAttributeLocation, METH_VARARGS},
    {"disableAttributeArray", (PyCFunction)SbkQGLShaderProgramFunc_disableAttributeArray, METH_O},
    {"enableAttributeArray", (PyCFunction)SbkQGLShaderProgramFunc_enableAttributeArray, METH_O},
    {"hasOpenGLShaderPrograms", (PyCFunction)SbkQGLShaderProgramFunc_hasOpenGLShaderPrograms, METH_NOARGS|METH_O|METH_STATIC},
    {"isLinked", (PyCFunction)SbkQGLShaderProgramFunc_isLinked, METH_NOARGS},
    {"link", (PyCFunction)SbkQGLShaderProgramFunc_link, METH_NOARGS},
    {"log", (PyCFunction)SbkQGLShaderProgramFunc_log, METH_NOARGS},
    {"programId", (PyCFunction)SbkQGLShaderProgramFunc_programId, METH_NOARGS},
    {"release", (PyCFunction)SbkQGLShaderProgramFunc_release, METH_NOARGS},
    {"removeAllShaders", (PyCFunction)SbkQGLShaderProgramFunc_removeAllShaders, METH_NOARGS},
    {"removeShader", (PyCFunction)SbkQGLShaderProgramFunc_removeShader, METH_O},
    {"setAttributeArray", (PyCFunction)SbkQGLShaderProgramFunc_setAttributeArray, METH_VARARGS},
    {"setAttributeValue", (PyCFunction)SbkQGLShaderProgramFunc_setAttributeValue, METH_VARARGS},
    {"setUniformValue", (PyCFunction)SbkQGLShaderProgramFunc_setUniformValue, METH_VARARGS},
    {"setUniformValueArray", (PyCFunction)SbkQGLShaderProgramFunc_setUniformValueArray, METH_VARARGS},
    {"shaders", (PyCFunction)SbkQGLShaderProgramFunc_shaders, METH_NOARGS},
    {"uniformLocation", (PyCFunction)SbkQGLShaderProgramFunc_uniformLocation, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGLShaderProgram_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtOpenGL.QGLShaderProgram",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGLShaderProgram_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGLShaderProgram_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QGLShaderProgram >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QGLShaderProgram(PyObject* module)
{
    SbkPySide_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGLShaderProgram_Type);

    SbkQGLShaderProgram_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQGLShaderProgram_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGLShaderProgram_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGLShaderProgram_Type));
    PyModule_AddObject(module, "QGLShaderProgram",
        ((PyObject*)&SbkQGLShaderProgram_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGLShaderProgram >("QGLShaderProgram*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGLShaderProgram >(typeid(QGLShaderProgram).name());
}


} // extern "C"

