/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtopengl_python.h"

#include "qglformat_wrapper.h"

// Extra includes
#include <qgl.h>

using namespace Shiboken;

static int
SbkQGLFormat_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGLFormat* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QGLFormat", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QGLFormat()
        cptr = new QGLFormat();
        //CppGenerator::writeParentChildManagement
    } else if (SbkPySide_QtOpenGL_QGL_FormatOption_Check(pyargs[0])) {
        QFlags<QGL::FormatOption> cpp_arg0 = Shiboken::Converter<QFlags<QGL::FormatOption> >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QGLFormat(QFlags<QGL::FormatOption>,int)
            cptr = new QGLFormat(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // QGLFormat(QFlags<QGL::FormatOption>,int)
            cptr = new QGLFormat(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGLFormat_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QGLFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QGLFormat > cpp_arg0_auto_ptr;
        QGLFormat* cpp_arg0 = Shiboken::Converter<QGLFormat* >::toCpp(pyargs[0]);
        if (!SbkQGLFormat_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QGLFormat >(cpp_arg0);
        // QGLFormat(QGLFormat)
        cptr = new QGLFormat(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormat_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QGLFormat >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGLFormat_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQGLFormat_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtOpenGL.QGL.FormatOptions, int = 0", "PySide.QtOpenGL.QGLFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLFormat", overloads);
        return -1;
}

static PyObject* SbkQGLFormatFunc_accum(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // accum()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLFormat::accum();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_accumBufferSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // accumBufferSize()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGLFormat::accumBufferSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_alpha(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // alpha()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLFormat::alpha();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_alphaBufferSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // alphaBufferSize()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGLFormat::alphaBufferSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_blueBufferSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // blueBufferSize()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGLFormat::blueBufferSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_defaultFormat(PyObject* self)
{
    PyObject* py_result = 0;

    // defaultFormat()
    QGLFormat cpp_result = QGLFormat::defaultFormat();
    py_result = Shiboken::Converter<QGLFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_defaultOverlayFormat(PyObject* self)
{
    PyObject* py_result = 0;

    // defaultOverlayFormat()
    QGLFormat cpp_result = QGLFormat::defaultOverlayFormat();
    py_result = Shiboken::Converter<QGLFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_depth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // depth()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLFormat::depth();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_depthBufferSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // depthBufferSize()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGLFormat::depthBufferSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_directRendering(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // directRendering()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLFormat::directRendering();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_doubleBuffer(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // doubleBuffer()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLFormat::doubleBuffer();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_greenBufferSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // greenBufferSize()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGLFormat::greenBufferSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_hasOpenGL(PyObject* self)
{
    PyObject* py_result = 0;

    // hasOpenGL()
    bool cpp_result = QGLFormat::hasOpenGL();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_hasOpenGLOverlays(PyObject* self)
{
    PyObject* py_result = 0;

    // hasOpenGLOverlays()
    bool cpp_result = QGLFormat::hasOpenGLOverlays();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_hasOverlay(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasOverlay()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLFormat::hasOverlay();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_openGLVersionFlags(PyObject* self)
{
    PyObject* py_result = 0;

    // openGLVersionFlags()
    QFlags<QGLFormat::OpenGLVersionFlag> cpp_result = QGLFormat::openGLVersionFlags();
    py_result = Shiboken::Converter<QFlags<QGLFormat::OpenGLVersionFlag> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_plane(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // plane()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGLFormat::plane();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_redBufferSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // redBufferSize()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGLFormat::redBufferSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_rgba(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rgba()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLFormat::rgba();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_sampleBuffers(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sampleBuffers()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLFormat::sampleBuffers();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_samples(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // samples()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGLFormat::samples();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_setAccum(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAccum(bool)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setAccum(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setAccum_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setAccum_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setAccum", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setAccumBufferSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setAccumBufferSize(int)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setAccumBufferSize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setAccumBufferSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setAccumBufferSize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setAccumBufferSize", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setAlpha(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAlpha(bool)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setAlpha(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setAlpha_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setAlpha_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setAlpha", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setAlphaBufferSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setAlphaBufferSize(int)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setAlphaBufferSize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setAlphaBufferSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setAlphaBufferSize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setAlphaBufferSize", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setBlueBufferSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setBlueBufferSize(int)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setBlueBufferSize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setBlueBufferSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setBlueBufferSize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setBlueBufferSize", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setDefaultFormat(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QGLFormat & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QGLFormat > cpp_arg0_auto_ptr;
        QGLFormat* cpp_arg0 = Shiboken::Converter<QGLFormat* >::toCpp(arg);
        if (!SbkQGLFormat_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QGLFormat >(cpp_arg0);
        // setDefaultFormat(QGLFormat)
        QGLFormat::setDefaultFormat(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setDefaultFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setDefaultFormat_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGLFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setDefaultFormat", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setDefaultOverlayFormat(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QGLFormat & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QGLFormat > cpp_arg0_auto_ptr;
        QGLFormat* cpp_arg0 = Shiboken::Converter<QGLFormat* >::toCpp(arg);
        if (!SbkQGLFormat_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QGLFormat >(cpp_arg0);
        // setDefaultOverlayFormat(QGLFormat)
        QGLFormat::setDefaultOverlayFormat(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setDefaultOverlayFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setDefaultOverlayFormat_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGLFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setDefaultOverlayFormat", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setDepth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDepth(bool)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setDepth(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setDepth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setDepth_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setDepth", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setDepthBufferSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setDepthBufferSize(int)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setDepthBufferSize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setDepthBufferSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setDepthBufferSize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setDepthBufferSize", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setDirectRendering(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDirectRendering(bool)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setDirectRendering(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setDirectRendering_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setDirectRendering_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setDirectRendering", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setDoubleBuffer(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDoubleBuffer(bool)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setDoubleBuffer(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setDoubleBuffer_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setDoubleBuffer_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setDoubleBuffer", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setGreenBufferSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setGreenBufferSize(int)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setGreenBufferSize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setGreenBufferSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setGreenBufferSize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setGreenBufferSize", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setOption(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtOpenGL_QGL_FormatOption_Check(arg)) {
        QFlags<QGL::FormatOption> cpp_arg0 = Shiboken::Converter<QFlags<QGL::FormatOption> >::toCpp(arg);
        // setOption(QFlags<QGL::FormatOption>)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setOption(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setOption_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setOption_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGL.FormatOptions", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setOption", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setOverlay(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setOverlay(bool)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setOverlay(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setOverlay_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setOverlay_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setOverlay", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setPlane(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setPlane(int)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setPlane(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setPlane_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setPlane_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setPlane", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setRedBufferSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setRedBufferSize(int)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setRedBufferSize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setRedBufferSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setRedBufferSize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setRedBufferSize", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setRgba(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setRgba(bool)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setRgba(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setRgba_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setRgba_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setRgba", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setSampleBuffers(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSampleBuffers(bool)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setSampleBuffers(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setSampleBuffers_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setSampleBuffers_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setSampleBuffers", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setSamples(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setSamples(int)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setSamples(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setSamples_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setSamples_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setSamples", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setStencil(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setStencil(bool)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setStencil(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setStencil_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setStencil_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setStencil", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setStencilBufferSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setStencilBufferSize(int)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setStencilBufferSize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setStencilBufferSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setStencilBufferSize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setStencilBufferSize", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setStereo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setStereo(bool)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setStereo(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setStereo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setStereo_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setStereo", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_setSwapInterval(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setSwapInterval(int)
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFormat::setSwapInterval(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_setSwapInterval_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFormatFunc_setSwapInterval_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.setSwapInterval", overloads);
        return 0;
}

static PyObject* SbkQGLFormatFunc_stencil(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // stencil()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLFormat::stencil();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_stencilBufferSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // stencilBufferSize()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGLFormat::stencilBufferSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_stereo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // stereo()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLFormat::stereo();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_swapInterval(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // swapInterval()const
    QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGLFormat::swapInterval();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFormatFunc_testOption(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (SbkPySide_QtOpenGL_QGL_FormatOption_Check(arg)) {
        QFlags<QGL::FormatOption> cpp_arg0 = Shiboken::Converter<QFlags<QGL::FormatOption> >::toCpp(arg);
        // testOption(QFlags<QGL::FormatOption>)const
        QGLFormat* cppSelf = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGLFormat::testOption(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFormatFunc_testOption_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGLFormatFunc_testOption_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGL.FormatOptions", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFormat.testOption", overloads);
        return 0;
}

static PyMethodDef SbkQGLFormat_methods[] = {
    {"accum", (PyCFunction)SbkQGLFormatFunc_accum, METH_NOARGS},
    {"accumBufferSize", (PyCFunction)SbkQGLFormatFunc_accumBufferSize, METH_NOARGS},
    {"alpha", (PyCFunction)SbkQGLFormatFunc_alpha, METH_NOARGS},
    {"alphaBufferSize", (PyCFunction)SbkQGLFormatFunc_alphaBufferSize, METH_NOARGS},
    {"blueBufferSize", (PyCFunction)SbkQGLFormatFunc_blueBufferSize, METH_NOARGS},
    {"defaultFormat", (PyCFunction)SbkQGLFormatFunc_defaultFormat, METH_NOARGS|METH_STATIC},
    {"defaultOverlayFormat", (PyCFunction)SbkQGLFormatFunc_defaultOverlayFormat, METH_NOARGS|METH_STATIC},
    {"depth", (PyCFunction)SbkQGLFormatFunc_depth, METH_NOARGS},
    {"depthBufferSize", (PyCFunction)SbkQGLFormatFunc_depthBufferSize, METH_NOARGS},
    {"directRendering", (PyCFunction)SbkQGLFormatFunc_directRendering, METH_NOARGS},
    {"doubleBuffer", (PyCFunction)SbkQGLFormatFunc_doubleBuffer, METH_NOARGS},
    {"greenBufferSize", (PyCFunction)SbkQGLFormatFunc_greenBufferSize, METH_NOARGS},
    {"hasOpenGL", (PyCFunction)SbkQGLFormatFunc_hasOpenGL, METH_NOARGS|METH_STATIC},
    {"hasOpenGLOverlays", (PyCFunction)SbkQGLFormatFunc_hasOpenGLOverlays, METH_NOARGS|METH_STATIC},
    {"hasOverlay", (PyCFunction)SbkQGLFormatFunc_hasOverlay, METH_NOARGS},
    {"openGLVersionFlags", (PyCFunction)SbkQGLFormatFunc_openGLVersionFlags, METH_NOARGS|METH_STATIC},
    {"plane", (PyCFunction)SbkQGLFormatFunc_plane, METH_NOARGS},
    {"redBufferSize", (PyCFunction)SbkQGLFormatFunc_redBufferSize, METH_NOARGS},
    {"rgba", (PyCFunction)SbkQGLFormatFunc_rgba, METH_NOARGS},
    {"sampleBuffers", (PyCFunction)SbkQGLFormatFunc_sampleBuffers, METH_NOARGS},
    {"samples", (PyCFunction)SbkQGLFormatFunc_samples, METH_NOARGS},
    {"setAccum", (PyCFunction)SbkQGLFormatFunc_setAccum, METH_O},
    {"setAccumBufferSize", (PyCFunction)SbkQGLFormatFunc_setAccumBufferSize, METH_O},
    {"setAlpha", (PyCFunction)SbkQGLFormatFunc_setAlpha, METH_O},
    {"setAlphaBufferSize", (PyCFunction)SbkQGLFormatFunc_setAlphaBufferSize, METH_O},
    {"setBlueBufferSize", (PyCFunction)SbkQGLFormatFunc_setBlueBufferSize, METH_O},
    {"setDefaultFormat", (PyCFunction)SbkQGLFormatFunc_setDefaultFormat, METH_O|METH_STATIC},
    {"setDefaultOverlayFormat", (PyCFunction)SbkQGLFormatFunc_setDefaultOverlayFormat, METH_O|METH_STATIC},
    {"setDepth", (PyCFunction)SbkQGLFormatFunc_setDepth, METH_O},
    {"setDepthBufferSize", (PyCFunction)SbkQGLFormatFunc_setDepthBufferSize, METH_O},
    {"setDirectRendering", (PyCFunction)SbkQGLFormatFunc_setDirectRendering, METH_O},
    {"setDoubleBuffer", (PyCFunction)SbkQGLFormatFunc_setDoubleBuffer, METH_O},
    {"setGreenBufferSize", (PyCFunction)SbkQGLFormatFunc_setGreenBufferSize, METH_O},
    {"setOption", (PyCFunction)SbkQGLFormatFunc_setOption, METH_O},
    {"setOverlay", (PyCFunction)SbkQGLFormatFunc_setOverlay, METH_O},
    {"setPlane", (PyCFunction)SbkQGLFormatFunc_setPlane, METH_O},
    {"setRedBufferSize", (PyCFunction)SbkQGLFormatFunc_setRedBufferSize, METH_O},
    {"setRgba", (PyCFunction)SbkQGLFormatFunc_setRgba, METH_O},
    {"setSampleBuffers", (PyCFunction)SbkQGLFormatFunc_setSampleBuffers, METH_O},
    {"setSamples", (PyCFunction)SbkQGLFormatFunc_setSamples, METH_O},
    {"setStencil", (PyCFunction)SbkQGLFormatFunc_setStencil, METH_O},
    {"setStencilBufferSize", (PyCFunction)SbkQGLFormatFunc_setStencilBufferSize, METH_O},
    {"setStereo", (PyCFunction)SbkQGLFormatFunc_setStereo, METH_O},
    {"setSwapInterval", (PyCFunction)SbkQGLFormatFunc_setSwapInterval, METH_O},
    {"stencil", (PyCFunction)SbkQGLFormatFunc_stencil, METH_NOARGS},
    {"stencilBufferSize", (PyCFunction)SbkQGLFormatFunc_stencilBufferSize, METH_NOARGS},
    {"stereo", (PyCFunction)SbkQGLFormatFunc_stereo, METH_NOARGS},
    {"swapInterval", (PyCFunction)SbkQGLFormatFunc_swapInterval, METH_NOARGS},
    {"testOption", (PyCFunction)SbkQGLFormatFunc_testOption, METH_O},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQGLFormat_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QGLFormat& cpp_self = *Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QGLFormat & >::isConvertible(other)) {
                // operator!=(const QGLFormat & arg__2)
                QGLFormat* cpp_other = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QGLFormat  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QGLFormat >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QGLFormat > cpp_other_auto_ptr;
                QGLFormat* cpp_other = Shiboken::Converter<QGLFormat* >::toCpp(other);
                if (!SbkQGLFormat_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QGLFormat >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQGLFormat_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QGLFormat & >::isConvertible(other)) {
                // operator==(const QGLFormat & arg__2)
                QGLFormat* cpp_other = Shiboken::Converter<QGLFormat* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QGLFormat  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QGLFormat >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QGLFormat > cpp_other_auto_ptr;
                QGLFormat* cpp_other = Shiboken::Converter<QGLFormat* >::toCpp(other);
                if (!SbkQGLFormat_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QGLFormat >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQGLFormat_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQGLFormat_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGLFormat_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtOpenGL.QGLFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQGLFormat_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGLFormat_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGLFormat_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QGLFormat >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

PyObject*
SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGLFormat::OpenGLVersionFlags >::toPython(
        ((QGLFormat::OpenGLVersionFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QGLFormat::OpenGLVersionFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGLFormat::OpenGLVersionFlags >::toPython(
        ((QGLFormat::OpenGLVersionFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QGLFormat::OpenGLVersionFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGLFormat::OpenGLVersionFlags >::toPython(
        ((QGLFormat::OpenGLVersionFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QGLFormat::OpenGLVersionFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGLFormat::OpenGLVersionFlags >::toPython(
        ~ Shiboken::Converter< QGLFormat::OpenGLVersionFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "OpenGLVersionFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "OpenGLVersionFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QGLFormat(PyObject* module)
{
    SbkPySide_QtOpenGLTypes[SBK_QGLFORMAT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGLFormat_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQGLFormat_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGLFormat_Type));
    PyModule_AddObject(module, "QGLFormat",
        ((PyObject*)&SbkQGLFormat_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: OpenGLVersionFlag
    SbkPySide_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX] = &SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type);
    PyDict_SetItemString(SbkQGLFormat_Type.super.ht_type.tp_dict,
            "OpenGLVersionFlag",((PyObject*)&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type));

    // init flags class: QFlags<QGLFormat::OpenGLVersionFlag>
    SbkPySide_QtOpenGLTypes[SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG__IDX] = &SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlags_Type);
    PyDict_SetItemString(SbkQGLFormat_Type.super.ht_type.tp_dict,
            "OpenGLVersionFlags",((PyObject*)&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type,
        (long) QGLFormat::OpenGL_Version_None, "OpenGL_Version_None");
    PyDict_SetItemString(SbkQGLFormat_Type.super.ht_type.tp_dict,
        "OpenGL_Version_None", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type.tp_dict,
        "OpenGL_Version_None", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type,
        (long) QGLFormat::OpenGL_Version_1_1, "OpenGL_Version_1_1");
    PyDict_SetItemString(SbkQGLFormat_Type.super.ht_type.tp_dict,
        "OpenGL_Version_1_1", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type.tp_dict,
        "OpenGL_Version_1_1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type,
        (long) QGLFormat::OpenGL_Version_1_2, "OpenGL_Version_1_2");
    PyDict_SetItemString(SbkQGLFormat_Type.super.ht_type.tp_dict,
        "OpenGL_Version_1_2", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type.tp_dict,
        "OpenGL_Version_1_2", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type,
        (long) QGLFormat::OpenGL_Version_1_3, "OpenGL_Version_1_3");
    PyDict_SetItemString(SbkQGLFormat_Type.super.ht_type.tp_dict,
        "OpenGL_Version_1_3", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type.tp_dict,
        "OpenGL_Version_1_3", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type,
        (long) QGLFormat::OpenGL_Version_1_4, "OpenGL_Version_1_4");
    PyDict_SetItemString(SbkQGLFormat_Type.super.ht_type.tp_dict,
        "OpenGL_Version_1_4", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type.tp_dict,
        "OpenGL_Version_1_4", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type,
        (long) QGLFormat::OpenGL_Version_1_5, "OpenGL_Version_1_5");
    PyDict_SetItemString(SbkQGLFormat_Type.super.ht_type.tp_dict,
        "OpenGL_Version_1_5", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type.tp_dict,
        "OpenGL_Version_1_5", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type,
        (long) QGLFormat::OpenGL_Version_2_0, "OpenGL_Version_2_0");
    PyDict_SetItemString(SbkQGLFormat_Type.super.ht_type.tp_dict,
        "OpenGL_Version_2_0", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type.tp_dict,
        "OpenGL_Version_2_0", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type,
        (long) QGLFormat::OpenGL_Version_2_1, "OpenGL_Version_2_1");
    PyDict_SetItemString(SbkQGLFormat_Type.super.ht_type.tp_dict,
        "OpenGL_Version_2_1", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type.tp_dict,
        "OpenGL_Version_2_1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type,
        (long) QGLFormat::OpenGL_ES_Common_Version_1_0, "OpenGL_ES_Common_Version_1_0");
    PyDict_SetItemString(SbkQGLFormat_Type.super.ht_type.tp_dict,
        "OpenGL_ES_Common_Version_1_0", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type.tp_dict,
        "OpenGL_ES_Common_Version_1_0", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type,
        (long) QGLFormat::OpenGL_ES_CommonLite_Version_1_0, "OpenGL_ES_CommonLite_Version_1_0");
    PyDict_SetItemString(SbkQGLFormat_Type.super.ht_type.tp_dict,
        "OpenGL_ES_CommonLite_Version_1_0", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type.tp_dict,
        "OpenGL_ES_CommonLite_Version_1_0", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type,
        (long) QGLFormat::OpenGL_ES_Common_Version_1_1, "OpenGL_ES_Common_Version_1_1");
    PyDict_SetItemString(SbkQGLFormat_Type.super.ht_type.tp_dict,
        "OpenGL_ES_Common_Version_1_1", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type.tp_dict,
        "OpenGL_ES_Common_Version_1_1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type,
        (long) QGLFormat::OpenGL_ES_CommonLite_Version_1_1, "OpenGL_ES_CommonLite_Version_1_1");
    PyDict_SetItemString(SbkQGLFormat_Type.super.ht_type.tp_dict,
        "OpenGL_ES_CommonLite_Version_1_1", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type.tp_dict,
        "OpenGL_ES_CommonLite_Version_1_1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type,
        (long) QGLFormat::OpenGL_ES_Version_2_0, "OpenGL_ES_Version_2_0");
    PyDict_SetItemString(SbkQGLFormat_Type.super.ht_type.tp_dict,
        "OpenGL_ES_Version_2_0", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type.tp_dict,
        "OpenGL_ES_Version_2_0", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type,
        (long) QGLFormat::OpenGL_Version_3_0, "OpenGL_Version_3_0");
    PyDict_SetItemString(SbkQGLFormat_Type.super.ht_type.tp_dict,
        "OpenGL_Version_3_0", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGLFormat_OpenGLVersionFlag_Type.tp_dict,
        "OpenGL_Version_3_0", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGLFormat::OpenGLVersionFlag");

    Shiboken::TypeResolver::createValueTypeResolver<QGLFormat >("QGLFormat");
    Shiboken::TypeResolver::createValueTypeResolver<QGLFormat >(typeid(QGLFormat).name());
}


} // extern "C"

