/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtopengl_python.h"

#include "qgl_wrapper.h"

// Extra includes
#include <qgl.h>

using namespace Shiboken;

static PyObject* SbkQGLFunc_setPreferredPaintEngine(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QPaintEngine::Type >::isConvertible(arg)) {
        QPaintEngine::Type cpp_arg0 = Shiboken::Converter<QPaintEngine::Type >::toCpp(arg);
        // setPreferredPaintEngine(QPaintEngine::Type)
        QGL::setPreferredPaintEngine(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFunc_setPreferredPaintEngine_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFunc_setPreferredPaintEngine_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEngine.Type", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGL.setPreferredPaintEngine", overloads);
        return 0;
}

static PyMethodDef SbkQGL_methods[] = {
    {"setPreferredPaintEngine", (PyCFunction)SbkQGLFunc_setPreferredPaintEngine, METH_O|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGL_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtOpenGL.QGL",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGL_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            0,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

PyObject*
SbkPySide_QtOpenGL_QGL_FormatOption___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGL::FormatOptions >::toPython(
        ((QGL::FormatOptions) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QGL::FormatOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtOpenGL_QGL_FormatOption___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGL::FormatOptions >::toPython(
        ((QGL::FormatOptions) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QGL::FormatOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtOpenGL_QGL_FormatOption___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGL::FormatOptions >::toPython(
        ((QGL::FormatOptions) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QGL::FormatOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtOpenGL_QGL_FormatOption___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGL::FormatOptions >::toPython(
        ~ Shiboken::Converter< QGL::FormatOptions >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtOpenGL_QGL_FormatOption_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtOpenGL_QGL_FormatOption___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtOpenGL_QGL_FormatOption___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtOpenGL_QGL_FormatOption___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtOpenGL_QGL_FormatOption___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtOpenGL_QGL_FormatOption_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtOpenGL_QGL_FormatOption_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtOpenGL_QGL_FormatOption_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FormatOption",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtOpenGL_QGL_FormatOption_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtOpenGL_QGL_FormatOption_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtOpenGL_QGL_FormatOption_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtOpenGL_QGL_FormatOption_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtOpenGL_QGL_FormatOptions_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtOpenGL_QGL_FormatOptions_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FormatOptions",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtOpenGL_QGL_FormatOption_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtOpenGL_QGL_FormatOptions_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtOpenGL_QGL_FormatOptions_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtOpenGL_QGL_FormatOptions_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QGL(PyObject* module)
{
    SbkPySide_QtOpenGLTypes[SBK_QGL_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGL_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQGL_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGL_Type));
    PyModule_AddObject(module, "QGL",
        ((PyObject*)&SbkQGL_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: FormatOption
    SbkPySide_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX] = &SbkPySide_QtOpenGL_QGL_FormatOption_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtOpenGL_QGL_FormatOption_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtOpenGL_QGL_FormatOption_Type);
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
            "FormatOption",((PyObject*)&SbkPySide_QtOpenGL_QGL_FormatOption_Type));

    // init flags class: QFlags<QGL::FormatOption>
    SbkPySide_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION__IDX] = &SbkPySide_QtOpenGL_QGL_FormatOptions_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtOpenGL_QGL_FormatOptions_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtOpenGL_QGL_FormatOptions_Type);
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
            "FormatOptions",((PyObject*)&SbkPySide_QtOpenGL_QGL_FormatOptions_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::DoubleBuffer, "DoubleBuffer");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "DoubleBuffer", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "DoubleBuffer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::DepthBuffer, "DepthBuffer");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "DepthBuffer", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "DepthBuffer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::Rgba, "Rgba");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "Rgba", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "Rgba", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::AlphaChannel, "AlphaChannel");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "AlphaChannel", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "AlphaChannel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::AccumBuffer, "AccumBuffer");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "AccumBuffer", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "AccumBuffer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::StencilBuffer, "StencilBuffer");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "StencilBuffer", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "StencilBuffer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::StereoBuffers, "StereoBuffers");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "StereoBuffers", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "StereoBuffers", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::DirectRendering, "DirectRendering");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "DirectRendering", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "DirectRendering", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::HasOverlay, "HasOverlay");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "HasOverlay", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "HasOverlay", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::SampleBuffers, "SampleBuffers");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "SampleBuffers", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "SampleBuffers", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::SingleBuffer, "SingleBuffer");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "SingleBuffer", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "SingleBuffer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::NoDepthBuffer, "NoDepthBuffer");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "NoDepthBuffer", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "NoDepthBuffer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::ColorIndex, "ColorIndex");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "ColorIndex", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "ColorIndex", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::NoAlphaChannel, "NoAlphaChannel");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "NoAlphaChannel", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "NoAlphaChannel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::NoAccumBuffer, "NoAccumBuffer");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "NoAccumBuffer", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "NoAccumBuffer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::NoStencilBuffer, "NoStencilBuffer");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "NoStencilBuffer", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "NoStencilBuffer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::NoStereoBuffers, "NoStereoBuffers");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "NoStereoBuffers", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "NoStereoBuffers", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::IndirectRendering, "IndirectRendering");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "IndirectRendering", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "IndirectRendering", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::NoOverlay, "NoOverlay");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "NoOverlay", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "NoOverlay", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtOpenGL_QGL_FormatOption_Type,
        (long) QGL::NoSampleBuffers, "NoSampleBuffers");
    PyDict_SetItemString(SbkQGL_Type.super.ht_type.tp_dict,
        "NoSampleBuffers", enum_item);
    PyDict_SetItemString(SbkPySide_QtOpenGL_QGL_FormatOption_Type.tp_dict,
        "NoSampleBuffers", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGL::FormatOption");

}


} // extern "C"

