/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtnetwork_python.h"

#include "qnetworkrequest_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qnetworkrequest.h>
#include <qobject.h>
#include <qsslconfiguration.h>
#include <qurl.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQNetworkRequest_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QNetworkRequest* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QNetworkRequest", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QNetworkRequest(QUrl)
        cptr = new QNetworkRequest();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QUrl & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(pyargs[0]);
        if (!SbkQUrl_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // QNetworkRequest(QUrl)
        cptr = new QNetworkRequest(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QNetworkRequest & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QNetworkRequest* cpp_arg0 = Shiboken::Converter<QNetworkRequest* >::toCpp(pyargs[0]);
        // QNetworkRequest(QNetworkRequest)
        cptr = new QNetworkRequest(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkRequest_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QNetworkRequest >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQNetworkRequest_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQNetworkRequest_Init_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkRequest", "PySide.QtCore.QUrl = QUrl()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkRequest", overloads);
        return -1;
}

static PyObject* SbkQNetworkRequestFunc_attribute(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "attribute", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QNetworkRequest::Attribute >::isConvertible(pyargs[0])) {
        QNetworkRequest::Attribute cpp_arg0 = Shiboken::Converter<QNetworkRequest::Attribute >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // attribute(QNetworkRequest::Attribute,QVariant)const
            QNetworkRequest* cppSelf = Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QNetworkRequest::attribute(cpp_arg0);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
            QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
            if (!SbkQVariant_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
            // attribute(QNetworkRequest::Attribute,QVariant)const
            QNetworkRequest* cppSelf = Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QNetworkRequest::attribute(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQNetworkRequestFunc_attribute_TypeError;
    } else goto SbkQNetworkRequestFunc_attribute_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQNetworkRequestFunc_attribute_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkRequest.Attribute, PySide.QtCore.QVariant = QVariant()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkRequest.attribute", overloads);
        return 0;
}

static PyObject* SbkQNetworkRequestFunc_hasRawHeader(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // hasRawHeader(QByteArray)const
        QNetworkRequest* cppSelf = Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QNetworkRequest::hasRawHeader(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkRequestFunc_hasRawHeader_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQNetworkRequestFunc_hasRawHeader_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkRequest.hasRawHeader", overloads);
        return 0;
}

static PyObject* SbkQNetworkRequestFunc_header(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QNetworkRequest::KnownHeaders >::isConvertible(arg)) {
        QNetworkRequest::KnownHeaders cpp_arg0 = Shiboken::Converter<QNetworkRequest::KnownHeaders >::toCpp(arg);
        // header(QNetworkRequest::KnownHeaders)const
        QNetworkRequest* cppSelf = Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QNetworkRequest::header(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkRequestFunc_header_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQNetworkRequestFunc_header_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkRequest.KnownHeaders", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkRequest.header", overloads);
        return 0;
}

static PyObject* SbkQNetworkRequestFunc_originatingObject(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // originatingObject()const
    QNetworkRequest* cppSelf = Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)self);
    QObject * cpp_result = cppSelf->QNetworkRequest::originatingObject();
    py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkRequestFunc_rawHeader(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // rawHeader(QByteArray)const
        QNetworkRequest* cppSelf = Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QNetworkRequest::rawHeader(*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkRequestFunc_rawHeader_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQNetworkRequestFunc_rawHeader_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkRequest.rawHeader", overloads);
        return 0;
}

static PyObject* SbkQNetworkRequestFunc_rawHeaderList(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rawHeaderList()const
    QNetworkRequest* cppSelf = Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)self);
    QList<QByteArray > cpp_result = cppSelf->QNetworkRequest::rawHeaderList();
    py_result = Shiboken::Converter<QList<QByteArray > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkRequestFunc_setAttribute(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setAttribute", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QNetworkRequest::Attribute >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        QNetworkRequest::Attribute cpp_arg0 = Shiboken::Converter<QNetworkRequest::Attribute >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // setAttribute(QNetworkRequest::Attribute,QVariant)
        QNetworkRequest* cppSelf = Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)self);
        cppSelf->QNetworkRequest::setAttribute(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkRequestFunc_setAttribute_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkRequestFunc_setAttribute_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkRequest.Attribute, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkRequest.setAttribute", overloads);
        return 0;
}

static PyObject* SbkQNetworkRequestFunc_setHeader(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setHeader", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QNetworkRequest::KnownHeaders >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        QNetworkRequest::KnownHeaders cpp_arg0 = Shiboken::Converter<QNetworkRequest::KnownHeaders >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // setHeader(QNetworkRequest::KnownHeaders,QVariant)
        QNetworkRequest* cppSelf = Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)self);
        cppSelf->QNetworkRequest::setHeader(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkRequestFunc_setHeader_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkRequestFunc_setHeader_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkRequest.KnownHeaders, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkRequest.setHeader", overloads);
        return 0;
}

static PyObject* SbkQNetworkRequestFunc_setOriginatingObject(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QObject * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);
        // setOriginatingObject(QObject*)
        QNetworkRequest* cppSelf = Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)self);
        cppSelf->QNetworkRequest::setOriginatingObject(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkRequestFunc_setOriginatingObject_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkRequestFunc_setOriginatingObject_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkRequest.setOriginatingObject", overloads);
        return 0;
}

static PyObject* SbkQNetworkRequestFunc_setRawHeader(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRawHeader", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QByteArray & >::isConvertible(pyargs[0]) && Shiboken::Converter<QByteArray & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!SbkQByteArray_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
        QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
        if (!SbkQByteArray_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
        // setRawHeader(QByteArray,QByteArray)
        QNetworkRequest* cppSelf = Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)self);
        cppSelf->QNetworkRequest::setRawHeader(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkRequestFunc_setRawHeader_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkRequestFunc_setRawHeader_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkRequest.setRawHeader", overloads);
        return 0;
}

static PyObject* SbkQNetworkRequestFunc_setSslConfiguration(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSslConfiguration & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSslConfiguration* cpp_arg0 = Shiboken::Converter<QSslConfiguration* >::toCpp(arg);
        // setSslConfiguration(QSslConfiguration)
        QNetworkRequest* cppSelf = Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)self);
        cppSelf->QNetworkRequest::setSslConfiguration(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkRequestFunc_setSslConfiguration_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkRequestFunc_setSslConfiguration_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QSslConfiguration", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkRequest.setSslConfiguration", overloads);
        return 0;
}

static PyObject* SbkQNetworkRequestFunc_setUrl(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QUrl & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
        if (!SbkQUrl_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // setUrl(QUrl)
        QNetworkRequest* cppSelf = Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)self);
        cppSelf->QNetworkRequest::setUrl(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkRequestFunc_setUrl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkRequestFunc_setUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkRequest.setUrl", overloads);
        return 0;
}

static PyObject* SbkQNetworkRequestFunc_sslConfiguration(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sslConfiguration()const
    QNetworkRequest* cppSelf = Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)self);
    QSslConfiguration cpp_result = cppSelf->QNetworkRequest::sslConfiguration();
    py_result = Shiboken::Converter<QSslConfiguration >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkRequestFunc_url(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // url()const
    QNetworkRequest* cppSelf = Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)self);
    QUrl cpp_result = cppSelf->QNetworkRequest::url();
    py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQNetworkRequest_methods[] = {
    {"attribute", (PyCFunction)SbkQNetworkRequestFunc_attribute, METH_VARARGS},
    {"hasRawHeader", (PyCFunction)SbkQNetworkRequestFunc_hasRawHeader, METH_O},
    {"header", (PyCFunction)SbkQNetworkRequestFunc_header, METH_O},
    {"originatingObject", (PyCFunction)SbkQNetworkRequestFunc_originatingObject, METH_NOARGS},
    {"rawHeader", (PyCFunction)SbkQNetworkRequestFunc_rawHeader, METH_O},
    {"rawHeaderList", (PyCFunction)SbkQNetworkRequestFunc_rawHeaderList, METH_NOARGS},
    {"setAttribute", (PyCFunction)SbkQNetworkRequestFunc_setAttribute, METH_VARARGS},
    {"setHeader", (PyCFunction)SbkQNetworkRequestFunc_setHeader, METH_VARARGS},
    {"setOriginatingObject", (PyCFunction)SbkQNetworkRequestFunc_setOriginatingObject, METH_O},
    {"setRawHeader", (PyCFunction)SbkQNetworkRequestFunc_setRawHeader, METH_VARARGS},
    {"setSslConfiguration", (PyCFunction)SbkQNetworkRequestFunc_setSslConfiguration, METH_O},
    {"setUrl", (PyCFunction)SbkQNetworkRequestFunc_setUrl, METH_O},
    {"sslConfiguration", (PyCFunction)SbkQNetworkRequestFunc_sslConfiguration, METH_NOARGS},
    {"url", (PyCFunction)SbkQNetworkRequestFunc_url, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQNetworkRequest_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QNetworkRequest& cpp_self = *Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QNetworkRequest & >::isConvertible(other)) {
                // operator!=(const QNetworkRequest & other) const
                QNetworkRequest* cpp_other = Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QNetworkRequest  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQNetworkRequest_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QNetworkRequest & >::isConvertible(other)) {
                // operator==(const QNetworkRequest & other) const
                QNetworkRequest* cpp_other = Shiboken::Converter<QNetworkRequest* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QNetworkRequest  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQNetworkRequest_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQNetworkRequest_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQNetworkRequest_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QNetworkRequest",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQNetworkRequest_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQNetworkRequest_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQNetworkRequest_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QNetworkRequest >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CacheLoadControl",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "KnownHeaders",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QNetworkRequest_Attribute_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QNetworkRequest_Attribute_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Attribute",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QNetworkRequest_Attribute_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QNetworkRequest_Attribute_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtNetwork_QNetworkRequest_Attribute_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QNetworkRequest(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQNetworkRequest_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQNetworkRequest_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQNetworkRequest_Type));
    PyModule_AddObject(module, "QNetworkRequest",
        ((PyObject*)&SbkQNetworkRequest_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: CacheLoadControl
    SbkPySide_QtNetworkTypes[SBK_QNETWORKREQUEST_CACHELOADCONTROL_IDX] = &SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_Type);
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
            "CacheLoadControl",((PyObject*)&SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_Type,
        (long) QNetworkRequest::AlwaysNetwork, "AlwaysNetwork");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "AlwaysNetwork", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_Type.tp_dict,
        "AlwaysNetwork", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_Type,
        (long) QNetworkRequest::PreferNetwork, "PreferNetwork");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "PreferNetwork", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_Type.tp_dict,
        "PreferNetwork", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_Type,
        (long) QNetworkRequest::PreferCache, "PreferCache");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "PreferCache", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_Type.tp_dict,
        "PreferCache", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_Type,
        (long) QNetworkRequest::AlwaysCache, "AlwaysCache");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "AlwaysCache", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_CacheLoadControl_Type.tp_dict,
        "AlwaysCache", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QNetworkRequest::CacheLoadControl");

    // init enum class: KnownHeaders
    SbkPySide_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX] = &SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Type);
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
            "KnownHeaders",((PyObject*)&SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Type,
        (long) QNetworkRequest::ContentTypeHeader, "ContentTypeHeader");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "ContentTypeHeader", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Type.tp_dict,
        "ContentTypeHeader", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Type,
        (long) QNetworkRequest::ContentLengthHeader, "ContentLengthHeader");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "ContentLengthHeader", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Type.tp_dict,
        "ContentLengthHeader", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Type,
        (long) QNetworkRequest::LocationHeader, "LocationHeader");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "LocationHeader", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Type.tp_dict,
        "LocationHeader", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Type,
        (long) QNetworkRequest::LastModifiedHeader, "LastModifiedHeader");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "LastModifiedHeader", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Type.tp_dict,
        "LastModifiedHeader", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Type,
        (long) QNetworkRequest::CookieHeader, "CookieHeader");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "CookieHeader", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Type.tp_dict,
        "CookieHeader", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Type,
        (long) QNetworkRequest::SetCookieHeader, "SetCookieHeader");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "SetCookieHeader", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_KnownHeaders_Type.tp_dict,
        "SetCookieHeader", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QNetworkRequest::KnownHeaders");

    // init enum class: Attribute
    SbkPySide_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX] = &SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type);
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
            "Attribute",((PyObject*)&SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type,
        (long) QNetworkRequest::HttpStatusCodeAttribute, "HttpStatusCodeAttribute");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "HttpStatusCodeAttribute", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type.tp_dict,
        "HttpStatusCodeAttribute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type,
        (long) QNetworkRequest::HttpReasonPhraseAttribute, "HttpReasonPhraseAttribute");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "HttpReasonPhraseAttribute", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type.tp_dict,
        "HttpReasonPhraseAttribute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type,
        (long) QNetworkRequest::RedirectionTargetAttribute, "RedirectionTargetAttribute");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "RedirectionTargetAttribute", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type.tp_dict,
        "RedirectionTargetAttribute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type,
        (long) QNetworkRequest::ConnectionEncryptedAttribute, "ConnectionEncryptedAttribute");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "ConnectionEncryptedAttribute", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type.tp_dict,
        "ConnectionEncryptedAttribute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type,
        (long) QNetworkRequest::CacheLoadControlAttribute, "CacheLoadControlAttribute");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "CacheLoadControlAttribute", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type.tp_dict,
        "CacheLoadControlAttribute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type,
        (long) QNetworkRequest::CacheSaveControlAttribute, "CacheSaveControlAttribute");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "CacheSaveControlAttribute", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type.tp_dict,
        "CacheSaveControlAttribute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type,
        (long) QNetworkRequest::SourceIsFromCacheAttribute, "SourceIsFromCacheAttribute");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "SourceIsFromCacheAttribute", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type.tp_dict,
        "SourceIsFromCacheAttribute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type,
        (long) QNetworkRequest::DoNotBufferUploadDataAttribute, "DoNotBufferUploadDataAttribute");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "DoNotBufferUploadDataAttribute", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type.tp_dict,
        "DoNotBufferUploadDataAttribute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type,
        (long) QNetworkRequest::HttpPipeliningAllowedAttribute, "HttpPipeliningAllowedAttribute");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "HttpPipeliningAllowedAttribute", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type.tp_dict,
        "HttpPipeliningAllowedAttribute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type,
        (long) QNetworkRequest::HttpPipeliningWasUsedAttribute, "HttpPipeliningWasUsedAttribute");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "HttpPipeliningWasUsedAttribute", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type.tp_dict,
        "HttpPipeliningWasUsedAttribute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type,
        (long) QNetworkRequest::User, "User");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "User", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type.tp_dict,
        "User", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type,
        (long) QNetworkRequest::UserMax, "UserMax");
    PyDict_SetItemString(SbkQNetworkRequest_Type.super.ht_type.tp_dict,
        "UserMax", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkRequest_Attribute_Type.tp_dict,
        "UserMax", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QNetworkRequest::Attribute");

    Shiboken::TypeResolver::createValueTypeResolver<QNetworkRequest >("QNetworkRequest");
    Shiboken::TypeResolver::createValueTypeResolver<QNetworkRequest >(typeid(QNetworkRequest).name());
}


} // extern "C"

