/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtnetwork_python.h"

#include "qauthenticator_wrapper.h"

// Extra includes
#include <qauthenticator.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQAuthenticator_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAuthenticator* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QAuthenticator", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QAuthenticator()
        cptr = new QAuthenticator();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QAuthenticator & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QAuthenticator* cpp_arg0 = Shiboken::Converter<QAuthenticator* >::toCpp(pyargs[0]);
        // QAuthenticator(QAuthenticator)
        cptr = new QAuthenticator(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAuthenticator_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAuthenticator >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAuthenticator_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQAuthenticator_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtNetwork.QAuthenticator", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QAuthenticator", overloads);
        return -1;
}

static PyObject* SbkQAuthenticatorFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QAuthenticator* cppSelf = Shiboken::Converter<QAuthenticator* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAuthenticator::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAuthenticatorFunc_password(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // password()const
    QAuthenticator* cppSelf = Shiboken::Converter<QAuthenticator* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QAuthenticator::password();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAuthenticatorFunc_realm(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // realm()const
    QAuthenticator* cppSelf = Shiboken::Converter<QAuthenticator* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QAuthenticator::realm();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAuthenticatorFunc_setPassword(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPassword(QString)
        QAuthenticator* cppSelf = Shiboken::Converter<QAuthenticator* >::toCpp((PyObject*)self);
        cppSelf->QAuthenticator::setPassword(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAuthenticatorFunc_setPassword_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAuthenticatorFunc_setPassword_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QAuthenticator.setPassword", overloads);
        return 0;
}

static PyObject* SbkQAuthenticatorFunc_setUser(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setUser(QString)
        QAuthenticator* cppSelf = Shiboken::Converter<QAuthenticator* >::toCpp((PyObject*)self);
        cppSelf->QAuthenticator::setUser(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAuthenticatorFunc_setUser_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAuthenticatorFunc_setUser_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QAuthenticator.setUser", overloads);
        return 0;
}

static PyObject* SbkQAuthenticatorFunc_user(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // user()const
    QAuthenticator* cppSelf = Shiboken::Converter<QAuthenticator* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QAuthenticator::user();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQAuthenticator_methods[] = {
    {"isNull", (PyCFunction)SbkQAuthenticatorFunc_isNull, METH_NOARGS},
    {"password", (PyCFunction)SbkQAuthenticatorFunc_password, METH_NOARGS},
    {"realm", (PyCFunction)SbkQAuthenticatorFunc_realm, METH_NOARGS},
    {"setPassword", (PyCFunction)SbkQAuthenticatorFunc_setPassword, METH_O},
    {"setUser", (PyCFunction)SbkQAuthenticatorFunc_setUser, METH_O},
    {"user", (PyCFunction)SbkQAuthenticatorFunc_user, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQAuthenticator_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QAuthenticator& cpp_self = *Shiboken::Converter<QAuthenticator* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QAuthenticator & >::isConvertible(other)) {
                // operator!=(const QAuthenticator & other) const
                QAuthenticator* cpp_other = Shiboken::Converter<QAuthenticator* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QAuthenticator  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQAuthenticator_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QAuthenticator & >::isConvertible(other)) {
                // operator==(const QAuthenticator & other) const
                QAuthenticator* cpp_other = Shiboken::Converter<QAuthenticator* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QAuthenticator  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQAuthenticator_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQAuthenticator_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAuthenticator_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QAuthenticator",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQAuthenticator_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAuthenticator_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAuthenticator_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAuthenticator >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QAuthenticator(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAuthenticator_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQAuthenticator_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAuthenticator_Type));
    PyModule_AddObject(module, "QAuthenticator",
        ((PyObject*)&SbkQAuthenticator_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QAuthenticator >("QAuthenticator");
    Shiboken::TypeResolver::createValueTypeResolver<QAuthenticator >(typeid(QAuthenticator).name());
}


} // extern "C"

