/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtmultimedia_python.h"

#include "qaudiooutput_wrapper.h"

// Extra includes
#include <QList>
#include <qaudiodeviceinfo.h>
#include <qaudioformat.h>
#include <qaudiooutput.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qiodevice.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAudioOutputWrapper::QAudioOutputWrapper(const QAudioDeviceInfo & audioDeviceInfo, const QAudioFormat & format, QObject * parent) : QAudioOutput(audioDeviceInfo, format, parent), m_metaObject(0) {
    // ... middle
}

QAudioOutputWrapper::QAudioOutputWrapper(const QAudioFormat & format, QObject * parent) : QAudioOutput(format, parent), m_metaObject(0) {
    // ... middle
}

void QAudioOutputWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAudioOutputWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAudioOutputWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAudioOutputWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QAudioOutputWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAudioOutput.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QAudioOutputWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAudioOutput.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QAudioOutputWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QAudioOutputWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QAudioOutput::staticMetaObject);
}
    return m_metaObject;
}

int QAudioOutputWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QAudioOutput::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QAudioOutputWrapper::~QAudioOutputWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQAudioOutput_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAudioOutputWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QAudioOutput", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QAudioOutput(QAudioFormat,QObject*)
        cptr = new QAudioOutputWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[1], self);
    } else if (Shiboken::Converter<QAudioFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QAudioFormat* cpp_arg0 = Shiboken::Converter<QAudioFormat* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QAudioOutput(QAudioFormat,QObject*)
            cptr = new QAudioOutputWrapper(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // QAudioOutput(QAudioFormat,QObject*)
            cptr = new QAudioOutputWrapper(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQAudioOutput_Init_TypeError;
    } else if (Shiboken::Converter<QAudioDeviceInfo & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QAudioDeviceInfo* cpp_arg0 = Shiboken::Converter<QAudioDeviceInfo* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QAudioOutput(QAudioDeviceInfo,QAudioFormat,QObject*)
            cptr = new QAudioOutputWrapper(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[2], self);
        } else if (Shiboken::Converter<QAudioFormat & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QAudioFormat* cpp_arg1 = Shiboken::Converter<QAudioFormat* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QAudioOutput(QAudioDeviceInfo,QAudioFormat,QObject*)
                cptr = new QAudioOutputWrapper(*cpp_arg0, *cpp_arg1);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[2], self);
            } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return -1;
                QObject* cpp_arg2 = Shiboken::Converter<QObject* >::toCpp(pyargs[2]);
                // QAudioOutput(QAudioDeviceInfo,QAudioFormat,QObject*)
                cptr = new QAudioOutputWrapper(*cpp_arg0, *cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[2], self);
            } else goto SbkQAudioOutput_Init_TypeError;
        } else goto SbkQAudioOutput_Init_TypeError;
    } else goto SbkQAudioOutput_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAudioOutput >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAudioOutput_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQAudioOutput_Init_TypeError:
        const char* overloads[] = {"PySide.QtMultimedia.QAudioDeviceInfo, PySide.QtMultimedia.QAudioFormat = QAudioFormat(), PySide.QtCore.QObject = None", "PySide.QtMultimedia.QAudioFormat = QAudioFormat(), PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtMultimedia.QAudioOutput", overloads);
        return -1;
}

static PyObject* SbkQAudioOutputFunc_bufferSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bufferSize()const
    QAudioOutput* cppSelf = Shiboken::Converter<QAudioOutput* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAudioOutput::bufferSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioOutputFunc_bytesFree(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bytesFree()const
    QAudioOutput* cppSelf = Shiboken::Converter<QAudioOutput* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAudioOutput::bytesFree();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioOutputFunc_elapsedUSecs(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // elapsedUSecs()const
    QAudioOutput* cppSelf = Shiboken::Converter<QAudioOutput* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QAudioOutput::elapsedUSecs();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioOutputFunc_error(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // error()const
    QAudioOutput* cppSelf = Shiboken::Converter<QAudioOutput* >::toCpp((PyObject*)self);
    QAudio::Error cpp_result = cppSelf->QAudioOutput::error();
    py_result = Shiboken::Converter<QAudio::Error >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioOutputFunc_notifyInterval(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // notifyInterval()const
    QAudioOutput* cppSelf = Shiboken::Converter<QAudioOutput* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAudioOutput::notifyInterval();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioOutputFunc_periodSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // periodSize()const
    QAudioOutput* cppSelf = Shiboken::Converter<QAudioOutput* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAudioOutput::periodSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioOutputFunc_processedUSecs(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // processedUSecs()const
    QAudioOutput* cppSelf = Shiboken::Converter<QAudioOutput* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QAudioOutput::processedUSecs();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioOutputFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    QAudioOutput* cppSelf = Shiboken::Converter<QAudioOutput* >::toCpp((PyObject*)self);
    cppSelf->QAudioOutput::reset();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAudioOutputFunc_resume(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // resume()
    QAudioOutput* cppSelf = Shiboken::Converter<QAudioOutput* >::toCpp((PyObject*)self);
    cppSelf->QAudioOutput::resume();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAudioOutputFunc_setBufferSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setBufferSize(int)
        QAudioOutput* cppSelf = Shiboken::Converter<QAudioOutput* >::toCpp((PyObject*)self);
        cppSelf->QAudioOutput::setBufferSize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAudioOutputFunc_setBufferSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAudioOutputFunc_setBufferSize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAudioOutput.setBufferSize", overloads);
        return 0;
}

static PyObject* SbkQAudioOutputFunc_setNotifyInterval(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setNotifyInterval(int)
        QAudioOutput* cppSelf = Shiboken::Converter<QAudioOutput* >::toCpp((PyObject*)self);
        cppSelf->QAudioOutput::setNotifyInterval(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAudioOutputFunc_setNotifyInterval_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAudioOutputFunc_setNotifyInterval_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAudioOutput.setNotifyInterval", overloads);
        return 0;
}

static PyObject* SbkQAudioOutputFunc_start(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // start()
        QAudioOutput* cppSelf = Shiboken::Converter<QAudioOutput* >::toCpp((PyObject*)self);
        QIODevice * cpp_result = cppSelf->QAudioOutput::start();
        py_result = Shiboken::Converter<QIODevice * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (Shiboken::Converter<QIODevice * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);
        // start(QIODevice*)
        QAudioOutput* cppSelf = Shiboken::Converter<QAudioOutput* >::toCpp((PyObject*)self);
        cppSelf->QAudioOutput::start(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else goto SbkQAudioOutputFunc_start_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAudioOutputFunc_start_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QIODevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAudioOutput.start", overloads);
        return 0;
}

static PyObject* SbkQAudioOutputFunc_state(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // state()const
    QAudioOutput* cppSelf = Shiboken::Converter<QAudioOutput* >::toCpp((PyObject*)self);
    QAudio::State cpp_result = cppSelf->QAudioOutput::state();
    py_result = Shiboken::Converter<QAudio::State >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioOutputFunc_stop(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // stop()
    QAudioOutput* cppSelf = Shiboken::Converter<QAudioOutput* >::toCpp((PyObject*)self);
    cppSelf->QAudioOutput::stop();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAudioOutputFunc_suspend(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // suspend()
    QAudioOutput* cppSelf = Shiboken::Converter<QAudioOutput* >::toCpp((PyObject*)self);
    cppSelf->QAudioOutput::suspend();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQAudioOutput_methods[] = {
    {"bufferSize", (PyCFunction)SbkQAudioOutputFunc_bufferSize, METH_NOARGS},
    {"bytesFree", (PyCFunction)SbkQAudioOutputFunc_bytesFree, METH_NOARGS},
    {"elapsedUSecs", (PyCFunction)SbkQAudioOutputFunc_elapsedUSecs, METH_NOARGS},
    {"error", (PyCFunction)SbkQAudioOutputFunc_error, METH_NOARGS},
    {"notifyInterval", (PyCFunction)SbkQAudioOutputFunc_notifyInterval, METH_NOARGS},
    {"periodSize", (PyCFunction)SbkQAudioOutputFunc_periodSize, METH_NOARGS},
    {"processedUSecs", (PyCFunction)SbkQAudioOutputFunc_processedUSecs, METH_NOARGS},
    {"reset", (PyCFunction)SbkQAudioOutputFunc_reset, METH_NOARGS},
    {"resume", (PyCFunction)SbkQAudioOutputFunc_resume, METH_NOARGS},
    {"setBufferSize", (PyCFunction)SbkQAudioOutputFunc_setBufferSize, METH_O},
    {"setNotifyInterval", (PyCFunction)SbkQAudioOutputFunc_setNotifyInterval, METH_O},
    {"start", (PyCFunction)SbkQAudioOutputFunc_start, METH_NOARGS|METH_O},
    {"state", (PyCFunction)SbkQAudioOutputFunc_state, METH_NOARGS},
    {"stop", (PyCFunction)SbkQAudioOutputFunc_stop, METH_NOARGS},
    {"suspend", (PyCFunction)SbkQAudioOutputFunc_suspend, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAudioOutput_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtMultimedia.QAudioOutput",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAudioOutput_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAudioOutput_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAudioOutput >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QAudioOutput(PyObject* module)
{
    SbkPySide_QtMultimediaTypes[SBK_QAUDIOOUTPUT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAudioOutput_Type);

    SbkQAudioOutput_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQAudioOutput_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQAudioOutput_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAudioOutput_Type));
    PyModule_AddObject(module, "QAudioOutput",
        ((PyObject*)&SbkQAudioOutput_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QAudioOutput >("QAudioOutput*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAudioOutput >(typeid(QAudioOutput).name());
}


} // extern "C"

