/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtmultimedia_python.h"

#include "qaudioinput_wrapper.h"

// Extra includes
#include <QList>
#include <qaudiodeviceinfo.h>
#include <qaudioformat.h>
#include <qaudioinput.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qiodevice.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAudioInputWrapper::QAudioInputWrapper(const QAudioDeviceInfo & audioDeviceInfo, const QAudioFormat & format, QObject * parent) : QAudioInput(audioDeviceInfo, format, parent), m_metaObject(0) {
    // ... middle
}

QAudioInputWrapper::QAudioInputWrapper(const QAudioFormat & format, QObject * parent) : QAudioInput(format, parent), m_metaObject(0) {
    // ... middle
}

void QAudioInputWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAudioInputWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAudioInputWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAudioInputWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QAudioInputWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAudioInput.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QAudioInputWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAudioInput.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QAudioInputWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QAudioInputWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QAudioInput::staticMetaObject);
}
    return m_metaObject;
}

int QAudioInputWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QAudioInput::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QAudioInputWrapper::~QAudioInputWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQAudioInput_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAudioInputWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QAudioInput", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QAudioInput(QAudioFormat,QObject*)
        cptr = new QAudioInputWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[1], self);
    } else if (Shiboken::Converter<QAudioFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QAudioFormat* cpp_arg0 = Shiboken::Converter<QAudioFormat* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QAudioInput(QAudioFormat,QObject*)
            cptr = new QAudioInputWrapper(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // QAudioInput(QAudioFormat,QObject*)
            cptr = new QAudioInputWrapper(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQAudioInput_Init_TypeError;
    } else if (Shiboken::Converter<QAudioDeviceInfo & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QAudioDeviceInfo* cpp_arg0 = Shiboken::Converter<QAudioDeviceInfo* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QAudioInput(QAudioDeviceInfo,QAudioFormat,QObject*)
            cptr = new QAudioInputWrapper(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[2], self);
        } else if (Shiboken::Converter<QAudioFormat & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QAudioFormat* cpp_arg1 = Shiboken::Converter<QAudioFormat* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QAudioInput(QAudioDeviceInfo,QAudioFormat,QObject*)
                cptr = new QAudioInputWrapper(*cpp_arg0, *cpp_arg1);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[2], self);
            } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return -1;
                QObject* cpp_arg2 = Shiboken::Converter<QObject* >::toCpp(pyargs[2]);
                // QAudioInput(QAudioDeviceInfo,QAudioFormat,QObject*)
                cptr = new QAudioInputWrapper(*cpp_arg0, *cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[2], self);
            } else goto SbkQAudioInput_Init_TypeError;
        } else goto SbkQAudioInput_Init_TypeError;
    } else goto SbkQAudioInput_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAudioInput >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAudioInput_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQAudioInput_Init_TypeError:
        const char* overloads[] = {"PySide.QtMultimedia.QAudioDeviceInfo, PySide.QtMultimedia.QAudioFormat = QAudioFormat(), PySide.QtCore.QObject = None", "PySide.QtMultimedia.QAudioFormat = QAudioFormat(), PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtMultimedia.QAudioInput", overloads);
        return -1;
}

static PyObject* SbkQAudioInputFunc_bufferSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bufferSize()const
    QAudioInput* cppSelf = Shiboken::Converter<QAudioInput* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAudioInput::bufferSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioInputFunc_bytesReady(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bytesReady()const
    QAudioInput* cppSelf = Shiboken::Converter<QAudioInput* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAudioInput::bytesReady();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioInputFunc_elapsedUSecs(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // elapsedUSecs()const
    QAudioInput* cppSelf = Shiboken::Converter<QAudioInput* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QAudioInput::elapsedUSecs();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioInputFunc_error(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // error()const
    QAudioInput* cppSelf = Shiboken::Converter<QAudioInput* >::toCpp((PyObject*)self);
    QAudio::Error cpp_result = cppSelf->QAudioInput::error();
    py_result = Shiboken::Converter<QAudio::Error >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioInputFunc_notifyInterval(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // notifyInterval()const
    QAudioInput* cppSelf = Shiboken::Converter<QAudioInput* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAudioInput::notifyInterval();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioInputFunc_periodSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // periodSize()const
    QAudioInput* cppSelf = Shiboken::Converter<QAudioInput* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAudioInput::periodSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioInputFunc_processedUSecs(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // processedUSecs()const
    QAudioInput* cppSelf = Shiboken::Converter<QAudioInput* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QAudioInput::processedUSecs();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioInputFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    QAudioInput* cppSelf = Shiboken::Converter<QAudioInput* >::toCpp((PyObject*)self);
    cppSelf->QAudioInput::reset();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAudioInputFunc_resume(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // resume()
    QAudioInput* cppSelf = Shiboken::Converter<QAudioInput* >::toCpp((PyObject*)self);
    cppSelf->QAudioInput::resume();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAudioInputFunc_setBufferSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setBufferSize(int)
        QAudioInput* cppSelf = Shiboken::Converter<QAudioInput* >::toCpp((PyObject*)self);
        cppSelf->QAudioInput::setBufferSize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAudioInputFunc_setBufferSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAudioInputFunc_setBufferSize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAudioInput.setBufferSize", overloads);
        return 0;
}

static PyObject* SbkQAudioInputFunc_setNotifyInterval(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setNotifyInterval(int)
        QAudioInput* cppSelf = Shiboken::Converter<QAudioInput* >::toCpp((PyObject*)self);
        cppSelf->QAudioInput::setNotifyInterval(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAudioInputFunc_setNotifyInterval_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAudioInputFunc_setNotifyInterval_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAudioInput.setNotifyInterval", overloads);
        return 0;
}

static PyObject* SbkQAudioInputFunc_start(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // start()
        QAudioInput* cppSelf = Shiboken::Converter<QAudioInput* >::toCpp((PyObject*)self);
        QIODevice * cpp_result = cppSelf->QAudioInput::start();
        py_result = Shiboken::Converter<QIODevice * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (Shiboken::Converter<QIODevice * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);
        // start(QIODevice*)
        QAudioInput* cppSelf = Shiboken::Converter<QAudioInput* >::toCpp((PyObject*)self);
        cppSelf->QAudioInput::start(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else goto SbkQAudioInputFunc_start_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAudioInputFunc_start_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QIODevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAudioInput.start", overloads);
        return 0;
}

static PyObject* SbkQAudioInputFunc_state(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // state()const
    QAudioInput* cppSelf = Shiboken::Converter<QAudioInput* >::toCpp((PyObject*)self);
    QAudio::State cpp_result = cppSelf->QAudioInput::state();
    py_result = Shiboken::Converter<QAudio::State >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioInputFunc_stop(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // stop()
    QAudioInput* cppSelf = Shiboken::Converter<QAudioInput* >::toCpp((PyObject*)self);
    cppSelf->QAudioInput::stop();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAudioInputFunc_suspend(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // suspend()
    QAudioInput* cppSelf = Shiboken::Converter<QAudioInput* >::toCpp((PyObject*)self);
    cppSelf->QAudioInput::suspend();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQAudioInput_methods[] = {
    {"bufferSize", (PyCFunction)SbkQAudioInputFunc_bufferSize, METH_NOARGS},
    {"bytesReady", (PyCFunction)SbkQAudioInputFunc_bytesReady, METH_NOARGS},
    {"elapsedUSecs", (PyCFunction)SbkQAudioInputFunc_elapsedUSecs, METH_NOARGS},
    {"error", (PyCFunction)SbkQAudioInputFunc_error, METH_NOARGS},
    {"notifyInterval", (PyCFunction)SbkQAudioInputFunc_notifyInterval, METH_NOARGS},
    {"periodSize", (PyCFunction)SbkQAudioInputFunc_periodSize, METH_NOARGS},
    {"processedUSecs", (PyCFunction)SbkQAudioInputFunc_processedUSecs, METH_NOARGS},
    {"reset", (PyCFunction)SbkQAudioInputFunc_reset, METH_NOARGS},
    {"resume", (PyCFunction)SbkQAudioInputFunc_resume, METH_NOARGS},
    {"setBufferSize", (PyCFunction)SbkQAudioInputFunc_setBufferSize, METH_O},
    {"setNotifyInterval", (PyCFunction)SbkQAudioInputFunc_setNotifyInterval, METH_O},
    {"start", (PyCFunction)SbkQAudioInputFunc_start, METH_NOARGS|METH_O},
    {"state", (PyCFunction)SbkQAudioInputFunc_state, METH_NOARGS},
    {"stop", (PyCFunction)SbkQAudioInputFunc_stop, METH_NOARGS},
    {"suspend", (PyCFunction)SbkQAudioInputFunc_suspend, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAudioInput_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtMultimedia.QAudioInput",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAudioInput_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAudioInput_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAudioInput >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QAudioInput(PyObject* module)
{
    SbkPySide_QtMultimediaTypes[SBK_QAUDIOINPUT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAudioInput_Type);

    SbkQAudioInput_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQAudioInput_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQAudioInput_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAudioInput_Type));
    PyModule_AddObject(module, "QAudioInput",
        ((PyObject*)&SbkQAudioInput_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QAudioInput >("QAudioInput*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAudioInput >(typeid(QAudioInput).name());
}


} // extern "C"

