/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtmultimedia_python.h"

#include "qaudiodeviceinfo_wrapper.h"

// Extra includes
#include <QList>
#include <qaudiodeviceinfo.h>
#include <qaudioformat.h>
#include <qbytearray.h>
#include <qstring.h>
#include <qstringlist.h>

using namespace Shiboken;

static int
SbkQAudioDeviceInfo_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAudioDeviceInfo* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QAudioDeviceInfo", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QAudioDeviceInfo()
        cptr = new QAudioDeviceInfo();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QAudioDeviceInfo & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QAudioDeviceInfo* cpp_arg0 = Shiboken::Converter<QAudioDeviceInfo* >::toCpp(pyargs[0]);
        // QAudioDeviceInfo(QAudioDeviceInfo)
        cptr = new QAudioDeviceInfo(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAudioDeviceInfo_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAudioDeviceInfo >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAudioDeviceInfo_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQAudioDeviceInfo_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtMultimedia.QAudioDeviceInfo", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtMultimedia.QAudioDeviceInfo", overloads);
        return -1;
}

static PyObject* SbkQAudioDeviceInfoFunc_deviceName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // deviceName()const
    QAudioDeviceInfo* cppSelf = Shiboken::Converter<QAudioDeviceInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QAudioDeviceInfo::deviceName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioDeviceInfoFunc_isFormatSupported(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QAudioFormat & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAudioFormat* cpp_arg0 = Shiboken::Converter<QAudioFormat* >::toCpp(arg);
        // isFormatSupported(QAudioFormat)const
        QAudioDeviceInfo* cppSelf = Shiboken::Converter<QAudioDeviceInfo* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAudioDeviceInfo::isFormatSupported(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAudioDeviceInfoFunc_isFormatSupported_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAudioDeviceInfoFunc_isFormatSupported_TypeError:
        const char* overloads[] = {"PySide.QtMultimedia.QAudioFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAudioDeviceInfo.isFormatSupported", overloads);
        return 0;
}

static PyObject* SbkQAudioDeviceInfoFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QAudioDeviceInfo* cppSelf = Shiboken::Converter<QAudioDeviceInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAudioDeviceInfo::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioDeviceInfoFunc_supportedByteOrders(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedByteOrders()const
    QAudioDeviceInfo* cppSelf = Shiboken::Converter<QAudioDeviceInfo* >::toCpp((PyObject*)self);
    QList<QAudioFormat::Endian > cpp_result = cppSelf->QAudioDeviceInfo::supportedByteOrders();
    py_result = Shiboken::Converter<QList<QAudioFormat::Endian > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioDeviceInfoFunc_supportedChannels(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedChannels()const
    QAudioDeviceInfo* cppSelf = Shiboken::Converter<QAudioDeviceInfo* >::toCpp((PyObject*)self);
    QList<int > cpp_result = cppSelf->QAudioDeviceInfo::supportedChannels();
    py_result = Shiboken::Converter<QList<int > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioDeviceInfoFunc_supportedCodecs(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedCodecs()const
    QAudioDeviceInfo* cppSelf = Shiboken::Converter<QAudioDeviceInfo* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QAudioDeviceInfo::supportedCodecs();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioDeviceInfoFunc_supportedFrequencies(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedFrequencies()const
    QAudioDeviceInfo* cppSelf = Shiboken::Converter<QAudioDeviceInfo* >::toCpp((PyObject*)self);
    QList<int > cpp_result = cppSelf->QAudioDeviceInfo::supportedFrequencies();
    py_result = Shiboken::Converter<QList<int > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioDeviceInfoFunc_supportedSampleSizes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedSampleSizes()const
    QAudioDeviceInfo* cppSelf = Shiboken::Converter<QAudioDeviceInfo* >::toCpp((PyObject*)self);
    QList<int > cpp_result = cppSelf->QAudioDeviceInfo::supportedSampleSizes();
    py_result = Shiboken::Converter<QList<int > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioDeviceInfoFunc_supportedSampleTypes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedSampleTypes()const
    QAudioDeviceInfo* cppSelf = Shiboken::Converter<QAudioDeviceInfo* >::toCpp((PyObject*)self);
    QList<QAudioFormat::SampleType > cpp_result = cppSelf->QAudioDeviceInfo::supportedSampleTypes();
    py_result = Shiboken::Converter<QList<QAudioFormat::SampleType > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQAudioDeviceInfo_methods[] = {
    {"deviceName", (PyCFunction)SbkQAudioDeviceInfoFunc_deviceName, METH_NOARGS},
    {"isFormatSupported", (PyCFunction)SbkQAudioDeviceInfoFunc_isFormatSupported, METH_O},
    {"isNull", (PyCFunction)SbkQAudioDeviceInfoFunc_isNull, METH_NOARGS},
    {"supportedByteOrders", (PyCFunction)SbkQAudioDeviceInfoFunc_supportedByteOrders, METH_NOARGS},
    {"supportedChannels", (PyCFunction)SbkQAudioDeviceInfoFunc_supportedChannels, METH_NOARGS},
    {"supportedCodecs", (PyCFunction)SbkQAudioDeviceInfoFunc_supportedCodecs, METH_NOARGS},
    {"supportedFrequencies", (PyCFunction)SbkQAudioDeviceInfoFunc_supportedFrequencies, METH_NOARGS},
    {"supportedSampleSizes", (PyCFunction)SbkQAudioDeviceInfoFunc_supportedSampleSizes, METH_NOARGS},
    {"supportedSampleTypes", (PyCFunction)SbkQAudioDeviceInfoFunc_supportedSampleTypes, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAudioDeviceInfo_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtMultimedia.QAudioDeviceInfo",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAudioDeviceInfo_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAudioDeviceInfo_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAudioDeviceInfo >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QAudioDeviceInfo(PyObject* module)
{
    SbkPySide_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAudioDeviceInfo_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQAudioDeviceInfo_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAudioDeviceInfo_Type));
    PyModule_AddObject(module, "QAudioDeviceInfo",
        ((PyObject*)&SbkQAudioDeviceInfo_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QAudioDeviceInfo >("QAudioDeviceInfo*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAudioDeviceInfo >(typeid(QAudioDeviceInfo).name());
}


} // extern "C"

