/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef SBK_QMAEMO5VALUEBUTTONWRAPPER_H
#define SBK_QMAEMO5VALUEBUTTONWRAPPER_H

#define protected public

#include <shiboken.h>

#include <qmaemo5valuebutton.h>

namespace PySide { class DynamicQMetaObject; }

class QMaemo5ValueButtonWrapper : public QMaemo5ValueButton
{
public:
    QMaemo5ValueButtonWrapper(QWidget * parent = 0);
    QMaemo5ValueButtonWrapper(const QIcon & icon, const QString & text, QWidget * parent = 0);
    QMaemo5ValueButtonWrapper(const QString & text, QWidget * parent = 0);
    virtual void actionEvent(QActionEvent * arg__1);
    virtual void changeEvent(QEvent * e);
    virtual void checkStateSet();
    virtual void childEvent(QChildEvent * arg__1);
    virtual void closeEvent(QCloseEvent * arg__1);
    virtual void connectNotify(const char * signal);
    virtual void contextMenuEvent(QContextMenuEvent * arg__1);
    virtual void customEvent(QEvent * arg__1);
    virtual int devType() const;
    virtual void disconnectNotify(const char * signal);
    virtual void dragEnterEvent(QDragEnterEvent * arg__1);
    virtual void dragLeaveEvent(QDragLeaveEvent * arg__1);
    virtual void dragMoveEvent(QDragMoveEvent * arg__1);
    virtual void dropEvent(QDropEvent * arg__1);
    virtual void enterEvent(QEvent * arg__1);
    virtual bool event(QEvent * e);
    virtual bool eventFilter(QObject * arg__1, QEvent * arg__2);
    virtual void focusInEvent(QFocusEvent * arg__1);
    virtual bool focusNextPrevChild(bool next);
    virtual void focusOutEvent(QFocusEvent * arg__1);
    virtual int heightForWidth(int arg__1) const;
    virtual void hideEvent(QHideEvent * arg__1);
    virtual bool hitButton(const QPoint & pos) const;
    virtual void inputMethodEvent(QInputMethodEvent * arg__1);
    virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg__1) const;
    virtual void keyPressEvent(QKeyEvent * arg__1);
    virtual void keyReleaseEvent(QKeyEvent * e);
    virtual void languageChange();
    virtual void leaveEvent(QEvent * arg__1);
    virtual const QMetaObject * metaObject() const;
    virtual int metric(QPaintDevice::PaintDeviceMetric arg__1) const;
    virtual QSize minimumSizeHint() const;
    virtual void mouseDoubleClickEvent(QMouseEvent * arg__1);
    virtual void mouseMoveEvent(QMouseEvent * e);
    virtual void mousePressEvent(QMouseEvent * e);
    virtual void mouseReleaseEvent(QMouseEvent * e);
    virtual void moveEvent(QMoveEvent * arg__1);
    virtual void nextCheckState();
    virtual QPaintEngine * paintEngine() const;
    virtual void paintEvent(QPaintEvent * pe);
    virtual void resizeEvent(QResizeEvent * arg__1);
    virtual void setValueText(const QString & text);
    virtual void setVisible(bool visible);
    virtual void showEvent(QShowEvent * arg__1);
    virtual QSize sizeHint() const;
    virtual void tabletEvent(QTabletEvent * arg__1);
    virtual void timerEvent(QTimerEvent * e);
    virtual void wheelEvent(QWheelEvent * arg__1);
    ~QMaemo5ValueButtonWrapper();
public:
    virtual int qt_metacall(QMetaObject::Call call, int id, void** args);
private:
    mutable PySide::DynamicQMetaObject* m_metaObject;
};

#endif // SBK_QMAEMO5VALUEBUTTONWRAPPER_H

