/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qwizard_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractbutton.h>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qwizard.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QWizardWrapper::QWizardWrapper(QWidget * parent, QFlags<Qt::WindowType> flags) : QWizard(parent, flags), m_metaObject(0) {
    // ... middle
}

void QWizardWrapper::accept()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "accept"));
    if (py_override.isNull()) {
        return this->QDialog::accept();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWizardWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWizardWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWizardWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWizardWrapper::cleanupPage(int id)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "cleanupPage"));
    if (py_override.isNull()) {
        return this->QWizard::cleanupPage(id);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        id
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWizardWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QDialog::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWizardWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWizardWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QDialog::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWizardWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QWizardWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWizard.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QWizardWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWizardWrapper::done(int result)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "done"));
    if (py_override.isNull()) {
        return this->QWizard::done(result);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        result
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWizardWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWizardWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWizardWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWizardWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWizardWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QWizardWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QWizard::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWizard.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QWizardWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QDialog::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWizard.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QWizardWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QWizardWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWizard.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QWizardWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QWizardWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWizard.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QWizardWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWizardWrapper::initializePage(int id)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "initializePage"));
    if (py_override.isNull()) {
        return this->QWizard::initializePage(id);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        id
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWizardWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QWizardWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWizard.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QWizardWrapper::keyPressEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QDialog::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWizardWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWizardWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWizardWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QWizardWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWizard.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QWizardWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QDialog::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWizard.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QWizardWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWizardWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWizardWrapper::mousePressEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWizardWrapper::mouseReleaseEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWizardWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QWizardWrapper::nextId() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "nextId"));
    if (py_override.isNull()) {
        return this->QWizard::nextId();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWizard.nextId", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QPaintEngine * QWizardWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWizard.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QWizardWrapper::paintEvent(QPaintEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QWizard::paintEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWizardWrapper::reject()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reject"));
    if (py_override.isNull()) {
        return this->QDialog::reject();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWizardWrapper::resizeEvent(QResizeEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QWizard::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWizardWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWizard::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QWizardWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QDialog::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QWizardWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QWizard::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWizard.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QWizardWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWizardWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QWizardWrapper::validateCurrentPage()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "validateCurrentPage"));
    if (py_override.isNull()) {
        return this->QWizard::validateCurrentPage();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWizard.validateCurrentPage", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QWizardWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QWidget::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QWizardWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QWizard::staticMetaObject);
}
    return m_metaObject;
}

int QWizardWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QWizard::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QWizardWrapper::~QWizardWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQWizard_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QWizardWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QWizard", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QWizard(QWidget*,QFlags<Qt::WindowType>)
        cptr = new QWizardWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QWizard(QWidget*,QFlags<Qt::WindowType>)
            cptr = new QWizardWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
        } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[1])) {
            QFlags<Qt::WindowType> cpp_arg1 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[1]);
            // QWizard(QWidget*,QFlags<Qt::WindowType>)
            cptr = new QWizardWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
        } else goto SbkQWizard_Init_TypeError;
    } else goto SbkQWizard_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QWizard >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQWizard_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQWizard_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None, PySide.QtCore.Qt.WindowFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWizard", overloads);
        return -1;
}

static PyObject* SbkQWizardFunc_addPage(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWizardPage * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWizardPage* cpp_arg0 = Shiboken::Converter<QWizardPage* >::toCpp(arg);
        // addPage(QWizardPage*)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QWizard::addPage(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQWizardFunc_addPage_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWizardFunc_addPage_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWizardPage", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.addPage", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_back(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // back()
    QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
    cppSelf->QWizard::back();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQWizardFunc_button(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWizard::WizardButton >::isConvertible(arg)) {
        QWizard::WizardButton cpp_arg0 = Shiboken::Converter<QWizard::WizardButton >::toCpp(arg);
        // button(QWizard::WizardButton)const
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        QAbstractButton * cpp_result = cppSelf->QWizard::button(cpp_arg0);
        py_result = Shiboken::Converter<QAbstractButton * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQWizardFunc_button_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWizardFunc_button_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWizard.WizardButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.button", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_buttonText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWizard::WizardButton >::isConvertible(arg)) {
        QWizard::WizardButton cpp_arg0 = Shiboken::Converter<QWizard::WizardButton >::toCpp(arg);
        // buttonText(QWizard::WizardButton)const
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QWizard::buttonText(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_buttonText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWizardFunc_buttonText_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWizard.WizardButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.buttonText", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_cleanupPage(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // cleanupPage(int)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::cleanupPage(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_cleanupPage_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_cleanupPage_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.cleanupPage", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_currentId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentId()const
    QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWizard::currentId();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWizardFunc_currentPage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentPage()const
    QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
    QWizardPage * cpp_result = cppSelf->QWizard::currentPage();
    py_result = Shiboken::Converter<QWizardPage * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWizardFunc_done(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // done(int)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::done(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_done_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_done_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.done", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWizard::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWizardFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.event", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_field(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // field(QString)const
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QWizard::field(*cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_field_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWizardFunc_field_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.field", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_hasVisitedPage(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // hasVisitedPage(int)const
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWizard::hasVisitedPage(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_hasVisitedPage_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWizardFunc_hasVisitedPage_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.hasVisitedPage", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_initializePage(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // initializePage(int)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::initializePage(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_initializePage_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_initializePage_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.initializePage", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_next(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // next()
    QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
    cppSelf->QWizard::next();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQWizardFunc_nextId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nextId()const
    QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWizard::nextId();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWizardFunc_options(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // options()const
    QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
    QFlags<QWizard::WizardOption> cpp_result = cppSelf->QWizard::options();
    py_result = Shiboken::Converter<QFlags<QWizard::WizardOption> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWizardFunc_page(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // page(int)const
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        QWizardPage * cpp_result = cppSelf->QWizard::page(cpp_arg0);
        py_result = Shiboken::Converter<QWizardPage * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQWizardFunc_page_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWizardFunc_page_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.page", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_pageIds(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pageIds()const
    QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
    QList<int > cpp_result = cppSelf->QWizard::pageIds();
    py_result = Shiboken::Converter<QList<int > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWizardFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::paintEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.paintEvent", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_pixmap(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWizard::WizardPixmap >::isConvertible(arg)) {
        QWizard::WizardPixmap cpp_arg0 = Shiboken::Converter<QWizard::WizardPixmap >::toCpp(arg);
        // pixmap(QWizard::WizardPixmap)const
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        QPixmap cpp_result = cppSelf->QWizard::pixmap(cpp_arg0);
        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_pixmap_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWizardFunc_pixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWizard.WizardPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.pixmap", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_removePage(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // removePage(int)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::removePage(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_removePage_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_removePage_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.removePage", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QResizeEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QResizeEvent* cpp_arg0 = Shiboken::Converter<QResizeEvent* >::toCpp(arg);
        // resizeEvent(QResizeEvent*)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::resizeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.resizeEvent", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_restart(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // restart()
    QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
    cppSelf->QWizard::restart();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQWizardFunc_setButton(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setButton", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWizard::WizardButton >::isConvertible(pyargs[0]) && Shiboken::Converter<QAbstractButton * >::isConvertible(pyargs[1])) {
        QWizard::WizardButton cpp_arg0 = Shiboken::Converter<QWizard::WizardButton >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QAbstractButton* cpp_arg1 = Shiboken::Converter<QAbstractButton* >::toCpp(pyargs[1]);
        // setButton(QWizard::WizardButton,QAbstractButton*)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::setButton(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQWizardFunc_setButton_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_setButton_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWizard.WizardButton, PySide.QtGui.QAbstractButton", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWizard.setButton", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_setButtonLayout(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QWizard::WizardButton >  >::isConvertible(arg)) {
        QList<QWizard::WizardButton >  cpp_arg0 = Shiboken::Converter<QList<QWizard::WizardButton >  >::toCpp(arg);
        // setButtonLayout(QList<QWizard::WizardButton>)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::setButtonLayout(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_setButtonLayout_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_setButtonLayout_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.setButtonLayout", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_setButtonText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setButtonText", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWizard::WizardButton >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        QWizard::WizardButton cpp_arg0 = Shiboken::Converter<QWizard::WizardButton >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setButtonText(QWizard::WizardButton,QString)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::setButtonText(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_setButtonText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_setButtonText_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWizard.WizardButton, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWizard.setButtonText", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_setField(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setField", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // setField(QString,QVariant)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::setField(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_setField_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_setField_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWizard.setField", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_setOption(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setOption", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QWizard::WizardOption >::isConvertible(pyargs[0])) {
        QWizard::WizardOption cpp_arg0 = Shiboken::Converter<QWizard::WizardOption >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setOption(QWizard::WizardOption,bool)
            QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
            cppSelf->QWizard::setOption(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setOption(QWizard::WizardOption,bool)
            QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
            cppSelf->QWizard::setOption(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQWizardFunc_setOption_TypeError;
    } else goto SbkQWizardFunc_setOption_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_setOption_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWizard.WizardOption, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWizard.setOption", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_setOptions(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QWizard_WizardOption_Check(arg)) {
        QFlags<QWizard::WizardOption> cpp_arg0 = Shiboken::Converter<QFlags<QWizard::WizardOption> >::toCpp(arg);
        // setOptions(QFlags<QWizard::WizardOption>)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::setOptions(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_setOptions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_setOptions_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWizard.WizardOptions", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.setOptions", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_setPage(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setPage", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QWizardPage * >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QWizardPage* cpp_arg1 = Shiboken::Converter<QWizardPage* >::toCpp(pyargs[1]);
        // setPage(int,QWizardPage*)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::setPage(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_setPage_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_setPage_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QWizardPage", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWizard.setPage", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_setPixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setPixmap", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWizard::WizardPixmap >::isConvertible(pyargs[0]) && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[1])) {
        QWizard::WizardPixmap cpp_arg0 = Shiboken::Converter<QWizard::WizardPixmap >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg1_auto_ptr;
        QPixmap* cpp_arg1 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[1]);
        if (!SbkQPixmap_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg1);
        // setPixmap(QWizard::WizardPixmap,QPixmap)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::setPixmap(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_setPixmap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_setPixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWizard.WizardPixmap, PySide.QtGui.QPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWizard.setPixmap", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_setStartId(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setStartId(int)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::setStartId(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_setStartId_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_setStartId_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.setStartId", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_setSubTitleFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::TextFormat >::isConvertible(arg)) {
        Qt::TextFormat cpp_arg0 = Shiboken::Converter<Qt::TextFormat >::toCpp(arg);
        // setSubTitleFormat(Qt::TextFormat)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::setSubTitleFormat(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_setSubTitleFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_setSubTitleFormat_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.TextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.setSubTitleFormat", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_setTitleFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::TextFormat >::isConvertible(arg)) {
        Qt::TextFormat cpp_arg0 = Shiboken::Converter<Qt::TextFormat >::toCpp(arg);
        // setTitleFormat(Qt::TextFormat)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::setTitleFormat(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_setTitleFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_setTitleFormat_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.TextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.setTitleFormat", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_setVisible(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setVisible(bool)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::setVisible(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_setVisible_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_setVisible_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.setVisible", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_setWizardStyle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWizard::WizardStyle >::isConvertible(arg)) {
        QWizard::WizardStyle cpp_arg0 = Shiboken::Converter<QWizard::WizardStyle >::toCpp(arg);
        // setWizardStyle(QWizard::WizardStyle)
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        cppSelf->QWizard::setWizardStyle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_setWizardStyle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWizardFunc_setWizardStyle_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWizard.WizardStyle", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.setWizardStyle", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QWizard::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWizardFunc_startId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // startId()const
    QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWizard::startId();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWizardFunc_subTitleFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // subTitleFormat()const
    QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
    Qt::TextFormat cpp_result = cppSelf->QWizard::subTitleFormat();
    py_result = Shiboken::Converter<Qt::TextFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWizardFunc_testOption(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWizard::WizardOption >::isConvertible(arg)) {
        QWizard::WizardOption cpp_arg0 = Shiboken::Converter<QWizard::WizardOption >::toCpp(arg);
        // testOption(QWizard::WizardOption)const
        QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWizard::testOption(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWizardFunc_testOption_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWizardFunc_testOption_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWizard.WizardOption", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QWizard.testOption", overloads);
        return 0;
}

static PyObject* SbkQWizardFunc_titleFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // titleFormat()const
    QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
    Qt::TextFormat cpp_result = cppSelf->QWizard::titleFormat();
    py_result = Shiboken::Converter<Qt::TextFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWizardFunc_validateCurrentPage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // validateCurrentPage()
    QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWizard::validateCurrentPage();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWizardFunc_visitedPages(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // visitedPages()const
    QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
    QList<int > cpp_result = cppSelf->QWizard::visitedPages();
    py_result = Shiboken::Converter<QList<int > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWizardFunc_wizardStyle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // wizardStyle()const
    QWizard* cppSelf = Shiboken::Converter<QWizard* >::toCpp((PyObject*)self);
    QWizard::WizardStyle cpp_result = cppSelf->QWizard::wizardStyle();
    py_result = Shiboken::Converter<QWizard::WizardStyle >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQWizard_methods[] = {
    {"addPage", (PyCFunction)SbkQWizardFunc_addPage, METH_O},
    {"back", (PyCFunction)SbkQWizardFunc_back, METH_NOARGS},
    {"button", (PyCFunction)SbkQWizardFunc_button, METH_O},
    {"buttonText", (PyCFunction)SbkQWizardFunc_buttonText, METH_O},
    {"cleanupPage", (PyCFunction)SbkQWizardFunc_cleanupPage, METH_O},
    {"currentId", (PyCFunction)SbkQWizardFunc_currentId, METH_NOARGS},
    {"currentPage", (PyCFunction)SbkQWizardFunc_currentPage, METH_NOARGS},
    {"done", (PyCFunction)SbkQWizardFunc_done, METH_O},
    {"event", (PyCFunction)SbkQWizardFunc_event, METH_O},
    {"field", (PyCFunction)SbkQWizardFunc_field, METH_O},
    {"hasVisitedPage", (PyCFunction)SbkQWizardFunc_hasVisitedPage, METH_O},
    {"initializePage", (PyCFunction)SbkQWizardFunc_initializePage, METH_O},
    {"next", (PyCFunction)SbkQWizardFunc_next, METH_NOARGS},
    {"nextId", (PyCFunction)SbkQWizardFunc_nextId, METH_NOARGS},
    {"options", (PyCFunction)SbkQWizardFunc_options, METH_NOARGS},
    {"page", (PyCFunction)SbkQWizardFunc_page, METH_O},
    {"pageIds", (PyCFunction)SbkQWizardFunc_pageIds, METH_NOARGS},
    {"paintEvent", (PyCFunction)SbkQWizardFunc_paintEvent, METH_O},
    {"pixmap", (PyCFunction)SbkQWizardFunc_pixmap, METH_O},
    {"removePage", (PyCFunction)SbkQWizardFunc_removePage, METH_O},
    {"resizeEvent", (PyCFunction)SbkQWizardFunc_resizeEvent, METH_O},
    {"restart", (PyCFunction)SbkQWizardFunc_restart, METH_NOARGS},
    {"setButton", (PyCFunction)SbkQWizardFunc_setButton, METH_VARARGS},
    {"setButtonLayout", (PyCFunction)SbkQWizardFunc_setButtonLayout, METH_O},
    {"setButtonText", (PyCFunction)SbkQWizardFunc_setButtonText, METH_VARARGS},
    {"setField", (PyCFunction)SbkQWizardFunc_setField, METH_VARARGS},
    {"setOption", (PyCFunction)SbkQWizardFunc_setOption, METH_VARARGS},
    {"setOptions", (PyCFunction)SbkQWizardFunc_setOptions, METH_O},
    {"setPage", (PyCFunction)SbkQWizardFunc_setPage, METH_VARARGS},
    {"setPixmap", (PyCFunction)SbkQWizardFunc_setPixmap, METH_VARARGS},
    {"setStartId", (PyCFunction)SbkQWizardFunc_setStartId, METH_O},
    {"setSubTitleFormat", (PyCFunction)SbkQWizardFunc_setSubTitleFormat, METH_O},
    {"setTitleFormat", (PyCFunction)SbkQWizardFunc_setTitleFormat, METH_O},
    {"setVisible", (PyCFunction)SbkQWizardFunc_setVisible, METH_O},
    {"setWizardStyle", (PyCFunction)SbkQWizardFunc_setWizardStyle, METH_O},
    {"sizeHint", (PyCFunction)SbkQWizardFunc_sizeHint, METH_NOARGS},
    {"startId", (PyCFunction)SbkQWizardFunc_startId, METH_NOARGS},
    {"subTitleFormat", (PyCFunction)SbkQWizardFunc_subTitleFormat, METH_NOARGS},
    {"testOption", (PyCFunction)SbkQWizardFunc_testOption, METH_O},
    {"titleFormat", (PyCFunction)SbkQWizardFunc_titleFormat, METH_NOARGS},
    {"validateCurrentPage", (PyCFunction)SbkQWizardFunc_validateCurrentPage, METH_NOARGS},
    {"visitedPages", (PyCFunction)SbkQWizardFunc_visitedPages, METH_NOARGS},
    {"wizardStyle", (PyCFunction)SbkQWizardFunc_wizardStyle, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQWizardSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QWizard* me = reinterpret_cast<QWizard*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QDIALOG_IDX]))
        return static_cast<QDialog*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWizard_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QWizard",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWizard_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQWizard_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQWizardSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QWizard >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QWizard_WizardButton_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QWizard_WizardButton_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QWizard_WizardButton_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WizardButton",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QWizard_WizardButton_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QWizard_WizardButton_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QWizard_WizardButton_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QWizard_WizardStyle_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QWizard_WizardStyle_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QWizard_WizardStyle_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WizardStyle",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QWizard_WizardStyle_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QWizard_WizardStyle_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QWizard_WizardStyle_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QWizard_WizardPixmap_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QWizard_WizardPixmap_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QWizard_WizardPixmap_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WizardPixmap",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QWizard_WizardPixmap_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QWizard_WizardPixmap_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QWizard_WizardPixmap_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QWizard_WizardOption___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QWizard::WizardOptions >::toPython(
        ((QWizard::WizardOptions) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QWizard::WizardOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QWizard_WizardOption___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QWizard::WizardOptions >::toPython(
        ((QWizard::WizardOptions) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QWizard::WizardOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QWizard_WizardOption___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QWizard::WizardOptions >::toPython(
        ((QWizard::WizardOptions) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QWizard::WizardOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QWizard_WizardOption___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QWizard::WizardOptions >::toPython(
        ~ Shiboken::Converter< QWizard::WizardOptions >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QWizard_WizardOption_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QWizard_WizardOption___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QWizard_WizardOption___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QWizard_WizardOption___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QWizard_WizardOption___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QWizard_WizardOption_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QWizard_WizardOption_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QWizard_WizardOption_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WizardOption",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QWizard_WizardOption_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QWizard_WizardOption_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QWizard_WizardOption_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QWizard_WizardOption_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QWizard_WizardOptions_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QWizard_WizardOptions_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WizardOptions",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QWizard_WizardOption_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QWizard_WizardOptions_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QWizard_WizardOptions_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QWizard_WizardOptions_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QWizard(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QWIZARD_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWizard_Type);

    SbkQWizard_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QDIALOG_IDX];
    SbkQWizard_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQWizard_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQWizard_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQWizard_Type));
    PyModule_AddObject(module, "QWizard",
        ((PyObject*)&SbkQWizard_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: WizardButton
    SbkPySide_QtGuiTypes[SBK_QWIZARD_WIZARDBUTTON_IDX] = &SbkPySide_QtGui_QWizard_WizardButton_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QWizard_WizardButton_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QWizard_WizardButton_Type);
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
            "WizardButton",((PyObject*)&SbkPySide_QtGui_QWizard_WizardButton_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardButton_Type,
        (long) QWizard::BackButton, "BackButton");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "BackButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardButton_Type.tp_dict,
        "BackButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardButton_Type,
        (long) QWizard::NextButton, "NextButton");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "NextButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardButton_Type.tp_dict,
        "NextButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardButton_Type,
        (long) QWizard::CommitButton, "CommitButton");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "CommitButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardButton_Type.tp_dict,
        "CommitButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardButton_Type,
        (long) QWizard::FinishButton, "FinishButton");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "FinishButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardButton_Type.tp_dict,
        "FinishButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardButton_Type,
        (long) QWizard::CancelButton, "CancelButton");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "CancelButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardButton_Type.tp_dict,
        "CancelButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardButton_Type,
        (long) QWizard::HelpButton, "HelpButton");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "HelpButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardButton_Type.tp_dict,
        "HelpButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardButton_Type,
        (long) QWizard::CustomButton1, "CustomButton1");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "CustomButton1", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardButton_Type.tp_dict,
        "CustomButton1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardButton_Type,
        (long) QWizard::CustomButton2, "CustomButton2");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "CustomButton2", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardButton_Type.tp_dict,
        "CustomButton2", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardButton_Type,
        (long) QWizard::CustomButton3, "CustomButton3");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "CustomButton3", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardButton_Type.tp_dict,
        "CustomButton3", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardButton_Type,
        (long) QWizard::Stretch, "Stretch");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "Stretch", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardButton_Type.tp_dict,
        "Stretch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardButton_Type,
        (long) QWizard::NoButton, "NoButton");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "NoButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardButton_Type.tp_dict,
        "NoButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardButton_Type,
        (long) QWizard::NStandardButtons, "NStandardButtons");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "NStandardButtons", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardButton_Type.tp_dict,
        "NStandardButtons", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardButton_Type,
        (long) QWizard::NButtons, "NButtons");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "NButtons", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardButton_Type.tp_dict,
        "NButtons", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWizard::WizardButton");

    // init enum class: WizardStyle
    SbkPySide_QtGuiTypes[SBK_QWIZARD_WIZARDSTYLE_IDX] = &SbkPySide_QtGui_QWizard_WizardStyle_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QWizard_WizardStyle_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QWizard_WizardStyle_Type);
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
            "WizardStyle",((PyObject*)&SbkPySide_QtGui_QWizard_WizardStyle_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardStyle_Type,
        (long) QWizard::ClassicStyle, "ClassicStyle");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "ClassicStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardStyle_Type.tp_dict,
        "ClassicStyle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardStyle_Type,
        (long) QWizard::ModernStyle, "ModernStyle");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "ModernStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardStyle_Type.tp_dict,
        "ModernStyle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardStyle_Type,
        (long) QWizard::MacStyle, "MacStyle");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "MacStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardStyle_Type.tp_dict,
        "MacStyle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardStyle_Type,
        (long) QWizard::AeroStyle, "AeroStyle");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "AeroStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardStyle_Type.tp_dict,
        "AeroStyle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardStyle_Type,
        (long) QWizard::NStyles, "NStyles");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "NStyles", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardStyle_Type.tp_dict,
        "NStyles", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWizard::WizardStyle");

    // init enum class: WizardPixmap
    SbkPySide_QtGuiTypes[SBK_QWIZARD_WIZARDPIXMAP_IDX] = &SbkPySide_QtGui_QWizard_WizardPixmap_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QWizard_WizardPixmap_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QWizard_WizardPixmap_Type);
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
            "WizardPixmap",((PyObject*)&SbkPySide_QtGui_QWizard_WizardPixmap_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardPixmap_Type,
        (long) QWizard::WatermarkPixmap, "WatermarkPixmap");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "WatermarkPixmap", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardPixmap_Type.tp_dict,
        "WatermarkPixmap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardPixmap_Type,
        (long) QWizard::LogoPixmap, "LogoPixmap");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "LogoPixmap", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardPixmap_Type.tp_dict,
        "LogoPixmap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardPixmap_Type,
        (long) QWizard::BannerPixmap, "BannerPixmap");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "BannerPixmap", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardPixmap_Type.tp_dict,
        "BannerPixmap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardPixmap_Type,
        (long) QWizard::BackgroundPixmap, "BackgroundPixmap");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "BackgroundPixmap", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardPixmap_Type.tp_dict,
        "BackgroundPixmap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardPixmap_Type,
        (long) QWizard::NPixmaps, "NPixmaps");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "NPixmaps", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardPixmap_Type.tp_dict,
        "NPixmaps", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWizard::WizardPixmap");

    // init enum class: WizardOption
    SbkPySide_QtGuiTypes[SBK_QWIZARD_WIZARDOPTION_IDX] = &SbkPySide_QtGui_QWizard_WizardOption_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QWizard_WizardOption_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QWizard_WizardOption_Type);
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
            "WizardOption",((PyObject*)&SbkPySide_QtGui_QWizard_WizardOption_Type));

    // init flags class: QFlags<QWizard::WizardOption>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QWIZARD_WIZARDOPTION__IDX] = &SbkPySide_QtGui_QWizard_WizardOptions_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QWizard_WizardOptions_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QWizard_WizardOptions_Type);
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
            "WizardOptions",((PyObject*)&SbkPySide_QtGui_QWizard_WizardOptions_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardOption_Type,
        (long) QWizard::IndependentPages, "IndependentPages");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "IndependentPages", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardOption_Type.tp_dict,
        "IndependentPages", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardOption_Type,
        (long) QWizard::IgnoreSubTitles, "IgnoreSubTitles");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "IgnoreSubTitles", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardOption_Type.tp_dict,
        "IgnoreSubTitles", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardOption_Type,
        (long) QWizard::ExtendedWatermarkPixmap, "ExtendedWatermarkPixmap");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "ExtendedWatermarkPixmap", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardOption_Type.tp_dict,
        "ExtendedWatermarkPixmap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardOption_Type,
        (long) QWizard::NoDefaultButton, "NoDefaultButton");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "NoDefaultButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardOption_Type.tp_dict,
        "NoDefaultButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardOption_Type,
        (long) QWizard::NoBackButtonOnStartPage, "NoBackButtonOnStartPage");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "NoBackButtonOnStartPage", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardOption_Type.tp_dict,
        "NoBackButtonOnStartPage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardOption_Type,
        (long) QWizard::NoBackButtonOnLastPage, "NoBackButtonOnLastPage");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "NoBackButtonOnLastPage", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardOption_Type.tp_dict,
        "NoBackButtonOnLastPage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardOption_Type,
        (long) QWizard::DisabledBackButtonOnLastPage, "DisabledBackButtonOnLastPage");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "DisabledBackButtonOnLastPage", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardOption_Type.tp_dict,
        "DisabledBackButtonOnLastPage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardOption_Type,
        (long) QWizard::HaveNextButtonOnLastPage, "HaveNextButtonOnLastPage");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "HaveNextButtonOnLastPage", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardOption_Type.tp_dict,
        "HaveNextButtonOnLastPage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardOption_Type,
        (long) QWizard::HaveFinishButtonOnEarlyPages, "HaveFinishButtonOnEarlyPages");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "HaveFinishButtonOnEarlyPages", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardOption_Type.tp_dict,
        "HaveFinishButtonOnEarlyPages", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardOption_Type,
        (long) QWizard::NoCancelButton, "NoCancelButton");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "NoCancelButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardOption_Type.tp_dict,
        "NoCancelButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardOption_Type,
        (long) QWizard::CancelButtonOnLeft, "CancelButtonOnLeft");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "CancelButtonOnLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardOption_Type.tp_dict,
        "CancelButtonOnLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardOption_Type,
        (long) QWizard::HaveHelpButton, "HaveHelpButton");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "HaveHelpButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardOption_Type.tp_dict,
        "HaveHelpButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardOption_Type,
        (long) QWizard::HelpButtonOnRight, "HelpButtonOnRight");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "HelpButtonOnRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardOption_Type.tp_dict,
        "HelpButtonOnRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardOption_Type,
        (long) QWizard::HaveCustomButton1, "HaveCustomButton1");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "HaveCustomButton1", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardOption_Type.tp_dict,
        "HaveCustomButton1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardOption_Type,
        (long) QWizard::HaveCustomButton2, "HaveCustomButton2");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "HaveCustomButton2", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardOption_Type.tp_dict,
        "HaveCustomButton2", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QWizard_WizardOption_Type,
        (long) QWizard::HaveCustomButton3, "HaveCustomButton3");
    PyDict_SetItemString(SbkQWizard_Type.super.ht_type.tp_dict,
        "HaveCustomButton3", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QWizard_WizardOption_Type.tp_dict,
        "HaveCustomButton3", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QWizard::WizardOption");

    Shiboken::TypeResolver::createObjectTypeResolver<QWizard >("QWizard*");
    Shiboken::TypeResolver::createObjectTypeResolver<QWizard >(typeid(QWizard).name());
}


} // extern "C"

