/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtreewidgetitemiterator_wrapper.h"

// Extra includes
#include <qtreewidget.h>
#include <qtreewidgetitemiterator.h>

using namespace Shiboken;

static int
SbkQTreeWidgetItemIterator_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTreeWidgetItemIterator* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QTreeWidgetItemIterator", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QTreeWidgetItemIterator & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTreeWidgetItemIterator* cpp_arg0 = Shiboken::Converter<QTreeWidgetItemIterator* >::toCpp(pyargs[0]);
        // QTreeWidgetItemIterator(QTreeWidgetItemIterator)
        cptr = new QTreeWidgetItemIterator(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QTreeWidgetItem * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTreeWidgetItem* cpp_arg0 = Shiboken::Converter<QTreeWidgetItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QTreeWidgetItemIterator(QTreeWidgetItem*,QFlags<QTreeWidgetItemIterator::IteratorFlag>)
            cptr = new QTreeWidgetItemIterator(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Check(pyargs[1])) {
            QFlags<QTreeWidgetItemIterator::IteratorFlag> cpp_arg1 = Shiboken::Converter<QFlags<QTreeWidgetItemIterator::IteratorFlag> >::toCpp(pyargs[1]);
            // QTreeWidgetItemIterator(QTreeWidgetItem*,QFlags<QTreeWidgetItemIterator::IteratorFlag>)
            cptr = new QTreeWidgetItemIterator(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQTreeWidgetItemIterator_Init_TypeError;
    } else if (Shiboken::Converter<QTreeWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTreeWidget* cpp_arg0 = Shiboken::Converter<QTreeWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QTreeWidgetItemIterator(QTreeWidget*,QFlags<QTreeWidgetItemIterator::IteratorFlag>)
            cptr = new QTreeWidgetItemIterator(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Check(pyargs[1])) {
            QFlags<QTreeWidgetItemIterator::IteratorFlag> cpp_arg1 = Shiboken::Converter<QFlags<QTreeWidgetItemIterator::IteratorFlag> >::toCpp(pyargs[1]);
            // QTreeWidgetItemIterator(QTreeWidget*,QFlags<QTreeWidgetItemIterator::IteratorFlag>)
            cptr = new QTreeWidgetItemIterator(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQTreeWidgetItemIterator_Init_TypeError;
    } else goto SbkQTreeWidgetItemIterator_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTreeWidgetItemIterator >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTreeWidgetItemIterator_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTreeWidgetItemIterator_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTreeWidget, PySide.QtGui.QTreeWidgetItemIterator.IteratorFlags = QTreeWidgetItemIterator.All", "PySide.QtGui.QTreeWidgetItem, PySide.QtGui.QTreeWidgetItemIterator.IteratorFlags = QTreeWidgetItemIterator.All", "PySide.QtGui.QTreeWidgetItemIterator", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeWidgetItemIterator", overloads);
        return -1;
}

static PyMethodDef SbkQTreeWidgetItemIterator_methods[] = {
    {0} // Sentinel
};

// type has number operators
static PyNumberMethods SbkQTreeWidgetItemIterator_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTreeWidgetItemIterator_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTreeWidgetItemIterator",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQTreeWidgetItemIterator_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTreeWidgetItemIterator_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTreeWidgetItemIterator_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTreeWidgetItemIterator >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

PyObject*
SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTreeWidgetItemIterator::IteratorFlags >::toPython(
        ((QTreeWidgetItemIterator::IteratorFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QTreeWidgetItemIterator::IteratorFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTreeWidgetItemIterator::IteratorFlags >::toPython(
        ((QTreeWidgetItemIterator::IteratorFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QTreeWidgetItemIterator::IteratorFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTreeWidgetItemIterator::IteratorFlags >::toPython(
        ((QTreeWidgetItemIterator::IteratorFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QTreeWidgetItemIterator::IteratorFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTreeWidgetItemIterator::IteratorFlags >::toPython(
        ~ Shiboken::Converter< QTreeWidgetItemIterator::IteratorFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "IteratorFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "IteratorFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QTreeWidgetItemIterator(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTREEWIDGETITEMITERATOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTreeWidgetItemIterator_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTreeWidgetItemIterator_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTreeWidgetItemIterator_Type));
    PyModule_AddObject(module, "QTreeWidgetItemIterator",
        ((PyObject*)&SbkQTreeWidgetItemIterator_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: IteratorFlag
    SbkPySide_QtGuiTypes[SBK_QTREEWIDGETITEMITERATOR_ITERATORFLAG_IDX] = &SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type);
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
            "IteratorFlag",((PyObject*)&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type));

    // init flags class: QFlags<QTreeWidgetItemIterator::IteratorFlag>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QTREEWIDGETITEMITERATOR_ITERATORFLAG__IDX] = &SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlags_Type);
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
            "IteratorFlags",((PyObject*)&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::All, "All");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "All", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "All", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::Hidden, "Hidden");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "Hidden", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "Hidden", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::NotHidden, "NotHidden");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "NotHidden", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "NotHidden", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::Selected, "Selected");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "Selected", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "Selected", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::Unselected, "Unselected");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "Unselected", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "Unselected", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::Selectable, "Selectable");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "Selectable", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "Selectable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::NotSelectable, "NotSelectable");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "NotSelectable", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "NotSelectable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::DragEnabled, "DragEnabled");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "DragEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "DragEnabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::DragDisabled, "DragDisabled");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "DragDisabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "DragDisabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::DropEnabled, "DropEnabled");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "DropEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "DropEnabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::DropDisabled, "DropDisabled");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "DropDisabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "DropDisabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::HasChildren, "HasChildren");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "HasChildren", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "HasChildren", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::NoChildren, "NoChildren");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "NoChildren", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "NoChildren", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::Checked, "Checked");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "Checked", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "Checked", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::NotChecked, "NotChecked");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "NotChecked", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "NotChecked", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::Enabled, "Enabled");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "Enabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "Enabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::Disabled, "Disabled");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "Disabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "Disabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::Editable, "Editable");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "Editable", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "Editable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::NotEditable, "NotEditable");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "NotEditable", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "NotEditable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type,
        (long) QTreeWidgetItemIterator::UserFlag, "UserFlag");
    PyDict_SetItemString(SbkQTreeWidgetItemIterator_Type.super.ht_type.tp_dict,
        "UserFlag", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTreeWidgetItemIterator_IteratorFlag_Type.tp_dict,
        "UserFlag", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTreeWidgetItemIterator::IteratorFlag");

    Shiboken::TypeResolver::createValueTypeResolver<QTreeWidgetItemIterator >("QTreeWidgetItemIterator");
    Shiboken::TypeResolver::createValueTypeResolver<QTreeWidgetItemIterator >(typeid(QTreeWidgetItemIterator).name());
}


} // extern "C"

