/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtexttablecell_wrapper.h"

// Extra includes
#include <QTextCursor>
#include <QTextFrame>
#include <qtextcursor.h>
#include <qtextformat.h>
#include <qtexttable.h>

using namespace Shiboken;

static int
SbkQTextTableCell_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextTableCell* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTextTableCell", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTextTableCell()
        cptr = new QTextTableCell();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextTableCell & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextTableCell* cpp_arg0 = Shiboken::Converter<QTextTableCell* >::toCpp(pyargs[0]);
        // QTextTableCell(QTextTableCell)
        cptr = new QTextTableCell(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableCell_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTextTableCell >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextTableCell_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTextTableCell_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QTextTableCell", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextTableCell", overloads);
        return -1;
}

static PyObject* SbkQTextTableCellFunc_begin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // begin()const
    QTextTableCell* cppSelf = Shiboken::Converter<QTextTableCell* >::toCpp((PyObject*)self);
    QTextFrame::iterator cpp_result = cppSelf->QTextTableCell::begin();
    py_result = Shiboken::Converter<QTextFrame::iterator >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableCellFunc_column(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // column()const
    QTextTableCell* cppSelf = Shiboken::Converter<QTextTableCell* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextTableCell::column();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableCellFunc_columnSpan(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // columnSpan()const
    QTextTableCell* cppSelf = Shiboken::Converter<QTextTableCell* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextTableCell::columnSpan();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableCellFunc_end(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // end()const
    QTextTableCell* cppSelf = Shiboken::Converter<QTextTableCell* >::toCpp((PyObject*)self);
    QTextFrame::iterator cpp_result = cppSelf->QTextTableCell::end();
    py_result = Shiboken::Converter<QTextFrame::iterator >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableCellFunc_firstCursorPosition(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // firstCursorPosition()const
    QTextTableCell* cppSelf = Shiboken::Converter<QTextTableCell* >::toCpp((PyObject*)self);
    QTextCursor cpp_result = cppSelf->QTextTableCell::firstCursorPosition();
    py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableCellFunc_firstPosition(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // firstPosition()const
    QTextTableCell* cppSelf = Shiboken::Converter<QTextTableCell* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextTableCell::firstPosition();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableCellFunc_format(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // format()const
    QTextTableCell* cppSelf = Shiboken::Converter<QTextTableCell* >::toCpp((PyObject*)self);
    QTextCharFormat cpp_result = cppSelf->QTextTableCell::format();
    py_result = Shiboken::Converter<QTextCharFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableCellFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QTextTableCell* cppSelf = Shiboken::Converter<QTextTableCell* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextTableCell::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableCellFunc_lastCursorPosition(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastCursorPosition()const
    QTextTableCell* cppSelf = Shiboken::Converter<QTextTableCell* >::toCpp((PyObject*)self);
    QTextCursor cpp_result = cppSelf->QTextTableCell::lastCursorPosition();
    py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableCellFunc_lastPosition(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastPosition()const
    QTextTableCell* cppSelf = Shiboken::Converter<QTextTableCell* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextTableCell::lastPosition();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableCellFunc_row(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // row()const
    QTextTableCell* cppSelf = Shiboken::Converter<QTextTableCell* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextTableCell::row();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableCellFunc_rowSpan(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rowSpan()const
    QTextTableCell* cppSelf = Shiboken::Converter<QTextTableCell* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextTableCell::rowSpan();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableCellFunc_setFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextCharFormat & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCharFormat* cpp_arg0 = Shiboken::Converter<QTextCharFormat* >::toCpp(arg);
        // setFormat(QTextCharFormat)
        QTextTableCell* cppSelf = Shiboken::Converter<QTextTableCell* >::toCpp((PyObject*)self);
        cppSelf->QTextTableCell::setFormat(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableCellFunc_setFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableCellFunc_setFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCharFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextTableCell.setFormat", overloads);
        return 0;
}

static PyObject* SbkQTextTableCellFunc_tableCellFormatIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tableCellFormatIndex()const
    QTextTableCell* cppSelf = Shiboken::Converter<QTextTableCell* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextTableCell::tableCellFormatIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQTextTableCell_methods[] = {
    {"begin", (PyCFunction)SbkQTextTableCellFunc_begin, METH_NOARGS},
    {"column", (PyCFunction)SbkQTextTableCellFunc_column, METH_NOARGS},
    {"columnSpan", (PyCFunction)SbkQTextTableCellFunc_columnSpan, METH_NOARGS},
    {"end", (PyCFunction)SbkQTextTableCellFunc_end, METH_NOARGS},
    {"firstCursorPosition", (PyCFunction)SbkQTextTableCellFunc_firstCursorPosition, METH_NOARGS},
    {"firstPosition", (PyCFunction)SbkQTextTableCellFunc_firstPosition, METH_NOARGS},
    {"format", (PyCFunction)SbkQTextTableCellFunc_format, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQTextTableCellFunc_isValid, METH_NOARGS},
    {"lastCursorPosition", (PyCFunction)SbkQTextTableCellFunc_lastCursorPosition, METH_NOARGS},
    {"lastPosition", (PyCFunction)SbkQTextTableCellFunc_lastPosition, METH_NOARGS},
    {"row", (PyCFunction)SbkQTextTableCellFunc_row, METH_NOARGS},
    {"rowSpan", (PyCFunction)SbkQTextTableCellFunc_rowSpan, METH_NOARGS},
    {"setFormat", (PyCFunction)SbkQTextTableCellFunc_setFormat, METH_O},
    {"tableCellFormatIndex", (PyCFunction)SbkQTextTableCellFunc_tableCellFormatIndex, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQTextTableCell_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QTextTableCell& cpp_self = *Shiboken::Converter<QTextTableCell* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QTextTableCell & >::isConvertible(other)) {
                // operator!=(const QTextTableCell & other) const
                QTextTableCell* cpp_other = Shiboken::Converter<QTextTableCell* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QTextTableCell  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQTextTableCell_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QTextTableCell & >::isConvertible(other)) {
                // operator==(const QTextTableCell & other) const
                QTextTableCell* cpp_other = Shiboken::Converter<QTextTableCell* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QTextTableCell  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQTextTableCell_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQTextTableCell_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextTableCell_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextTableCell",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQTextTableCell_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextTableCell_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextTableCell_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTextTableCell >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QTextTableCell(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTTABLECELL_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextTableCell_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTextTableCell_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextTableCell_Type));
    PyModule_AddObject(module, "QTextTableCell",
        ((PyObject*)&SbkQTextTableCell_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QTextTableCell >("QTextTableCell");
    Shiboken::TypeResolver::createValueTypeResolver<QTextTableCell >(typeid(QTextTableCell).name());
}


} // extern "C"

