/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextimageformat_wrapper.h"

// Extra includes
#include <QMap>
#include <QVector>
#include <qbrush.h>
#include <qcolor.h>
#include <qfont.h>
#include <qpen.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qtextformat.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTextImageFormatWrapper::QTextImageFormatWrapper() : QTextImageFormat() {
    // ... middle
}

QTextImageFormatWrapper::QTextImageFormatWrapper(const QTextFormat & format) : QTextImageFormat(format) {
    // ... middle
}

QTextImageFormatWrapper::~QTextImageFormatWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQTextImageFormat_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextImageFormatWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTextImageFormat", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTextImageFormat()
        cptr = new QTextImageFormatWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextFormat* cpp_arg0 = Shiboken::Converter<QTextFormat* >::toCpp(pyargs[0]);
        // QTextImageFormat(QTextFormat)
        cptr = new QTextImageFormatWrapper(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextImageFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextImageFormat* cpp_arg0 = Shiboken::Converter<QTextImageFormat* >::toCpp(pyargs[0]);
        // QTextImageFormat(QTextImageFormat)
        cptr = new QTextImageFormatWrapper(*reinterpret_cast<QTextImageFormatWrapper*>(cpp_arg0));
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextImageFormat_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTextImageFormat >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextImageFormat_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTextImageFormat_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextImageFormat", "", "PySide.QtGui.QTextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextImageFormat", overloads);
        return -1;
}

static PyObject* SbkQTextImageFormatFunc_height(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // height()const
    QTextImageFormat* cppSelf = Shiboken::Converter<QTextImageFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextImageFormat::height();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextImageFormatFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QTextImageFormat* cppSelf = Shiboken::Converter<QTextImageFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextImageFormat::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextImageFormatFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QTextImageFormat* cppSelf = Shiboken::Converter<QTextImageFormat* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextImageFormat::name();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextImageFormatFunc_setHeight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setHeight(qreal)
        QTextImageFormat* cppSelf = Shiboken::Converter<QTextImageFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextImageFormat::setHeight(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextImageFormatFunc_setHeight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextImageFormatFunc_setHeight_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextImageFormat.setHeight", overloads);
        return 0;
}

static PyObject* SbkQTextImageFormatFunc_setName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setName(QString)
        QTextImageFormat* cppSelf = Shiboken::Converter<QTextImageFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextImageFormat::setName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextImageFormatFunc_setName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextImageFormatFunc_setName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextImageFormat.setName", overloads);
        return 0;
}

static PyObject* SbkQTextImageFormatFunc_setWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setWidth(qreal)
        QTextImageFormat* cppSelf = Shiboken::Converter<QTextImageFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextImageFormat::setWidth(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextImageFormatFunc_setWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextImageFormatFunc_setWidth_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextImageFormat.setWidth", overloads);
        return 0;
}

static PyObject* SbkQTextImageFormatFunc_width(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // width()const
    QTextImageFormat* cppSelf = Shiboken::Converter<QTextImageFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextImageFormat::width();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQTextImageFormat_methods[] = {
    {"height", (PyCFunction)SbkQTextImageFormatFunc_height, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQTextImageFormatFunc_isValid, METH_NOARGS},
    {"name", (PyCFunction)SbkQTextImageFormatFunc_name, METH_NOARGS},
    {"setHeight", (PyCFunction)SbkQTextImageFormatFunc_setHeight, METH_O},
    {"setName", (PyCFunction)SbkQTextImageFormatFunc_setName, METH_O},
    {"setWidth", (PyCFunction)SbkQTextImageFormatFunc_setWidth, METH_O},
    {"width", (PyCFunction)SbkQTextImageFormatFunc_width, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQTextImageFormat_ObjCopierFunc(const void* ptr){
    return new QTextImageFormatWrapper(*reinterpret_cast<const QTextImageFormat*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextImageFormat_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextImageFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextImageFormat_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextImageFormat_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQTextImageFormat_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTextImageFormat >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QTextImageFormat(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTIMAGEFORMAT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextImageFormat_Type);

    SbkQTextImageFormat_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX];
    // Fill type discovery information
    SbkQTextImageFormat_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTextImageFormat_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextImageFormat_Type));
    PyModule_AddObject(module, "QTextImageFormat",
        ((PyObject*)&SbkQTextImageFormat_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QTextImageFormat >("QTextImageFormat");
    Shiboken::TypeResolver::createValueTypeResolver<QTextImageFormat >(typeid(QTextImageFormat).name());
}


} // extern "C"

