/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextframeformat_wrapper.h"

// Extra includes
#include <QMap>
#include <QVector>
#include <qbrush.h>
#include <qcolor.h>
#include <qpen.h>
#include <qstring.h>
#include <qtextformat.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTextFrameFormatWrapper::QTextFrameFormatWrapper() : QTextFrameFormat() {
    // ... middle
}

QTextFrameFormatWrapper::QTextFrameFormatWrapper(const QTextFormat & fmt) : QTextFrameFormat(fmt) {
    // ... middle
}

QTextFrameFormatWrapper::~QTextFrameFormatWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQTextFrameFormat_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextFrameFormatWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTextFrameFormat", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTextFrameFormat()
        cptr = new QTextFrameFormatWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextFormat* cpp_arg0 = Shiboken::Converter<QTextFormat* >::toCpp(pyargs[0]);
        // QTextFrameFormat(QTextFormat)
        cptr = new QTextFrameFormatWrapper(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextFrameFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextFrameFormat* cpp_arg0 = Shiboken::Converter<QTextFrameFormat* >::toCpp(pyargs[0]);
        // QTextFrameFormat(QTextFrameFormat)
        cptr = new QTextFrameFormatWrapper(*reinterpret_cast<QTextFrameFormatWrapper*>(cpp_arg0));
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFrameFormat_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTextFrameFormat >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextFrameFormat_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTextFrameFormat_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextFrameFormat", "", "PySide.QtGui.QTextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextFrameFormat", overloads);
        return -1;
}

static PyObject* SbkQTextFrameFormatFunc_border(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // border()const
    QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextFrameFormat::border();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFrameFormatFunc_borderBrush(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // borderBrush()const
    QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
    QBrush cpp_result = cppSelf->QTextFrameFormat::borderBrush();
    py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFrameFormatFunc_borderStyle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // borderStyle()const
    QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
    QTextFrameFormat::BorderStyle cpp_result = cppSelf->QTextFrameFormat::borderStyle();
    py_result = Shiboken::Converter<QTextFrameFormat::BorderStyle >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFrameFormatFunc_bottomMargin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bottomMargin()const
    QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextFrameFormat::bottomMargin();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFrameFormatFunc_height(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // height()const
    QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
    QTextLength cpp_result = cppSelf->QTextFrameFormat::height();
    py_result = Shiboken::Converter<QTextLength >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFrameFormatFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextFrameFormat::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFrameFormatFunc_leftMargin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // leftMargin()const
    QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextFrameFormat::leftMargin();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFrameFormatFunc_margin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // margin()const
    QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextFrameFormat::margin();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFrameFormatFunc_padding(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // padding()const
    QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextFrameFormat::padding();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFrameFormatFunc_pageBreakPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pageBreakPolicy()const
    QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
    QFlags<QTextFormat::PageBreakFlag> cpp_result = cppSelf->QTextFrameFormat::pageBreakPolicy();
    py_result = Shiboken::Converter<QFlags<QTextFormat::PageBreakFlag> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFrameFormatFunc_position(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // position()const
    QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
    QTextFrameFormat::Position cpp_result = cppSelf->QTextFrameFormat::position();
    py_result = Shiboken::Converter<QTextFrameFormat::Position >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFrameFormatFunc_rightMargin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rightMargin()const
    QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextFrameFormat::rightMargin();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFrameFormatFunc_setBorder(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setBorder(qreal)
        QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFrameFormat::setBorder(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFrameFormatFunc_setBorder_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFrameFormatFunc_setBorder_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFrameFormat.setBorder", overloads);
        return 0;
}

static PyObject* SbkQTextFrameFormatFunc_setBorderBrush(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBrush & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(arg);
        if (!SbkQBrush_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // setBorderBrush(QBrush)
        QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFrameFormat::setBorderBrush(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFrameFormatFunc_setBorderBrush_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFrameFormatFunc_setBorderBrush_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFrameFormat.setBorderBrush", overloads);
        return 0;
}

static PyObject* SbkQTextFrameFormatFunc_setBorderStyle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextFrameFormat::BorderStyle >::isConvertible(arg)) {
        QTextFrameFormat::BorderStyle cpp_arg0 = Shiboken::Converter<QTextFrameFormat::BorderStyle >::toCpp(arg);
        // setBorderStyle(QTextFrameFormat::BorderStyle)
        QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFrameFormat::setBorderStyle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFrameFormatFunc_setBorderStyle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFrameFormatFunc_setBorderStyle_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextFrameFormat.BorderStyle", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFrameFormat.setBorderStyle", overloads);
        return 0;
}

static PyObject* SbkQTextFrameFormatFunc_setBottomMargin(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setBottomMargin(qreal)
        QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFrameFormat::setBottomMargin(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFrameFormatFunc_setBottomMargin_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFrameFormatFunc_setBottomMargin_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFrameFormat.setBottomMargin", overloads);
        return 0;
}

static PyObject* SbkQTextFrameFormatFunc_setHeight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setHeight(qreal)
        QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFrameFormat::setHeight(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QTextLength & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextLength* cpp_arg0 = Shiboken::Converter<QTextLength* >::toCpp(arg);
        // setHeight(QTextLength)
        QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFrameFormat::setHeight(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFrameFormatFunc_setHeight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFrameFormatFunc_setHeight_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextLength", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFrameFormat.setHeight", overloads);
        return 0;
}

static PyObject* SbkQTextFrameFormatFunc_setLeftMargin(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setLeftMargin(qreal)
        QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFrameFormat::setLeftMargin(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFrameFormatFunc_setLeftMargin_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFrameFormatFunc_setLeftMargin_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFrameFormat.setLeftMargin", overloads);
        return 0;
}

static PyObject* SbkQTextFrameFormatFunc_setMargin(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setMargin(qreal)
        QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFrameFormat::setMargin(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFrameFormatFunc_setMargin_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFrameFormatFunc_setMargin_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFrameFormat.setMargin", overloads);
        return 0;
}

static PyObject* SbkQTextFrameFormatFunc_setPadding(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setPadding(qreal)
        QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFrameFormat::setPadding(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFrameFormatFunc_setPadding_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFrameFormatFunc_setPadding_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFrameFormat.setPadding", overloads);
        return 0;
}

static PyObject* SbkQTextFrameFormatFunc_setPageBreakPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QTextFormat_PageBreakFlag_Check(arg)) {
        QFlags<QTextFormat::PageBreakFlag> cpp_arg0 = Shiboken::Converter<QFlags<QTextFormat::PageBreakFlag> >::toCpp(arg);
        // setPageBreakPolicy(QFlags<QTextFormat::PageBreakFlag>)
        QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFrameFormat::setPageBreakPolicy(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFrameFormatFunc_setPageBreakPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFrameFormatFunc_setPageBreakPolicy_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextFormat.PageBreakFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFrameFormat.setPageBreakPolicy", overloads);
        return 0;
}

static PyObject* SbkQTextFrameFormatFunc_setPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextFrameFormat::Position >::isConvertible(arg)) {
        QTextFrameFormat::Position cpp_arg0 = Shiboken::Converter<QTextFrameFormat::Position >::toCpp(arg);
        // setPosition(QTextFrameFormat::Position)
        QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFrameFormat::setPosition(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFrameFormatFunc_setPosition_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFrameFormatFunc_setPosition_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextFrameFormat.Position", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFrameFormat.setPosition", overloads);
        return 0;
}

static PyObject* SbkQTextFrameFormatFunc_setRightMargin(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setRightMargin(qreal)
        QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFrameFormat::setRightMargin(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFrameFormatFunc_setRightMargin_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFrameFormatFunc_setRightMargin_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFrameFormat.setRightMargin", overloads);
        return 0;
}

static PyObject* SbkQTextFrameFormatFunc_setTopMargin(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setTopMargin(qreal)
        QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFrameFormat::setTopMargin(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFrameFormatFunc_setTopMargin_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFrameFormatFunc_setTopMargin_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFrameFormat.setTopMargin", overloads);
        return 0;
}

static PyObject* SbkQTextFrameFormatFunc_setWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setWidth(qreal)
        QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFrameFormat::setWidth(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QTextLength & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextLength* cpp_arg0 = Shiboken::Converter<QTextLength* >::toCpp(arg);
        // setWidth(QTextLength)
        QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFrameFormat::setWidth(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFrameFormatFunc_setWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFrameFormatFunc_setWidth_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextLength", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFrameFormat.setWidth", overloads);
        return 0;
}

static PyObject* SbkQTextFrameFormatFunc_topMargin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // topMargin()const
    QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextFrameFormat::topMargin();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFrameFormatFunc_width(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // width()const
    QTextFrameFormat* cppSelf = Shiboken::Converter<QTextFrameFormat* >::toCpp((PyObject*)self);
    QTextLength cpp_result = cppSelf->QTextFrameFormat::width();
    py_result = Shiboken::Converter<QTextLength >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQTextFrameFormat_methods[] = {
    {"border", (PyCFunction)SbkQTextFrameFormatFunc_border, METH_NOARGS},
    {"borderBrush", (PyCFunction)SbkQTextFrameFormatFunc_borderBrush, METH_NOARGS},
    {"borderStyle", (PyCFunction)SbkQTextFrameFormatFunc_borderStyle, METH_NOARGS},
    {"bottomMargin", (PyCFunction)SbkQTextFrameFormatFunc_bottomMargin, METH_NOARGS},
    {"height", (PyCFunction)SbkQTextFrameFormatFunc_height, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQTextFrameFormatFunc_isValid, METH_NOARGS},
    {"leftMargin", (PyCFunction)SbkQTextFrameFormatFunc_leftMargin, METH_NOARGS},
    {"margin", (PyCFunction)SbkQTextFrameFormatFunc_margin, METH_NOARGS},
    {"padding", (PyCFunction)SbkQTextFrameFormatFunc_padding, METH_NOARGS},
    {"pageBreakPolicy", (PyCFunction)SbkQTextFrameFormatFunc_pageBreakPolicy, METH_NOARGS},
    {"position", (PyCFunction)SbkQTextFrameFormatFunc_position, METH_NOARGS},
    {"rightMargin", (PyCFunction)SbkQTextFrameFormatFunc_rightMargin, METH_NOARGS},
    {"setBorder", (PyCFunction)SbkQTextFrameFormatFunc_setBorder, METH_O},
    {"setBorderBrush", (PyCFunction)SbkQTextFrameFormatFunc_setBorderBrush, METH_O},
    {"setBorderStyle", (PyCFunction)SbkQTextFrameFormatFunc_setBorderStyle, METH_O},
    {"setBottomMargin", (PyCFunction)SbkQTextFrameFormatFunc_setBottomMargin, METH_O},
    {"setHeight", (PyCFunction)SbkQTextFrameFormatFunc_setHeight, METH_O},
    {"setLeftMargin", (PyCFunction)SbkQTextFrameFormatFunc_setLeftMargin, METH_O},
    {"setMargin", (PyCFunction)SbkQTextFrameFormatFunc_setMargin, METH_O},
    {"setPadding", (PyCFunction)SbkQTextFrameFormatFunc_setPadding, METH_O},
    {"setPageBreakPolicy", (PyCFunction)SbkQTextFrameFormatFunc_setPageBreakPolicy, METH_O},
    {"setPosition", (PyCFunction)SbkQTextFrameFormatFunc_setPosition, METH_O},
    {"setRightMargin", (PyCFunction)SbkQTextFrameFormatFunc_setRightMargin, METH_O},
    {"setTopMargin", (PyCFunction)SbkQTextFrameFormatFunc_setTopMargin, METH_O},
    {"setWidth", (PyCFunction)SbkQTextFrameFormatFunc_setWidth, METH_O},
    {"topMargin", (PyCFunction)SbkQTextFrameFormatFunc_topMargin, METH_NOARGS},
    {"width", (PyCFunction)SbkQTextFrameFormatFunc_width, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQTextFrameFormat_ObjCopierFunc(const void* ptr){
    return new QTextFrameFormatWrapper(*reinterpret_cast<const QTextFrameFormat*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextFrameFormat_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextFrameFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextFrameFormat_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextFrameFormat_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQTextFrameFormat_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTextFrameFormat >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QTextFrameFormat_Position_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextFrameFormat_Position_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextFrameFormat_Position_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Position",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextFrameFormat_Position_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextFrameFormat_Position_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextFrameFormat_Position_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QTextFrameFormat_BorderStyle_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextFrameFormat_BorderStyle_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "BorderStyle",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextFrameFormat_BorderStyle_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextFrameFormat_BorderStyle_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextFrameFormat_BorderStyle_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QTextFrameFormat(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextFrameFormat_Type);

    SbkQTextFrameFormat_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_IDX];
    // Fill type discovery information
    SbkQTextFrameFormat_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTextFrameFormat_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextFrameFormat_Type));
    PyModule_AddObject(module, "QTextFrameFormat",
        ((PyObject*)&SbkQTextFrameFormat_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Position
    SbkPySide_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_POSITION_IDX] = &SbkPySide_QtGui_QTextFrameFormat_Position_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextFrameFormat_Position_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextFrameFormat_Position_Type);
    PyDict_SetItemString(SbkQTextFrameFormat_Type.super.ht_type.tp_dict,
            "Position",((PyObject*)&SbkPySide_QtGui_QTextFrameFormat_Position_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFrameFormat_Position_Type,
        (long) QTextFrameFormat::InFlow, "InFlow");
    PyDict_SetItemString(SbkQTextFrameFormat_Type.super.ht_type.tp_dict,
        "InFlow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFrameFormat_Position_Type.tp_dict,
        "InFlow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFrameFormat_Position_Type,
        (long) QTextFrameFormat::FloatLeft, "FloatLeft");
    PyDict_SetItemString(SbkQTextFrameFormat_Type.super.ht_type.tp_dict,
        "FloatLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFrameFormat_Position_Type.tp_dict,
        "FloatLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFrameFormat_Position_Type,
        (long) QTextFrameFormat::FloatRight, "FloatRight");
    PyDict_SetItemString(SbkQTextFrameFormat_Type.super.ht_type.tp_dict,
        "FloatRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFrameFormat_Position_Type.tp_dict,
        "FloatRight", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextFrameFormat::Position");

    // init enum class: BorderStyle
    SbkPySide_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX] = &SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type);
    PyDict_SetItemString(SbkQTextFrameFormat_Type.super.ht_type.tp_dict,
            "BorderStyle",((PyObject*)&SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type,
        (long) QTextFrameFormat::BorderStyle_None, "BorderStyle_None");
    PyDict_SetItemString(SbkQTextFrameFormat_Type.super.ht_type.tp_dict,
        "BorderStyle_None", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type.tp_dict,
        "BorderStyle_None", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type,
        (long) QTextFrameFormat::BorderStyle_Dotted, "BorderStyle_Dotted");
    PyDict_SetItemString(SbkQTextFrameFormat_Type.super.ht_type.tp_dict,
        "BorderStyle_Dotted", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type.tp_dict,
        "BorderStyle_Dotted", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type,
        (long) QTextFrameFormat::BorderStyle_Dashed, "BorderStyle_Dashed");
    PyDict_SetItemString(SbkQTextFrameFormat_Type.super.ht_type.tp_dict,
        "BorderStyle_Dashed", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type.tp_dict,
        "BorderStyle_Dashed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type,
        (long) QTextFrameFormat::BorderStyle_Solid, "BorderStyle_Solid");
    PyDict_SetItemString(SbkQTextFrameFormat_Type.super.ht_type.tp_dict,
        "BorderStyle_Solid", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type.tp_dict,
        "BorderStyle_Solid", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type,
        (long) QTextFrameFormat::BorderStyle_Double, "BorderStyle_Double");
    PyDict_SetItemString(SbkQTextFrameFormat_Type.super.ht_type.tp_dict,
        "BorderStyle_Double", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type.tp_dict,
        "BorderStyle_Double", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type,
        (long) QTextFrameFormat::BorderStyle_DotDash, "BorderStyle_DotDash");
    PyDict_SetItemString(SbkQTextFrameFormat_Type.super.ht_type.tp_dict,
        "BorderStyle_DotDash", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type.tp_dict,
        "BorderStyle_DotDash", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type,
        (long) QTextFrameFormat::BorderStyle_DotDotDash, "BorderStyle_DotDotDash");
    PyDict_SetItemString(SbkQTextFrameFormat_Type.super.ht_type.tp_dict,
        "BorderStyle_DotDotDash", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type.tp_dict,
        "BorderStyle_DotDotDash", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type,
        (long) QTextFrameFormat::BorderStyle_Groove, "BorderStyle_Groove");
    PyDict_SetItemString(SbkQTextFrameFormat_Type.super.ht_type.tp_dict,
        "BorderStyle_Groove", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type.tp_dict,
        "BorderStyle_Groove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type,
        (long) QTextFrameFormat::BorderStyle_Ridge, "BorderStyle_Ridge");
    PyDict_SetItemString(SbkQTextFrameFormat_Type.super.ht_type.tp_dict,
        "BorderStyle_Ridge", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type.tp_dict,
        "BorderStyle_Ridge", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type,
        (long) QTextFrameFormat::BorderStyle_Inset, "BorderStyle_Inset");
    PyDict_SetItemString(SbkQTextFrameFormat_Type.super.ht_type.tp_dict,
        "BorderStyle_Inset", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type.tp_dict,
        "BorderStyle_Inset", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type,
        (long) QTextFrameFormat::BorderStyle_Outset, "BorderStyle_Outset");
    PyDict_SetItemString(SbkQTextFrameFormat_Type.super.ht_type.tp_dict,
        "BorderStyle_Outset", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFrameFormat_BorderStyle_Type.tp_dict,
        "BorderStyle_Outset", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextFrameFormat::BorderStyle");

    Shiboken::TypeResolver::createValueTypeResolver<QTextFrameFormat >("QTextFrameFormat");
    Shiboken::TypeResolver::createValueTypeResolver<QTextFrameFormat >(typeid(QTextFrameFormat).name());
}


} // extern "C"

