/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextcharformat_wrapper.h"

// Extra includes
#include <QMap>
#include <QVector>
#include <qbrush.h>
#include <qcolor.h>
#include <qfont.h>
#include <qpen.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qtextformat.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTextCharFormatWrapper::QTextCharFormatWrapper() : QTextCharFormat() {
    // ... middle
}

QTextCharFormatWrapper::QTextCharFormatWrapper(const QTextFormat & fmt) : QTextCharFormat(fmt) {
    // ... middle
}

QTextCharFormatWrapper::~QTextCharFormatWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQTextCharFormat_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextCharFormatWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTextCharFormat", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTextCharFormat()
        cptr = new QTextCharFormatWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextFormat* cpp_arg0 = Shiboken::Converter<QTextFormat* >::toCpp(pyargs[0]);
        // QTextCharFormat(QTextFormat)
        cptr = new QTextCharFormatWrapper(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextCharFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextCharFormat* cpp_arg0 = Shiboken::Converter<QTextCharFormat* >::toCpp(pyargs[0]);
        // QTextCharFormat(QTextCharFormat)
        cptr = new QTextCharFormatWrapper(*reinterpret_cast<QTextCharFormatWrapper*>(cpp_arg0));
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormat_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTextCharFormat >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextCharFormat_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTextCharFormat_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCharFormat", "", "PySide.QtGui.QTextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextCharFormat", overloads);
        return -1;
}

static PyObject* SbkQTextCharFormatFunc_anchorHref(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // anchorHref()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextCharFormat::anchorHref();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_anchorNames(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // anchorNames()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QTextCharFormat::anchorNames();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_font(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // font()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    QFont cpp_result = cppSelf->QTextCharFormat::font();
    py_result = Shiboken::Converter<QFont >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_fontCapitalization(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontCapitalization()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    QFont::Capitalization cpp_result = cppSelf->QTextCharFormat::fontCapitalization();
    py_result = Shiboken::Converter<QFont::Capitalization >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_fontFamily(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontFamily()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextCharFormat::fontFamily();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_fontFixedPitch(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontFixedPitch()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextCharFormat::fontFixedPitch();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_fontItalic(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontItalic()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextCharFormat::fontItalic();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_fontKerning(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontKerning()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextCharFormat::fontKerning();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_fontLetterSpacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontLetterSpacing()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextCharFormat::fontLetterSpacing();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_fontOverline(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontOverline()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextCharFormat::fontOverline();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_fontPointSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontPointSize()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextCharFormat::fontPointSize();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_fontStrikeOut(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontStrikeOut()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextCharFormat::fontStrikeOut();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_fontStyleHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontStyleHint()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    QFont::StyleHint cpp_result = cppSelf->QTextCharFormat::fontStyleHint();
    py_result = Shiboken::Converter<QFont::StyleHint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_fontStyleStrategy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontStyleStrategy()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    QFont::StyleStrategy cpp_result = cppSelf->QTextCharFormat::fontStyleStrategy();
    py_result = Shiboken::Converter<QFont::StyleStrategy >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_fontUnderline(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontUnderline()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextCharFormat::fontUnderline();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_fontWeight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontWeight()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextCharFormat::fontWeight();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_fontWordSpacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fontWordSpacing()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextCharFormat::fontWordSpacing();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_isAnchor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isAnchor()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextCharFormat::isAnchor();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextCharFormat::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_setAnchor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAnchor(bool)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setAnchor(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setAnchor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setAnchor_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setAnchor", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setAnchorHref(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setAnchorHref(QString)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setAnchorHref(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setAnchorHref_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setAnchorHref_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setAnchorHref", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setAnchorNames(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!SbkQStringList_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setAnchorNames(QStringList)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setAnchorNames(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setAnchorNames_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setAnchorNames_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setAnchorNames", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setFont(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(arg);
        if (!SbkQFont_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // setFont(QFont)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setFont(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setFont_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setFont_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setFont", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setFontCapitalization(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont::Capitalization >::isConvertible(arg)) {
        QFont::Capitalization cpp_arg0 = Shiboken::Converter<QFont::Capitalization >::toCpp(arg);
        // setFontCapitalization(QFont::Capitalization)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setFontCapitalization(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setFontCapitalization_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setFontCapitalization_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont.Capitalization", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setFontCapitalization", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setFontFamily(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFontFamily(QString)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setFontFamily(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setFontFamily_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setFontFamily_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setFontFamily", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setFontFixedPitch(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setFontFixedPitch(bool)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setFontFixedPitch(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setFontFixedPitch_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setFontFixedPitch_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setFontFixedPitch", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setFontItalic(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setFontItalic(bool)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setFontItalic(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setFontItalic_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setFontItalic_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setFontItalic", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setFontKerning(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setFontKerning(bool)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setFontKerning(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setFontKerning_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setFontKerning_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setFontKerning", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setFontLetterSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setFontLetterSpacing(qreal)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setFontLetterSpacing(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setFontLetterSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setFontLetterSpacing_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setFontLetterSpacing", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setFontOverline(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setFontOverline(bool)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setFontOverline(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setFontOverline_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setFontOverline_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setFontOverline", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setFontPointSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setFontPointSize(qreal)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setFontPointSize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setFontPointSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setFontPointSize_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setFontPointSize", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setFontStrikeOut(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setFontStrikeOut(bool)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setFontStrikeOut(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setFontStrikeOut_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setFontStrikeOut_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setFontStrikeOut", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setFontStyleHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setFontStyleHint", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QFont::StyleHint >::isConvertible(pyargs[0])) {
        QFont::StyleHint cpp_arg0 = Shiboken::Converter<QFont::StyleHint >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setFontStyleHint(QFont::StyleHint,QFont::StyleStrategy)
            QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
            cppSelf->QTextCharFormat::setFontStyleHint(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QFont::StyleStrategy >::isConvertible(pyargs[1])) {
            QFont::StyleStrategy cpp_arg1 = Shiboken::Converter<QFont::StyleStrategy >::toCpp(pyargs[1]);
            // setFontStyleHint(QFont::StyleHint,QFont::StyleStrategy)
            QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
            cppSelf->QTextCharFormat::setFontStyleHint(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQTextCharFormatFunc_setFontStyleHint_TypeError;
    } else goto SbkQTextCharFormatFunc_setFontStyleHint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setFontStyleHint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont.StyleHint, PySide.QtGui.QFont.StyleStrategy = QFont.PreferDefault", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextCharFormat.setFontStyleHint", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setFontStyleStrategy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont::StyleStrategy >::isConvertible(arg)) {
        QFont::StyleStrategy cpp_arg0 = Shiboken::Converter<QFont::StyleStrategy >::toCpp(arg);
        // setFontStyleStrategy(QFont::StyleStrategy)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setFontStyleStrategy(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setFontStyleStrategy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setFontStyleStrategy_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont.StyleStrategy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setFontStyleStrategy", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setFontUnderline(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setFontUnderline(bool)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setFontUnderline(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setFontUnderline_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setFontUnderline_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setFontUnderline", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setFontWeight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setFontWeight(int)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setFontWeight(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setFontWeight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setFontWeight_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setFontWeight", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setFontWordSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setFontWordSpacing(qreal)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setFontWordSpacing(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setFontWordSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setFontWordSpacing_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setFontWordSpacing", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setTableCellColumnSpan(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setTableCellColumnSpan(int)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setTableCellColumnSpan(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setTableCellColumnSpan_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setTableCellColumnSpan_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setTableCellColumnSpan", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setTableCellRowSpan(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setTableCellRowSpan(int)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setTableCellRowSpan(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setTableCellRowSpan_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setTableCellRowSpan_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setTableCellRowSpan", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setTextOutline(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPen & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPen > cpp_arg0_auto_ptr;
        QPen* cpp_arg0 = Shiboken::Converter<QPen* >::toCpp(arg);
        if (!SbkQPen_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPen >(cpp_arg0);
        // setTextOutline(QPen)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setTextOutline(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setTextOutline_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setTextOutline_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPen", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setTextOutline", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setToolTip(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setToolTip(QString)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setToolTip(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setToolTip_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setToolTip_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setToolTip", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setUnderlineColor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QColor & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(arg);
        if (!SbkQColor_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        // setUnderlineColor(QColor)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setUnderlineColor(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setUnderlineColor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setUnderlineColor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QColor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setUnderlineColor", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setUnderlineStyle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextCharFormat::UnderlineStyle >::isConvertible(arg)) {
        QTextCharFormat::UnderlineStyle cpp_arg0 = Shiboken::Converter<QTextCharFormat::UnderlineStyle >::toCpp(arg);
        // setUnderlineStyle(QTextCharFormat::UnderlineStyle)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setUnderlineStyle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setUnderlineStyle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setUnderlineStyle_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCharFormat.UnderlineStyle", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setUnderlineStyle", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_setVerticalAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextCharFormat::VerticalAlignment >::isConvertible(arg)) {
        QTextCharFormat::VerticalAlignment cpp_arg0 = Shiboken::Converter<QTextCharFormat::VerticalAlignment >::toCpp(arg);
        // setVerticalAlignment(QTextCharFormat::VerticalAlignment)
        QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextCharFormat::setVerticalAlignment(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextCharFormatFunc_setVerticalAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextCharFormatFunc_setVerticalAlignment_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCharFormat.VerticalAlignment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextCharFormat.setVerticalAlignment", overloads);
        return 0;
}

static PyObject* SbkQTextCharFormatFunc_tableCellColumnSpan(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tableCellColumnSpan()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextCharFormat::tableCellColumnSpan();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_tableCellRowSpan(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tableCellRowSpan()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextCharFormat::tableCellRowSpan();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_textOutline(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textOutline()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    QPen cpp_result = cppSelf->QTextCharFormat::textOutline();
    py_result = Shiboken::Converter<QPen >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_toolTip(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toolTip()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextCharFormat::toolTip();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_underlineColor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // underlineColor()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    QColor cpp_result = cppSelf->QTextCharFormat::underlineColor();
    py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_underlineStyle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // underlineStyle()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    QTextCharFormat::UnderlineStyle cpp_result = cppSelf->QTextCharFormat::underlineStyle();
    py_result = Shiboken::Converter<QTextCharFormat::UnderlineStyle >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextCharFormatFunc_verticalAlignment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // verticalAlignment()const
    QTextCharFormat* cppSelf = Shiboken::Converter<QTextCharFormat* >::toCpp((PyObject*)self);
    QTextCharFormat::VerticalAlignment cpp_result = cppSelf->QTextCharFormat::verticalAlignment();
    py_result = Shiboken::Converter<QTextCharFormat::VerticalAlignment >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQTextCharFormat_methods[] = {
    {"anchorHref", (PyCFunction)SbkQTextCharFormatFunc_anchorHref, METH_NOARGS},
    {"anchorNames", (PyCFunction)SbkQTextCharFormatFunc_anchorNames, METH_NOARGS},
    {"font", (PyCFunction)SbkQTextCharFormatFunc_font, METH_NOARGS},
    {"fontCapitalization", (PyCFunction)SbkQTextCharFormatFunc_fontCapitalization, METH_NOARGS},
    {"fontFamily", (PyCFunction)SbkQTextCharFormatFunc_fontFamily, METH_NOARGS},
    {"fontFixedPitch", (PyCFunction)SbkQTextCharFormatFunc_fontFixedPitch, METH_NOARGS},
    {"fontItalic", (PyCFunction)SbkQTextCharFormatFunc_fontItalic, METH_NOARGS},
    {"fontKerning", (PyCFunction)SbkQTextCharFormatFunc_fontKerning, METH_NOARGS},
    {"fontLetterSpacing", (PyCFunction)SbkQTextCharFormatFunc_fontLetterSpacing, METH_NOARGS},
    {"fontOverline", (PyCFunction)SbkQTextCharFormatFunc_fontOverline, METH_NOARGS},
    {"fontPointSize", (PyCFunction)SbkQTextCharFormatFunc_fontPointSize, METH_NOARGS},
    {"fontStrikeOut", (PyCFunction)SbkQTextCharFormatFunc_fontStrikeOut, METH_NOARGS},
    {"fontStyleHint", (PyCFunction)SbkQTextCharFormatFunc_fontStyleHint, METH_NOARGS},
    {"fontStyleStrategy", (PyCFunction)SbkQTextCharFormatFunc_fontStyleStrategy, METH_NOARGS},
    {"fontUnderline", (PyCFunction)SbkQTextCharFormatFunc_fontUnderline, METH_NOARGS},
    {"fontWeight", (PyCFunction)SbkQTextCharFormatFunc_fontWeight, METH_NOARGS},
    {"fontWordSpacing", (PyCFunction)SbkQTextCharFormatFunc_fontWordSpacing, METH_NOARGS},
    {"isAnchor", (PyCFunction)SbkQTextCharFormatFunc_isAnchor, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQTextCharFormatFunc_isValid, METH_NOARGS},
    {"setAnchor", (PyCFunction)SbkQTextCharFormatFunc_setAnchor, METH_O},
    {"setAnchorHref", (PyCFunction)SbkQTextCharFormatFunc_setAnchorHref, METH_O},
    {"setAnchorNames", (PyCFunction)SbkQTextCharFormatFunc_setAnchorNames, METH_O},
    {"setFont", (PyCFunction)SbkQTextCharFormatFunc_setFont, METH_O},
    {"setFontCapitalization", (PyCFunction)SbkQTextCharFormatFunc_setFontCapitalization, METH_O},
    {"setFontFamily", (PyCFunction)SbkQTextCharFormatFunc_setFontFamily, METH_O},
    {"setFontFixedPitch", (PyCFunction)SbkQTextCharFormatFunc_setFontFixedPitch, METH_O},
    {"setFontItalic", (PyCFunction)SbkQTextCharFormatFunc_setFontItalic, METH_O},
    {"setFontKerning", (PyCFunction)SbkQTextCharFormatFunc_setFontKerning, METH_O},
    {"setFontLetterSpacing", (PyCFunction)SbkQTextCharFormatFunc_setFontLetterSpacing, METH_O},
    {"setFontOverline", (PyCFunction)SbkQTextCharFormatFunc_setFontOverline, METH_O},
    {"setFontPointSize", (PyCFunction)SbkQTextCharFormatFunc_setFontPointSize, METH_O},
    {"setFontStrikeOut", (PyCFunction)SbkQTextCharFormatFunc_setFontStrikeOut, METH_O},
    {"setFontStyleHint", (PyCFunction)SbkQTextCharFormatFunc_setFontStyleHint, METH_VARARGS},
    {"setFontStyleStrategy", (PyCFunction)SbkQTextCharFormatFunc_setFontStyleStrategy, METH_O},
    {"setFontUnderline", (PyCFunction)SbkQTextCharFormatFunc_setFontUnderline, METH_O},
    {"setFontWeight", (PyCFunction)SbkQTextCharFormatFunc_setFontWeight, METH_O},
    {"setFontWordSpacing", (PyCFunction)SbkQTextCharFormatFunc_setFontWordSpacing, METH_O},
    {"setTableCellColumnSpan", (PyCFunction)SbkQTextCharFormatFunc_setTableCellColumnSpan, METH_O},
    {"setTableCellRowSpan", (PyCFunction)SbkQTextCharFormatFunc_setTableCellRowSpan, METH_O},
    {"setTextOutline", (PyCFunction)SbkQTextCharFormatFunc_setTextOutline, METH_O},
    {"setToolTip", (PyCFunction)SbkQTextCharFormatFunc_setToolTip, METH_O},
    {"setUnderlineColor", (PyCFunction)SbkQTextCharFormatFunc_setUnderlineColor, METH_O},
    {"setUnderlineStyle", (PyCFunction)SbkQTextCharFormatFunc_setUnderlineStyle, METH_O},
    {"setVerticalAlignment", (PyCFunction)SbkQTextCharFormatFunc_setVerticalAlignment, METH_O},
    {"tableCellColumnSpan", (PyCFunction)SbkQTextCharFormatFunc_tableCellColumnSpan, METH_NOARGS},
    {"tableCellRowSpan", (PyCFunction)SbkQTextCharFormatFunc_tableCellRowSpan, METH_NOARGS},
    {"textOutline", (PyCFunction)SbkQTextCharFormatFunc_textOutline, METH_NOARGS},
    {"toolTip", (PyCFunction)SbkQTextCharFormatFunc_toolTip, METH_NOARGS},
    {"underlineColor", (PyCFunction)SbkQTextCharFormatFunc_underlineColor, METH_NOARGS},
    {"underlineStyle", (PyCFunction)SbkQTextCharFormatFunc_underlineStyle, METH_NOARGS},
    {"verticalAlignment", (PyCFunction)SbkQTextCharFormatFunc_verticalAlignment, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQTextCharFormat_ObjCopierFunc(const void* ptr){
    return new QTextCharFormatWrapper(*reinterpret_cast<const QTextCharFormat*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextCharFormat_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextCharFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextCharFormat_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextCharFormat_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQTextCharFormat_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTextCharFormat >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "VerticalAlignment",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "UnderlineStyle",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QTextCharFormat(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextCharFormat_Type);

    SbkQTextCharFormat_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_IDX];
    // Fill type discovery information
    SbkQTextCharFormat_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTextCharFormat_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextCharFormat_Type));
    PyModule_AddObject(module, "QTextCharFormat",
        ((PyObject*)&SbkQTextCharFormat_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: VerticalAlignment
    SbkPySide_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX] = &SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Type);
    PyDict_SetItemString(SbkQTextCharFormat_Type.super.ht_type.tp_dict,
            "VerticalAlignment",((PyObject*)&SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Type,
        (long) QTextCharFormat::AlignNormal, "AlignNormal");
    PyDict_SetItemString(SbkQTextCharFormat_Type.super.ht_type.tp_dict,
        "AlignNormal", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Type.tp_dict,
        "AlignNormal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Type,
        (long) QTextCharFormat::AlignSuperScript, "AlignSuperScript");
    PyDict_SetItemString(SbkQTextCharFormat_Type.super.ht_type.tp_dict,
        "AlignSuperScript", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Type.tp_dict,
        "AlignSuperScript", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Type,
        (long) QTextCharFormat::AlignSubScript, "AlignSubScript");
    PyDict_SetItemString(SbkQTextCharFormat_Type.super.ht_type.tp_dict,
        "AlignSubScript", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Type.tp_dict,
        "AlignSubScript", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Type,
        (long) QTextCharFormat::AlignMiddle, "AlignMiddle");
    PyDict_SetItemString(SbkQTextCharFormat_Type.super.ht_type.tp_dict,
        "AlignMiddle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Type.tp_dict,
        "AlignMiddle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Type,
        (long) QTextCharFormat::AlignTop, "AlignTop");
    PyDict_SetItemString(SbkQTextCharFormat_Type.super.ht_type.tp_dict,
        "AlignTop", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Type.tp_dict,
        "AlignTop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Type,
        (long) QTextCharFormat::AlignBottom, "AlignBottom");
    PyDict_SetItemString(SbkQTextCharFormat_Type.super.ht_type.tp_dict,
        "AlignBottom", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCharFormat_VerticalAlignment_Type.tp_dict,
        "AlignBottom", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextCharFormat::VerticalAlignment");

    // init enum class: UnderlineStyle
    SbkPySide_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX] = &SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type);
    PyDict_SetItemString(SbkQTextCharFormat_Type.super.ht_type.tp_dict,
            "UnderlineStyle",((PyObject*)&SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type,
        (long) QTextCharFormat::NoUnderline, "NoUnderline");
    PyDict_SetItemString(SbkQTextCharFormat_Type.super.ht_type.tp_dict,
        "NoUnderline", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type.tp_dict,
        "NoUnderline", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type,
        (long) QTextCharFormat::SingleUnderline, "SingleUnderline");
    PyDict_SetItemString(SbkQTextCharFormat_Type.super.ht_type.tp_dict,
        "SingleUnderline", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type.tp_dict,
        "SingleUnderline", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type,
        (long) QTextCharFormat::DashUnderline, "DashUnderline");
    PyDict_SetItemString(SbkQTextCharFormat_Type.super.ht_type.tp_dict,
        "DashUnderline", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type.tp_dict,
        "DashUnderline", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type,
        (long) QTextCharFormat::DotLine, "DotLine");
    PyDict_SetItemString(SbkQTextCharFormat_Type.super.ht_type.tp_dict,
        "DotLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type.tp_dict,
        "DotLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type,
        (long) QTextCharFormat::DashDotLine, "DashDotLine");
    PyDict_SetItemString(SbkQTextCharFormat_Type.super.ht_type.tp_dict,
        "DashDotLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type.tp_dict,
        "DashDotLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type,
        (long) QTextCharFormat::DashDotDotLine, "DashDotDotLine");
    PyDict_SetItemString(SbkQTextCharFormat_Type.super.ht_type.tp_dict,
        "DashDotDotLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type.tp_dict,
        "DashDotDotLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type,
        (long) QTextCharFormat::WaveUnderline, "WaveUnderline");
    PyDict_SetItemString(SbkQTextCharFormat_Type.super.ht_type.tp_dict,
        "WaveUnderline", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type.tp_dict,
        "WaveUnderline", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type,
        (long) QTextCharFormat::SpellCheckUnderline, "SpellCheckUnderline");
    PyDict_SetItemString(SbkQTextCharFormat_Type.super.ht_type.tp_dict,
        "SpellCheckUnderline", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextCharFormat_UnderlineStyle_Type.tp_dict,
        "SpellCheckUnderline", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextCharFormat::UnderlineStyle");

    Shiboken::TypeResolver::createValueTypeResolver<QTextCharFormat >("QTextCharFormat");
    Shiboken::TypeResolver::createValueTypeResolver<QTextCharFormat >(typeid(QTextCharFormat).name());
}


} // extern "C"

