/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextblock_iterator_wrapper.h"

// Extra includes
#include <QTextBlock>
#include <qtextobject.h>

using namespace Shiboken;

static PyObject* SbkQTextBlock_iteratorFunc_atEnd(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // atEnd()const
    QTextBlock::iterator* cppSelf = Shiboken::Converter<QTextBlock::iterator* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextBlock::iterator::atEnd();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextBlock_iteratorFunc_fragment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fragment()const
    QTextBlock::iterator* cppSelf = Shiboken::Converter<QTextBlock::iterator* >::toCpp((PyObject*)self);
    QTextFragment cpp_result = cppSelf->QTextBlock::iterator::fragment();
    py_result = Shiboken::Converter<QTextFragment >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static int
SbkQTextBlock_iterator_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextBlock::iterator* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "iterator", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // iterator()
        cptr = new QTextBlock::iterator();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextBlock::iterator & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextBlock::iterator* cpp_arg0 = Shiboken::Converter<QTextBlock::iterator* >::toCpp(pyargs[0]);
        // iterator(QTextBlock::iterator)
        cptr = new QTextBlock::iterator(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextBlock_iterator_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTextBlock::iterator >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextBlock_iterator_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTextBlock_iterator_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QTextBlock::iterator", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.iterator", overloads);
        return -1;
}

static PyMethodDef SbkQTextBlock_iterator_methods[] = {
    {"atEnd", (PyCFunction)SbkQTextBlock_iteratorFunc_atEnd, METH_NOARGS},
    {"fragment", (PyCFunction)SbkQTextBlock_iteratorFunc_fragment, METH_NOARGS},
    {0} // Sentinel
};

// type has number operators
static PyNumberMethods SbkQTextBlock_iterator_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQTextBlock_iterator_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QTextBlock::iterator& cpp_self = *Shiboken::Converter<QTextBlock::iterator* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QTextBlock::iterator & >::isConvertible(other)) {
                // operator!=(const QTextBlock::iterator & o) const
                QTextBlock::iterator* cpp_other = Shiboken::Converter<QTextBlock::iterator* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QTextBlock::iterator  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQTextBlock_iterator_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QTextBlock::iterator & >::isConvertible(other)) {
                // operator==(const QTextBlock::iterator & o) const
                QTextBlock::iterator* cpp_other = Shiboken::Converter<QTextBlock::iterator* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QTextBlock::iterator  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQTextBlock_iterator_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQTextBlock_iterator_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextBlock_iterator_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.iterator",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQTextBlock_iterator_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQTextBlock_iterator_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextBlock_iterator_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextBlock_iterator_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTextBlock::iterator >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QTextBlock_iterator(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTBLOCK_ITERATOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextBlock_iterator_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTextBlock_iterator_Type) < 0)
        return;

    PyDict_SetItemString(module,"iterator", (PyObject*)&SbkQTextBlock_iterator_Type);
    Shiboken::TypeResolver::createValueTypeResolver<QTextBlock::iterator >("QTextBlock::iterator");
    Shiboken::TypeResolver::createValueTypeResolver<QTextBlock::iterator >(typeid(QTextBlock::iterator).name());
}


} // extern "C"

