/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qsyntaxhighlighter_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcolor.h>
#include <qcoreevent.h>
#include <qfont.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qsyntaxhighlighter.h>
#include <qtextdocument.h>
#include <qtextedit.h>
#include <qtextformat.h>
#include <qtextobject.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QSyntaxHighlighterWrapper::QSyntaxHighlighterWrapper(QObject * parent) : QSyntaxHighlighter(parent), m_metaObject(0) {
    // ... middle
}

QSyntaxHighlighterWrapper::QSyntaxHighlighterWrapper(QTextDocument * parent) : QSyntaxHighlighter(parent), m_metaObject(0) {
    // ... middle
}

QSyntaxHighlighterWrapper::QSyntaxHighlighterWrapper(QTextEdit * parent) : QSyntaxHighlighter(parent), m_metaObject(0) {
    // ... middle
}

void QSyntaxHighlighterWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSyntaxHighlighterWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSyntaxHighlighterWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSyntaxHighlighterWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QSyntaxHighlighterWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSyntaxHighlighter.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QSyntaxHighlighterWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSyntaxHighlighter.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QSyntaxHighlighterWrapper::highlightBlock(const QString & text)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "highlightBlock"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSyntaxHighlighter.highlightBlock()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QString & >::toPython(text)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSyntaxHighlighterWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QSyntaxHighlighterWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QSyntaxHighlighter::staticMetaObject);
}
    return m_metaObject;
}

int QSyntaxHighlighterWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QSyntaxHighlighter::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QSyntaxHighlighterWrapper::~QSyntaxHighlighterWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQSyntaxHighlighter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSyntaxHighlighterWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QSyntaxHighlighter' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QSyntaxHighlighter", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QTextEdit * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextEdit* cpp_arg0 = Shiboken::Converter<QTextEdit* >::toCpp(pyargs[0]);
        // QSyntaxHighlighter(QTextEdit*)
        cptr = new QSyntaxHighlighterWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (numArgs == 1 && Shiboken::Converter<QTextDocument * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextDocument* cpp_arg0 = Shiboken::Converter<QTextDocument* >::toCpp(pyargs[0]);
        // QSyntaxHighlighter(QTextDocument*)
        cptr = new QSyntaxHighlighterWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (numArgs == 1 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QSyntaxHighlighter(QObject*)
        cptr = new QSyntaxHighlighterWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQSyntaxHighlighter_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QSyntaxHighlighter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSyntaxHighlighter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQSyntaxHighlighter_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", "PySide.QtGui.QTextDocument", "PySide.QtGui.QTextEdit", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSyntaxHighlighter", overloads);
        return -1;
}

static PyObject* SbkQSyntaxHighlighterFunc_currentBlock(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentBlock()const
    QSyntaxHighlighter* cppSelf = Shiboken::Converter<QSyntaxHighlighter* >::toCpp((PyObject*)self);
    QTextBlock cpp_result = cppSelf->QSyntaxHighlighter::currentBlock();
    py_result = Shiboken::Converter<QTextBlock >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSyntaxHighlighterFunc_currentBlockState(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentBlockState()const
    QSyntaxHighlighter* cppSelf = Shiboken::Converter<QSyntaxHighlighter* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSyntaxHighlighter::currentBlockState();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSyntaxHighlighterFunc_currentBlockUserData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentBlockUserData()const
    QSyntaxHighlighter* cppSelf = Shiboken::Converter<QSyntaxHighlighter* >::toCpp((PyObject*)self);
    QTextBlockUserData * cpp_result = cppSelf->QSyntaxHighlighter::currentBlockUserData();
    py_result = Shiboken::Converter<QTextBlockUserData * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSyntaxHighlighterFunc_document(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // document()const
    QSyntaxHighlighter* cppSelf = Shiboken::Converter<QSyntaxHighlighter* >::toCpp((PyObject*)self);
    QTextDocument * cpp_result = cppSelf->QSyntaxHighlighter::document();
    py_result = Shiboken::Converter<QTextDocument * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSyntaxHighlighterFunc_format(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // format(int)const
        QSyntaxHighlighter* cppSelf = Shiboken::Converter<QSyntaxHighlighter* >::toCpp((PyObject*)self);
        QTextCharFormat cpp_result = cppSelf->QSyntaxHighlighter::format(cpp_arg0);
        py_result = Shiboken::Converter<QTextCharFormat >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSyntaxHighlighterFunc_format_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSyntaxHighlighterFunc_format_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSyntaxHighlighter.format", overloads);
        return 0;
}

static PyObject* SbkQSyntaxHighlighterFunc_highlightBlock(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // highlightBlock(QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSyntaxHighlighter.highlightBlock()' not implemented.");
            return 0;
        }
        QSyntaxHighlighter* cppSelf = Shiboken::Converter<QSyntaxHighlighter* >::toCpp((PyObject*)self);
        cppSelf->highlightBlock(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSyntaxHighlighterFunc_highlightBlock_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSyntaxHighlighterFunc_highlightBlock_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSyntaxHighlighter.highlightBlock", overloads);
        return 0;
}

static PyObject* SbkQSyntaxHighlighterFunc_previousBlockState(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // previousBlockState()const
    QSyntaxHighlighter* cppSelf = Shiboken::Converter<QSyntaxHighlighter* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSyntaxHighlighter::previousBlockState();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSyntaxHighlighterFunc_rehighlight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // rehighlight()
    QSyntaxHighlighter* cppSelf = Shiboken::Converter<QSyntaxHighlighter* >::toCpp((PyObject*)self);
    cppSelf->QSyntaxHighlighter::rehighlight();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQSyntaxHighlighterFunc_rehighlightBlock(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextBlock & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextBlock* cpp_arg0 = Shiboken::Converter<QTextBlock* >::toCpp(arg);
        // rehighlightBlock(QTextBlock)
        QSyntaxHighlighter* cppSelf = Shiboken::Converter<QSyntaxHighlighter* >::toCpp((PyObject*)self);
        cppSelf->QSyntaxHighlighter::rehighlightBlock(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSyntaxHighlighterFunc_rehighlightBlock_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSyntaxHighlighterFunc_rehighlightBlock_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextBlock", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSyntaxHighlighter.rehighlightBlock", overloads);
        return 0;
}

static PyObject* SbkQSyntaxHighlighterFunc_setCurrentBlockState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCurrentBlockState(int)
        QSyntaxHighlighter* cppSelf = Shiboken::Converter<QSyntaxHighlighter* >::toCpp((PyObject*)self);
        cppSelf->QSyntaxHighlighter::setCurrentBlockState(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSyntaxHighlighterFunc_setCurrentBlockState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSyntaxHighlighterFunc_setCurrentBlockState_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSyntaxHighlighter.setCurrentBlockState", overloads);
        return 0;
}

static PyObject* SbkQSyntaxHighlighterFunc_setCurrentBlockUserData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextBlockUserData * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextBlockUserData* cpp_arg0 = Shiboken::Converter<QTextBlockUserData* >::toCpp(arg);
        // setCurrentBlockUserData(QTextBlockUserData*)
        QSyntaxHighlighter* cppSelf = Shiboken::Converter<QSyntaxHighlighter* >::toCpp((PyObject*)self);
        cppSelf->QSyntaxHighlighter::setCurrentBlockUserData(cpp_arg0);

        // Ownership transferences.
        BindingManager::instance().transferOwnershipToCpp(arg);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSyntaxHighlighterFunc_setCurrentBlockUserData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSyntaxHighlighterFunc_setCurrentBlockUserData_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextBlockUserData", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSyntaxHighlighter.setCurrentBlockUserData", overloads);
        return 0;
}

static PyObject* SbkQSyntaxHighlighterFunc_setDocument(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextDocument * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextDocument* cpp_arg0 = Shiboken::Converter<QTextDocument* >::toCpp(arg);
        // setDocument(QTextDocument*)
        QSyntaxHighlighter* cppSelf = Shiboken::Converter<QSyntaxHighlighter* >::toCpp((PyObject*)self);
        cppSelf->QSyntaxHighlighter::setDocument(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQSyntaxHighlighterFunc_setDocument_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSyntaxHighlighterFunc_setDocument_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextDocument", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSyntaxHighlighter.setDocument", overloads);
        return 0;
}

static PyObject* SbkQSyntaxHighlighterFunc_setFormat(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setFormat", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 3 && Shiboken::Converter<QTextCharFormat & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QTextCharFormat* cpp_arg2 = Shiboken::Converter<QTextCharFormat* >::toCpp(pyargs[2]);
            // setFormat(int,int,QTextCharFormat)
            QSyntaxHighlighter* cppSelf = Shiboken::Converter<QSyntaxHighlighter* >::toCpp((PyObject*)self);
            cppSelf->QSyntaxHighlighter::setFormat(cpp_arg0, cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QFont & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QFont > cpp_arg2_auto_ptr;
            QFont* cpp_arg2 = Shiboken::Converter<QFont* >::toCpp(pyargs[2]);
            if (!SbkQFont_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QFont >(cpp_arg2);
            // setFormat(int,int,QFont)
            QSyntaxHighlighter* cppSelf = Shiboken::Converter<QSyntaxHighlighter* >::toCpp((PyObject*)self);
            cppSelf->QSyntaxHighlighter::setFormat(cpp_arg0, cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QColor & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QColor > cpp_arg2_auto_ptr;
            QColor* cpp_arg2 = Shiboken::Converter<QColor* >::toCpp(pyargs[2]);
            if (!SbkQColor_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QColor >(cpp_arg2);
            // setFormat(int,int,QColor)
            QSyntaxHighlighter* cppSelf = Shiboken::Converter<QSyntaxHighlighter* >::toCpp((PyObject*)self);
            cppSelf->QSyntaxHighlighter::setFormat(cpp_arg0, cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQSyntaxHighlighterFunc_setFormat_TypeError;
    } else goto SbkQSyntaxHighlighterFunc_setFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSyntaxHighlighterFunc_setFormat_TypeError:
        const char* overloads[] = {"int, int, PySide.QtGui.QColor", "int, int, PySide.QtGui.QFont", "int, int, PySide.QtGui.QTextCharFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSyntaxHighlighter.setFormat", overloads);
        return 0;
}

static PyMethodDef SbkQSyntaxHighlighter_methods[] = {
    {"currentBlock", (PyCFunction)SbkQSyntaxHighlighterFunc_currentBlock, METH_NOARGS},
    {"currentBlockState", (PyCFunction)SbkQSyntaxHighlighterFunc_currentBlockState, METH_NOARGS},
    {"currentBlockUserData", (PyCFunction)SbkQSyntaxHighlighterFunc_currentBlockUserData, METH_NOARGS},
    {"document", (PyCFunction)SbkQSyntaxHighlighterFunc_document, METH_NOARGS},
    {"format", (PyCFunction)SbkQSyntaxHighlighterFunc_format, METH_O},
    {"highlightBlock", (PyCFunction)SbkQSyntaxHighlighterFunc_highlightBlock, METH_O},
    {"previousBlockState", (PyCFunction)SbkQSyntaxHighlighterFunc_previousBlockState, METH_NOARGS},
    {"rehighlight", (PyCFunction)SbkQSyntaxHighlighterFunc_rehighlight, METH_NOARGS},
    {"rehighlightBlock", (PyCFunction)SbkQSyntaxHighlighterFunc_rehighlightBlock, METH_O},
    {"setCurrentBlockState", (PyCFunction)SbkQSyntaxHighlighterFunc_setCurrentBlockState, METH_O},
    {"setCurrentBlockUserData", (PyCFunction)SbkQSyntaxHighlighterFunc_setCurrentBlockUserData, METH_O},
    {"setDocument", (PyCFunction)SbkQSyntaxHighlighterFunc_setDocument, METH_O},
    {"setFormat", (PyCFunction)SbkQSyntaxHighlighterFunc_setFormat, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSyntaxHighlighter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QSyntaxHighlighter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSyntaxHighlighter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSyntaxHighlighter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QSyntaxHighlighter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QSyntaxHighlighter(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSYNTAXHIGHLIGHTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSyntaxHighlighter_Type);

    SbkQSyntaxHighlighter_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQSyntaxHighlighter_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQSyntaxHighlighter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSyntaxHighlighter_Type));
    PyModule_AddObject(module, "QSyntaxHighlighter",
        ((PyObject*)&SbkQSyntaxHighlighter_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QSyntaxHighlighter >("QSyntaxHighlighter*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSyntaxHighlighter >(typeid(QSyntaxHighlighter).name());
}


} // extern "C"

