/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qstyleoptionviewitem_wrapper.h"

// Extra includes
#include <qstyleoption.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQStyleOptionViewItem_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStyleOptionViewItem* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStyleOptionViewItem", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStyleOptionViewItem()
        cptr = new QStyleOptionViewItem();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QStyleOptionViewItem(int)
        cptr = new QStyleOptionViewItem(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QStyleOptionViewItem* cpp_arg0 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[0]);
        // QStyleOptionViewItem(QStyleOptionViewItem)
        cptr = new QStyleOptionViewItem(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyleOptionViewItem_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QStyleOptionViewItem >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStyleOptionViewItem_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQStyleOptionViewItem_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QStyleOptionViewItem", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyleOptionViewItem", overloads);
        return -1;
}

static PyMethodDef SbkQStyleOptionViewItem_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQStyleOptionViewItem_get_showDecorationSelected(SbkBaseWrapper* self)
{
    return Shiboken::Converter<bool >::toPython(Shiboken::Converter<QStyleOptionViewItem* >::toCpp((PyObject*)self)->showDecorationSelected);
}
static int SbkQStyleOptionViewItem_set_showDecorationSelected(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'showDecorationSelected' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'showDecorationSelected', 'bool' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionViewItem* >::toCpp((PyObject*)self)->showDecorationSelected = Shiboken::Converter<bool >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionViewItem_get_decorationPosition(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QStyleOptionViewItem::Position >::toPython(Shiboken::Converter<QStyleOptionViewItem* >::toCpp((PyObject*)self)->decorationPosition);
}
static int SbkQStyleOptionViewItem_set_decorationPosition(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'decorationPosition' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QStyleOptionViewItem::Position >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'decorationPosition', 'Position' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionViewItem* >::toCpp((PyObject*)self)->decorationPosition = Shiboken::Converter<QStyleOptionViewItem::Position >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionViewItem_get_decorationAlignment(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(Shiboken::Converter<QStyleOptionViewItem* >::toCpp((PyObject*)self)->decorationAlignment);
}
static int SbkQStyleOptionViewItem_set_decorationAlignment(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'decorationAlignment' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtCore_Qt_AlignmentFlag_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'decorationAlignment', 'Alignment' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionViewItem* >::toCpp((PyObject*)self)->decorationAlignment = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionViewItem_get_displayAlignment(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(Shiboken::Converter<QStyleOptionViewItem* >::toCpp((PyObject*)self)->displayAlignment);
}
static int SbkQStyleOptionViewItem_set_displayAlignment(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'displayAlignment' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtCore_Qt_AlignmentFlag_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'displayAlignment', 'Alignment' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionViewItem* >::toCpp((PyObject*)self)->displayAlignment = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionViewItem_get_textElideMode(SbkBaseWrapper* self)
{
    return Shiboken::Converter<Qt::TextElideMode >::toPython(Shiboken::Converter<QStyleOptionViewItem* >::toCpp((PyObject*)self)->textElideMode);
}
static int SbkQStyleOptionViewItem_set_textElideMode(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'textElideMode' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<Qt::TextElideMode >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'textElideMode', 'TextElideMode' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionViewItem* >::toCpp((PyObject*)self)->textElideMode = Shiboken::Converter<Qt::TextElideMode >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionViewItem_get_decorationSize(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QSize >::toPython(Shiboken::Converter<QStyleOptionViewItem* >::toCpp((PyObject*)self)->decorationSize);
}
static int SbkQStyleOptionViewItem_set_decorationSize(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'decorationSize' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QSize >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'decorationSize', 'QSize' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionViewItem* >::toCpp((PyObject*)self)->decorationSize = Shiboken::Converter<QSize >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionViewItem_get_font(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFont >::toPython(Shiboken::Converter<QStyleOptionViewItem* >::toCpp((PyObject*)self)->font);
}
static int SbkQStyleOptionViewItem_set_font(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'font' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QFont >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'font', 'QFont' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionViewItem* >::toCpp((PyObject*)self)->font = Shiboken::Converter<QFont >::toCpp(value);

    return 0;
}

// Getters and Setters for QStyleOptionViewItem
static PyGetSetDef SbkQStyleOptionViewItem_getsetlist[] = {
    {const_cast<char*>("showDecorationSelected"), (getter)SbkQStyleOptionViewItem_get_showDecorationSelected, (setter)SbkQStyleOptionViewItem_set_showDecorationSelected},
    {const_cast<char*>("decorationPosition"), (getter)SbkQStyleOptionViewItem_get_decorationPosition, (setter)SbkQStyleOptionViewItem_set_decorationPosition},
    {const_cast<char*>("decorationAlignment"), (getter)SbkQStyleOptionViewItem_get_decorationAlignment, (setter)SbkQStyleOptionViewItem_set_decorationAlignment},
    {const_cast<char*>("displayAlignment"), (getter)SbkQStyleOptionViewItem_get_displayAlignment, (setter)SbkQStyleOptionViewItem_set_displayAlignment},
    {const_cast<char*>("textElideMode"), (getter)SbkQStyleOptionViewItem_get_textElideMode, (setter)SbkQStyleOptionViewItem_set_textElideMode},
    {const_cast<char*>("decorationSize"), (getter)SbkQStyleOptionViewItem_get_decorationSize, (setter)SbkQStyleOptionViewItem_set_decorationSize},
    {const_cast<char*>("font"), (getter)SbkQStyleOptionViewItem_get_font, (setter)SbkQStyleOptionViewItem_set_font},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStyleOptionViewItem_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStyleOptionViewItem",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStyleOptionViewItem_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQStyleOptionViewItem_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStyleOptionViewItem_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QStyleOptionViewItem >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionVersion_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionVersion_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionVersion_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionVersion",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionVersion_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionVersion_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionVersion_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionViewItem_Position_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionViewItem_Position_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionViewItem_Position_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Position",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionViewItem_Position_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionViewItem_Position_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionViewItem_Position_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QStyleOptionViewItem(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStyleOptionViewItem_Type);

    SbkQStyleOptionViewItem_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQStyleOptionViewItem_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStyleOptionViewItem_Type));
    PyModule_AddObject(module, "QStyleOptionViewItem",
        ((PyObject*)&SbkQStyleOptionViewItem_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StyleOptionVersion
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONVERSION_IDX] = &SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionVersion_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionVersion_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionVersion_Type);
    PyDict_SetItemString(SbkQStyleOptionViewItem_Type.super.ht_type.tp_dict,
            "StyleOptionVersion",((PyObject*)&SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionVersion_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionVersion_Type,
        (long) QStyleOptionViewItem::Version, "Version");
    PyDict_SetItemString(SbkQStyleOptionViewItem_Type.super.ht_type.tp_dict,
        "Version", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionVersion_Type.tp_dict,
        "Version", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionViewItem::StyleOptionVersion");

    // init enum class: StyleOptionType
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONTYPE_IDX] = &SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionType_Type);
    PyDict_SetItemString(SbkQStyleOptionViewItem_Type.super.ht_type.tp_dict,
            "StyleOptionType",((PyObject*)&SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionType_Type,
        (long) QStyleOptionViewItem::Type, "Type");
    PyDict_SetItemString(SbkQStyleOptionViewItem_Type.super.ht_type.tp_dict,
        "Type", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItem_StyleOptionType_Type.tp_dict,
        "Type", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionViewItem::StyleOptionType");

    // init enum class: Position
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONVIEWITEM_POSITION_IDX] = &SbkPySide_QtGui_QStyleOptionViewItem_Position_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionViewItem_Position_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionViewItem_Position_Type);
    PyDict_SetItemString(SbkQStyleOptionViewItem_Type.super.ht_type.tp_dict,
            "Position",((PyObject*)&SbkPySide_QtGui_QStyleOptionViewItem_Position_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItem_Position_Type,
        (long) QStyleOptionViewItem::Left, "Left");
    PyDict_SetItemString(SbkQStyleOptionViewItem_Type.super.ht_type.tp_dict,
        "Left", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItem_Position_Type.tp_dict,
        "Left", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItem_Position_Type,
        (long) QStyleOptionViewItem::Right, "Right");
    PyDict_SetItemString(SbkQStyleOptionViewItem_Type.super.ht_type.tp_dict,
        "Right", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItem_Position_Type.tp_dict,
        "Right", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItem_Position_Type,
        (long) QStyleOptionViewItem::Top, "Top");
    PyDict_SetItemString(SbkQStyleOptionViewItem_Type.super.ht_type.tp_dict,
        "Top", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItem_Position_Type.tp_dict,
        "Top", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionViewItem_Position_Type,
        (long) QStyleOptionViewItem::Bottom, "Bottom");
    PyDict_SetItemString(SbkQStyleOptionViewItem_Type.super.ht_type.tp_dict,
        "Bottom", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionViewItem_Position_Type.tp_dict,
        "Bottom", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionViewItem::Position");

    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionViewItem >("QStyleOptionViewItem");
    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionViewItem >(typeid(QStyleOptionViewItem).name());
}


} // extern "C"

