/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qmouseeventtransition_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractanimation.h>
#include <qabstractstate.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmouseeventtransition.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainterpath.h>
#include <qstate.h>
#include <qstatemachine.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QMouseEventTransitionWrapper::QMouseEventTransitionWrapper(QObject * object, QEvent::Type type, Qt::MouseButton button, QState * sourceState) : QMouseEventTransition(object, type, button, sourceState), m_metaObject(0) {
    // ... middle
}

QMouseEventTransitionWrapper::QMouseEventTransitionWrapper(QState * sourceState) : QMouseEventTransition(sourceState), m_metaObject(0) {
    // ... middle
}

void QMouseEventTransitionWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMouseEventTransitionWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMouseEventTransitionWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMouseEventTransitionWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QMouseEventTransitionWrapper::event(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QEventTransition::event(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMouseEventTransition.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QMouseEventTransitionWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMouseEventTransition.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

bool QMouseEventTransitionWrapper::eventTest(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventTest"));
    if (py_override.isNull()) {
        return this->QMouseEventTransition::eventTest(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMouseEventTransition.eventTest", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QMouseEventTransitionWrapper::onTransition(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "onTransition"));
    if (py_override.isNull()) {
        return this->QMouseEventTransition::onTransition(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMouseEventTransitionWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QMouseEventTransitionWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QMouseEventTransition::staticMetaObject);
}
    return m_metaObject;
}

int QMouseEventTransitionWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QMouseEventTransition::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QMouseEventTransitionWrapper::~QMouseEventTransitionWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQMouseEventTransition_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMouseEventTransitionWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQMouseEventTransition_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QMouseEventTransition", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QMouseEventTransition(QState*)
        cptr = new QMouseEventTransitionWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QState * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QState* cpp_arg0 = Shiboken::Converter<QState* >::toCpp(pyargs[0]);
        // QMouseEventTransition(QState*)
        cptr = new QMouseEventTransitionWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0]) && Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[1]) && Shiboken::Converter<Qt::MouseButton >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        QEvent::Type cpp_arg1 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[1]);
        Qt::MouseButton cpp_arg2 = Shiboken::Converter<Qt::MouseButton >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // QMouseEventTransition(QObject*,QEvent::Type,Qt::MouseButton,QState*)
            cptr = new QMouseEventTransitionWrapper(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QState * >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return -1;
            QState* cpp_arg3 = Shiboken::Converter<QState* >::toCpp(pyargs[3]);
            // QMouseEventTransition(QObject*,QEvent::Type,Qt::MouseButton,QState*)
            cptr = new QMouseEventTransitionWrapper(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQMouseEventTransition_Init_TypeError;
    } else goto SbkQMouseEventTransition_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QMouseEventTransition >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQMouseEventTransition_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQMouseEventTransition_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QEvent.Type, PySide.QtCore.Qt.MouseButton, PySide.QtCore.QState = None", "PySide.QtCore.QState = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMouseEventTransition", overloads);
        return -1;
}

static PyObject* SbkQMouseEventTransitionFunc_button(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // button()const
    QMouseEventTransition* cppSelf = Shiboken::Converter<QMouseEventTransition* >::toCpp((PyObject*)self);
    Qt::MouseButton cpp_result = cppSelf->QMouseEventTransition::button();
    py_result = Shiboken::Converter<Qt::MouseButton >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMouseEventTransitionFunc_eventTest(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // eventTest(QEvent*)
        QMouseEventTransition* cppSelf = Shiboken::Converter<QMouseEventTransition* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMouseEventTransition::eventTest(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMouseEventTransitionFunc_eventTest_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMouseEventTransitionFunc_eventTest_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMouseEventTransition.eventTest", overloads);
        return 0;
}

static PyObject* SbkQMouseEventTransitionFunc_hitTestPath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hitTestPath()const
    QMouseEventTransition* cppSelf = Shiboken::Converter<QMouseEventTransition* >::toCpp((PyObject*)self);
    QPainterPath cpp_result = cppSelf->QMouseEventTransition::hitTestPath();
    py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMouseEventTransitionFunc_modifierMask(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // modifierMask()const
    QMouseEventTransition* cppSelf = Shiboken::Converter<QMouseEventTransition* >::toCpp((PyObject*)self);
    QFlags<Qt::KeyboardModifier> cpp_result = cppSelf->QMouseEventTransition::modifierMask();
    py_result = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMouseEventTransitionFunc_onTransition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // onTransition(QEvent*)
        QMouseEventTransition* cppSelf = Shiboken::Converter<QMouseEventTransition* >::toCpp((PyObject*)self);
        cppSelf->QMouseEventTransition::onTransition(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMouseEventTransitionFunc_onTransition_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMouseEventTransitionFunc_onTransition_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMouseEventTransition.onTransition", overloads);
        return 0;
}

static PyObject* SbkQMouseEventTransitionFunc_setButton(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::MouseButton >::isConvertible(arg)) {
        Qt::MouseButton cpp_arg0 = Shiboken::Converter<Qt::MouseButton >::toCpp(arg);
        // setButton(Qt::MouseButton)
        QMouseEventTransition* cppSelf = Shiboken::Converter<QMouseEventTransition* >::toCpp((PyObject*)self);
        cppSelf->QMouseEventTransition::setButton(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMouseEventTransitionFunc_setButton_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMouseEventTransitionFunc_setButton_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.MouseButton", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMouseEventTransition.setButton", overloads);
        return 0;
}

static PyObject* SbkQMouseEventTransitionFunc_setHitTestPath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPainterPath & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // setHitTestPath(QPainterPath)
        QMouseEventTransition* cppSelf = Shiboken::Converter<QMouseEventTransition* >::toCpp((PyObject*)self);
        cppSelf->QMouseEventTransition::setHitTestPath(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMouseEventTransitionFunc_setHitTestPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMouseEventTransitionFunc_setHitTestPath_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMouseEventTransition.setHitTestPath", overloads);
        return 0;
}

static PyObject* SbkQMouseEventTransitionFunc_setModifierMask(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(arg)) {
        QFlags<Qt::KeyboardModifier> cpp_arg0 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(arg);
        // setModifierMask(QFlags<Qt::KeyboardModifier>)
        QMouseEventTransition* cppSelf = Shiboken::Converter<QMouseEventTransition* >::toCpp((PyObject*)self);
        cppSelf->QMouseEventTransition::setModifierMask(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMouseEventTransitionFunc_setModifierMask_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMouseEventTransitionFunc_setModifierMask_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.KeyboardModifiers", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMouseEventTransition.setModifierMask", overloads);
        return 0;
}

static PyMethodDef SbkQMouseEventTransition_methods[] = {
    {"button", (PyCFunction)SbkQMouseEventTransitionFunc_button, METH_NOARGS},
    {"eventTest", (PyCFunction)SbkQMouseEventTransitionFunc_eventTest, METH_O},
    {"hitTestPath", (PyCFunction)SbkQMouseEventTransitionFunc_hitTestPath, METH_NOARGS},
    {"modifierMask", (PyCFunction)SbkQMouseEventTransitionFunc_modifierMask, METH_NOARGS},
    {"onTransition", (PyCFunction)SbkQMouseEventTransitionFunc_onTransition, METH_O},
    {"setButton", (PyCFunction)SbkQMouseEventTransitionFunc_setButton, METH_O},
    {"setHitTestPath", (PyCFunction)SbkQMouseEventTransitionFunc_setHitTestPath, METH_O},
    {"setModifierMask", (PyCFunction)SbkQMouseEventTransitionFunc_setModifierMask, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMouseEventTransition_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QMouseEventTransition",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMouseEventTransition_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMouseEventTransition_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QMouseEventTransition >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QMouseEventTransition(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QMOUSEEVENTTRANSITION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMouseEventTransition_Type);

    SbkQMouseEventTransition_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QEVENTTRANSITION_IDX];
    // Fill type discovery information
    SbkQMouseEventTransition_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQMouseEventTransition_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMouseEventTransition_Type));
    PyModule_AddObject(module, "QMouseEventTransition",
        ((PyObject*)&SbkQMouseEventTransition_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QMouseEventTransition >("QMouseEventTransition*");
    Shiboken::TypeResolver::createObjectTypeResolver<QMouseEventTransition >(typeid(QMouseEventTransition).name());
}


} // extern "C"

