/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qlayout_wrapper.h"

// Extra includes
#include <QList>
#include "glue/qlayout_help_functions.h"
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qlayout.h>
#include <qlayoutitem.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QLayoutWrapper::QLayoutWrapper() : QLayout(), m_metaObject(0) {
    // ... middle
}

QLayoutWrapper::QLayoutWrapper(QWidget * parent) : QLayout(parent), m_metaObject(0) {
    // ... middle
}

void QLayoutWrapper::addItem(QLayoutItem * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "addItem"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.addItem()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QLayoutItem * >::toPython(arg__1)
    ));


    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));

}

void QLayoutWrapper::childEvent(QChildEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QLayout::childEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLayoutWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QLayoutWrapper::count() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "count"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.count()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.count", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QLayoutWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLayoutWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QLayoutWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QLayoutWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QFlags<Qt::Orientation> QLayoutWrapper::expandingDirections() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "expandingDirections"));
    if (py_override.isNull()) {
        return this->QLayout::expandingDirections();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::Orientation>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::Orientation> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.expandingDirections", SbkType<QFlags<Qt::Orientation> >()->tp_name, py_result->ob_type->tp_name);
        return QFlags<Qt::Orientation>();
    }
    QFlags<Qt::Orientation> cpp_result(Shiboken::Converter<QFlags<Qt::Orientation> >::toCpp(py_result));
    return cpp_result;
}

QRect QLayoutWrapper::geometry() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "geometry"));
    if (py_override.isNull()) {
        return this->QLayout::geometry();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.geometry", SbkType<QRect >()->tp_name, py_result->ob_type->tp_name);
        return QRect();
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

bool QLayoutWrapper::hasHeightForWidth() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasHeightForWidth"));
    if (py_override.isNull()) {
        return this->QLayoutItem::hasHeightForWidth();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.hasHeightForWidth", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

int QLayoutWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QLayoutItem::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QLayoutWrapper::indexOf(QWidget * arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "indexOf"));
    if (py_override.isNull()) {
        return this->QLayout::indexOf(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWidget * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.indexOf", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QLayoutWrapper::invalidate()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "invalidate"));
    if (py_override.isNull()) {
        return this->QLayout::invalidate();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QLayoutWrapper::isEmpty() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isEmpty"));
    if (py_override.isNull()) {
        return this->QLayout::isEmpty();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.isEmpty", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QLayoutItem * QLayoutWrapper::itemAt(int index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemAt"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.itemAt()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));


    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayoutItem * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.itemAt", SbkType<QLayoutItem * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QLayoutItem * cpp_result(Shiboken::Converter<QLayoutItem * >::toCpp(py_result));

    return cpp_result;
}

QLayout * QLayoutWrapper::layout()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "layout"));
    if (py_override.isNull()) {
        return this->QLayout::layout();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayout * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.layout", SbkType<QLayout * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QLayout * cpp_result(Shiboken::Converter<QLayout * >::toCpp(py_result));
    return cpp_result;
}

QSize QLayoutWrapper::maximumSize() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "maximumSize"));
    if (py_override.isNull()) {
        return this->QLayout::maximumSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.maximumSize", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

int QLayoutWrapper::minimumHeightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumHeightForWidth"));
    if (py_override.isNull()) {
        return this->QLayoutItem::minimumHeightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.minimumHeightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QLayoutWrapper::minimumSize() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSize"));
    if (py_override.isNull()) {
        return this->QLayout::minimumSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.minimumSize", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QLayoutWrapper::setGeometry(const QRect & arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setGeometry"));
    if (py_override.isNull()) {
        return this->QLayout::setGeometry(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QRect & >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QLayoutWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.sizeHint()' not implemented.");
        return QSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

QSpacerItem * QLayoutWrapper::spacerItem()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "spacerItem"));
    if (py_override.isNull()) {
        return this->QLayoutItem::spacerItem();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSpacerItem * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.spacerItem", SbkType<QSpacerItem * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QSpacerItem * cpp_result(Shiboken::Converter<QSpacerItem * >::toCpp(py_result));
    return cpp_result;
}

QLayoutItem * QLayoutWrapper::takeAt(int index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "takeAt"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.takeAt()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayoutItem * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.takeAt", SbkType<QLayoutItem * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QLayoutItem * cpp_result(Shiboken::Converter<QLayoutItem * >::toCpp(py_result));
    return cpp_result;
}

void QLayoutWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QWidget * QLayoutWrapper::widget()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "widget"));
    if (py_override.isNull()) {
        return this->QLayoutItem::widget();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QWidget * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLayout.widget", SbkType<QWidget * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QWidget * cpp_result(Shiboken::Converter<QWidget * >::toCpp(py_result));
    return cpp_result;
}

const QMetaObject* QLayoutWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QLayout::staticMetaObject);
}
    return m_metaObject;
}

int QLayoutWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QLayout::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QLayoutWrapper::~QLayoutWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQLayout_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QLayoutWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUT_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QLayout' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

        type->mi_init = myType->mi_init;
        type->mi_offsets = myType->mi_offsets;
        type->mi_specialcast = myType->mi_specialcast;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QLayout", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QLayout()
        cptr = new QLayoutWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QLayout(QWidget*)
        cptr = new QLayoutWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQLayout_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QLayout >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQLayout_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQLayout_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QLayout", overloads);
        return -1;
}

static PyObject* SbkQLayoutFunc_activate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // activate()
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLayout::activate();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_addChildLayout(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QLayout * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QLayout* cpp_arg0 = Shiboken::Converter<QLayout* >::toCpp(arg);
        // addChildLayout(QLayout*)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        // Begin code injection
        
        addLayoutOwnership(cppSelf, cpp_arg0);
        
        // End of code injection

        cppSelf->QLayout::addChildLayout(cpp_arg0);

        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_addChildLayout_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLayoutFunc_addChildLayout_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLayout", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.addChildLayout", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_addChildWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // addChildWidget(QWidget*)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        // Begin code injection
        
        addLayoutOwnership(cppSelf, cpp_arg0);
        
        // End of code injection

        cppSelf->QLayout::addChildWidget(cpp_arg0);

        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_addChildWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLayoutFunc_addChildWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.addChildWidget", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_addItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QLayoutItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QLayoutItem* cpp_arg0 = Shiboken::Converter<QLayoutItem* >::toCpp(arg);
        // addItem(QLayoutItem*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.addItem()' not implemented.");
            return 0;
        }
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        // Begin code injection
        
        addLayoutOwnership(cppSelf, cpp_arg0);
        
        // End of code injection

        cppSelf->addItem(cpp_arg0);

        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_addItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLayoutFunc_addItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLayoutItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.addItem", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_addWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // addWidget(QWidget*)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        // Begin code injection
        
        addLayoutOwnership(cppSelf, cpp_arg0);
        
        // End of code injection

        cppSelf->QLayout::addWidget(cpp_arg0);

        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_addWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLayoutFunc_addWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.addWidget", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_alignmentRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // alignmentRect(QRect)const
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QLayout::alignmentRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_alignmentRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLayoutFunc_alignmentRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.alignmentRect", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_childEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QChildEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QChildEvent* cpp_arg0 = Shiboken::Converter<QChildEvent* >::toCpp(arg);
        // childEvent(QChildEvent*)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        cppSelf->QLayout::childEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_childEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLayoutFunc_childEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QChildEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.childEvent", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_closestAcceptableSize(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "closestAcceptableSize", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QSize & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QSize* cpp_arg1 = Shiboken::Converter<QSize* >::toCpp(pyargs[1]);
        // closestAcceptableSize(const QWidget*,QSize)
        QSize cpp_result = QLayout::closestAcceptableSize(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_closestAcceptableSize_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLayoutFunc_closestAcceptableSize_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QLayout.closestAcceptableSize", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_contentsMargins(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // contentsMargins()const
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    QMargins cpp_result = cppSelf->QLayout::contentsMargins();
    py_result = Shiboken::Converter<QMargins >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_contentsRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // contentsRect()const
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QLayout::contentsRect();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.count()' not implemented.");
        return 0;
    }
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_expandingDirections(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // expandingDirections()const
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    QFlags<Qt::Orientation> cpp_result = cppSelf->QLayout::expandingDirections();
    py_result = Shiboken::Converter<QFlags<Qt::Orientation> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_geometry(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // geometry()const
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QLayout::geometry();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_indexOf(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // indexOf(QWidget*)const
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QLayout::indexOf(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_indexOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLayoutFunc_indexOf_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.indexOf", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_invalidate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // invalidate()
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    cppSelf->QLayout::invalidate();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQLayoutFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLayout::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_isEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEnabled()const
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLayout::isEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_itemAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // itemAt(int)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.itemAt()' not implemented.");
            return 0;
        }
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);

        QLayoutItem * cpp_result = cppSelf->itemAt(cpp_arg0);
        py_result = Shiboken::Converter<QLayoutItem * >::toPython(cpp_result);

        // Begin code injection
        
        addLayoutOwnership(cppSelf, cpp_result);
        
        // End of code injection

        // Ownership transferences.
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_itemAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLayoutFunc_itemAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.itemAt", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_layout(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // layout()
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    QLayout * cpp_result = cppSelf->QLayout::layout();
    py_result = Shiboken::Converter<QLayout * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_margin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // margin()const
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QLayout::margin();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_maximumSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumSize()const
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QLayout::maximumSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_menuBar(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // menuBar()const
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QLayout::menuBar();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_minimumSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSize()const
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QLayout::minimumSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_parentWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // parentWidget()const
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QLayout::parentWidget();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(py_result, self);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_removeItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QLayoutItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QLayoutItem* cpp_arg0 = Shiboken::Converter<QLayoutItem* >::toCpp(arg);
        // removeItem(QLayoutItem*)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        cppSelf->QLayout::removeItem(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_removeItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLayoutFunc_removeItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLayoutItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.removeItem", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_removeWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // removeWidget(QWidget*)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        cppSelf->QLayout::removeWidget(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_removeWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLayoutFunc_removeWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.removeWidget", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_setAlignment(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setAlignment", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        QFlags<Qt::AlignmentFlag> cpp_arg1 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[1]);
        // setAlignment(QWidget*,QFlags<Qt::AlignmentFlag>)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QLayout::setAlignment(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QLayout * >::isConvertible(pyargs[0]) && SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QLayout* cpp_arg0 = Shiboken::Converter<QLayout* >::toCpp(pyargs[0]);
        QFlags<Qt::AlignmentFlag> cpp_arg1 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[1]);
        // setAlignment(QLayout*,QFlags<Qt::AlignmentFlag>)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QLayout::setAlignment(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[0])) {
        QFlags<Qt::AlignmentFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[0]);
        // setAlignment(QFlags<Qt::AlignmentFlag>)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        cppSelf->QLayout::setAlignment(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else goto SbkQLayoutFunc_setAlignment_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLayoutFunc_setAlignment_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Alignment", "PySide.QtGui.QLayout, PySide.QtCore.Qt.Alignment", "PySide.QtGui.QWidget, PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QLayout.setAlignment", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_setContentsMargins(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQLayoutFunc_setContentsMargins_TypeError;

    if (!PyArg_UnpackTuple(args, "setContentsMargins", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // setContentsMargins(int,int,int,int)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        cppSelf->QLayout::setContentsMargins(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QMargins & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QMargins* cpp_arg0 = Shiboken::Converter<QMargins* >::toCpp(pyargs[0]);
        // setContentsMargins(QMargins)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        cppSelf->QLayout::setContentsMargins(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_setContentsMargins_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLayoutFunc_setContentsMargins_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMargins", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QLayout.setContentsMargins", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_setEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setEnabled(bool)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        cppSelf->QLayout::setEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_setEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLayoutFunc_setEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.setEnabled", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_setGeometry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // setGeometry(QRect)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        cppSelf->QLayout::setGeometry(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_setGeometry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLayoutFunc_setGeometry_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.setGeometry", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_setMargin(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMargin(int)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        cppSelf->QLayout::setMargin(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_setMargin_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLayoutFunc_setMargin_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.setMargin", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_setMenuBar(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // setMenuBar(QWidget*)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        // Begin code injection
        
        addLayoutOwnership(cppSelf, cpp_arg0);
        
        // End of code injection

        cppSelf->QLayout::setMenuBar(cpp_arg0);

        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_setMenuBar_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLayoutFunc_setMenuBar_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.setMenuBar", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_setSizeConstraint(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QLayout::SizeConstraint >::isConvertible(arg)) {
        QLayout::SizeConstraint cpp_arg0 = Shiboken::Converter<QLayout::SizeConstraint >::toCpp(arg);
        // setSizeConstraint(QLayout::SizeConstraint)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        cppSelf->QLayout::setSizeConstraint(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_setSizeConstraint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLayoutFunc_setSizeConstraint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLayout.SizeConstraint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.setSizeConstraint", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_setSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setSpacing(int)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        cppSelf->QLayout::setSpacing(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_setSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLayoutFunc_setSpacing_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.setSpacing", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_sizeConstraint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeConstraint()const
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    QLayout::SizeConstraint cpp_result = cppSelf->QLayout::sizeConstraint();
    py_result = Shiboken::Converter<QLayout::SizeConstraint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_spacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // spacing()const
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QLayout::spacing();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_takeAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // takeAt(int)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.takeAt()' not implemented.");
            return 0;
        }
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        QLayoutItem * cpp_result = cppSelf->takeAt(cpp_arg0);
        py_result = Shiboken::Converter<QLayoutItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(Py_None, py_result);
    } else goto SbkQLayoutFunc_takeAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLayoutFunc_takeAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.takeAt", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_totalHeightForWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // totalHeightForWidth(int)const
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QLayout::totalHeightForWidth(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_totalHeightForWidth_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLayoutFunc_totalHeightForWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.totalHeightForWidth", overloads);
        return 0;
}

static PyObject* SbkQLayoutFunc_totalMaximumSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // totalMaximumSize()const
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QLayout::totalMaximumSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_totalMinimumSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // totalMinimumSize()const
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QLayout::totalMinimumSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_totalSizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // totalSizeHint()const
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QLayout::totalSizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLayoutFunc_update(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // update()
    QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
    cppSelf->QLayout::update();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQLayoutFunc_widgetEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // widgetEvent(QEvent*)
        QLayout* cppSelf = Shiboken::Converter<QLayout* >::toCpp((PyObject*)self);
        cppSelf->QLayout::widgetEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLayoutFunc_widgetEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLayoutFunc_widgetEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLayout.widgetEvent", overloads);
        return 0;
}

static PyMethodDef SbkQLayout_methods[] = {
    {"activate", (PyCFunction)SbkQLayoutFunc_activate, METH_NOARGS},
    {"addChildLayout", (PyCFunction)SbkQLayoutFunc_addChildLayout, METH_O},
    {"addChildWidget", (PyCFunction)SbkQLayoutFunc_addChildWidget, METH_O},
    {"addItem", (PyCFunction)SbkQLayoutFunc_addItem, METH_O},
    {"addWidget", (PyCFunction)SbkQLayoutFunc_addWidget, METH_O},
    {"alignmentRect", (PyCFunction)SbkQLayoutFunc_alignmentRect, METH_O},
    {"childEvent", (PyCFunction)SbkQLayoutFunc_childEvent, METH_O},
    {"closestAcceptableSize", (PyCFunction)SbkQLayoutFunc_closestAcceptableSize, METH_VARARGS|METH_STATIC},
    {"contentsMargins", (PyCFunction)SbkQLayoutFunc_contentsMargins, METH_NOARGS},
    {"contentsRect", (PyCFunction)SbkQLayoutFunc_contentsRect, METH_NOARGS},
    {"count", (PyCFunction)SbkQLayoutFunc_count, METH_NOARGS},
    {"expandingDirections", (PyCFunction)SbkQLayoutFunc_expandingDirections, METH_NOARGS},
    {"geometry", (PyCFunction)SbkQLayoutFunc_geometry, METH_NOARGS},
    {"indexOf", (PyCFunction)SbkQLayoutFunc_indexOf, METH_O},
    {"invalidate", (PyCFunction)SbkQLayoutFunc_invalidate, METH_NOARGS},
    {"isEmpty", (PyCFunction)SbkQLayoutFunc_isEmpty, METH_NOARGS},
    {"isEnabled", (PyCFunction)SbkQLayoutFunc_isEnabled, METH_NOARGS},
    {"itemAt", (PyCFunction)SbkQLayoutFunc_itemAt, METH_O},
    {"layout", (PyCFunction)SbkQLayoutFunc_layout, METH_NOARGS},
    {"margin", (PyCFunction)SbkQLayoutFunc_margin, METH_NOARGS},
    {"maximumSize", (PyCFunction)SbkQLayoutFunc_maximumSize, METH_NOARGS},
    {"menuBar", (PyCFunction)SbkQLayoutFunc_menuBar, METH_NOARGS},
    {"minimumSize", (PyCFunction)SbkQLayoutFunc_minimumSize, METH_NOARGS},
    {"parentWidget", (PyCFunction)SbkQLayoutFunc_parentWidget, METH_NOARGS},
    {"removeItem", (PyCFunction)SbkQLayoutFunc_removeItem, METH_O},
    {"removeWidget", (PyCFunction)SbkQLayoutFunc_removeWidget, METH_O},
    {"setAlignment", (PyCFunction)SbkQLayoutFunc_setAlignment, METH_VARARGS},
    {"setContentsMargins", (PyCFunction)SbkQLayoutFunc_setContentsMargins, METH_VARARGS},
    {"setEnabled", (PyCFunction)SbkQLayoutFunc_setEnabled, METH_O},
    {"setGeometry", (PyCFunction)SbkQLayoutFunc_setGeometry, METH_O},
    {"setMargin", (PyCFunction)SbkQLayoutFunc_setMargin, METH_O},
    {"setMenuBar", (PyCFunction)SbkQLayoutFunc_setMenuBar, METH_O},
    {"setSizeConstraint", (PyCFunction)SbkQLayoutFunc_setSizeConstraint, METH_O},
    {"setSpacing", (PyCFunction)SbkQLayoutFunc_setSpacing, METH_O},
    {"sizeConstraint", (PyCFunction)SbkQLayoutFunc_sizeConstraint, METH_NOARGS},
    {"spacing", (PyCFunction)SbkQLayoutFunc_spacing, METH_NOARGS},
    {"takeAt", (PyCFunction)SbkQLayoutFunc_takeAt, METH_O},
    {"totalHeightForWidth", (PyCFunction)SbkQLayoutFunc_totalHeightForWidth, METH_O},
    {"totalMaximumSize", (PyCFunction)SbkQLayoutFunc_totalMaximumSize, METH_NOARGS},
    {"totalMinimumSize", (PyCFunction)SbkQLayoutFunc_totalMinimumSize, METH_NOARGS},
    {"totalSizeHint", (PyCFunction)SbkQLayoutFunc_totalSizeHint, METH_NOARGS},
    {"update", (PyCFunction)SbkQLayoutFunc_update, METH_NOARGS},
    {"widgetEvent", (PyCFunction)SbkQLayoutFunc_widgetEvent, METH_O},
    {0} // Sentinel
};

extern "C"
{

static int mi_offsets[] = { -1, -1, -1, -1, -1 };
int*
SbkQLayout_mi_init(const void* cptr)
{
    if (mi_offsets[0] == -1) {
        std::set<int> offsets;
        std::set<int>::iterator it;
        const QLayout* class_ptr = reinterpret_cast<const QLayout*>(cptr);
        size_t base = (size_t) class_ptr;
        offsets.insert(((size_t) static_cast<const QObject*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QObject*>((QLayout*)((void*)class_ptr))) - base);
        offsets.insert(((size_t) static_cast<const QLayoutItem*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QLayoutItem*>((QLayout*)((void*)class_ptr))) - base);

        offsets.erase(0);

        int i = 0;
        for (it = offsets.begin(); it != offsets.end(); it++) {
            mi_offsets[i] = *it;
            i++;
        }
    }
    return mi_offsets;
}
static void* SbkQLayoutSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QLayout* me = reinterpret_cast<QLayout*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX]))
        return static_cast<QLayoutItem*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQLayout_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QLayout",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQLayout_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQLayout_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             SbkQLayout_mi_init,
    /*mi_specialcast*/      &SbkQLayoutSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QLayout >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QLayout_SizeConstraint_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QLayout_SizeConstraint_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QLayout_SizeConstraint_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SizeConstraint",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QLayout_SizeConstraint_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QLayout_SizeConstraint_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QLayout_SizeConstraint_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QLayout(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QLAYOUT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQLayout_Type);

    SbkQLayout_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX];
    SbkQLayout_Type.super.ht_type.tp_bases = PyTuple_Pack(2,
        (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX], (PyTypeObject*)SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX]);

    // Fill type discovery information
    SbkQLayout_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQLayout_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQLayout_Type));
    PyModule_AddObject(module, "QLayout",
        ((PyObject*)&SbkQLayout_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: SizeConstraint
    SbkPySide_QtGuiTypes[SBK_QLAYOUT_SIZECONSTRAINT_IDX] = &SbkPySide_QtGui_QLayout_SizeConstraint_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QLayout_SizeConstraint_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QLayout_SizeConstraint_Type);
    PyDict_SetItemString(SbkQLayout_Type.super.ht_type.tp_dict,
            "SizeConstraint",((PyObject*)&SbkPySide_QtGui_QLayout_SizeConstraint_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QLayout_SizeConstraint_Type,
        (long) QLayout::SetDefaultConstraint, "SetDefaultConstraint");
    PyDict_SetItemString(SbkQLayout_Type.super.ht_type.tp_dict,
        "SetDefaultConstraint", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QLayout_SizeConstraint_Type.tp_dict,
        "SetDefaultConstraint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QLayout_SizeConstraint_Type,
        (long) QLayout::SetNoConstraint, "SetNoConstraint");
    PyDict_SetItemString(SbkQLayout_Type.super.ht_type.tp_dict,
        "SetNoConstraint", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QLayout_SizeConstraint_Type.tp_dict,
        "SetNoConstraint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QLayout_SizeConstraint_Type,
        (long) QLayout::SetMinimumSize, "SetMinimumSize");
    PyDict_SetItemString(SbkQLayout_Type.super.ht_type.tp_dict,
        "SetMinimumSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QLayout_SizeConstraint_Type.tp_dict,
        "SetMinimumSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QLayout_SizeConstraint_Type,
        (long) QLayout::SetFixedSize, "SetFixedSize");
    PyDict_SetItemString(SbkQLayout_Type.super.ht_type.tp_dict,
        "SetFixedSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QLayout_SizeConstraint_Type.tp_dict,
        "SetFixedSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QLayout_SizeConstraint_Type,
        (long) QLayout::SetMaximumSize, "SetMaximumSize");
    PyDict_SetItemString(SbkQLayout_Type.super.ht_type.tp_dict,
        "SetMaximumSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QLayout_SizeConstraint_Type.tp_dict,
        "SetMaximumSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QLayout_SizeConstraint_Type,
        (long) QLayout::SetMinAndMaxSize, "SetMinAndMaxSize");
    PyDict_SetItemString(SbkQLayout_Type.super.ht_type.tp_dict,
        "SetMinAndMaxSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QLayout_SizeConstraint_Type.tp_dict,
        "SetMinAndMaxSize", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QLayout::SizeConstraint");

    Shiboken::TypeResolver::createObjectTypeResolver<QLayout >("QLayout*");
    Shiboken::TypeResolver::createObjectTypeResolver<QLayout >(typeid(QLayout).name());
}


} // extern "C"

