/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qitemeditorfactory_wrapper.h"

// Extra includes
#include <qbytearray.h>
#include <qitemeditorfactory.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QItemEditorFactoryWrapper::QItemEditorFactoryWrapper() : QItemEditorFactory() {
    // ... middle
}

QWidget * QItemEditorFactoryWrapper::createEditor(QVariant::Type type, QWidget * parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createEditor"));
    if (py_override.isNull()) {
        return this->QItemEditorFactory::createEditor(type, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QVariant::Type >::toPython(type),
        Shiboken::Converter<QWidget * >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QWidget * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QItemEditorFactory.createEditor", SbkType<QWidget * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QWidget * cpp_result(Shiboken::Converter<QWidget * >::toCpp(py_result));
    return cpp_result;
}

QByteArray QItemEditorFactoryWrapper::valuePropertyName(QVariant::Type type) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "valuePropertyName"));
    if (py_override.isNull()) {
        return this->QItemEditorFactory::valuePropertyName(type);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QVariant::Type >::toPython(type)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QByteArray();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QByteArray >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QItemEditorFactory.valuePropertyName", SbkType<QByteArray >()->tp_name, py_result->ob_type->tp_name);
        return QByteArray();
    }
    QByteArray cpp_result(Shiboken::Converter<QByteArray >::toCpp(py_result));
    return cpp_result;
}

QItemEditorFactoryWrapper::~QItemEditorFactoryWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQItemEditorFactory_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QItemEditorFactoryWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    // QItemEditorFactory()
    cptr = new QItemEditorFactoryWrapper();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QItemEditorFactory >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkQItemEditorFactoryFunc_createEditor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "createEditor", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QVariant::Type >::isConvertible(pyargs[0]) && Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
        QVariant::Type cpp_arg0 = Shiboken::Converter<QVariant::Type >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
        // createEditor(QVariant::Type,QWidget*)const
        QItemEditorFactory* cppSelf = Shiboken::Converter<QItemEditorFactory* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QItemEditorFactory::createEditor(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQItemEditorFactoryFunc_createEditor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemEditorFactoryFunc_createEditor_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant.Type, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemEditorFactory.createEditor", overloads);
        return 0;
}

static PyObject* SbkQItemEditorFactoryFunc_defaultFactory(PyObject* self)
{
    PyObject* py_result = 0;

    // defaultFactory()
    const QItemEditorFactory * cpp_result = QItemEditorFactory::defaultFactory();
    py_result = Shiboken::Converter<QItemEditorFactory * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQItemEditorFactoryFunc_registerEditor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "registerEditor", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QVariant::Type >::isConvertible(pyargs[0]) && Shiboken::Converter<QItemEditorCreatorBase * >::isConvertible(pyargs[1])) {
        QVariant::Type cpp_arg0 = Shiboken::Converter<QVariant::Type >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QItemEditorCreatorBase* cpp_arg1 = Shiboken::Converter<QItemEditorCreatorBase* >::toCpp(pyargs[1]);
        // registerEditor(QVariant::Type,QItemEditorCreatorBase*)
        QItemEditorFactory* cppSelf = Shiboken::Converter<QItemEditorFactory* >::toCpp((PyObject*)self);
        cppSelf->QItemEditorFactory::registerEditor(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQItemEditorFactoryFunc_registerEditor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemEditorFactoryFunc_registerEditor_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant.Type, PySide.QtGui.QItemEditorCreatorBase", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemEditorFactory.registerEditor", overloads);
        return 0;
}

static PyObject* SbkQItemEditorFactoryFunc_setDefaultFactory(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QItemEditorFactory * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemEditorFactory* cpp_arg0 = Shiboken::Converter<QItemEditorFactory* >::toCpp(arg);
        // setDefaultFactory(QItemEditorFactory*)
        QItemEditorFactory::setDefaultFactory(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQItemEditorFactoryFunc_setDefaultFactory_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemEditorFactoryFunc_setDefaultFactory_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemEditorFactory", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemEditorFactory.setDefaultFactory", overloads);
        return 0;
}

static PyObject* SbkQItemEditorFactoryFunc_valuePropertyName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QVariant::Type >::isConvertible(arg)) {
        QVariant::Type cpp_arg0 = Shiboken::Converter<QVariant::Type >::toCpp(arg);
        // valuePropertyName(QVariant::Type)const
        QItemEditorFactory* cppSelf = Shiboken::Converter<QItemEditorFactory* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QItemEditorFactory::valuePropertyName(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemEditorFactoryFunc_valuePropertyName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemEditorFactoryFunc_valuePropertyName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant.Type", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemEditorFactory.valuePropertyName", overloads);
        return 0;
}

static PyMethodDef SbkQItemEditorFactory_methods[] = {
    {"createEditor", (PyCFunction)SbkQItemEditorFactoryFunc_createEditor, METH_VARARGS},
    {"defaultFactory", (PyCFunction)SbkQItemEditorFactoryFunc_defaultFactory, METH_NOARGS|METH_STATIC},
    {"registerEditor", (PyCFunction)SbkQItemEditorFactoryFunc_registerEditor, METH_VARARGS},
    {"setDefaultFactory", (PyCFunction)SbkQItemEditorFactoryFunc_setDefaultFactory, METH_O|METH_STATIC},
    {"valuePropertyName", (PyCFunction)SbkQItemEditorFactoryFunc_valuePropertyName, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQItemEditorFactory_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QItemEditorFactory",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQItemEditorFactory_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQItemEditorFactory_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QItemEditorFactory >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQItemEditorFactory_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQItemEditorFactory_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QItemEditorFactory*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void) init_QItemEditorFactory(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QITEMEDITORFACTORY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQItemEditorFactory_Type);

    // Fill type discovery information
    SbkQItemEditorFactory_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQItemEditorFactory_Type.type_discovery->addTypeDiscoveryFunction(&SbkQItemEditorFactory_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQItemEditorFactory_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQItemEditorFactory_Type));
    PyModule_AddObject(module, "QItemEditorFactory",
        ((PyObject*)&SbkQItemEditorFactory_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QItemEditorFactory >("QItemEditorFactory*");
    Shiboken::TypeResolver::createObjectTypeResolver<QItemEditorFactory >(typeid(QItemEditorFactory).name());
}


} // extern "C"

