/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qgraphicssceneresizeevent_wrapper.h"

// Extra includes
#include <qsize.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGraphicsSceneResizeEventWrapper::QGraphicsSceneResizeEventWrapper() : QGraphicsSceneResizeEvent() {
    // ... middle
}

QGraphicsSceneResizeEventWrapper::~QGraphicsSceneResizeEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQGraphicsSceneResizeEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsSceneResizeEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    // QGraphicsSceneResizeEvent()
    cptr = new QGraphicsSceneResizeEventWrapper();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QGraphicsSceneResizeEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkQGraphicsSceneResizeEventFunc_newSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // newSize()const
    QGraphicsSceneResizeEvent* cppSelf = Shiboken::Converter<QGraphicsSceneResizeEvent* >::toCpp((PyObject*)self);
    QSizeF cpp_result = cppSelf->QGraphicsSceneResizeEvent::newSize();
    py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneResizeEventFunc_oldSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // oldSize()const
    QGraphicsSceneResizeEvent* cppSelf = Shiboken::Converter<QGraphicsSceneResizeEvent* >::toCpp((PyObject*)self);
    QSizeF cpp_result = cppSelf->QGraphicsSceneResizeEvent::oldSize();
    py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsSceneResizeEventFunc_setNewSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSizeF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QSizeF > cpp_arg0_auto_ptr;
        QSizeF* cpp_arg0 = Shiboken::Converter<QSizeF* >::toCpp(arg);
        if (!SbkQSizeF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg0);
        // setNewSize(QSizeF)
        QGraphicsSceneResizeEvent* cppSelf = Shiboken::Converter<QGraphicsSceneResizeEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneResizeEvent::setNewSize(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneResizeEventFunc_setNewSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneResizeEventFunc_setNewSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSizeF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneResizeEvent.setNewSize", overloads);
        return 0;
}

static PyObject* SbkQGraphicsSceneResizeEventFunc_setOldSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSizeF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QSizeF > cpp_arg0_auto_ptr;
        QSizeF* cpp_arg0 = Shiboken::Converter<QSizeF* >::toCpp(arg);
        if (!SbkQSizeF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg0);
        // setOldSize(QSizeF)
        QGraphicsSceneResizeEvent* cppSelf = Shiboken::Converter<QGraphicsSceneResizeEvent* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsSceneResizeEvent::setOldSize(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsSceneResizeEventFunc_setOldSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsSceneResizeEventFunc_setOldSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSizeF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsSceneResizeEvent.setOldSize", overloads);
        return 0;
}

static PyMethodDef SbkQGraphicsSceneResizeEvent_methods[] = {
    {"newSize", (PyCFunction)SbkQGraphicsSceneResizeEventFunc_newSize, METH_NOARGS},
    {"oldSize", (PyCFunction)SbkQGraphicsSceneResizeEventFunc_oldSize, METH_NOARGS},
    {"setNewSize", (PyCFunction)SbkQGraphicsSceneResizeEventFunc_setNewSize, METH_O},
    {"setOldSize", (PyCFunction)SbkQGraphicsSceneResizeEventFunc_setOldSize, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsSceneResizeEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGraphicsSceneResizeEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsSceneResizeEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsSceneResizeEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QGraphicsSceneResizeEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQGraphicsSceneResizeEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQGraphicsSceneResizeEvent_Type);
     if ( reinterpret_cast<QGraphicsSceneResizeEvent*>(cptr)->type() == QEvent::GraphicsSceneResize)
        return &SbkQGraphicsSceneResizeEvent_Type;
    return 0;
}


PyAPI_FUNC(void) init_QGraphicsSceneResizeEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENERESIZEEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsSceneResizeEvent_Type);

    SbkQGraphicsSceneResizeEvent_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGRAPHICSSCENEEVENT_IDX];
    // Fill type discovery information
    SbkQGraphicsSceneResizeEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;
    SbkQGraphicsSceneResizeEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQGraphicsSceneResizeEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsSceneResizeEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsSceneResizeEvent_Type));
    PyModule_AddObject(module, "QGraphicsSceneResizeEvent",
        ((PyObject*)&SbkQGraphicsSceneResizeEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsSceneResizeEvent >("QGraphicsSceneResizeEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsSceneResizeEvent >(typeid(QGraphicsSceneResizeEvent).name());
}


} // extern "C"

