/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qgraphicseffect_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qgraphicseffect.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGraphicsEffectWrapper::QGraphicsEffectWrapper(QObject * parent) : QGraphicsEffect(parent), m_metaObject(0) {
    // ... middle
}

QRectF QGraphicsEffectWrapper::boundingRectFor(const QRectF & sourceRect) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "boundingRectFor"));
    if (py_override.isNull()) {
        return this->QGraphicsEffect::boundingRectFor(sourceRect);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QRectF & >::toPython(sourceRect)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRectF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRectF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsEffect.boundingRectFor", SbkType<QRectF >()->tp_name, py_result->ob_type->tp_name);
        return QRectF();
    }
    QRectF cpp_result(Shiboken::Converter<QRectF >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsEffectWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsEffectWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsEffectWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsEffectWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsEffectWrapper::draw(QPainter * painter)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "draw"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGraphicsEffect.draw()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPainter * >::toPython(painter)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsEffectWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsEffect.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QGraphicsEffectWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsEffect.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QGraphicsEffectWrapper::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sourceChanged"));
    if (py_override.isNull()) {
        return this->QGraphicsEffect::sourceChanged(flags);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::toPython(flags)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsEffectWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QGraphicsEffectWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QGraphicsEffect::staticMetaObject);
}
    return m_metaObject;
}

int QGraphicsEffectWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QGraphicsEffect::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QGraphicsEffectWrapper::~QGraphicsEffectWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQGraphicsEffect_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsEffectWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSEFFECT_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QGraphicsEffect' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QGraphicsEffect", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QGraphicsEffect(QObject*)
        cptr = new QGraphicsEffectWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QGraphicsEffect(QObject*)
        cptr = new QGraphicsEffectWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQGraphicsEffect_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QGraphicsEffect >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGraphicsEffect_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQGraphicsEffect_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsEffect", overloads);
        return -1;
}

static PyObject* SbkQGraphicsEffectFunc_boundingRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // boundingRect()const
    QGraphicsEffect* cppSelf = Shiboken::Converter<QGraphicsEffect* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QGraphicsEffect::boundingRect();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsEffectFunc_boundingRectFor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRectF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!SbkQRectF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // boundingRectFor(QRectF)const
        QGraphicsEffect* cppSelf = Shiboken::Converter<QGraphicsEffect* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QGraphicsEffect::boundingRectFor(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsEffectFunc_boundingRectFor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsEffectFunc_boundingRectFor_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsEffect.boundingRectFor", overloads);
        return 0;
}

static PyObject* SbkQGraphicsEffectFunc_draw(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPainter * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(arg);
        // draw(QPainter*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGraphicsEffect.draw()' not implemented.");
            return 0;
        }
        QGraphicsEffect* cppSelf = Shiboken::Converter<QGraphicsEffect* >::toCpp((PyObject*)self);
        cppSelf->draw(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsEffectFunc_draw_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsEffectFunc_draw_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsEffect.draw", overloads);
        return 0;
}

static PyObject* SbkQGraphicsEffectFunc_drawSource(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPainter * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(arg);
        // drawSource(QPainter*)
        QGraphicsEffect* cppSelf = Shiboken::Converter<QGraphicsEffect* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsEffect::drawSource(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsEffectFunc_drawSource_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsEffectFunc_drawSource_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsEffect.drawSource", overloads);
        return 0;
}

static PyObject* SbkQGraphicsEffectFunc_isEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEnabled()const
    QGraphicsEffect* cppSelf = Shiboken::Converter<QGraphicsEffect* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGraphicsEffect::isEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsEffectFunc_setEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setEnabled(bool)
        QGraphicsEffect* cppSelf = Shiboken::Converter<QGraphicsEffect* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsEffect::setEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsEffectFunc_setEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsEffectFunc_setEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsEffect.setEnabled", overloads);
        return 0;
}

static PyObject* SbkQGraphicsEffectFunc_sourceBoundingRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // sourceBoundingRect(Qt::CoordinateSystem)const
        QGraphicsEffect* cppSelf = Shiboken::Converter<QGraphicsEffect* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QGraphicsEffect::sourceBoundingRect();
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<Qt::CoordinateSystem >::isConvertible(arg)) {
        Qt::CoordinateSystem cpp_arg0 = Shiboken::Converter<Qt::CoordinateSystem >::toCpp(arg);
        // sourceBoundingRect(Qt::CoordinateSystem)const
        QGraphicsEffect* cppSelf = Shiboken::Converter<QGraphicsEffect* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QGraphicsEffect::sourceBoundingRect(cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsEffectFunc_sourceBoundingRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsEffectFunc_sourceBoundingRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.CoordinateSystem = Qt.LogicalCoordinates", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsEffect.sourceBoundingRect", overloads);
        return 0;
}

static PyObject* SbkQGraphicsEffectFunc_sourceChanged(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_Check(arg)) {
        QFlags<QGraphicsEffect::ChangeFlag> cpp_arg0 = Shiboken::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::toCpp(arg);
        // sourceChanged(QFlags<QGraphicsEffect::ChangeFlag>)
        QGraphicsEffect* cppSelf = Shiboken::Converter<QGraphicsEffect* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsEffect::sourceChanged(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsEffectFunc_sourceChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsEffectFunc_sourceChanged_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsEffect.ChangeFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsEffect.sourceChanged", overloads);
        return 0;
}

static PyObject* SbkQGraphicsEffectFunc_sourceIsPixmap(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sourceIsPixmap()const
    QGraphicsEffect* cppSelf = Shiboken::Converter<QGraphicsEffect* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGraphicsEffect::sourceIsPixmap();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsEffectFunc_sourcePixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "sourcePixmap", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 0) {
        // sourcePixmap(Qt::CoordinateSystem,QPoint*,QGraphicsEffect::PixmapPadMode)const
        QGraphicsEffect* cppSelf = Shiboken::Converter<QGraphicsEffect* >::toCpp((PyObject*)self);
        QPixmap cpp_result = cppSelf->QGraphicsEffect::sourcePixmap();
        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<Qt::CoordinateSystem >::isConvertible(pyargs[0])) {
        Qt::CoordinateSystem cpp_arg0 = Shiboken::Converter<Qt::CoordinateSystem >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // sourcePixmap(Qt::CoordinateSystem,QPoint*,QGraphicsEffect::PixmapPadMode)const
            QGraphicsEffect* cppSelf = Shiboken::Converter<QGraphicsEffect* >::toCpp((PyObject*)self);
            QPixmap cpp_result = cppSelf->QGraphicsEffect::sourcePixmap(cpp_arg0);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QPoint * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // sourcePixmap(Qt::CoordinateSystem,QPoint*,QGraphicsEffect::PixmapPadMode)const
                QGraphicsEffect* cppSelf = Shiboken::Converter<QGraphicsEffect* >::toCpp((PyObject*)self);
                QPixmap cpp_result = cppSelf->QGraphicsEffect::sourcePixmap(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QGraphicsEffect::PixmapPadMode >::isConvertible(pyargs[2])) {
                QGraphicsEffect::PixmapPadMode cpp_arg2 = Shiboken::Converter<QGraphicsEffect::PixmapPadMode >::toCpp(pyargs[2]);
                // sourcePixmap(Qt::CoordinateSystem,QPoint*,QGraphicsEffect::PixmapPadMode)const
                QGraphicsEffect* cppSelf = Shiboken::Converter<QGraphicsEffect* >::toCpp((PyObject*)self);
                QPixmap cpp_result = cppSelf->QGraphicsEffect::sourcePixmap(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQGraphicsEffectFunc_sourcePixmap_TypeError;
        } else goto SbkQGraphicsEffectFunc_sourcePixmap_TypeError;
    } else goto SbkQGraphicsEffectFunc_sourcePixmap_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsEffectFunc_sourcePixmap_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.CoordinateSystem = Qt.LogicalCoordinates, PySide.QtCore.QPoint = None, PySide.QtGui.QGraphicsEffect.PixmapPadMode = PadToEffectiveBoundingRect", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsEffect.sourcePixmap", overloads);
        return 0;
}

static PyObject* SbkQGraphicsEffectFunc_update(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // update()
    QGraphicsEffect* cppSelf = Shiboken::Converter<QGraphicsEffect* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsEffect::update();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGraphicsEffectFunc_updateBoundingRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // updateBoundingRect()
    QGraphicsEffect* cppSelf = Shiboken::Converter<QGraphicsEffect* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsEffect::updateBoundingRect();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQGraphicsEffect_methods[] = {
    {"boundingRect", (PyCFunction)SbkQGraphicsEffectFunc_boundingRect, METH_NOARGS},
    {"boundingRectFor", (PyCFunction)SbkQGraphicsEffectFunc_boundingRectFor, METH_O},
    {"draw", (PyCFunction)SbkQGraphicsEffectFunc_draw, METH_O},
    {"drawSource", (PyCFunction)SbkQGraphicsEffectFunc_drawSource, METH_O},
    {"isEnabled", (PyCFunction)SbkQGraphicsEffectFunc_isEnabled, METH_NOARGS},
    {"setEnabled", (PyCFunction)SbkQGraphicsEffectFunc_setEnabled, METH_O},
    {"sourceBoundingRect", (PyCFunction)SbkQGraphicsEffectFunc_sourceBoundingRect, METH_NOARGS|METH_O},
    {"sourceChanged", (PyCFunction)SbkQGraphicsEffectFunc_sourceChanged, METH_O},
    {"sourceIsPixmap", (PyCFunction)SbkQGraphicsEffectFunc_sourceIsPixmap, METH_NOARGS},
    {"sourcePixmap", (PyCFunction)SbkQGraphicsEffectFunc_sourcePixmap, METH_VARARGS},
    {"update", (PyCFunction)SbkQGraphicsEffectFunc_update, METH_NOARGS},
    {"updateBoundingRect", (PyCFunction)SbkQGraphicsEffectFunc_updateBoundingRect, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsEffect_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGraphicsEffect",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsEffect_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsEffect_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QGraphicsEffect >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QGraphicsEffect_PixmapPadMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGraphicsEffect_PixmapPadMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGraphicsEffect_PixmapPadMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PixmapPadMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QGraphicsEffect_PixmapPadMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGraphicsEffect_PixmapPadMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QGraphicsEffect_PixmapPadMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QGraphicsEffect_ChangeFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsEffect::ChangeFlags >::toPython(
        ((QGraphicsEffect::ChangeFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QGraphicsEffect::ChangeFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGraphicsEffect_ChangeFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsEffect::ChangeFlags >::toPython(
        ((QGraphicsEffect::ChangeFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QGraphicsEffect::ChangeFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGraphicsEffect_ChangeFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsEffect::ChangeFlags >::toPython(
        ((QGraphicsEffect::ChangeFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QGraphicsEffect::ChangeFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGraphicsEffect_ChangeFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsEffect::ChangeFlags >::toPython(
        ~ Shiboken::Converter< QGraphicsEffect::ChangeFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QGraphicsEffect_ChangeFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QGraphicsEffect_ChangeFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QGraphicsEffect_ChangeFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QGraphicsEffect_ChangeFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ChangeFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGraphicsEffect_ChangeFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGraphicsEffect_ChangeFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ChangeFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGraphicsEffect_ChangeFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QGraphicsEffect_ChangeFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QGraphicsEffect_ChangeFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QGraphicsEffect(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSEFFECT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsEffect_Type);

    SbkQGraphicsEffect_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQGraphicsEffect_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsEffect_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsEffect_Type));
    PyModule_AddObject(module, "QGraphicsEffect",
        ((PyObject*)&SbkQGraphicsEffect_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: PixmapPadMode
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSEFFECT_PIXMAPPADMODE_IDX] = &SbkPySide_QtGui_QGraphicsEffect_PixmapPadMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGraphicsEffect_PixmapPadMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGraphicsEffect_PixmapPadMode_Type);
    PyDict_SetItemString(SbkQGraphicsEffect_Type.super.ht_type.tp_dict,
            "PixmapPadMode",((PyObject*)&SbkPySide_QtGui_QGraphicsEffect_PixmapPadMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsEffect_PixmapPadMode_Type,
        (long) QGraphicsEffect::NoPad, "NoPad");
    PyDict_SetItemString(SbkQGraphicsEffect_Type.super.ht_type.tp_dict,
        "NoPad", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsEffect_PixmapPadMode_Type.tp_dict,
        "NoPad", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsEffect_PixmapPadMode_Type,
        (long) QGraphicsEffect::PadToTransparentBorder, "PadToTransparentBorder");
    PyDict_SetItemString(SbkQGraphicsEffect_Type.super.ht_type.tp_dict,
        "PadToTransparentBorder", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsEffect_PixmapPadMode_Type.tp_dict,
        "PadToTransparentBorder", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsEffect_PixmapPadMode_Type,
        (long) QGraphicsEffect::PadToEffectiveBoundingRect, "PadToEffectiveBoundingRect");
    PyDict_SetItemString(SbkQGraphicsEffect_Type.super.ht_type.tp_dict,
        "PadToEffectiveBoundingRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsEffect_PixmapPadMode_Type.tp_dict,
        "PadToEffectiveBoundingRect", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGraphicsEffect::PixmapPadMode");

    // init enum class: ChangeFlag
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSEFFECT_CHANGEFLAG_IDX] = &SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_Type);
    PyDict_SetItemString(SbkQGraphicsEffect_Type.super.ht_type.tp_dict,
            "ChangeFlag",((PyObject*)&SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_Type));

    // init flags class: QFlags<QGraphicsEffect::ChangeFlag>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG__IDX] = &SbkPySide_QtGui_QGraphicsEffect_ChangeFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGraphicsEffect_ChangeFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGraphicsEffect_ChangeFlags_Type);
    PyDict_SetItemString(SbkQGraphicsEffect_Type.super.ht_type.tp_dict,
            "ChangeFlags",((PyObject*)&SbkPySide_QtGui_QGraphicsEffect_ChangeFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_Type,
        (long) QGraphicsEffect::SourceAttached, "SourceAttached");
    PyDict_SetItemString(SbkQGraphicsEffect_Type.super.ht_type.tp_dict,
        "SourceAttached", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_Type.tp_dict,
        "SourceAttached", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_Type,
        (long) QGraphicsEffect::SourceDetached, "SourceDetached");
    PyDict_SetItemString(SbkQGraphicsEffect_Type.super.ht_type.tp_dict,
        "SourceDetached", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_Type.tp_dict,
        "SourceDetached", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_Type,
        (long) QGraphicsEffect::SourceBoundingRectChanged, "SourceBoundingRectChanged");
    PyDict_SetItemString(SbkQGraphicsEffect_Type.super.ht_type.tp_dict,
        "SourceBoundingRectChanged", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_Type.tp_dict,
        "SourceBoundingRectChanged", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_Type,
        (long) QGraphicsEffect::SourceInvalidated, "SourceInvalidated");
    PyDict_SetItemString(SbkQGraphicsEffect_Type.super.ht_type.tp_dict,
        "SourceInvalidated", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsEffect_ChangeFlag_Type.tp_dict,
        "SourceInvalidated", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGraphicsEffect::ChangeFlag");

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsEffect >("QGraphicsEffect*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsEffect >(typeid(QGraphicsEffect).name());
}


} // extern "C"

