/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qfontmetricsf_wrapper.h"

// Extra includes
#include <qchar.h>
#include <qfont.h>
#include <qfontmetrics.h>
#include <qpaintdevice.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQFontMetricsF_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QFontMetricsF* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QFontMetricsF", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (Shiboken::Converter<QFont & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(pyargs[0]);
        if (!SbkQFont_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        if (numArgs == 1) {
            // QFontMetricsF(QFont)
            cptr = new QFontMetricsF(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QPaintDevice * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QPaintDevice* cpp_arg1 = Shiboken::Converter<QPaintDevice* >::toCpp(pyargs[1]);
            // QFontMetricsF(QFont,QPaintDevice*)
            cptr = new QFontMetricsF(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQFontMetricsF_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QFontMetrics & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QFontMetrics > cpp_arg0_auto_ptr;
        QFontMetrics* cpp_arg0 = Shiboken::Converter<QFontMetrics* >::toCpp(pyargs[0]);
        if (!SbkQFontMetrics_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QFontMetrics >(cpp_arg0);
        // QFontMetricsF(QFontMetrics)
        cptr = new QFontMetricsF(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QFontMetricsF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QFontMetricsF > cpp_arg0_auto_ptr;
        QFontMetricsF* cpp_arg0 = Shiboken::Converter<QFontMetricsF* >::toCpp(pyargs[0]);
        if (!SbkQFontMetricsF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QFontMetricsF >(cpp_arg0);
        // QFontMetricsF(QFontMetricsF)
        cptr = new QFontMetricsF(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontMetricsF_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QFontMetricsF >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQFontMetricsF_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQFontMetricsF_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", "PySide.QtGui.QFont, PySide.QtGui.QPaintDevice", "PySide.QtGui.QFontMetrics", "PySide.QtGui.QFontMetricsF", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontMetricsF", overloads);
        return -1;
}

static PyObject* SbkQFontMetricsFFunc_ascent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // ascent()const
    QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFontMetricsF::ascent();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFFunc_averageCharWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // averageCharWidth()const
    QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFontMetricsF::averageCharWidth();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFFunc_boundingRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQFontMetricsFFunc_boundingRect_TypeError;

    if (!PyArg_UnpackTuple(args, "boundingRect", 1, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (Shiboken::Converter<QRectF & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!SbkQString_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (numArgs == 3) {
            // boundingRect(QRectF,int,QString,int,int*)const
            QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
            // Begin code injection
            
            int* array = NULL;
            bool errorOccurred = false;
            
            if (numArgs == 5) {
                array = Shiboken::sequenceToIntArray(pyargs[5-1], true);
                if (PyErr_Occurred()) {
                    if (array)
                        delete []array;
                    errorOccurred = true;
                }
            }
            
            if (!errorOccurred) {
                QRectF retval = cppSelf->boundingRect((*cpp_arg0), cpp_arg1, (*cpp_arg2), 0, array);
            
                if (array)
                    delete []array;
            
                py_result = Shiboken::Converter<QRectF >::toPython(retval);
            }
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // boundingRect(QRectF,int,QString,int,int*)const
                QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
                // Begin code injection
                
                int* array = NULL;
                bool errorOccurred = false;
                
                if (numArgs == 5) {
                    array = Shiboken::sequenceToIntArray(pyargs[5-1], true);
                    if (PyErr_Occurred()) {
                        if (array)
                            delete []array;
                        errorOccurred = true;
                    }
                }
                
                if (!errorOccurred) {
                    QRectF retval = cppSelf->boundingRect((*cpp_arg0), cpp_arg1, (*cpp_arg2), cpp_arg3, array);
                
                    if (array)
                        delete []array;
                
                    py_result = Shiboken::Converter<QRectF >::toPython(retval);
                }
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else if (PyObject_Check(pyargs[4])) {
                // boundingRect(QRectF,int,QString,int,int*)const
                QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
                // Begin code injection
                
                int* array = NULL;
                bool errorOccurred = false;
                
                if (numArgs == 5) {
                    array = Shiboken::sequenceToIntArray(pyargs[5-1], true);
                    if (PyErr_Occurred()) {
                        if (array)
                            delete []array;
                        errorOccurred = true;
                    }
                }
                
                if (!errorOccurred) {
                    QRectF retval = cppSelf->boundingRect((*cpp_arg0), cpp_arg1, (*cpp_arg2), cpp_arg3, array);
                
                    if (array)
                        delete []array;
                
                    py_result = Shiboken::Converter<QRectF >::toPython(retval);
                }
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else goto SbkQFontMetricsFFunc_boundingRect_TypeError;
        } else goto SbkQFontMetricsFFunc_boundingRect_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QChar >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(pyargs[0]);
        if (!SbkQChar_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        // boundingRect(QChar)const
        QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QFontMetricsF::boundingRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // boundingRect(QString)const
        QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QFontMetricsF::boundingRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontMetricsFFunc_boundingRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontMetricsFFunc_boundingRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QChar", "PySide.QtCore.QRectF, int, PySide.QtCore.QString, int = 0, int = 0", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontMetricsF.boundingRect", overloads);
        return 0;
}

static PyObject* SbkQFontMetricsFFunc_descent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // descent()const
    QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFontMetricsF::descent();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFFunc_elidedText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "elidedText", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::TextElideMode >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        Qt::TextElideMode cpp_arg1 = Shiboken::Converter<Qt::TextElideMode >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // elidedText(QString,Qt::TextElideMode,qreal,int)const
            QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QFontMetricsF::elidedText(*cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // elidedText(QString,Qt::TextElideMode,qreal,int)const
            QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QFontMetricsF::elidedText(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQFontMetricsFFunc_elidedText_TypeError;
    } else goto SbkQFontMetricsFFunc_elidedText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontMetricsFFunc_elidedText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.Qt.TextElideMode, float, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontMetricsF.elidedText", overloads);
        return 0;
}

static PyObject* SbkQFontMetricsFFunc_height(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // height()const
    QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFontMetricsF::height();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFFunc_inFont(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QChar >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(arg);
        if (!SbkQChar_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        // inFont(QChar)const
        QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QFontMetricsF::inFont(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontMetricsFFunc_inFont_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontMetricsFFunc_inFont_TypeError:
        const char* overloads[] = {"PySide.QtCore.QChar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontMetricsF.inFont", overloads);
        return 0;
}

static PyObject* SbkQFontMetricsFFunc_leading(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // leading()const
    QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFontMetricsF::leading();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFFunc_leftBearing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QChar >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(arg);
        if (!SbkQChar_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        // leftBearing(QChar)const
        QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QFontMetricsF::leftBearing(*cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontMetricsFFunc_leftBearing_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontMetricsFFunc_leftBearing_TypeError:
        const char* overloads[] = {"PySide.QtCore.QChar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontMetricsF.leftBearing", overloads);
        return 0;
}

static PyObject* SbkQFontMetricsFFunc_lineSpacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lineSpacing()const
    QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFontMetricsF::lineSpacing();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFFunc_lineWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lineWidth()const
    QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFontMetricsF::lineWidth();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFFunc_maxWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maxWidth()const
    QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFontMetricsF::maxWidth();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFFunc_minLeftBearing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minLeftBearing()const
    QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFontMetricsF::minLeftBearing();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFFunc_minRightBearing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minRightBearing()const
    QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFontMetricsF::minRightBearing();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFFunc_overlinePos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // overlinePos()const
    QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFontMetricsF::overlinePos();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFFunc_rightBearing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QChar >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(arg);
        if (!SbkQChar_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        // rightBearing(QChar)const
        QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QFontMetricsF::rightBearing(*cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontMetricsFFunc_rightBearing_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontMetricsFFunc_rightBearing_TypeError:
        const char* overloads[] = {"PySide.QtCore.QChar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontMetricsF.rightBearing", overloads);
        return 0;
}

static PyObject* SbkQFontMetricsFFunc_size(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "size", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // size(int,QString,int,int*)const
            QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
            // Begin code injection
            
            int* array = NULL;
            bool errorOccurred = false;
            
            if (numArgs == 4) {
                array = Shiboken::sequenceToIntArray(pyargs[4-1], true);
                if (PyErr_Occurred()) {
                    if (array)
                        delete []array;
                    errorOccurred = true;
                }
            }
            
            if (!errorOccurred) {
                QSizeF retval = cppSelf->size(cpp_arg0, (*cpp_arg1), 0, array);
            
                if (array)
                    delete []array;
            
                py_result = Shiboken::Converter<QSizeF >::toPython(retval);
            }
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // size(int,QString,int,int*)const
                QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
                // Begin code injection
                
                int* array = NULL;
                bool errorOccurred = false;
                
                if (numArgs == 4) {
                    array = Shiboken::sequenceToIntArray(pyargs[4-1], true);
                    if (PyErr_Occurred()) {
                        if (array)
                            delete []array;
                        errorOccurred = true;
                    }
                }
                
                if (!errorOccurred) {
                    QSizeF retval = cppSelf->size(cpp_arg0, (*cpp_arg1), cpp_arg2, array);
                
                    if (array)
                        delete []array;
                
                    py_result = Shiboken::Converter<QSizeF >::toPython(retval);
                }
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else if (PyObject_Check(pyargs[3])) {
                // size(int,QString,int,int*)const
                QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
                // Begin code injection
                
                int* array = NULL;
                bool errorOccurred = false;
                
                if (numArgs == 4) {
                    array = Shiboken::sequenceToIntArray(pyargs[4-1], true);
                    if (PyErr_Occurred()) {
                        if (array)
                            delete []array;
                        errorOccurred = true;
                    }
                }
                
                if (!errorOccurred) {
                    QSizeF retval = cppSelf->size(cpp_arg0, (*cpp_arg1), cpp_arg2, array);
                
                    if (array)
                        delete []array;
                
                    py_result = Shiboken::Converter<QSizeF >::toPython(retval);
                }
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else goto SbkQFontMetricsFFunc_size_TypeError;
        } else goto SbkQFontMetricsFFunc_size_TypeError;
    } else goto SbkQFontMetricsFFunc_size_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontMetricsFFunc_size_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QString, int = 0, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFontMetricsF.size", overloads);
        return 0;
}

static PyObject* SbkQFontMetricsFFunc_strikeOutPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // strikeOutPos()const
    QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFontMetricsF::strikeOutPos();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFFunc_tightBoundingRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // tightBoundingRect(QString)const
        QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QFontMetricsF::tightBoundingRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontMetricsFFunc_tightBoundingRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontMetricsFFunc_tightBoundingRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontMetricsF.tightBoundingRect", overloads);
        return 0;
}

static PyObject* SbkQFontMetricsFFunc_underlinePos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // underlinePos()const
    QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFontMetricsF::underlinePos();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontMetricsFFunc_width(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QChar >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QChar > cpp_arg0_auto_ptr;
        QChar* cpp_arg0 = Shiboken::Converter<QChar* >::toCpp(arg);
        if (!SbkQChar_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QChar >(cpp_arg0);
        // width(QChar)const
        QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QFontMetricsF::width(*cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // width(QString)const
        QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QFontMetricsF::width(*cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontMetricsFFunc_width_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontMetricsFFunc_width_TypeError:
        const char* overloads[] = {"PySide.QtCore.QChar", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFontMetricsF.width", overloads);
        return 0;
}

static PyObject* SbkQFontMetricsFFunc_xHeight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // xHeight()const
    QFontMetricsF* cppSelf = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFontMetricsF::xHeight();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQFontMetricsF_methods[] = {
    {"ascent", (PyCFunction)SbkQFontMetricsFFunc_ascent, METH_NOARGS},
    {"averageCharWidth", (PyCFunction)SbkQFontMetricsFFunc_averageCharWidth, METH_NOARGS},
    {"boundingRect", (PyCFunction)SbkQFontMetricsFFunc_boundingRect, METH_VARARGS},
    {"descent", (PyCFunction)SbkQFontMetricsFFunc_descent, METH_NOARGS},
    {"elidedText", (PyCFunction)SbkQFontMetricsFFunc_elidedText, METH_VARARGS},
    {"height", (PyCFunction)SbkQFontMetricsFFunc_height, METH_NOARGS},
    {"inFont", (PyCFunction)SbkQFontMetricsFFunc_inFont, METH_O},
    {"leading", (PyCFunction)SbkQFontMetricsFFunc_leading, METH_NOARGS},
    {"leftBearing", (PyCFunction)SbkQFontMetricsFFunc_leftBearing, METH_O},
    {"lineSpacing", (PyCFunction)SbkQFontMetricsFFunc_lineSpacing, METH_NOARGS},
    {"lineWidth", (PyCFunction)SbkQFontMetricsFFunc_lineWidth, METH_NOARGS},
    {"maxWidth", (PyCFunction)SbkQFontMetricsFFunc_maxWidth, METH_NOARGS},
    {"minLeftBearing", (PyCFunction)SbkQFontMetricsFFunc_minLeftBearing, METH_NOARGS},
    {"minRightBearing", (PyCFunction)SbkQFontMetricsFFunc_minRightBearing, METH_NOARGS},
    {"overlinePos", (PyCFunction)SbkQFontMetricsFFunc_overlinePos, METH_NOARGS},
    {"rightBearing", (PyCFunction)SbkQFontMetricsFFunc_rightBearing, METH_O},
    {"size", (PyCFunction)SbkQFontMetricsFFunc_size, METH_VARARGS},
    {"strikeOutPos", (PyCFunction)SbkQFontMetricsFFunc_strikeOutPos, METH_NOARGS},
    {"tightBoundingRect", (PyCFunction)SbkQFontMetricsFFunc_tightBoundingRect, METH_O},
    {"underlinePos", (PyCFunction)SbkQFontMetricsFFunc_underlinePos, METH_NOARGS},
    {"width", (PyCFunction)SbkQFontMetricsFFunc_width, METH_O},
    {"xHeight", (PyCFunction)SbkQFontMetricsFFunc_xHeight, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQFontMetricsF_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QFontMetricsF& cpp_self = *Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QFontMetricsF & >::isConvertible(other)) {
                // operator!=(const QFontMetricsF & other)
                QFontMetricsF* cpp_other = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QFontMetricsF  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QFontMetricsF & >::isConvertible(other)) {
                // operator!=(const QFontMetricsF & other) const
                QFontMetricsF* cpp_other = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QFontMetricsF  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QFontMetricsF >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QFontMetricsF > cpp_other_auto_ptr;
                QFontMetricsF* cpp_other = Shiboken::Converter<QFontMetricsF* >::toCpp(other);
                if (!SbkQFontMetricsF_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QFontMetricsF >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQFontMetricsF_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QFontMetricsF & >::isConvertible(other)) {
                // operator==(const QFontMetricsF & other)
                QFontMetricsF* cpp_other = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QFontMetricsF  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QFontMetricsF & >::isConvertible(other)) {
                // operator==(const QFontMetricsF & other) const
                QFontMetricsF* cpp_other = Shiboken::Converter<QFontMetricsF* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QFontMetricsF  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QFontMetricsF >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QFontMetricsF > cpp_other_auto_ptr;
                QFontMetricsF* cpp_other = Shiboken::Converter<QFontMetricsF* >::toCpp(other);
                if (!SbkQFontMetricsF_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QFontMetricsF >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQFontMetricsF_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQFontMetricsF_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQFontMetricsF_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QFontMetricsF",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQFontMetricsF_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQFontMetricsF_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQFontMetricsF_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QFontMetricsF >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QFontMetricsF(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QFONTMETRICSF_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQFontMetricsF_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQFontMetricsF_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQFontMetricsF_Type));
    PyModule_AddObject(module, "QFontMetricsF",
        ((PyObject*)&SbkQFontMetricsF_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QFontMetricsF >("QFontMetricsF");
    Shiboken::TypeResolver::createValueTypeResolver<QFontMetricsF >(typeid(QFontMetricsF).name());
}


} // extern "C"

