/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qcalendarwidget_wrapper.h"

// Extra includes
#include <QList>
#include <QMap>
#include <QTextCharFormat>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcalendarwidget.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qdatetime.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qtextformat.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QCalendarWidgetWrapper::QCalendarWidgetWrapper(QWidget * parent) : QCalendarWidget(parent), m_metaObject(0) {
    // ... middle
}

void QCalendarWidgetWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCalendarWidgetWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCalendarWidgetWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCalendarWidgetWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCalendarWidgetWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCalendarWidgetWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QWidget::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCalendarWidgetWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QCalendarWidgetWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QCalendarWidget.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QCalendarWidgetWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCalendarWidgetWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCalendarWidgetWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCalendarWidgetWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCalendarWidgetWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCalendarWidgetWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QCalendarWidgetWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QCalendarWidget::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QCalendarWidget.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QCalendarWidgetWrapper::eventFilter(QObject * watched, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QCalendarWidget::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(watched),
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QCalendarWidget.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QCalendarWidgetWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QCalendarWidgetWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QCalendarWidget.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QCalendarWidgetWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QCalendarWidgetWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QCalendarWidget.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QCalendarWidgetWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCalendarWidgetWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QCalendarWidgetWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QCalendarWidget.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QCalendarWidgetWrapper::keyPressEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QCalendarWidget::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCalendarWidgetWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCalendarWidgetWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCalendarWidgetWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QCalendarWidgetWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QCalendarWidget.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QCalendarWidgetWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QCalendarWidget::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QCalendarWidget.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QCalendarWidgetWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCalendarWidgetWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCalendarWidgetWrapper::mousePressEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QCalendarWidget::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCalendarWidgetWrapper::mouseReleaseEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCalendarWidgetWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCalendarWidgetWrapper::paintCell(QPainter * painter, const QRect & rect, const QDate & date) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintCell"));
    if (py_override.isNull()) {
        return this->QCalendarWidget::paintCell(painter, rect, date);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QPainter * >::toPython(painter),
        Shiboken::Converter<QRect & >::toPython(rect),
        Shiboken::Converter<QDate & >::toPython(date)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QCalendarWidgetWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QCalendarWidget.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QCalendarWidgetWrapper::paintEvent(QPaintEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QWidget::paintEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCalendarWidgetWrapper::resizeEvent(QResizeEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QCalendarWidget::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCalendarWidgetWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCalendarWidgetWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSize QCalendarWidgetWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QCalendarWidget::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QCalendarWidget.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QCalendarWidgetWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCalendarWidgetWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCalendarWidgetWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QWidget::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QCalendarWidgetWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QCalendarWidget::staticMetaObject);
}
    return m_metaObject;
}

int QCalendarWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QCalendarWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QCalendarWidgetWrapper::~QCalendarWidgetWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQCalendarWidget_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QCalendarWidgetWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QCalendarWidget", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QCalendarWidget(QWidget*)
        cptr = new QCalendarWidgetWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QCalendarWidget(QWidget*)
        cptr = new QCalendarWidgetWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQCalendarWidget_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QCalendarWidget >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQCalendarWidget_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQCalendarWidget_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCalendarWidget", overloads);
        return -1;
}

static PyObject* SbkQCalendarWidgetFunc_dateEditAcceptDelay(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dateEditAcceptDelay()const
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QCalendarWidget::dateEditAcceptDelay();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCalendarWidgetFunc_dateTextFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // dateTextFormat()const
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        QMap<QDate, QTextCharFormat > cpp_result = cppSelf->QCalendarWidget::dateTextFormat();
        py_result = Shiboken::Converter<QMap<QDate, QTextCharFormat > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QDate & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(arg);
        // dateTextFormat(QDate)const
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        QTextCharFormat cpp_result = cppSelf->QCalendarWidget::dateTextFormat(*cpp_arg0);
        py_result = Shiboken::Converter<QTextCharFormat >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_dateTextFormat_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQCalendarWidgetFunc_dateTextFormat_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QDate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.dateTextFormat", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QCalendarWidget::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQCalendarWidgetFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.event", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_eventFilter(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0]) && Shiboken::Converter<QEvent * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QEvent* cpp_arg1 = Shiboken::Converter<QEvent* >::toCpp(pyargs[1]);
        // eventFilter(QObject*,QEvent*)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QCalendarWidget::eventFilter(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_eventFilter_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQCalendarWidgetFunc_eventFilter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCalendarWidget.eventFilter", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_firstDayOfWeek(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // firstDayOfWeek()const
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    Qt::DayOfWeek cpp_result = cppSelf->QCalendarWidget::firstDayOfWeek();
    py_result = Shiboken::Converter<Qt::DayOfWeek >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCalendarWidgetFunc_headerTextFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // headerTextFormat()const
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    QTextCharFormat cpp_result = cppSelf->QCalendarWidget::headerTextFormat();
    py_result = Shiboken::Converter<QTextCharFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCalendarWidgetFunc_horizontalHeaderFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // horizontalHeaderFormat()const
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    QCalendarWidget::HorizontalHeaderFormat cpp_result = cppSelf->QCalendarWidget::horizontalHeaderFormat();
    py_result = Shiboken::Converter<QCalendarWidget::HorizontalHeaderFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCalendarWidgetFunc_isDateEditEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isDateEditEnabled()const
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QCalendarWidget::isDateEditEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCalendarWidgetFunc_isGridVisible(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isGridVisible()const
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QCalendarWidget::isGridVisible();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCalendarWidgetFunc_isNavigationBarVisible(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNavigationBarVisible()const
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QCalendarWidget::isNavigationBarVisible();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCalendarWidgetFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::keyPressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.keyPressEvent", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_maximumDate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumDate()const
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    QDate cpp_result = cppSelf->QCalendarWidget::maximumDate();
    py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCalendarWidgetFunc_minimumDate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumDate()const
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    QDate cpp_result = cppSelf->QCalendarWidget::minimumDate();
    py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCalendarWidgetFunc_minimumSizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSizeHint()const
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QCalendarWidget::minimumSizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCalendarWidgetFunc_monthShown(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // monthShown()const
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QCalendarWidget::monthShown();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCalendarWidgetFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mousePressEvent(QMouseEvent*)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::mousePressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.mousePressEvent", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_paintCell(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "paintCell", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QRect & >::isConvertible(pyargs[1]) && Shiboken::Converter<QDate & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QRect* cpp_arg1 = Shiboken::Converter<QRect* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QDate* cpp_arg2 = Shiboken::Converter<QDate* >::toCpp(pyargs[2]);
        // paintCell(QPainter*,QRect,QDate)const
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::paintCell(cpp_arg0, *cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_paintCell_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_paintCell_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRect, PySide.QtCore.QDate", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCalendarWidget.paintCell", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QResizeEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QResizeEvent* cpp_arg0 = Shiboken::Converter<QResizeEvent* >::toCpp(arg);
        // resizeEvent(QResizeEvent*)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::resizeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.resizeEvent", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_selectedDate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectedDate()const
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    QDate cpp_result = cppSelf->QCalendarWidget::selectedDate();
    py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCalendarWidgetFunc_selectionMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectionMode()const
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    QCalendarWidget::SelectionMode cpp_result = cppSelf->QCalendarWidget::selectionMode();
    py_result = Shiboken::Converter<QCalendarWidget::SelectionMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCalendarWidgetFunc_setCurrentPage(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setCurrentPage", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setCurrentPage(int,int)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::setCurrentPage(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_setCurrentPage_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_setCurrentPage_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCalendarWidget.setCurrentPage", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_setDateEditAcceptDelay(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setDateEditAcceptDelay(int)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::setDateEditAcceptDelay(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_setDateEditAcceptDelay_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_setDateEditAcceptDelay_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.setDateEditAcceptDelay", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_setDateEditEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDateEditEnabled(bool)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::setDateEditEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_setDateEditEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_setDateEditEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.setDateEditEnabled", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_setDateRange(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setDateRange", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QDate & >::isConvertible(pyargs[0]) && Shiboken::Converter<QDate & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QDate* cpp_arg1 = Shiboken::Converter<QDate* >::toCpp(pyargs[1]);
        // setDateRange(QDate,QDate)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::setDateRange(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_setDateRange_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_setDateRange_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDate, PySide.QtCore.QDate", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCalendarWidget.setDateRange", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_setDateTextFormat(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setDateTextFormat", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QDate & >::isConvertible(pyargs[0]) && Shiboken::Converter<QTextCharFormat & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QTextCharFormat* cpp_arg1 = Shiboken::Converter<QTextCharFormat* >::toCpp(pyargs[1]);
        // setDateTextFormat(QDate,QTextCharFormat)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::setDateTextFormat(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_setDateTextFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_setDateTextFormat_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDate, PySide.QtGui.QTextCharFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCalendarWidget.setDateTextFormat", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_setFirstDayOfWeek(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::DayOfWeek >::isConvertible(arg)) {
        Qt::DayOfWeek cpp_arg0 = Shiboken::Converter<Qt::DayOfWeek >::toCpp(arg);
        // setFirstDayOfWeek(Qt::DayOfWeek)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::setFirstDayOfWeek(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_setFirstDayOfWeek_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_setFirstDayOfWeek_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DayOfWeek", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.setFirstDayOfWeek", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_setGridVisible(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setGridVisible(bool)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::setGridVisible(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_setGridVisible_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_setGridVisible_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.setGridVisible", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_setHeaderTextFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextCharFormat & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCharFormat* cpp_arg0 = Shiboken::Converter<QTextCharFormat* >::toCpp(arg);
        // setHeaderTextFormat(QTextCharFormat)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::setHeaderTextFormat(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_setHeaderTextFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_setHeaderTextFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCharFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.setHeaderTextFormat", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_setHorizontalHeaderFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QCalendarWidget::HorizontalHeaderFormat >::isConvertible(arg)) {
        QCalendarWidget::HorizontalHeaderFormat cpp_arg0 = Shiboken::Converter<QCalendarWidget::HorizontalHeaderFormat >::toCpp(arg);
        // setHorizontalHeaderFormat(QCalendarWidget::HorizontalHeaderFormat)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::setHorizontalHeaderFormat(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_setHorizontalHeaderFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_setHorizontalHeaderFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QCalendarWidget.HorizontalHeaderFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.setHorizontalHeaderFormat", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_setMaximumDate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDate & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(arg);
        // setMaximumDate(QDate)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::setMaximumDate(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_setMaximumDate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_setMaximumDate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.setMaximumDate", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_setMinimumDate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDate & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(arg);
        // setMinimumDate(QDate)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::setMinimumDate(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_setMinimumDate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_setMinimumDate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.setMinimumDate", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_setNavigationBarVisible(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setNavigationBarVisible(bool)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::setNavigationBarVisible(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_setNavigationBarVisible_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_setNavigationBarVisible_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.setNavigationBarVisible", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_setSelectedDate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDate & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(arg);
        // setSelectedDate(QDate)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::setSelectedDate(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_setSelectedDate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_setSelectedDate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.setSelectedDate", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_setSelectionMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QCalendarWidget::SelectionMode >::isConvertible(arg)) {
        QCalendarWidget::SelectionMode cpp_arg0 = Shiboken::Converter<QCalendarWidget::SelectionMode >::toCpp(arg);
        // setSelectionMode(QCalendarWidget::SelectionMode)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::setSelectionMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_setSelectionMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_setSelectionMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QCalendarWidget.SelectionMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.setSelectionMode", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_setVerticalHeaderFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QCalendarWidget::VerticalHeaderFormat >::isConvertible(arg)) {
        QCalendarWidget::VerticalHeaderFormat cpp_arg0 = Shiboken::Converter<QCalendarWidget::VerticalHeaderFormat >::toCpp(arg);
        // setVerticalHeaderFormat(QCalendarWidget::VerticalHeaderFormat)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::setVerticalHeaderFormat(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_setVerticalHeaderFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_setVerticalHeaderFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QCalendarWidget.VerticalHeaderFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.setVerticalHeaderFormat", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_setWeekdayTextFormat(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setWeekdayTextFormat", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<Qt::DayOfWeek >::isConvertible(pyargs[0]) && Shiboken::Converter<QTextCharFormat & >::isConvertible(pyargs[1])) {
        Qt::DayOfWeek cpp_arg0 = Shiboken::Converter<Qt::DayOfWeek >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QTextCharFormat* cpp_arg1 = Shiboken::Converter<QTextCharFormat* >::toCpp(pyargs[1]);
        // setWeekdayTextFormat(Qt::DayOfWeek,QTextCharFormat)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::setWeekdayTextFormat(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_setWeekdayTextFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_setWeekdayTextFormat_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DayOfWeek, PySide.QtGui.QTextCharFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCalendarWidget.setWeekdayTextFormat", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_showNextMonth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // showNextMonth()
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    cppSelf->QCalendarWidget::showNextMonth();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQCalendarWidgetFunc_showNextYear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // showNextYear()
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    cppSelf->QCalendarWidget::showNextYear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQCalendarWidgetFunc_showPreviousMonth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // showPreviousMonth()
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    cppSelf->QCalendarWidget::showPreviousMonth();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQCalendarWidgetFunc_showPreviousYear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // showPreviousYear()
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    cppSelf->QCalendarWidget::showPreviousYear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQCalendarWidgetFunc_showSelectedDate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // showSelectedDate()
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    cppSelf->QCalendarWidget::showSelectedDate();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQCalendarWidgetFunc_showToday(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // showToday()
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    cppSelf->QCalendarWidget::showToday();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQCalendarWidgetFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QCalendarWidget::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCalendarWidgetFunc_updateCell(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDate & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(arg);
        // updateCell(QDate)
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        cppSelf->QCalendarWidget::updateCell(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_updateCell_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCalendarWidgetFunc_updateCell_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.updateCell", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_updateCells(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // updateCells()
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    cppSelf->QCalendarWidget::updateCells();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQCalendarWidgetFunc_verticalHeaderFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // verticalHeaderFormat()const
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    QCalendarWidget::VerticalHeaderFormat cpp_result = cppSelf->QCalendarWidget::verticalHeaderFormat();
    py_result = Shiboken::Converter<QCalendarWidget::VerticalHeaderFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCalendarWidgetFunc_weekdayTextFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::DayOfWeek >::isConvertible(arg)) {
        Qt::DayOfWeek cpp_arg0 = Shiboken::Converter<Qt::DayOfWeek >::toCpp(arg);
        // weekdayTextFormat(Qt::DayOfWeek)const
        QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
        QTextCharFormat cpp_result = cppSelf->QCalendarWidget::weekdayTextFormat(cpp_arg0);
        py_result = Shiboken::Converter<QTextCharFormat >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCalendarWidgetFunc_weekdayTextFormat_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQCalendarWidgetFunc_weekdayTextFormat_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DayOfWeek", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCalendarWidget.weekdayTextFormat", overloads);
        return 0;
}

static PyObject* SbkQCalendarWidgetFunc_yearShown(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // yearShown()const
    QCalendarWidget* cppSelf = Shiboken::Converter<QCalendarWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QCalendarWidget::yearShown();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQCalendarWidget_methods[] = {
    {"dateEditAcceptDelay", (PyCFunction)SbkQCalendarWidgetFunc_dateEditAcceptDelay, METH_NOARGS},
    {"dateTextFormat", (PyCFunction)SbkQCalendarWidgetFunc_dateTextFormat, METH_NOARGS|METH_O},
    {"event", (PyCFunction)SbkQCalendarWidgetFunc_event, METH_O},
    {"eventFilter", (PyCFunction)SbkQCalendarWidgetFunc_eventFilter, METH_VARARGS},
    {"firstDayOfWeek", (PyCFunction)SbkQCalendarWidgetFunc_firstDayOfWeek, METH_NOARGS},
    {"headerTextFormat", (PyCFunction)SbkQCalendarWidgetFunc_headerTextFormat, METH_NOARGS},
    {"horizontalHeaderFormat", (PyCFunction)SbkQCalendarWidgetFunc_horizontalHeaderFormat, METH_NOARGS},
    {"isDateEditEnabled", (PyCFunction)SbkQCalendarWidgetFunc_isDateEditEnabled, METH_NOARGS},
    {"isGridVisible", (PyCFunction)SbkQCalendarWidgetFunc_isGridVisible, METH_NOARGS},
    {"isNavigationBarVisible", (PyCFunction)SbkQCalendarWidgetFunc_isNavigationBarVisible, METH_NOARGS},
    {"keyPressEvent", (PyCFunction)SbkQCalendarWidgetFunc_keyPressEvent, METH_O},
    {"maximumDate", (PyCFunction)SbkQCalendarWidgetFunc_maximumDate, METH_NOARGS},
    {"minimumDate", (PyCFunction)SbkQCalendarWidgetFunc_minimumDate, METH_NOARGS},
    {"minimumSizeHint", (PyCFunction)SbkQCalendarWidgetFunc_minimumSizeHint, METH_NOARGS},
    {"monthShown", (PyCFunction)SbkQCalendarWidgetFunc_monthShown, METH_NOARGS},
    {"mousePressEvent", (PyCFunction)SbkQCalendarWidgetFunc_mousePressEvent, METH_O},
    {"paintCell", (PyCFunction)SbkQCalendarWidgetFunc_paintCell, METH_VARARGS},
    {"resizeEvent", (PyCFunction)SbkQCalendarWidgetFunc_resizeEvent, METH_O},
    {"selectedDate", (PyCFunction)SbkQCalendarWidgetFunc_selectedDate, METH_NOARGS},
    {"selectionMode", (PyCFunction)SbkQCalendarWidgetFunc_selectionMode, METH_NOARGS},
    {"setCurrentPage", (PyCFunction)SbkQCalendarWidgetFunc_setCurrentPage, METH_VARARGS},
    {"setDateEditAcceptDelay", (PyCFunction)SbkQCalendarWidgetFunc_setDateEditAcceptDelay, METH_O},
    {"setDateEditEnabled", (PyCFunction)SbkQCalendarWidgetFunc_setDateEditEnabled, METH_O},
    {"setDateRange", (PyCFunction)SbkQCalendarWidgetFunc_setDateRange, METH_VARARGS},
    {"setDateTextFormat", (PyCFunction)SbkQCalendarWidgetFunc_setDateTextFormat, METH_VARARGS},
    {"setFirstDayOfWeek", (PyCFunction)SbkQCalendarWidgetFunc_setFirstDayOfWeek, METH_O},
    {"setGridVisible", (PyCFunction)SbkQCalendarWidgetFunc_setGridVisible, METH_O},
    {"setHeaderTextFormat", (PyCFunction)SbkQCalendarWidgetFunc_setHeaderTextFormat, METH_O},
    {"setHorizontalHeaderFormat", (PyCFunction)SbkQCalendarWidgetFunc_setHorizontalHeaderFormat, METH_O},
    {"setMaximumDate", (PyCFunction)SbkQCalendarWidgetFunc_setMaximumDate, METH_O},
    {"setMinimumDate", (PyCFunction)SbkQCalendarWidgetFunc_setMinimumDate, METH_O},
    {"setNavigationBarVisible", (PyCFunction)SbkQCalendarWidgetFunc_setNavigationBarVisible, METH_O},
    {"setSelectedDate", (PyCFunction)SbkQCalendarWidgetFunc_setSelectedDate, METH_O},
    {"setSelectionMode", (PyCFunction)SbkQCalendarWidgetFunc_setSelectionMode, METH_O},
    {"setVerticalHeaderFormat", (PyCFunction)SbkQCalendarWidgetFunc_setVerticalHeaderFormat, METH_O},
    {"setWeekdayTextFormat", (PyCFunction)SbkQCalendarWidgetFunc_setWeekdayTextFormat, METH_VARARGS},
    {"showNextMonth", (PyCFunction)SbkQCalendarWidgetFunc_showNextMonth, METH_NOARGS},
    {"showNextYear", (PyCFunction)SbkQCalendarWidgetFunc_showNextYear, METH_NOARGS},
    {"showPreviousMonth", (PyCFunction)SbkQCalendarWidgetFunc_showPreviousMonth, METH_NOARGS},
    {"showPreviousYear", (PyCFunction)SbkQCalendarWidgetFunc_showPreviousYear, METH_NOARGS},
    {"showSelectedDate", (PyCFunction)SbkQCalendarWidgetFunc_showSelectedDate, METH_NOARGS},
    {"showToday", (PyCFunction)SbkQCalendarWidgetFunc_showToday, METH_NOARGS},
    {"sizeHint", (PyCFunction)SbkQCalendarWidgetFunc_sizeHint, METH_NOARGS},
    {"updateCell", (PyCFunction)SbkQCalendarWidgetFunc_updateCell, METH_O},
    {"updateCells", (PyCFunction)SbkQCalendarWidgetFunc_updateCells, METH_NOARGS},
    {"verticalHeaderFormat", (PyCFunction)SbkQCalendarWidgetFunc_verticalHeaderFormat, METH_NOARGS},
    {"weekdayTextFormat", (PyCFunction)SbkQCalendarWidgetFunc_weekdayTextFormat, METH_O},
    {"yearShown", (PyCFunction)SbkQCalendarWidgetFunc_yearShown, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQCalendarWidgetSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QCalendarWidget* me = reinterpret_cast<QCalendarWidget*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQCalendarWidget_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QCalendarWidget",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQCalendarWidget_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQCalendarWidget_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQCalendarWidgetSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QCalendarWidget >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "HorizontalHeaderFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QCalendarWidget_VerticalHeaderFormat_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QCalendarWidget_VerticalHeaderFormat_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QCalendarWidget_VerticalHeaderFormat_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "VerticalHeaderFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QCalendarWidget_VerticalHeaderFormat_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QCalendarWidget_VerticalHeaderFormat_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QCalendarWidget_VerticalHeaderFormat_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QCalendarWidget_SelectionMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QCalendarWidget_SelectionMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QCalendarWidget_SelectionMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SelectionMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QCalendarWidget_SelectionMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QCalendarWidget_SelectionMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QCalendarWidget_SelectionMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QCalendarWidget(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QCALENDARWIDGET_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQCalendarWidget_Type);

    SbkQCalendarWidget_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX];
    SbkQCalendarWidget_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQCalendarWidget_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQCalendarWidget_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQCalendarWidget_Type));
    PyModule_AddObject(module, "QCalendarWidget",
        ((PyObject*)&SbkQCalendarWidget_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: HorizontalHeaderFormat
    SbkPySide_QtGuiTypes[SBK_QCALENDARWIDGET_HORIZONTALHEADERFORMAT_IDX] = &SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_Type);
    PyDict_SetItemString(SbkQCalendarWidget_Type.super.ht_type.tp_dict,
            "HorizontalHeaderFormat",((PyObject*)&SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_Type,
        (long) QCalendarWidget::NoHorizontalHeader, "NoHorizontalHeader");
    PyDict_SetItemString(SbkQCalendarWidget_Type.super.ht_type.tp_dict,
        "NoHorizontalHeader", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_Type.tp_dict,
        "NoHorizontalHeader", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_Type,
        (long) QCalendarWidget::SingleLetterDayNames, "SingleLetterDayNames");
    PyDict_SetItemString(SbkQCalendarWidget_Type.super.ht_type.tp_dict,
        "SingleLetterDayNames", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_Type.tp_dict,
        "SingleLetterDayNames", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_Type,
        (long) QCalendarWidget::ShortDayNames, "ShortDayNames");
    PyDict_SetItemString(SbkQCalendarWidget_Type.super.ht_type.tp_dict,
        "ShortDayNames", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_Type.tp_dict,
        "ShortDayNames", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_Type,
        (long) QCalendarWidget::LongDayNames, "LongDayNames");
    PyDict_SetItemString(SbkQCalendarWidget_Type.super.ht_type.tp_dict,
        "LongDayNames", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QCalendarWidget_HorizontalHeaderFormat_Type.tp_dict,
        "LongDayNames", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QCalendarWidget::HorizontalHeaderFormat");

    // init enum class: VerticalHeaderFormat
    SbkPySide_QtGuiTypes[SBK_QCALENDARWIDGET_VERTICALHEADERFORMAT_IDX] = &SbkPySide_QtGui_QCalendarWidget_VerticalHeaderFormat_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QCalendarWidget_VerticalHeaderFormat_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QCalendarWidget_VerticalHeaderFormat_Type);
    PyDict_SetItemString(SbkQCalendarWidget_Type.super.ht_type.tp_dict,
            "VerticalHeaderFormat",((PyObject*)&SbkPySide_QtGui_QCalendarWidget_VerticalHeaderFormat_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QCalendarWidget_VerticalHeaderFormat_Type,
        (long) QCalendarWidget::NoVerticalHeader, "NoVerticalHeader");
    PyDict_SetItemString(SbkQCalendarWidget_Type.super.ht_type.tp_dict,
        "NoVerticalHeader", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QCalendarWidget_VerticalHeaderFormat_Type.tp_dict,
        "NoVerticalHeader", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QCalendarWidget_VerticalHeaderFormat_Type,
        (long) QCalendarWidget::ISOWeekNumbers, "ISOWeekNumbers");
    PyDict_SetItemString(SbkQCalendarWidget_Type.super.ht_type.tp_dict,
        "ISOWeekNumbers", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QCalendarWidget_VerticalHeaderFormat_Type.tp_dict,
        "ISOWeekNumbers", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QCalendarWidget::VerticalHeaderFormat");

    // init enum class: SelectionMode
    SbkPySide_QtGuiTypes[SBK_QCALENDARWIDGET_SELECTIONMODE_IDX] = &SbkPySide_QtGui_QCalendarWidget_SelectionMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QCalendarWidget_SelectionMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QCalendarWidget_SelectionMode_Type);
    PyDict_SetItemString(SbkQCalendarWidget_Type.super.ht_type.tp_dict,
            "SelectionMode",((PyObject*)&SbkPySide_QtGui_QCalendarWidget_SelectionMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QCalendarWidget_SelectionMode_Type,
        (long) QCalendarWidget::NoSelection, "NoSelection");
    PyDict_SetItemString(SbkQCalendarWidget_Type.super.ht_type.tp_dict,
        "NoSelection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QCalendarWidget_SelectionMode_Type.tp_dict,
        "NoSelection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QCalendarWidget_SelectionMode_Type,
        (long) QCalendarWidget::SingleSelection, "SingleSelection");
    PyDict_SetItemString(SbkQCalendarWidget_Type.super.ht_type.tp_dict,
        "SingleSelection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QCalendarWidget_SelectionMode_Type.tp_dict,
        "SingleSelection", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QCalendarWidget::SelectionMode");

    Shiboken::TypeResolver::createObjectTypeResolver<QCalendarWidget >("QCalendarWidget*");
    Shiboken::TypeResolver::createObjectTypeResolver<QCalendarWidget >(typeid(QCalendarWidget).name());
}


} // extern "C"

