/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qabstractkineticscroller_wrapper.h"

// Extra includes
#include <qabstractkineticscroller.h>
#include <qevent.h>
#include <qgraphicssceneevent.h>
#include <qpoint.h>
#include <qsize.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractKineticScrollerWrapper::QAbstractKineticScrollerWrapper() : QAbstractKineticScroller() {
    // ... middle
}

bool QAbstractKineticScrollerWrapper::canStartScrollingAt(const QPoint & globalPos) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "canStartScrollingAt"));
    if (py_override.isNull()) {
        return this->QAbstractKineticScroller::canStartScrollingAt(globalPos);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPoint & >::toPython(globalPos)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractKineticScroller.canStartScrollingAt", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractKineticScrollerWrapper::cancelLeftMouseButtonPress(const QPoint & globalPressPos)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "cancelLeftMouseButtonPress"));
    if (py_override.isNull()) {
        return this->QAbstractKineticScroller::cancelLeftMouseButtonPress(globalPressPos);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPoint & >::toPython(globalPressPos)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QPoint QAbstractKineticScrollerWrapper::maximumScrollPosition() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "maximumScrollPosition"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractKineticScroller.maximumScrollPosition()' not implemented.");
        return QPoint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPoint();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPoint >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractKineticScroller.maximumScrollPosition", SbkType<QPoint >()->tp_name, py_result->ob_type->tp_name);
        return QPoint();
    }
    QPoint cpp_result(Shiboken::Converter<QPoint >::toCpp(py_result));
    return cpp_result;
}

QPoint QAbstractKineticScrollerWrapper::scrollPosition() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollPosition"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractKineticScroller.scrollPosition()' not implemented.");
        return QPoint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPoint();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPoint >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractKineticScroller.scrollPosition", SbkType<QPoint >()->tp_name, py_result->ob_type->tp_name);
        return QPoint();
    }
    QPoint cpp_result(Shiboken::Converter<QPoint >::toCpp(py_result));
    return cpp_result;
}

void QAbstractKineticScrollerWrapper::setScrollPosition(const QPoint & pos, const QPoint & overshootDelta)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setScrollPosition"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractKineticScroller.setScrollPosition()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QPoint & >::toPython(pos),
        Shiboken::Converter<QPoint & >::toPython(overshootDelta)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QAbstractKineticScrollerWrapper::viewportSize() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewportSize"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractKineticScroller.viewportSize()' not implemented.");
        return QSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractKineticScroller.viewportSize", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

QAbstractKineticScrollerWrapper::~QAbstractKineticScrollerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQAbstractKineticScroller_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractKineticScrollerWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTKINETICSCROLLER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractKineticScroller' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // QAbstractKineticScroller()
    cptr = new QAbstractKineticScrollerWrapper();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAbstractKineticScroller >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkQAbstractKineticScrollerFunc_axisLockThreshold(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // axisLockThreshold()const
    QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QAbstractKineticScroller::axisLockThreshold();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractKineticScrollerFunc_canStartScrollingAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // canStartScrollingAt(QPoint)const
        QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractKineticScroller::canStartScrollingAt(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractKineticScrollerFunc_canStartScrollingAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractKineticScrollerFunc_canStartScrollingAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractKineticScroller.canStartScrollingAt", overloads);
        return 0;
}

static PyObject* SbkQAbstractKineticScrollerFunc_cancelLeftMouseButtonPress(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // cancelLeftMouseButtonPress(QPoint)
        QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
        cppSelf->QAbstractKineticScroller::cancelLeftMouseButtonPress(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractKineticScrollerFunc_cancelLeftMouseButtonPress_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractKineticScrollerFunc_cancelLeftMouseButtonPress_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractKineticScroller.cancelLeftMouseButtonPress", overloads);
        return 0;
}

static PyObject* SbkQAbstractKineticScrollerFunc_decelerationFactor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // decelerationFactor()const
    QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QAbstractKineticScroller::decelerationFactor();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractKineticScrollerFunc_directionErrorMargin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // directionErrorMargin()const
    QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAbstractKineticScroller::directionErrorMargin();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractKineticScrollerFunc_dragInertia(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dragInertia()const
    QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QAbstractKineticScroller::dragInertia();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractKineticScrollerFunc_ensureVisible(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "ensureVisible", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // ensureVisible(QPoint,int,int)
            QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
            cppSelf->QAbstractKineticScroller::ensureVisible(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // ensureVisible(QPoint,int,int)
                QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
                cppSelf->QAbstractKineticScroller::ensureVisible(*cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // ensureVisible(QPoint,int,int)
                QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
                cppSelf->QAbstractKineticScroller::ensureVisible(*cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQAbstractKineticScrollerFunc_ensureVisible_TypeError;
        } else goto SbkQAbstractKineticScrollerFunc_ensureVisible_TypeError;
    } else goto SbkQAbstractKineticScrollerFunc_ensureVisible_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractKineticScrollerFunc_ensureVisible_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, int = 50, int = 50", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractKineticScroller.ensureVisible", overloads);
        return 0;
}

static PyObject* SbkQAbstractKineticScrollerFunc_fastVelocityFactor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fastVelocityFactor()const
    QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QAbstractKineticScroller::fastVelocityFactor();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractKineticScrollerFunc_handleMouseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // handleMouseEvent(QMouseEvent*)
        QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractKineticScroller::handleMouseEvent(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QGraphicsSceneMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneMouseEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp(arg);
        // handleMouseEvent(QGraphicsSceneMouseEvent*)
        QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractKineticScroller::handleMouseEvent(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractKineticScrollerFunc_handleMouseEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractKineticScrollerFunc_handleMouseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneMouseEvent", "PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractKineticScroller.handleMouseEvent", overloads);
        return 0;
}

static PyObject* SbkQAbstractKineticScrollerFunc_isEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEnabled()const
    QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractKineticScroller::isEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractKineticScrollerFunc_isLowFrictionEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isLowFrictionEnabled()const
    QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractKineticScroller::isLowFrictionEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractKineticScrollerFunc_maximumScrollPosition(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumScrollPosition()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractKineticScroller.maximumScrollPosition()' not implemented.");
        return 0;
    }
    QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->maximumScrollPosition();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractKineticScrollerFunc_maximumVelocity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumVelocity()const
    QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QAbstractKineticScroller::maximumVelocity();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractKineticScrollerFunc_minimumVelocity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumVelocity()const
    QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QAbstractKineticScroller::minimumVelocity();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractKineticScrollerFunc_panningThreshold(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // panningThreshold()const
    QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAbstractKineticScroller::panningThreshold();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractKineticScrollerFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
    cppSelf->QAbstractKineticScroller::reset();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractKineticScrollerFunc_scrollPosition(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scrollPosition()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractKineticScroller.scrollPosition()' not implemented.");
        return 0;
    }
    QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->scrollPosition();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractKineticScrollerFunc_scrollTo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // scrollTo(QPoint)
        QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
        cppSelf->QAbstractKineticScroller::scrollTo(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractKineticScrollerFunc_scrollTo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractKineticScrollerFunc_scrollTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractKineticScroller.scrollTo", overloads);
        return 0;
}

static PyObject* SbkQAbstractKineticScrollerFunc_scrollsPerSecond(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scrollsPerSecond()const
    QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAbstractKineticScroller::scrollsPerSecond();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractKineticScrollerFunc_setAxisLockThreshold(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setAxisLockThreshold(qreal)
        QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
        cppSelf->QAbstractKineticScroller::setAxisLockThreshold(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractKineticScrollerFunc_setAxisLockThreshold_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractKineticScrollerFunc_setAxisLockThreshold_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractKineticScroller.setAxisLockThreshold", overloads);
        return 0;
}

static PyObject* SbkQAbstractKineticScrollerFunc_setDecelerationFactor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setDecelerationFactor(qreal)
        QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
        cppSelf->QAbstractKineticScroller::setDecelerationFactor(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractKineticScrollerFunc_setDecelerationFactor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractKineticScrollerFunc_setDecelerationFactor_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractKineticScroller.setDecelerationFactor", overloads);
        return 0;
}

static PyObject* SbkQAbstractKineticScrollerFunc_setDirectionErrorMargin(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setDirectionErrorMargin(int)
        QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
        cppSelf->QAbstractKineticScroller::setDirectionErrorMargin(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractKineticScrollerFunc_setDirectionErrorMargin_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractKineticScrollerFunc_setDirectionErrorMargin_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractKineticScroller.setDirectionErrorMargin", overloads);
        return 0;
}

static PyObject* SbkQAbstractKineticScrollerFunc_setDragInertia(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setDragInertia(qreal)
        QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
        cppSelf->QAbstractKineticScroller::setDragInertia(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractKineticScrollerFunc_setDragInertia_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractKineticScrollerFunc_setDragInertia_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractKineticScroller.setDragInertia", overloads);
        return 0;
}

static PyObject* SbkQAbstractKineticScrollerFunc_setEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setEnabled(bool)
        QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
        cppSelf->QAbstractKineticScroller::setEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractKineticScrollerFunc_setEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractKineticScrollerFunc_setEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractKineticScroller.setEnabled", overloads);
        return 0;
}

static PyObject* SbkQAbstractKineticScrollerFunc_setFastVelocityFactor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setFastVelocityFactor(qreal)
        QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
        cppSelf->QAbstractKineticScroller::setFastVelocityFactor(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractKineticScrollerFunc_setFastVelocityFactor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractKineticScrollerFunc_setFastVelocityFactor_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractKineticScroller.setFastVelocityFactor", overloads);
        return 0;
}

static PyObject* SbkQAbstractKineticScrollerFunc_setLowFrictionEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setLowFrictionEnabled(bool)
        QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
        cppSelf->QAbstractKineticScroller::setLowFrictionEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractKineticScrollerFunc_setLowFrictionEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractKineticScrollerFunc_setLowFrictionEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractKineticScroller.setLowFrictionEnabled", overloads);
        return 0;
}

static PyObject* SbkQAbstractKineticScrollerFunc_setMaximumVelocity(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setMaximumVelocity(qreal)
        QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
        cppSelf->QAbstractKineticScroller::setMaximumVelocity(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractKineticScrollerFunc_setMaximumVelocity_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractKineticScrollerFunc_setMaximumVelocity_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractKineticScroller.setMaximumVelocity", overloads);
        return 0;
}

static PyObject* SbkQAbstractKineticScrollerFunc_setMinimumVelocity(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setMinimumVelocity(qreal)
        QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
        cppSelf->QAbstractKineticScroller::setMinimumVelocity(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractKineticScrollerFunc_setMinimumVelocity_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractKineticScrollerFunc_setMinimumVelocity_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractKineticScroller.setMinimumVelocity", overloads);
        return 0;
}

static PyObject* SbkQAbstractKineticScrollerFunc_setPanningThreshold(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setPanningThreshold(int)
        QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
        cppSelf->QAbstractKineticScroller::setPanningThreshold(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractKineticScrollerFunc_setPanningThreshold_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractKineticScrollerFunc_setPanningThreshold_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractKineticScroller.setPanningThreshold", overloads);
        return 0;
}

static PyObject* SbkQAbstractKineticScrollerFunc_setScrollPosition(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setScrollPosition", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPoint & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
        // setScrollPosition(QPoint,QPoint)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractKineticScroller.setScrollPosition()' not implemented.");
            return 0;
        }
        QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
        cppSelf->setScrollPosition(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractKineticScrollerFunc_setScrollPosition_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractKineticScrollerFunc_setScrollPosition_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAbstractKineticScroller.setScrollPosition", overloads);
        return 0;
}

static PyObject* SbkQAbstractKineticScrollerFunc_setScrollsPerSecond(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setScrollsPerSecond(int)
        QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
        cppSelf->QAbstractKineticScroller::setScrollsPerSecond(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractKineticScrollerFunc_setScrollsPerSecond_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractKineticScrollerFunc_setScrollsPerSecond_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAbstractKineticScroller.setScrollsPerSecond", overloads);
        return 0;
}

static PyObject* SbkQAbstractKineticScrollerFunc_viewportSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewportSize()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractKineticScroller.viewportSize()' not implemented.");
        return 0;
    }
    QAbstractKineticScroller* cppSelf = Shiboken::Converter<QAbstractKineticScroller* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->viewportSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQAbstractKineticScroller_methods[] = {
    {"axisLockThreshold", (PyCFunction)SbkQAbstractKineticScrollerFunc_axisLockThreshold, METH_NOARGS},
    {"canStartScrollingAt", (PyCFunction)SbkQAbstractKineticScrollerFunc_canStartScrollingAt, METH_O},
    {"cancelLeftMouseButtonPress", (PyCFunction)SbkQAbstractKineticScrollerFunc_cancelLeftMouseButtonPress, METH_O},
    {"decelerationFactor", (PyCFunction)SbkQAbstractKineticScrollerFunc_decelerationFactor, METH_NOARGS},
    {"directionErrorMargin", (PyCFunction)SbkQAbstractKineticScrollerFunc_directionErrorMargin, METH_NOARGS},
    {"dragInertia", (PyCFunction)SbkQAbstractKineticScrollerFunc_dragInertia, METH_NOARGS},
    {"ensureVisible", (PyCFunction)SbkQAbstractKineticScrollerFunc_ensureVisible, METH_VARARGS},
    {"fastVelocityFactor", (PyCFunction)SbkQAbstractKineticScrollerFunc_fastVelocityFactor, METH_NOARGS},
    {"handleMouseEvent", (PyCFunction)SbkQAbstractKineticScrollerFunc_handleMouseEvent, METH_O},
    {"isEnabled", (PyCFunction)SbkQAbstractKineticScrollerFunc_isEnabled, METH_NOARGS},
    {"isLowFrictionEnabled", (PyCFunction)SbkQAbstractKineticScrollerFunc_isLowFrictionEnabled, METH_NOARGS},
    {"maximumScrollPosition", (PyCFunction)SbkQAbstractKineticScrollerFunc_maximumScrollPosition, METH_NOARGS},
    {"maximumVelocity", (PyCFunction)SbkQAbstractKineticScrollerFunc_maximumVelocity, METH_NOARGS},
    {"minimumVelocity", (PyCFunction)SbkQAbstractKineticScrollerFunc_minimumVelocity, METH_NOARGS},
    {"panningThreshold", (PyCFunction)SbkQAbstractKineticScrollerFunc_panningThreshold, METH_NOARGS},
    {"reset", (PyCFunction)SbkQAbstractKineticScrollerFunc_reset, METH_NOARGS},
    {"scrollPosition", (PyCFunction)SbkQAbstractKineticScrollerFunc_scrollPosition, METH_NOARGS},
    {"scrollTo", (PyCFunction)SbkQAbstractKineticScrollerFunc_scrollTo, METH_O},
    {"scrollsPerSecond", (PyCFunction)SbkQAbstractKineticScrollerFunc_scrollsPerSecond, METH_NOARGS},
    {"setAxisLockThreshold", (PyCFunction)SbkQAbstractKineticScrollerFunc_setAxisLockThreshold, METH_O},
    {"setDecelerationFactor", (PyCFunction)SbkQAbstractKineticScrollerFunc_setDecelerationFactor, METH_O},
    {"setDirectionErrorMargin", (PyCFunction)SbkQAbstractKineticScrollerFunc_setDirectionErrorMargin, METH_O},
    {"setDragInertia", (PyCFunction)SbkQAbstractKineticScrollerFunc_setDragInertia, METH_O},
    {"setEnabled", (PyCFunction)SbkQAbstractKineticScrollerFunc_setEnabled, METH_O},
    {"setFastVelocityFactor", (PyCFunction)SbkQAbstractKineticScrollerFunc_setFastVelocityFactor, METH_O},
    {"setLowFrictionEnabled", (PyCFunction)SbkQAbstractKineticScrollerFunc_setLowFrictionEnabled, METH_O},
    {"setMaximumVelocity", (PyCFunction)SbkQAbstractKineticScrollerFunc_setMaximumVelocity, METH_O},
    {"setMinimumVelocity", (PyCFunction)SbkQAbstractKineticScrollerFunc_setMinimumVelocity, METH_O},
    {"setPanningThreshold", (PyCFunction)SbkQAbstractKineticScrollerFunc_setPanningThreshold, METH_O},
    {"setScrollPosition", (PyCFunction)SbkQAbstractKineticScrollerFunc_setScrollPosition, METH_VARARGS},
    {"setScrollsPerSecond", (PyCFunction)SbkQAbstractKineticScrollerFunc_setScrollsPerSecond, METH_O},
    {"viewportSize", (PyCFunction)SbkQAbstractKineticScrollerFunc_viewportSize, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractKineticScroller_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QAbstractKineticScroller",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractKineticScroller_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractKineticScroller_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAbstractKineticScroller >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQAbstractKineticScroller_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQAbstractKineticScroller_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QAbstractKineticScroller*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void) init_QAbstractKineticScroller(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QABSTRACTKINETICSCROLLER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractKineticScroller_Type);

    // Fill type discovery information
    SbkQAbstractKineticScroller_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQAbstractKineticScroller_Type.type_discovery->addTypeDiscoveryFunction(&SbkQAbstractKineticScroller_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractKineticScroller_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractKineticScroller_Type));
    PyModule_AddObject(module, "QAbstractKineticScroller",
        ((PyObject*)&SbkQAbstractKineticScroller_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractKineticScroller >("QAbstractKineticScroller*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractKineticScroller >(typeid(QAbstractKineticScroller).name());
}


} // extern "C"

