/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qtimeline_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qeasingcurve.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qtimeline.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTimeLineWrapper::QTimeLineWrapper(int duration, QObject * parent) : QTimeLine(duration, parent), m_metaObject(0) {
    // ... middle
}

void QTimeLineWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTimeLineWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTimeLineWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTimeLineWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QTimeLineWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTimeLine.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QTimeLineWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTimeLine.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QTimeLineWrapper::timerEvent(QTimerEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QTimeLine::timerEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

qreal QTimeLineWrapper::valueForTime(int msec) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "valueForTime"));
    if (py_override.isNull()) {
        return this->QTimeLine::valueForTime(msec);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        msec
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qreal(0);
    }
    // Check return type
    bool typeIsValid = PyFloat_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTimeLine.valueForTime", SbkType<qreal >()->tp_name, py_result->ob_type->tp_name);
        return qreal(0);
    }
    qreal cpp_result(Shiboken::Converter<double >::toCpp(py_result));
    return cpp_result;
}

const QMetaObject* QTimeLineWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QTimeLine::staticMetaObject);
}
    return m_metaObject;
}

int QTimeLineWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QTimeLine::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QTimeLineWrapper::~QTimeLineWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQTimeLine_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTimeLineWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QTimeLine", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QTimeLine(int,QObject*)
        cptr = new QTimeLineWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[1], self);
    } else if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QTimeLine(int,QObject*)
            cptr = new QTimeLineWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // QTimeLine(int,QObject*)
            cptr = new QTimeLineWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQTimeLine_Init_TypeError;
    } else goto SbkQTimeLine_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTimeLine >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTimeLine_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTimeLine_Init_TypeError:
        const char* overloads[] = {"int = 1000, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QTimeLine", overloads);
        return -1;
}

static PyObject* SbkQTimeLineFunc_currentFrame(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentFrame()const
    QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTimeLine::currentFrame();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTimeLineFunc_currentTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentTime()const
    QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTimeLine::currentTime();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTimeLineFunc_currentValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentValue()const
    QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTimeLine::currentValue();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTimeLineFunc_curveShape(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // curveShape()const
    QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
    QTimeLine::CurveShape cpp_result = cppSelf->QTimeLine::curveShape();
    py_result = Shiboken::Converter<QTimeLine::CurveShape >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTimeLineFunc_direction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // direction()const
    QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
    QTimeLine::Direction cpp_result = cppSelf->QTimeLine::direction();
    py_result = Shiboken::Converter<QTimeLine::Direction >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTimeLineFunc_duration(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // duration()const
    QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTimeLine::duration();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTimeLineFunc_easingCurve(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // easingCurve()const
    QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
    QEasingCurve cpp_result = cppSelf->QTimeLine::easingCurve();
    py_result = Shiboken::Converter<QEasingCurve >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTimeLineFunc_endFrame(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // endFrame()const
    QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTimeLine::endFrame();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTimeLineFunc_frameForTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // frameForTime(int)const
        QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTimeLine::frameForTime(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimeLineFunc_frameForTime_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTimeLineFunc_frameForTime_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTimeLine.frameForTime", overloads);
        return 0;
}

static PyObject* SbkQTimeLineFunc_loopCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // loopCount()const
    QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTimeLine::loopCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTimeLineFunc_resume(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // resume()
    QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
    cppSelf->QTimeLine::resume();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTimeLineFunc_setCurrentTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCurrentTime(int)
        QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
        cppSelf->QTimeLine::setCurrentTime(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimeLineFunc_setCurrentTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTimeLineFunc_setCurrentTime_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTimeLine.setCurrentTime", overloads);
        return 0;
}

static PyObject* SbkQTimeLineFunc_setCurveShape(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTimeLine::CurveShape >::isConvertible(arg)) {
        QTimeLine::CurveShape cpp_arg0 = Shiboken::Converter<QTimeLine::CurveShape >::toCpp(arg);
        // setCurveShape(QTimeLine::CurveShape)
        QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
        cppSelf->QTimeLine::setCurveShape(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimeLineFunc_setCurveShape_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTimeLineFunc_setCurveShape_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTimeLine.CurveShape", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTimeLine.setCurveShape", overloads);
        return 0;
}

static PyObject* SbkQTimeLineFunc_setDirection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTimeLine::Direction >::isConvertible(arg)) {
        QTimeLine::Direction cpp_arg0 = Shiboken::Converter<QTimeLine::Direction >::toCpp(arg);
        // setDirection(QTimeLine::Direction)
        QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
        cppSelf->QTimeLine::setDirection(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimeLineFunc_setDirection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTimeLineFunc_setDirection_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTimeLine.Direction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTimeLine.setDirection", overloads);
        return 0;
}

static PyObject* SbkQTimeLineFunc_setDuration(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setDuration(int)
        QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
        cppSelf->QTimeLine::setDuration(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimeLineFunc_setDuration_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTimeLineFunc_setDuration_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTimeLine.setDuration", overloads);
        return 0;
}

static PyObject* SbkQTimeLineFunc_setEasingCurve(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEasingCurve & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QEasingCurve > cpp_arg0_auto_ptr;
        QEasingCurve* cpp_arg0 = Shiboken::Converter<QEasingCurve* >::toCpp(arg);
        if (!SbkQEasingCurve_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QEasingCurve >(cpp_arg0);
        // setEasingCurve(QEasingCurve)
        QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
        cppSelf->QTimeLine::setEasingCurve(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimeLineFunc_setEasingCurve_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTimeLineFunc_setEasingCurve_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEasingCurve", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTimeLine.setEasingCurve", overloads);
        return 0;
}

static PyObject* SbkQTimeLineFunc_setEndFrame(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setEndFrame(int)
        QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
        cppSelf->QTimeLine::setEndFrame(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimeLineFunc_setEndFrame_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTimeLineFunc_setEndFrame_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTimeLine.setEndFrame", overloads);
        return 0;
}

static PyObject* SbkQTimeLineFunc_setFrameRange(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setFrameRange", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setFrameRange(int,int)
        QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
        cppSelf->QTimeLine::setFrameRange(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimeLineFunc_setFrameRange_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTimeLineFunc_setFrameRange_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QTimeLine.setFrameRange", overloads);
        return 0;
}

static PyObject* SbkQTimeLineFunc_setLoopCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setLoopCount(int)
        QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
        cppSelf->QTimeLine::setLoopCount(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimeLineFunc_setLoopCount_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTimeLineFunc_setLoopCount_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTimeLine.setLoopCount", overloads);
        return 0;
}

static PyObject* SbkQTimeLineFunc_setPaused(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setPaused(bool)
        QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
        cppSelf->QTimeLine::setPaused(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimeLineFunc_setPaused_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTimeLineFunc_setPaused_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTimeLine.setPaused", overloads);
        return 0;
}

static PyObject* SbkQTimeLineFunc_setStartFrame(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setStartFrame(int)
        QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
        cppSelf->QTimeLine::setStartFrame(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimeLineFunc_setStartFrame_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTimeLineFunc_setStartFrame_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTimeLine.setStartFrame", overloads);
        return 0;
}

static PyObject* SbkQTimeLineFunc_setUpdateInterval(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setUpdateInterval(int)
        QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
        cppSelf->QTimeLine::setUpdateInterval(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimeLineFunc_setUpdateInterval_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTimeLineFunc_setUpdateInterval_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTimeLine.setUpdateInterval", overloads);
        return 0;
}

static PyObject* SbkQTimeLineFunc_start(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // start()
    QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
    cppSelf->QTimeLine::start();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTimeLineFunc_startFrame(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // startFrame()const
    QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTimeLine::startFrame();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTimeLineFunc_state(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // state()const
    QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
    QTimeLine::State cpp_result = cppSelf->QTimeLine::state();
    py_result = Shiboken::Converter<QTimeLine::State >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTimeLineFunc_stop(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // stop()
    QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
    cppSelf->QTimeLine::stop();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTimeLineFunc_timerEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTimerEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTimerEvent* cpp_arg0 = Shiboken::Converter<QTimerEvent* >::toCpp(arg);
        // timerEvent(QTimerEvent*)
        QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
        cppSelf->QTimeLine::timerEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimeLineFunc_timerEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTimeLineFunc_timerEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTimerEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTimeLine.timerEvent", overloads);
        return 0;
}

static PyObject* SbkQTimeLineFunc_toggleDirection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // toggleDirection()
    QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
    cppSelf->QTimeLine::toggleDirection();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTimeLineFunc_updateInterval(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // updateInterval()const
    QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTimeLine::updateInterval();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTimeLineFunc_valueForTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // valueForTime(int)const
        QTimeLine* cppSelf = Shiboken::Converter<QTimeLine* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QTimeLine::valueForTime(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimeLineFunc_valueForTime_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTimeLineFunc_valueForTime_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTimeLine.valueForTime", overloads);
        return 0;
}

static PyMethodDef SbkQTimeLine_methods[] = {
    {"currentFrame", (PyCFunction)SbkQTimeLineFunc_currentFrame, METH_NOARGS},
    {"currentTime", (PyCFunction)SbkQTimeLineFunc_currentTime, METH_NOARGS},
    {"currentValue", (PyCFunction)SbkQTimeLineFunc_currentValue, METH_NOARGS},
    {"curveShape", (PyCFunction)SbkQTimeLineFunc_curveShape, METH_NOARGS},
    {"direction", (PyCFunction)SbkQTimeLineFunc_direction, METH_NOARGS},
    {"duration", (PyCFunction)SbkQTimeLineFunc_duration, METH_NOARGS},
    {"easingCurve", (PyCFunction)SbkQTimeLineFunc_easingCurve, METH_NOARGS},
    {"endFrame", (PyCFunction)SbkQTimeLineFunc_endFrame, METH_NOARGS},
    {"frameForTime", (PyCFunction)SbkQTimeLineFunc_frameForTime, METH_O},
    {"loopCount", (PyCFunction)SbkQTimeLineFunc_loopCount, METH_NOARGS},
    {"resume", (PyCFunction)SbkQTimeLineFunc_resume, METH_NOARGS},
    {"setCurrentTime", (PyCFunction)SbkQTimeLineFunc_setCurrentTime, METH_O},
    {"setCurveShape", (PyCFunction)SbkQTimeLineFunc_setCurveShape, METH_O},
    {"setDirection", (PyCFunction)SbkQTimeLineFunc_setDirection, METH_O},
    {"setDuration", (PyCFunction)SbkQTimeLineFunc_setDuration, METH_O},
    {"setEasingCurve", (PyCFunction)SbkQTimeLineFunc_setEasingCurve, METH_O},
    {"setEndFrame", (PyCFunction)SbkQTimeLineFunc_setEndFrame, METH_O},
    {"setFrameRange", (PyCFunction)SbkQTimeLineFunc_setFrameRange, METH_VARARGS},
    {"setLoopCount", (PyCFunction)SbkQTimeLineFunc_setLoopCount, METH_O},
    {"setPaused", (PyCFunction)SbkQTimeLineFunc_setPaused, METH_O},
    {"setStartFrame", (PyCFunction)SbkQTimeLineFunc_setStartFrame, METH_O},
    {"setUpdateInterval", (PyCFunction)SbkQTimeLineFunc_setUpdateInterval, METH_O},
    {"start", (PyCFunction)SbkQTimeLineFunc_start, METH_NOARGS},
    {"startFrame", (PyCFunction)SbkQTimeLineFunc_startFrame, METH_NOARGS},
    {"state", (PyCFunction)SbkQTimeLineFunc_state, METH_NOARGS},
    {"stop", (PyCFunction)SbkQTimeLineFunc_stop, METH_NOARGS},
    {"timerEvent", (PyCFunction)SbkQTimeLineFunc_timerEvent, METH_O},
    {"toggleDirection", (PyCFunction)SbkQTimeLineFunc_toggleDirection, METH_NOARGS},
    {"updateInterval", (PyCFunction)SbkQTimeLineFunc_updateInterval, METH_NOARGS},
    {"valueForTime", (PyCFunction)SbkQTimeLineFunc_valueForTime, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTimeLine_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QTimeLine",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTimeLine_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTimeLine_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTimeLine >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtCore_QTimeLine_Direction_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QTimeLine_Direction_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QTimeLine_Direction_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Direction",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QTimeLine_Direction_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QTimeLine_Direction_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QTimeLine_Direction_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QTimeLine_CurveShape_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QTimeLine_CurveShape_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QTimeLine_CurveShape_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CurveShape",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QTimeLine_CurveShape_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QTimeLine_CurveShape_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QTimeLine_CurveShape_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QTimeLine_State_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QTimeLine_State_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QTimeLine_State_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "State",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QTimeLine_State_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QTimeLine_State_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QTimeLine_State_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QTimeLine(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QTIMELINE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTimeLine_Type);

    SbkQTimeLine_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQTimeLine_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTimeLine_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTimeLine_Type));
    PyModule_AddObject(module, "QTimeLine",
        ((PyObject*)&SbkQTimeLine_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Direction
    SbkPySide_QtCoreTypes[SBK_QTIMELINE_DIRECTION_IDX] = &SbkPySide_QtCore_QTimeLine_Direction_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QTimeLine_Direction_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QTimeLine_Direction_Type);
    PyDict_SetItemString(SbkQTimeLine_Type.super.ht_type.tp_dict,
            "Direction",((PyObject*)&SbkPySide_QtCore_QTimeLine_Direction_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTimeLine_Direction_Type,
        (long) QTimeLine::Forward, "Forward");
    PyDict_SetItemString(SbkQTimeLine_Type.super.ht_type.tp_dict,
        "Forward", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTimeLine_Direction_Type.tp_dict,
        "Forward", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTimeLine_Direction_Type,
        (long) QTimeLine::Backward, "Backward");
    PyDict_SetItemString(SbkQTimeLine_Type.super.ht_type.tp_dict,
        "Backward", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTimeLine_Direction_Type.tp_dict,
        "Backward", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTimeLine::Direction");

    // init enum class: CurveShape
    SbkPySide_QtCoreTypes[SBK_QTIMELINE_CURVESHAPE_IDX] = &SbkPySide_QtCore_QTimeLine_CurveShape_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QTimeLine_CurveShape_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QTimeLine_CurveShape_Type);
    PyDict_SetItemString(SbkQTimeLine_Type.super.ht_type.tp_dict,
            "CurveShape",((PyObject*)&SbkPySide_QtCore_QTimeLine_CurveShape_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTimeLine_CurveShape_Type,
        (long) QTimeLine::EaseInCurve, "EaseInCurve");
    PyDict_SetItemString(SbkQTimeLine_Type.super.ht_type.tp_dict,
        "EaseInCurve", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTimeLine_CurveShape_Type.tp_dict,
        "EaseInCurve", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTimeLine_CurveShape_Type,
        (long) QTimeLine::EaseOutCurve, "EaseOutCurve");
    PyDict_SetItemString(SbkQTimeLine_Type.super.ht_type.tp_dict,
        "EaseOutCurve", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTimeLine_CurveShape_Type.tp_dict,
        "EaseOutCurve", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTimeLine_CurveShape_Type,
        (long) QTimeLine::EaseInOutCurve, "EaseInOutCurve");
    PyDict_SetItemString(SbkQTimeLine_Type.super.ht_type.tp_dict,
        "EaseInOutCurve", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTimeLine_CurveShape_Type.tp_dict,
        "EaseInOutCurve", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTimeLine_CurveShape_Type,
        (long) QTimeLine::LinearCurve, "LinearCurve");
    PyDict_SetItemString(SbkQTimeLine_Type.super.ht_type.tp_dict,
        "LinearCurve", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTimeLine_CurveShape_Type.tp_dict,
        "LinearCurve", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTimeLine_CurveShape_Type,
        (long) QTimeLine::SineCurve, "SineCurve");
    PyDict_SetItemString(SbkQTimeLine_Type.super.ht_type.tp_dict,
        "SineCurve", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTimeLine_CurveShape_Type.tp_dict,
        "SineCurve", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTimeLine_CurveShape_Type,
        (long) QTimeLine::CosineCurve, "CosineCurve");
    PyDict_SetItemString(SbkQTimeLine_Type.super.ht_type.tp_dict,
        "CosineCurve", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTimeLine_CurveShape_Type.tp_dict,
        "CosineCurve", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTimeLine::CurveShape");

    // init enum class: State
    SbkPySide_QtCoreTypes[SBK_QTIMELINE_STATE_IDX] = &SbkPySide_QtCore_QTimeLine_State_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QTimeLine_State_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QTimeLine_State_Type);
    PyDict_SetItemString(SbkQTimeLine_Type.super.ht_type.tp_dict,
            "State",((PyObject*)&SbkPySide_QtCore_QTimeLine_State_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTimeLine_State_Type,
        (long) QTimeLine::NotRunning, "NotRunning");
    PyDict_SetItemString(SbkQTimeLine_Type.super.ht_type.tp_dict,
        "NotRunning", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTimeLine_State_Type.tp_dict,
        "NotRunning", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTimeLine_State_Type,
        (long) QTimeLine::Paused, "Paused");
    PyDict_SetItemString(SbkQTimeLine_Type.super.ht_type.tp_dict,
        "Paused", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTimeLine_State_Type.tp_dict,
        "Paused", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTimeLine_State_Type,
        (long) QTimeLine::Running, "Running");
    PyDict_SetItemString(SbkQTimeLine_Type.super.ht_type.tp_dict,
        "Running", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTimeLine_State_Type.tp_dict,
        "Running", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTimeLine::State");

    Shiboken::TypeResolver::createObjectTypeResolver<QTimeLine >("QTimeLine*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTimeLine >(typeid(QTimeLine).name());
}


} // extern "C"

