/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qsemaphore_wrapper.h"

// Extra includes
#include <qsemaphore.h>

using namespace Shiboken;

static int
SbkQSemaphore_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSemaphore* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QSemaphore", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QSemaphore(int)
        cptr = new QSemaphore();
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QSemaphore(int)
        cptr = new QSemaphore(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSemaphore_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QSemaphore >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSemaphore_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQSemaphore_Init_TypeError:
        const char* overloads[] = {"int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QSemaphore", overloads);
        return -1;
}

static PyObject* SbkQSemaphoreFunc_acquire(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // acquire(int)
        QSemaphore* cppSelf = Shiboken::Converter<QSemaphore* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        cppSelf->QSemaphore::acquire();
        thread_state_saver.restore();
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // acquire(int)
        QSemaphore* cppSelf = Shiboken::Converter<QSemaphore* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        cppSelf->QSemaphore::acquire(cpp_arg0);
        thread_state_saver.restore();
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSemaphoreFunc_acquire_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSemaphoreFunc_acquire_TypeError:
        const char* overloads[] = {"int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSemaphore.acquire", overloads);
        return 0;
}

static PyObject* SbkQSemaphoreFunc_available(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // available()const
    QSemaphore* cppSelf = Shiboken::Converter<QSemaphore* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSemaphore::available();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSemaphoreFunc_release(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // release(int)
        QSemaphore* cppSelf = Shiboken::Converter<QSemaphore* >::toCpp((PyObject*)self);
        cppSelf->QSemaphore::release();
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // release(int)
        QSemaphore* cppSelf = Shiboken::Converter<QSemaphore* >::toCpp((PyObject*)self);
        cppSelf->QSemaphore::release(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSemaphoreFunc_release_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSemaphoreFunc_release_TypeError:
        const char* overloads[] = {"int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSemaphore.release", overloads);
        return 0;
}

static PyObject* SbkQSemaphoreFunc_tryAcquire(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "tryAcquire", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // tryAcquire(int)
        QSemaphore* cppSelf = Shiboken::Converter<QSemaphore* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSemaphore::tryAcquire();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // tryAcquire(int)
            QSemaphore* cppSelf = Shiboken::Converter<QSemaphore* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QSemaphore::tryAcquire(cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // tryAcquire(int,int)
            QSemaphore* cppSelf = Shiboken::Converter<QSemaphore* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QSemaphore::tryAcquire(cpp_arg0, cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQSemaphoreFunc_tryAcquire_TypeError;
    } else goto SbkQSemaphoreFunc_tryAcquire_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSemaphoreFunc_tryAcquire_TypeError:
        const char* overloads[] = {"int = 1", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QSemaphore.tryAcquire", overloads);
        return 0;
}

static PyMethodDef SbkQSemaphore_methods[] = {
    {"acquire", (PyCFunction)SbkQSemaphoreFunc_acquire, METH_NOARGS|METH_O},
    {"available", (PyCFunction)SbkQSemaphoreFunc_available, METH_NOARGS},
    {"release", (PyCFunction)SbkQSemaphoreFunc_release, METH_NOARGS|METH_O},
    {"tryAcquire", (PyCFunction)SbkQSemaphoreFunc_tryAcquire, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSemaphore_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QSemaphore",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSemaphore_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSemaphore_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QSemaphore >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QSemaphore(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QSEMAPHORE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSemaphore_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQSemaphore_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSemaphore_Type));
    PyModule_AddObject(module, "QSemaphore",
        ((PyObject*)&SbkQSemaphore_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QSemaphore >("QSemaphore*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSemaphore >(typeid(QSemaphore).name());
}


} // extern "C"

