/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qlocale_wrapper.h"

// Extra includes
#include <QDate>
#include <QList>
#include <qchar.h>
#include <qdatetime.h>
#include <qlocale.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQLocale_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QLocale* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QLocale", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QLocale()
        cptr = new QLocale();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // QLocale(QString)
        cptr = new QLocale(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QLocale::Language >::isConvertible(pyargs[0])) {
        QLocale::Language cpp_arg0 = Shiboken::Converter<QLocale::Language >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QLocale(QLocale::Language,QLocale::Country)
            cptr = new QLocale(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QLocale::Country >::isConvertible(pyargs[1])) {
            QLocale::Country cpp_arg1 = Shiboken::Converter<QLocale::Country >::toCpp(pyargs[1]);
            // QLocale(QLocale::Language,QLocale::Country)
            cptr = new QLocale(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQLocale_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QLocale & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QLocale > cpp_arg0_auto_ptr;
        QLocale* cpp_arg0 = Shiboken::Converter<QLocale* >::toCpp(pyargs[0]);
        if (!SbkQLocale_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QLocale >(cpp_arg0);
        // QLocale(QLocale)
        cptr = new QLocale(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLocale_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QLocale >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQLocale_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQLocale_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QLocale.Language, PySide.QtCore.QLocale.Country = AnyCountry", "PySide.QtCore.QLocale", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLocale", overloads);
        return -1;
}

static PyObject* SbkQLocaleFunc_amText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // amText()const
    QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QLocale::amText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLocaleFunc_c(PyObject* self)
{
    PyObject* py_result = 0;

    // c()
    QLocale cpp_result = QLocale::c();
    py_result = Shiboken::Converter<QLocale >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLocaleFunc_countriesForLanguage(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QLocale::Language >::isConvertible(arg)) {
        QLocale::Language cpp_arg0 = Shiboken::Converter<QLocale::Language >::toCpp(arg);
        // countriesForLanguage(QLocale::Language)
        QList<QLocale::Country > cpp_result = QLocale::countriesForLanguage(cpp_arg0);
        py_result = Shiboken::Converter<QList<QLocale::Country > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLocaleFunc_countriesForLanguage_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_countriesForLanguage_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLocale.Language", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLocale.countriesForLanguage", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_country(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // country()const
    QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
    QLocale::Country cpp_result = cppSelf->QLocale::country();
    py_result = Shiboken::Converter<QLocale::Country >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLocaleFunc_countryToString(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QLocale::Country >::isConvertible(arg)) {
        QLocale::Country cpp_arg0 = Shiboken::Converter<QLocale::Country >::toCpp(arg);
        // countryToString(QLocale::Country)
        QString cpp_result = QLocale::countryToString(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLocaleFunc_countryToString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_countryToString_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLocale.Country", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLocale.countryToString", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_dateFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // dateFormat(QLocale::FormatType)const
        QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QLocale::dateFormat();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QLocale::FormatType >::isConvertible(arg)) {
        QLocale::FormatType cpp_arg0 = Shiboken::Converter<QLocale::FormatType >::toCpp(arg);
        // dateFormat(QLocale::FormatType)const
        QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QLocale::dateFormat(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLocaleFunc_dateFormat_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_dateFormat_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLocale.FormatType = LongFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLocale.dateFormat", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_dateTimeFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // dateTimeFormat(QLocale::FormatType)const
        QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QLocale::dateTimeFormat();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QLocale::FormatType >::isConvertible(arg)) {
        QLocale::FormatType cpp_arg0 = Shiboken::Converter<QLocale::FormatType >::toCpp(arg);
        // dateTimeFormat(QLocale::FormatType)const
        QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QLocale::dateTimeFormat(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLocaleFunc_dateTimeFormat_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_dateTimeFormat_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLocale.FormatType = LongFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLocale.dateTimeFormat", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_dayName(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "dayName", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // dayName(int,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::dayName(cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QLocale::FormatType >::isConvertible(pyargs[1])) {
            QLocale::FormatType cpp_arg1 = Shiboken::Converter<QLocale::FormatType >::toCpp(pyargs[1]);
            // dayName(int,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::dayName(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQLocaleFunc_dayName_TypeError;
    } else goto SbkQLocaleFunc_dayName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_dayName_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QLocale.FormatType = LongFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLocale.dayName", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_decimalPoint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // decimalPoint()const
    QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
    QChar cpp_result = cppSelf->QLocale::decimalPoint();
    py_result = Shiboken::Converter<QChar >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLocaleFunc_exponential(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // exponential()const
    QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
    QChar cpp_result = cppSelf->QLocale::exponential();
    py_result = Shiboken::Converter<QChar >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLocaleFunc_groupSeparator(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // groupSeparator()const
    QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
    QChar cpp_result = cppSelf->QLocale::groupSeparator();
    py_result = Shiboken::Converter<QChar >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLocaleFunc_language(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // language()const
    QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
    QLocale::Language cpp_result = cppSelf->QLocale::language();
    py_result = Shiboken::Converter<QLocale::Language >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLocaleFunc_languageToString(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QLocale::Language >::isConvertible(arg)) {
        QLocale::Language cpp_arg0 = Shiboken::Converter<QLocale::Language >::toCpp(arg);
        // languageToString(QLocale::Language)
        QString cpp_result = QLocale::languageToString(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLocaleFunc_languageToString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_languageToString_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLocale.Language", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLocale.languageToString", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_measurementSystem(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // measurementSystem()const
    QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
    QLocale::MeasurementSystem cpp_result = cppSelf->QLocale::measurementSystem();
    py_result = Shiboken::Converter<QLocale::MeasurementSystem >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLocaleFunc_monthName(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "monthName", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // monthName(int,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::monthName(cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QLocale::FormatType >::isConvertible(pyargs[1])) {
            QLocale::FormatType cpp_arg1 = Shiboken::Converter<QLocale::FormatType >::toCpp(pyargs[1]);
            // monthName(int,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::monthName(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQLocaleFunc_monthName_TypeError;
    } else goto SbkQLocaleFunc_monthName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_monthName_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QLocale.FormatType = LongFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLocale.monthName", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QLocale::name();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLocaleFunc_negativeSign(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // negativeSign()const
    QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
    QChar cpp_result = cppSelf->QLocale::negativeSign();
    py_result = Shiboken::Converter<QChar >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLocaleFunc_numberOptions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // numberOptions()const
    QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
    QFlags<QLocale::NumberOption> cpp_result = cppSelf->QLocale::numberOptions();
    py_result = Shiboken::Converter<QFlags<QLocale::NumberOption> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLocaleFunc_percent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // percent()const
    QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
    QChar cpp_result = cppSelf->QLocale::percent();
    py_result = Shiboken::Converter<QChar >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLocaleFunc_pmText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pmText()const
    QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QLocale::pmText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLocaleFunc_positiveSign(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // positiveSign()const
    QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
    QChar cpp_result = cppSelf->QLocale::positiveSign();
    py_result = Shiboken::Converter<QChar >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLocaleFunc_setDefault(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QLocale & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QLocale > cpp_arg0_auto_ptr;
        QLocale* cpp_arg0 = Shiboken::Converter<QLocale* >::toCpp(arg);
        if (!SbkQLocale_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QLocale >(cpp_arg0);
        // setDefault(QLocale)
        QLocale::setDefault(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLocaleFunc_setDefault_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLocaleFunc_setDefault_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLocale", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLocale.setDefault", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_setNumberOptions(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_QLocale_NumberOption_Check(arg)) {
        QFlags<QLocale::NumberOption> cpp_arg0 = Shiboken::Converter<QFlags<QLocale::NumberOption> >::toCpp(arg);
        // setNumberOptions(QFlags<QLocale::NumberOption>)
        QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
        cppSelf->QLocale::setNumberOptions(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLocaleFunc_setNumberOptions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLocaleFunc_setNumberOptions_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLocale.NumberOptions", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLocale.setNumberOptions", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_standaloneDayName(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "standaloneDayName", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // standaloneDayName(int,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::standaloneDayName(cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QLocale::FormatType >::isConvertible(pyargs[1])) {
            QLocale::FormatType cpp_arg1 = Shiboken::Converter<QLocale::FormatType >::toCpp(pyargs[1]);
            // standaloneDayName(int,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::standaloneDayName(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQLocaleFunc_standaloneDayName_TypeError;
    } else goto SbkQLocaleFunc_standaloneDayName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_standaloneDayName_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QLocale.FormatType = LongFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLocale.standaloneDayName", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_standaloneMonthName(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "standaloneMonthName", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // standaloneMonthName(int,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::standaloneMonthName(cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QLocale::FormatType >::isConvertible(pyargs[1])) {
            QLocale::FormatType cpp_arg1 = Shiboken::Converter<QLocale::FormatType >::toCpp(pyargs[1]);
            // standaloneMonthName(int,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::standaloneMonthName(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQLocaleFunc_standaloneMonthName_TypeError;
    } else goto SbkQLocaleFunc_standaloneMonthName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_standaloneMonthName_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QLocale.FormatType = LongFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLocale.standaloneMonthName", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_system(PyObject* self)
{
    PyObject* py_result = 0;

    // system()
    QLocale cpp_result = QLocale::system();
    py_result = Shiboken::Converter<QLocale >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLocaleFunc_timeFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // timeFormat(QLocale::FormatType)const
        QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QLocale::timeFormat();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QLocale::FormatType >::isConvertible(arg)) {
        QLocale::FormatType cpp_arg0 = Shiboken::Converter<QLocale::FormatType >::toCpp(arg);
        // timeFormat(QLocale::FormatType)const
        QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QLocale::timeFormat(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLocaleFunc_timeFormat_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_timeFormat_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLocale.FormatType = LongFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLocale.timeFormat", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_toDate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "toDate", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // toDate(QString,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QDate cpp_result = cppSelf->QLocale::toDate(*cpp_arg0);
            py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // toDate(QString,QString)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QDate cpp_result = cppSelf->QLocale::toDate(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QLocale::FormatType >::isConvertible(pyargs[1])) {
            QLocale::FormatType cpp_arg1 = Shiboken::Converter<QLocale::FormatType >::toCpp(pyargs[1]);
            // toDate(QString,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QDate cpp_result = cppSelf->QLocale::toDate(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQLocaleFunc_toDate_TypeError;
    } else goto SbkQLocaleFunc_toDate_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_toDate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QLocale.FormatType = LongFormat", "PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLocale.toDate", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_toDateTime(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "toDateTime", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // toDateTime(QString,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QDateTime cpp_result = cppSelf->QLocale::toDateTime(*cpp_arg0);
            py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // toDateTime(QString,QString)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QDateTime cpp_result = cppSelf->QLocale::toDateTime(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QLocale::FormatType >::isConvertible(pyargs[1])) {
            QLocale::FormatType cpp_arg1 = Shiboken::Converter<QLocale::FormatType >::toCpp(pyargs[1]);
            // toDateTime(QString,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QDateTime cpp_result = cppSelf->QLocale::toDateTime(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQLocaleFunc_toDateTime_TypeError;
    } else goto SbkQLocaleFunc_toDateTime_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_toDateTime_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QLocale.FormatType = LongFormat", "PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLocale.toDateTime", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_toDouble(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // toDouble(QString,bool*)const
        QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_args,bool* - START
        bool ok_;
        double retval_ = cppSelf->toDouble(*cpp_arg0, &ok_);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_args,bool* - END
        
        // End of code injection


        //CppGenerator::writeParentChildManagement
    } else goto SbkQLocaleFunc_toDouble_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_toDouble_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLocale.toDouble", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_toFloat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // toFloat(QString,bool*)const
        QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_args,bool* - START
        bool ok_;
        float retval_ = cppSelf->toFloat(*cpp_arg0, &ok_);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_args,bool* - END
        
        // End of code injection


        //CppGenerator::writeParentChildManagement
    } else goto SbkQLocaleFunc_toFloat_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_toFloat_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLocale.toFloat", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_toInt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "toInt", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // toInt(QString,bool*,int)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - fix_arg,bool*,arg - START
            bool ok_;
            int retval_ = cppSelf->toInt((*cpp_arg0), &ok_, 0);
            py_result = Shiboken::makeTuple(retval_, ok_);
            // TEMPLATE - fix_arg,bool*,arg - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // toInt(QString,bool*,int)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - fix_arg,bool*,arg - START
            bool ok_;
            int retval_ = cppSelf->toInt((*cpp_arg0), &ok_, cpp_arg1);
            py_result = Shiboken::makeTuple(retval_, ok_);
            // TEMPLATE - fix_arg,bool*,arg - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else goto SbkQLocaleFunc_toInt_TypeError;
    } else goto SbkQLocaleFunc_toInt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_toInt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool = 0, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLocale.toInt", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_toLongLong(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "toLongLong", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // toLongLong(QString,bool*,int)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - fix_arg,bool*,arg - START
            bool ok_;
            qlonglong retval_ = cppSelf->toLongLong((*cpp_arg0), &ok_, 0);
            py_result = Shiboken::makeTuple(retval_, ok_);
            // TEMPLATE - fix_arg,bool*,arg - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // toLongLong(QString,bool*,int)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - fix_arg,bool*,arg - START
            bool ok_;
            qlonglong retval_ = cppSelf->toLongLong((*cpp_arg0), &ok_, cpp_arg1);
            py_result = Shiboken::makeTuple(retval_, ok_);
            // TEMPLATE - fix_arg,bool*,arg - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else goto SbkQLocaleFunc_toLongLong_TypeError;
    } else goto SbkQLocaleFunc_toLongLong_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_toLongLong_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool = 0, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLocale.toLongLong", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_toShort(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "toShort", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // toShort(QString,bool*,int)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - fix_arg,bool*,arg - START
            bool ok_;
            short retval_ = cppSelf->toShort((*cpp_arg0), &ok_, 0);
            py_result = Shiboken::makeTuple(retval_, ok_);
            // TEMPLATE - fix_arg,bool*,arg - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // toShort(QString,bool*,int)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - fix_arg,bool*,arg - START
            bool ok_;
            short retval_ = cppSelf->toShort((*cpp_arg0), &ok_, cpp_arg1);
            py_result = Shiboken::makeTuple(retval_, ok_);
            // TEMPLATE - fix_arg,bool*,arg - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else goto SbkQLocaleFunc_toShort_TypeError;
    } else goto SbkQLocaleFunc_toShort_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_toShort_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool = 0, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLocale.toShort", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_toString(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "toString", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 1 && PyLong_Check(pyargs[0])) {
        qlonglong cpp_arg0 = Shiboken::Converter<qlonglong >::toCpp(pyargs[0]);
        // toString(qlonglong)const
        QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QLocale::toString(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyFloat_Check(pyargs[0])) {
        float cpp_arg0 = Shiboken::Converter<float >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // toString(float,char,int)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::toString(cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<char >::isConvertible(pyargs[1])) {
            char cpp_arg1 = Shiboken::Converter<char >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // toString(float,char,int)const
                QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
                QString cpp_result = cppSelf->QLocale::toString(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QString >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // toString(float,char,int)const
                QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
                QString cpp_result = cppSelf->QLocale::toString(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QString >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQLocaleFunc_toString_TypeError;
        } else goto SbkQLocaleFunc_toString_TypeError;
    } else if (PyFloat_Check(pyargs[0])) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // toString(double,char,int)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::toString(cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<char >::isConvertible(pyargs[1])) {
            char cpp_arg1 = Shiboken::Converter<char >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // toString(double,char,int)const
                QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
                QString cpp_result = cppSelf->QLocale::toString(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QString >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // toString(double,char,int)const
                QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
                QString cpp_result = cppSelf->QLocale::toString(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QString >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQLocaleFunc_toString_TypeError;
        } else goto SbkQLocaleFunc_toString_TypeError;
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        short cpp_arg0 = Shiboken::Converter<short >::toCpp(pyargs[0]);
        // toString(short)const
        QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QLocale::toString(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // toString(int)const
        QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QLocale::toString(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QTime & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTime* cpp_arg0 = Shiboken::Converter<QTime* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // toString(QTime,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::toString(*cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // toString(QTime,QString)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::toString(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QLocale::FormatType >::isConvertible(pyargs[1])) {
            QLocale::FormatType cpp_arg1 = Shiboken::Converter<QLocale::FormatType >::toCpp(pyargs[1]);
            // toString(QTime,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::toString(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQLocaleFunc_toString_TypeError;
    } else if (Shiboken::Converter<QDateTime & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // toString(QDateTime,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::toString(*cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // toString(QDateTime,QString)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::toString(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QLocale::FormatType >::isConvertible(pyargs[1])) {
            QLocale::FormatType cpp_arg1 = Shiboken::Converter<QLocale::FormatType >::toCpp(pyargs[1]);
            // toString(QDateTime,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::toString(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQLocaleFunc_toString_TypeError;
    } else if (Shiboken::Converter<QDate & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // toString(QDate,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::toString(*cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // toString(QDate,QString)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::toString(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QLocale::FormatType >::isConvertible(pyargs[1])) {
            QLocale::FormatType cpp_arg1 = Shiboken::Converter<QLocale::FormatType >::toCpp(pyargs[1]);
            // toString(QDate,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QLocale::toString(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQLocaleFunc_toString_TypeError;
    } else goto SbkQLocaleFunc_toString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_toString_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDate, PySide.QtCore.QLocale.FormatType = LongFormat", "PySide.QtCore.QDate, PySide.QtCore.QString", "PySide.QtCore.QDateTime, PySide.QtCore.QLocale.FormatType = LongFormat", "PySide.QtCore.QDateTime, PySide.QtCore.QString", "PySide.QtCore.QTime, PySide.QtCore.QLocale.FormatType = LongFormat", "PySide.QtCore.QTime, PySide.QtCore.QString", "float, char = 'g', int = 6", "float, char = 'g', int = 6", "int", "long long", "short", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLocale.toString", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_toTime(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "toTime", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // toTime(QString,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QTime cpp_result = cppSelf->QLocale::toTime(*cpp_arg0);
            py_result = Shiboken::Converter<QTime >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // toTime(QString,QString)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QTime cpp_result = cppSelf->QLocale::toTime(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QTime >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QLocale::FormatType >::isConvertible(pyargs[1])) {
            QLocale::FormatType cpp_arg1 = Shiboken::Converter<QLocale::FormatType >::toCpp(pyargs[1]);
            // toTime(QString,QLocale::FormatType)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            QTime cpp_result = cppSelf->QLocale::toTime(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QTime >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQLocaleFunc_toTime_TypeError;
    } else goto SbkQLocaleFunc_toTime_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_toTime_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QLocale.FormatType = LongFormat", "PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLocale.toTime", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_toUInt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "toUInt", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // toUInt(QString,bool*,int)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - fix_arg,bool*,arg - START
            bool ok_;
            uint retval_ = cppSelf->toUInt((*cpp_arg0), &ok_, 0);
            py_result = Shiboken::makeTuple(retval_, ok_);
            // TEMPLATE - fix_arg,bool*,arg - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // toUInt(QString,bool*,int)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - fix_arg,bool*,arg - START
            bool ok_;
            uint retval_ = cppSelf->toUInt((*cpp_arg0), &ok_, cpp_arg1);
            py_result = Shiboken::makeTuple(retval_, ok_);
            // TEMPLATE - fix_arg,bool*,arg - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else goto SbkQLocaleFunc_toUInt_TypeError;
    } else goto SbkQLocaleFunc_toUInt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_toUInt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLocale.toUInt", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_toULongLong(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "toULongLong", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // toULongLong(QString,bool*,int)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - fix_arg,bool*,arg - START
            bool ok_;
            qlonglong retval_ = cppSelf->toULongLong((*cpp_arg0), &ok_, 0);
            py_result = Shiboken::makeTuple(retval_, ok_);
            // TEMPLATE - fix_arg,bool*,arg - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // toULongLong(QString,bool*,int)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - fix_arg,bool*,arg - START
            bool ok_;
            qlonglong retval_ = cppSelf->toULongLong((*cpp_arg0), &ok_, cpp_arg1);
            py_result = Shiboken::makeTuple(retval_, ok_);
            // TEMPLATE - fix_arg,bool*,arg - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else goto SbkQLocaleFunc_toULongLong_TypeError;
    } else goto SbkQLocaleFunc_toULongLong_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_toULongLong_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLocale.toULongLong", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_toUShort(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "toUShort", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // toUShort(QString,bool*,int)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - fix_arg,bool*,arg - START
            bool ok_;
            ushort retval_ = cppSelf->toUShort((*cpp_arg0), &ok_, 0);
            py_result = Shiboken::makeTuple(retval_, ok_);
            // TEMPLATE - fix_arg,bool*,arg - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // toUShort(QString,bool*,int)const
            QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - fix_arg,bool*,arg - START
            bool ok_;
            ushort retval_ = cppSelf->toUShort((*cpp_arg0), &ok_, cpp_arg1);
            py_result = Shiboken::makeTuple(retval_, ok_);
            // TEMPLATE - fix_arg,bool*,arg - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else goto SbkQLocaleFunc_toUShort_TypeError;
    } else goto SbkQLocaleFunc_toUShort_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLocaleFunc_toUShort_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool = 0, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLocale.toUShort", overloads);
        return 0;
}

static PyObject* SbkQLocaleFunc_zeroDigit(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // zeroDigit()const
    QLocale* cppSelf = Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);
    QChar cpp_result = cppSelf->QLocale::zeroDigit();
    py_result = Shiboken::Converter<QChar >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQLocale_methods[] = {
    {"amText", (PyCFunction)SbkQLocaleFunc_amText, METH_NOARGS},
    {"c", (PyCFunction)SbkQLocaleFunc_c, METH_NOARGS|METH_STATIC},
    {"countriesForLanguage", (PyCFunction)SbkQLocaleFunc_countriesForLanguage, METH_O|METH_STATIC},
    {"country", (PyCFunction)SbkQLocaleFunc_country, METH_NOARGS},
    {"countryToString", (PyCFunction)SbkQLocaleFunc_countryToString, METH_O|METH_STATIC},
    {"dateFormat", (PyCFunction)SbkQLocaleFunc_dateFormat, METH_NOARGS|METH_O},
    {"dateTimeFormat", (PyCFunction)SbkQLocaleFunc_dateTimeFormat, METH_NOARGS|METH_O},
    {"dayName", (PyCFunction)SbkQLocaleFunc_dayName, METH_VARARGS},
    {"decimalPoint", (PyCFunction)SbkQLocaleFunc_decimalPoint, METH_NOARGS},
    {"exponential", (PyCFunction)SbkQLocaleFunc_exponential, METH_NOARGS},
    {"groupSeparator", (PyCFunction)SbkQLocaleFunc_groupSeparator, METH_NOARGS},
    {"language", (PyCFunction)SbkQLocaleFunc_language, METH_NOARGS},
    {"languageToString", (PyCFunction)SbkQLocaleFunc_languageToString, METH_O|METH_STATIC},
    {"measurementSystem", (PyCFunction)SbkQLocaleFunc_measurementSystem, METH_NOARGS},
    {"monthName", (PyCFunction)SbkQLocaleFunc_monthName, METH_VARARGS},
    {"name", (PyCFunction)SbkQLocaleFunc_name, METH_NOARGS},
    {"negativeSign", (PyCFunction)SbkQLocaleFunc_negativeSign, METH_NOARGS},
    {"numberOptions", (PyCFunction)SbkQLocaleFunc_numberOptions, METH_NOARGS},
    {"percent", (PyCFunction)SbkQLocaleFunc_percent, METH_NOARGS},
    {"pmText", (PyCFunction)SbkQLocaleFunc_pmText, METH_NOARGS},
    {"positiveSign", (PyCFunction)SbkQLocaleFunc_positiveSign, METH_NOARGS},
    {"setDefault", (PyCFunction)SbkQLocaleFunc_setDefault, METH_O|METH_STATIC},
    {"setNumberOptions", (PyCFunction)SbkQLocaleFunc_setNumberOptions, METH_O},
    {"standaloneDayName", (PyCFunction)SbkQLocaleFunc_standaloneDayName, METH_VARARGS},
    {"standaloneMonthName", (PyCFunction)SbkQLocaleFunc_standaloneMonthName, METH_VARARGS},
    {"system", (PyCFunction)SbkQLocaleFunc_system, METH_NOARGS|METH_STATIC},
    {"timeFormat", (PyCFunction)SbkQLocaleFunc_timeFormat, METH_NOARGS|METH_O},
    {"toDate", (PyCFunction)SbkQLocaleFunc_toDate, METH_VARARGS},
    {"toDateTime", (PyCFunction)SbkQLocaleFunc_toDateTime, METH_VARARGS},
    {"toDouble", (PyCFunction)SbkQLocaleFunc_toDouble, METH_O},
    {"toFloat", (PyCFunction)SbkQLocaleFunc_toFloat, METH_O},
    {"toInt", (PyCFunction)SbkQLocaleFunc_toInt, METH_VARARGS},
    {"toLongLong", (PyCFunction)SbkQLocaleFunc_toLongLong, METH_VARARGS},
    {"toShort", (PyCFunction)SbkQLocaleFunc_toShort, METH_VARARGS},
    {"toString", (PyCFunction)SbkQLocaleFunc_toString, METH_VARARGS},
    {"toTime", (PyCFunction)SbkQLocaleFunc_toTime, METH_VARARGS},
    {"toUInt", (PyCFunction)SbkQLocaleFunc_toUInt, METH_VARARGS},
    {"toULongLong", (PyCFunction)SbkQLocaleFunc_toULongLong, METH_VARARGS},
    {"toUShort", (PyCFunction)SbkQLocaleFunc_toUShort, METH_VARARGS},
    {"zeroDigit", (PyCFunction)SbkQLocaleFunc_zeroDigit, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQLocale_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QLocale& cpp_self = *Shiboken::Converter<QLocale* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QLocale & >::isConvertible(other)) {
                // operator!=(const QLocale & other) const
                QLocale* cpp_other = Shiboken::Converter<QLocale* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QLocale  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QLocale >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QLocale > cpp_other_auto_ptr;
                QLocale* cpp_other = Shiboken::Converter<QLocale* >::toCpp(other);
                if (!SbkQLocale_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QLocale >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQLocale_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QLocale & >::isConvertible(other)) {
                // operator==(const QLocale & other) const
                QLocale* cpp_other = Shiboken::Converter<QLocale* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QLocale  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QLocale >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QLocale > cpp_other_auto_ptr;
                QLocale* cpp_other = Shiboken::Converter<QLocale* >::toCpp(other);
                if (!SbkQLocale_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QLocale >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQLocale_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQLocale_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQLocale_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QLocale",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQLocale_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQLocale_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQLocale_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QLocale >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtCore_QLocale_MeasurementSystem_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QLocale_MeasurementSystem_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QLocale_MeasurementSystem_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MeasurementSystem",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QLocale_MeasurementSystem_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QLocale_MeasurementSystem_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QLocale_MeasurementSystem_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtCore_QLocale_NumberOption___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QLocale::NumberOptions >::toPython(
        ((QLocale::NumberOptions) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QLocale::NumberOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QLocale_NumberOption___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QLocale::NumberOptions >::toPython(
        ((QLocale::NumberOptions) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QLocale::NumberOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QLocale_NumberOption___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QLocale::NumberOptions >::toPython(
        ((QLocale::NumberOptions) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QLocale::NumberOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QLocale_NumberOption___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QLocale::NumberOptions >::toPython(
        ~ Shiboken::Converter< QLocale::NumberOptions >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_QLocale_NumberOption_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_QLocale_NumberOption___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_QLocale_NumberOption___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_QLocale_NumberOption___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_QLocale_NumberOption___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_QLocale_NumberOption_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QLocale_NumberOption_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QLocale_NumberOption_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "NumberOption",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_QLocale_NumberOption_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QLocale_NumberOption_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QLocale_NumberOption_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QLocale_NumberOption_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QLocale_NumberOptions_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QLocale_NumberOptions_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "NumberOptions",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_QLocale_NumberOption_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QLocale_NumberOptions_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QLocale_NumberOptions_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_QLocale_NumberOptions_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtCore_QLocale_FormatType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QLocale_FormatType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QLocale_FormatType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FormatType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QLocale_FormatType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QLocale_FormatType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QLocale_FormatType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QLocale_Country_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QLocale_Country_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QLocale_Country_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Country",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QLocale_Country_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QLocale_Country_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QLocale_Country_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QLocale_Language_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QLocale_Language_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QLocale_Language_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Language",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QLocale_Language_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QLocale_Language_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QLocale_Language_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QLocale(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QLOCALE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQLocale_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQLocale_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQLocale_Type));
    PyModule_AddObject(module, "QLocale",
        ((PyObject*)&SbkQLocale_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: MeasurementSystem
    SbkPySide_QtCoreTypes[SBK_QLOCALE_MEASUREMENTSYSTEM_IDX] = &SbkPySide_QtCore_QLocale_MeasurementSystem_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QLocale_MeasurementSystem_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QLocale_MeasurementSystem_Type);
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
            "MeasurementSystem",((PyObject*)&SbkPySide_QtCore_QLocale_MeasurementSystem_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_MeasurementSystem_Type,
        (long) QLocale::MetricSystem, "MetricSystem");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "MetricSystem", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_MeasurementSystem_Type.tp_dict,
        "MetricSystem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_MeasurementSystem_Type,
        (long) QLocale::ImperialSystem, "ImperialSystem");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "ImperialSystem", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_MeasurementSystem_Type.tp_dict,
        "ImperialSystem", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QLocale::MeasurementSystem");

    // init enum class: NumberOption
    SbkPySide_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX] = &SbkPySide_QtCore_QLocale_NumberOption_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QLocale_NumberOption_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QLocale_NumberOption_Type);
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
            "NumberOption",((PyObject*)&SbkPySide_QtCore_QLocale_NumberOption_Type));

    // init flags class: QFlags<QLocale::NumberOption>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION__IDX] = &SbkPySide_QtCore_QLocale_NumberOptions_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QLocale_NumberOptions_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QLocale_NumberOptions_Type);
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
            "NumberOptions",((PyObject*)&SbkPySide_QtCore_QLocale_NumberOptions_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_NumberOption_Type,
        (long) QLocale::OmitGroupSeparator, "OmitGroupSeparator");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "OmitGroupSeparator", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_NumberOption_Type.tp_dict,
        "OmitGroupSeparator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_NumberOption_Type,
        (long) QLocale::RejectGroupSeparator, "RejectGroupSeparator");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "RejectGroupSeparator", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_NumberOption_Type.tp_dict,
        "RejectGroupSeparator", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QLocale::NumberOption");

    // init enum class: FormatType
    SbkPySide_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX] = &SbkPySide_QtCore_QLocale_FormatType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QLocale_FormatType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QLocale_FormatType_Type);
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
            "FormatType",((PyObject*)&SbkPySide_QtCore_QLocale_FormatType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_FormatType_Type,
        (long) QLocale::LongFormat, "LongFormat");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "LongFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_FormatType_Type.tp_dict,
        "LongFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_FormatType_Type,
        (long) QLocale::ShortFormat, "ShortFormat");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "ShortFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_FormatType_Type.tp_dict,
        "ShortFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_FormatType_Type,
        (long) QLocale::NarrowFormat, "NarrowFormat");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "NarrowFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_FormatType_Type.tp_dict,
        "NarrowFormat", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QLocale::FormatType");

    // init enum class: Country
    SbkPySide_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX] = &SbkPySide_QtCore_QLocale_Country_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QLocale_Country_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QLocale_Country_Type);
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
            "Country",((PyObject*)&SbkPySide_QtCore_QLocale_Country_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::AnyCountry, "AnyCountry");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "AnyCountry", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "AnyCountry", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Afghanistan, "Afghanistan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Afghanistan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Afghanistan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Albania, "Albania");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Albania", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Albania", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Algeria, "Algeria");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Algeria", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Algeria", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::AmericanSamoa, "AmericanSamoa");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "AmericanSamoa", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "AmericanSamoa", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Andorra, "Andorra");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Andorra", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Andorra", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Angola, "Angola");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Angola", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Angola", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Anguilla, "Anguilla");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Anguilla", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Anguilla", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Antarctica, "Antarctica");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Antarctica", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Antarctica", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::AntiguaAndBarbuda, "AntiguaAndBarbuda");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "AntiguaAndBarbuda", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "AntiguaAndBarbuda", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Argentina, "Argentina");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Argentina", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Argentina", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Armenia, "Armenia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Armenia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Armenia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Aruba, "Aruba");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Aruba", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Aruba", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Australia, "Australia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Australia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Australia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Austria, "Austria");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Austria", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Austria", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Azerbaijan, "Azerbaijan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Azerbaijan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Azerbaijan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Bahamas, "Bahamas");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Bahamas", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Bahamas", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Bahrain, "Bahrain");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Bahrain", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Bahrain", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Bangladesh, "Bangladesh");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Bangladesh", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Bangladesh", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Barbados, "Barbados");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Barbados", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Barbados", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Belarus, "Belarus");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Belarus", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Belarus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Belgium, "Belgium");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Belgium", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Belgium", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Belize, "Belize");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Belize", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Belize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Benin, "Benin");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Benin", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Benin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Bermuda, "Bermuda");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Bermuda", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Bermuda", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Bhutan, "Bhutan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Bhutan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Bhutan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Bolivia, "Bolivia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Bolivia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Bolivia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::BosniaAndHerzegowina, "BosniaAndHerzegowina");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "BosniaAndHerzegowina", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "BosniaAndHerzegowina", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Botswana, "Botswana");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Botswana", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Botswana", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::BouvetIsland, "BouvetIsland");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "BouvetIsland", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "BouvetIsland", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Brazil, "Brazil");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Brazil", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Brazil", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::BritishIndianOceanTerritory, "BritishIndianOceanTerritory");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "BritishIndianOceanTerritory", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "BritishIndianOceanTerritory", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::BruneiDarussalam, "BruneiDarussalam");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "BruneiDarussalam", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "BruneiDarussalam", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Bulgaria, "Bulgaria");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Bulgaria", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Bulgaria", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::BurkinaFaso, "BurkinaFaso");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "BurkinaFaso", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "BurkinaFaso", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Burundi, "Burundi");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Burundi", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Burundi", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Cambodia, "Cambodia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Cambodia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Cambodia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Cameroon, "Cameroon");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Cameroon", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Cameroon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Canada, "Canada");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Canada", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Canada", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::CapeVerde, "CapeVerde");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "CapeVerde", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "CapeVerde", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::CaymanIslands, "CaymanIslands");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "CaymanIslands", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "CaymanIslands", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::CentralAfricanRepublic, "CentralAfricanRepublic");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "CentralAfricanRepublic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "CentralAfricanRepublic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Chad, "Chad");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Chad", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Chad", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Chile, "Chile");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Chile", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Chile", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::China, "China");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "China", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "China", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::ChristmasIsland, "ChristmasIsland");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "ChristmasIsland", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "ChristmasIsland", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::CocosIslands, "CocosIslands");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "CocosIslands", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "CocosIslands", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Colombia, "Colombia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Colombia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Colombia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Comoros, "Comoros");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Comoros", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Comoros", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::DemocraticRepublicOfCongo, "DemocraticRepublicOfCongo");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "DemocraticRepublicOfCongo", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "DemocraticRepublicOfCongo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::PeoplesRepublicOfCongo, "PeoplesRepublicOfCongo");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "PeoplesRepublicOfCongo", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "PeoplesRepublicOfCongo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::CookIslands, "CookIslands");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "CookIslands", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "CookIslands", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::CostaRica, "CostaRica");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "CostaRica", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "CostaRica", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::IvoryCoast, "IvoryCoast");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "IvoryCoast", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "IvoryCoast", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Croatia, "Croatia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Croatia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Croatia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Cuba, "Cuba");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Cuba", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Cuba", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Cyprus, "Cyprus");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Cyprus", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Cyprus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::CzechRepublic, "CzechRepublic");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "CzechRepublic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "CzechRepublic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Denmark, "Denmark");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Denmark", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Denmark", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Djibouti, "Djibouti");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Djibouti", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Djibouti", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Dominica, "Dominica");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Dominica", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Dominica", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::DominicanRepublic, "DominicanRepublic");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "DominicanRepublic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "DominicanRepublic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::EastTimor, "EastTimor");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "EastTimor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "EastTimor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Ecuador, "Ecuador");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Ecuador", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Ecuador", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Egypt, "Egypt");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Egypt", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Egypt", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::ElSalvador, "ElSalvador");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "ElSalvador", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "ElSalvador", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::EquatorialGuinea, "EquatorialGuinea");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "EquatorialGuinea", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "EquatorialGuinea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Eritrea, "Eritrea");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Eritrea", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Eritrea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Estonia, "Estonia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Estonia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Estonia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Ethiopia, "Ethiopia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Ethiopia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Ethiopia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::FalklandIslands, "FalklandIslands");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "FalklandIslands", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "FalklandIslands", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::FaroeIslands, "FaroeIslands");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "FaroeIslands", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "FaroeIslands", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::FijiCountry, "FijiCountry");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "FijiCountry", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "FijiCountry", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Finland, "Finland");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Finland", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Finland", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::France, "France");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "France", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "France", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::MetropolitanFrance, "MetropolitanFrance");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "MetropolitanFrance", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "MetropolitanFrance", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::FrenchGuiana, "FrenchGuiana");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "FrenchGuiana", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "FrenchGuiana", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::FrenchPolynesia, "FrenchPolynesia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "FrenchPolynesia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "FrenchPolynesia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::FrenchSouthernTerritories, "FrenchSouthernTerritories");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "FrenchSouthernTerritories", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "FrenchSouthernTerritories", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Gabon, "Gabon");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Gabon", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Gabon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Gambia, "Gambia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Gambia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Gambia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Georgia, "Georgia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Georgia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Georgia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Germany, "Germany");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Germany", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Germany", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Ghana, "Ghana");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Ghana", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Ghana", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Gibraltar, "Gibraltar");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Gibraltar", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Gibraltar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Greece, "Greece");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Greece", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Greece", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Greenland, "Greenland");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Greenland", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Greenland", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Grenada, "Grenada");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Grenada", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Grenada", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Guadeloupe, "Guadeloupe");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Guadeloupe", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Guadeloupe", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Guam, "Guam");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Guam", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Guam", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Guatemala, "Guatemala");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Guatemala", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Guatemala", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Guinea, "Guinea");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Guinea", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Guinea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::GuineaBissau, "GuineaBissau");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "GuineaBissau", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "GuineaBissau", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Guyana, "Guyana");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Guyana", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Guyana", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Haiti, "Haiti");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Haiti", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Haiti", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::HeardAndMcDonaldIslands, "HeardAndMcDonaldIslands");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "HeardAndMcDonaldIslands", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "HeardAndMcDonaldIslands", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Honduras, "Honduras");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Honduras", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Honduras", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::HongKong, "HongKong");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "HongKong", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "HongKong", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Hungary, "Hungary");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Hungary", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Hungary", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Iceland, "Iceland");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Iceland", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Iceland", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::India, "India");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "India", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "India", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Indonesia, "Indonesia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Indonesia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Indonesia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Iran, "Iran");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Iran", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Iran", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Iraq, "Iraq");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Iraq", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Iraq", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Ireland, "Ireland");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Ireland", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Ireland", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Israel, "Israel");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Israel", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Israel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Italy, "Italy");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Italy", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Italy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Jamaica, "Jamaica");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Jamaica", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Jamaica", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Japan, "Japan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Japan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Japan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Jordan, "Jordan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Jordan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Jordan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Kazakhstan, "Kazakhstan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Kazakhstan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Kazakhstan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Kenya, "Kenya");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Kenya", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Kenya", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Kiribati, "Kiribati");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Kiribati", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Kiribati", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::DemocraticRepublicOfKorea, "DemocraticRepublicOfKorea");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "DemocraticRepublicOfKorea", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "DemocraticRepublicOfKorea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::RepublicOfKorea, "RepublicOfKorea");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "RepublicOfKorea", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "RepublicOfKorea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Kuwait, "Kuwait");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Kuwait", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Kuwait", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Kyrgyzstan, "Kyrgyzstan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Kyrgyzstan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Kyrgyzstan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Lao, "Lao");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Lao", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Lao", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Latvia, "Latvia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Latvia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Latvia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Lebanon, "Lebanon");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Lebanon", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Lebanon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Lesotho, "Lesotho");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Lesotho", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Lesotho", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Liberia, "Liberia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Liberia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Liberia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::LibyanArabJamahiriya, "LibyanArabJamahiriya");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "LibyanArabJamahiriya", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "LibyanArabJamahiriya", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Liechtenstein, "Liechtenstein");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Liechtenstein", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Liechtenstein", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Lithuania, "Lithuania");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Lithuania", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Lithuania", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Luxembourg, "Luxembourg");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Luxembourg", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Luxembourg", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Macau, "Macau");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Macau", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Macau", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Macedonia, "Macedonia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Macedonia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Macedonia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Madagascar, "Madagascar");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Madagascar", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Madagascar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Malawi, "Malawi");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Malawi", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Malawi", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Malaysia, "Malaysia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Malaysia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Malaysia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Maldives, "Maldives");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Maldives", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Maldives", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Mali, "Mali");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Mali", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Mali", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Malta, "Malta");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Malta", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Malta", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::MarshallIslands, "MarshallIslands");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "MarshallIslands", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "MarshallIslands", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Martinique, "Martinique");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Martinique", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Martinique", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Mauritania, "Mauritania");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Mauritania", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Mauritania", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Mauritius, "Mauritius");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Mauritius", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Mauritius", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Mayotte, "Mayotte");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Mayotte", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Mayotte", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Mexico, "Mexico");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Mexico", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Mexico", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Micronesia, "Micronesia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Micronesia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Micronesia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Moldova, "Moldova");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Moldova", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Moldova", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Monaco, "Monaco");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Monaco", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Monaco", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Mongolia, "Mongolia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Mongolia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Mongolia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Montserrat, "Montserrat");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Montserrat", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Montserrat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Morocco, "Morocco");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Morocco", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Morocco", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Mozambique, "Mozambique");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Mozambique", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Mozambique", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Myanmar, "Myanmar");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Myanmar", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Myanmar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Namibia, "Namibia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Namibia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Namibia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::NauruCountry, "NauruCountry");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "NauruCountry", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "NauruCountry", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Nepal, "Nepal");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Nepal", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Nepal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Netherlands, "Netherlands");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Netherlands", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Netherlands", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::NetherlandsAntilles, "NetherlandsAntilles");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "NetherlandsAntilles", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "NetherlandsAntilles", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::NewCaledonia, "NewCaledonia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "NewCaledonia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "NewCaledonia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::NewZealand, "NewZealand");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "NewZealand", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "NewZealand", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Nicaragua, "Nicaragua");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Nicaragua", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Nicaragua", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Niger, "Niger");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Niger", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Niger", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Nigeria, "Nigeria");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Nigeria", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Nigeria", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Niue, "Niue");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Niue", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Niue", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::NorfolkIsland, "NorfolkIsland");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "NorfolkIsland", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "NorfolkIsland", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::NorthernMarianaIslands, "NorthernMarianaIslands");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "NorthernMarianaIslands", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "NorthernMarianaIslands", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Norway, "Norway");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Norway", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Norway", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Oman, "Oman");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Oman", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Oman", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Pakistan, "Pakistan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Pakistan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Pakistan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Palau, "Palau");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Palau", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Palau", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::PalestinianTerritory, "PalestinianTerritory");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "PalestinianTerritory", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "PalestinianTerritory", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Panama, "Panama");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Panama", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Panama", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::PapuaNewGuinea, "PapuaNewGuinea");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "PapuaNewGuinea", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "PapuaNewGuinea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Paraguay, "Paraguay");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Paraguay", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Paraguay", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Peru, "Peru");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Peru", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Peru", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Philippines, "Philippines");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Philippines", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Philippines", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Pitcairn, "Pitcairn");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Pitcairn", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Pitcairn", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Poland, "Poland");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Poland", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Poland", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Portugal, "Portugal");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Portugal", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Portugal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::PuertoRico, "PuertoRico");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "PuertoRico", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "PuertoRico", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Qatar, "Qatar");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Qatar", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Qatar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Reunion, "Reunion");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Reunion", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Reunion", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Romania, "Romania");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Romania", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Romania", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::RussianFederation, "RussianFederation");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "RussianFederation", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "RussianFederation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Rwanda, "Rwanda");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Rwanda", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Rwanda", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::SaintKittsAndNevis, "SaintKittsAndNevis");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "SaintKittsAndNevis", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "SaintKittsAndNevis", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::StLucia, "StLucia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "StLucia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "StLucia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::StVincentAndTheGrenadines, "StVincentAndTheGrenadines");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "StVincentAndTheGrenadines", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "StVincentAndTheGrenadines", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Samoa, "Samoa");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Samoa", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Samoa", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::SanMarino, "SanMarino");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "SanMarino", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "SanMarino", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::SaoTomeAndPrincipe, "SaoTomeAndPrincipe");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "SaoTomeAndPrincipe", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "SaoTomeAndPrincipe", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::SaudiArabia, "SaudiArabia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "SaudiArabia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "SaudiArabia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Senegal, "Senegal");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Senegal", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Senegal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Seychelles, "Seychelles");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Seychelles", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Seychelles", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::SierraLeone, "SierraLeone");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "SierraLeone", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "SierraLeone", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Singapore, "Singapore");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Singapore", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Singapore", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Slovakia, "Slovakia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Slovakia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Slovakia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Slovenia, "Slovenia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Slovenia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Slovenia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::SolomonIslands, "SolomonIslands");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "SolomonIslands", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "SolomonIslands", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Somalia, "Somalia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Somalia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Somalia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::SouthAfrica, "SouthAfrica");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "SouthAfrica", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "SouthAfrica", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::SouthGeorgiaAndTheSouthSandwichIslands, "SouthGeorgiaAndTheSouthSandwichIslands");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "SouthGeorgiaAndTheSouthSandwichIslands", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "SouthGeorgiaAndTheSouthSandwichIslands", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Spain, "Spain");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Spain", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Spain", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::SriLanka, "SriLanka");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "SriLanka", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "SriLanka", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::StHelena, "StHelena");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "StHelena", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "StHelena", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::StPierreAndMiquelon, "StPierreAndMiquelon");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "StPierreAndMiquelon", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "StPierreAndMiquelon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Sudan, "Sudan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Sudan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Sudan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Suriname, "Suriname");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Suriname", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Suriname", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::SvalbardAndJanMayenIslands, "SvalbardAndJanMayenIslands");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "SvalbardAndJanMayenIslands", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "SvalbardAndJanMayenIslands", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Swaziland, "Swaziland");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Swaziland", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Swaziland", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Sweden, "Sweden");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Sweden", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Sweden", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Switzerland, "Switzerland");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Switzerland", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Switzerland", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::SyrianArabRepublic, "SyrianArabRepublic");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "SyrianArabRepublic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "SyrianArabRepublic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Taiwan, "Taiwan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Taiwan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Taiwan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Tajikistan, "Tajikistan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Tajikistan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Tajikistan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Tanzania, "Tanzania");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Tanzania", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Tanzania", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Thailand, "Thailand");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Thailand", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Thailand", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Togo, "Togo");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Togo", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Togo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Tokelau, "Tokelau");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Tokelau", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Tokelau", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::TongaCountry, "TongaCountry");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "TongaCountry", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "TongaCountry", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::TrinidadAndTobago, "TrinidadAndTobago");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "TrinidadAndTobago", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "TrinidadAndTobago", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Tunisia, "Tunisia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Tunisia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Tunisia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Turkey, "Turkey");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Turkey", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Turkey", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Turkmenistan, "Turkmenistan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Turkmenistan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Turkmenistan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::TurksAndCaicosIslands, "TurksAndCaicosIslands");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "TurksAndCaicosIslands", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "TurksAndCaicosIslands", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Tuvalu, "Tuvalu");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Tuvalu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Tuvalu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Uganda, "Uganda");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Uganda", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Uganda", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Ukraine, "Ukraine");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Ukraine", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Ukraine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::UnitedArabEmirates, "UnitedArabEmirates");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "UnitedArabEmirates", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "UnitedArabEmirates", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::UnitedKingdom, "UnitedKingdom");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "UnitedKingdom", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "UnitedKingdom", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::UnitedStates, "UnitedStates");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "UnitedStates", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "UnitedStates", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::UnitedStatesMinorOutlyingIslands, "UnitedStatesMinorOutlyingIslands");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "UnitedStatesMinorOutlyingIslands", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "UnitedStatesMinorOutlyingIslands", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Uruguay, "Uruguay");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Uruguay", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Uruguay", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Uzbekistan, "Uzbekistan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Uzbekistan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Uzbekistan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Vanuatu, "Vanuatu");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Vanuatu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Vanuatu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::VaticanCityState, "VaticanCityState");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "VaticanCityState", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "VaticanCityState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Venezuela, "Venezuela");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Venezuela", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Venezuela", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::VietNam, "VietNam");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "VietNam", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "VietNam", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::BritishVirginIslands, "BritishVirginIslands");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "BritishVirginIslands", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "BritishVirginIslands", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::USVirginIslands, "USVirginIslands");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "USVirginIslands", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "USVirginIslands", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::WallisAndFutunaIslands, "WallisAndFutunaIslands");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "WallisAndFutunaIslands", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "WallisAndFutunaIslands", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::WesternSahara, "WesternSahara");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "WesternSahara", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "WesternSahara", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Yemen, "Yemen");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Yemen", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Yemen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Yugoslavia, "Yugoslavia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Yugoslavia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Yugoslavia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Zambia, "Zambia");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Zambia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Zambia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::Zimbabwe, "Zimbabwe");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Zimbabwe", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "Zimbabwe", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::SerbiaAndMontenegro, "SerbiaAndMontenegro");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "SerbiaAndMontenegro", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "SerbiaAndMontenegro", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Country_Type,
        (long) QLocale::LastCountry, "LastCountry");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "LastCountry", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Country_Type.tp_dict,
        "LastCountry", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QLocale::Country");

    // init enum class: Language
    SbkPySide_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX] = &SbkPySide_QtCore_QLocale_Language_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QLocale_Language_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QLocale_Language_Type);
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
            "Language",((PyObject*)&SbkPySide_QtCore_QLocale_Language_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::C, "C");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "C", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "C", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Abkhazian, "Abkhazian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Abkhazian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Abkhazian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Afan, "Afan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Afan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Afan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Afar, "Afar");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Afar", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Afar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Afrikaans, "Afrikaans");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Afrikaans", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Afrikaans", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Albanian, "Albanian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Albanian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Albanian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Amharic, "Amharic");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Amharic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Amharic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Arabic, "Arabic");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Arabic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Arabic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Armenian, "Armenian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Armenian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Armenian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Assamese, "Assamese");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Assamese", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Assamese", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Aymara, "Aymara");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Aymara", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Aymara", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Azerbaijani, "Azerbaijani");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Azerbaijani", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Azerbaijani", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Bashkir, "Bashkir");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Bashkir", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Bashkir", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Basque, "Basque");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Basque", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Basque", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Bengali, "Bengali");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Bengali", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Bengali", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Bhutani, "Bhutani");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Bhutani", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Bhutani", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Bihari, "Bihari");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Bihari", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Bihari", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Bislama, "Bislama");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Bislama", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Bislama", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Breton, "Breton");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Breton", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Breton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Bulgarian, "Bulgarian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Bulgarian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Bulgarian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Burmese, "Burmese");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Burmese", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Burmese", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Byelorussian, "Byelorussian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Byelorussian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Byelorussian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Cambodian, "Cambodian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Cambodian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Cambodian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Catalan, "Catalan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Catalan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Catalan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Chinese, "Chinese");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Chinese", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Chinese", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Corsican, "Corsican");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Corsican", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Corsican", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Croatian, "Croatian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Croatian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Croatian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Czech, "Czech");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Czech", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Czech", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Danish, "Danish");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Danish", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Danish", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Dutch, "Dutch");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Dutch", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Dutch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::English, "English");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "English", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "English", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Esperanto, "Esperanto");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Esperanto", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Esperanto", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Estonian, "Estonian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Estonian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Estonian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Faroese, "Faroese");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Faroese", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Faroese", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::FijiLanguage, "FijiLanguage");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "FijiLanguage", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "FijiLanguage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Finnish, "Finnish");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Finnish", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Finnish", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::French, "French");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "French", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "French", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Frisian, "Frisian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Frisian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Frisian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Gaelic, "Gaelic");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Gaelic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Gaelic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Galician, "Galician");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Galician", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Galician", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Georgian, "Georgian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Georgian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Georgian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::German, "German");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "German", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "German", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Greek, "Greek");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Greek", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Greek", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Greenlandic, "Greenlandic");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Greenlandic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Greenlandic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Guarani, "Guarani");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Guarani", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Guarani", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Gujarati, "Gujarati");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Gujarati", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Gujarati", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Hausa, "Hausa");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Hausa", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Hausa", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Hebrew, "Hebrew");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Hebrew", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Hebrew", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Hindi, "Hindi");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Hindi", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Hindi", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Hungarian, "Hungarian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Hungarian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Hungarian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Icelandic, "Icelandic");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Icelandic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Icelandic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Indonesian, "Indonesian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Indonesian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Indonesian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Interlingua, "Interlingua");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Interlingua", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Interlingua", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Interlingue, "Interlingue");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Interlingue", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Interlingue", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Inuktitut, "Inuktitut");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Inuktitut", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Inuktitut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Inupiak, "Inupiak");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Inupiak", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Inupiak", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Irish, "Irish");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Irish", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Irish", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Italian, "Italian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Italian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Italian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Japanese, "Japanese");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Japanese", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Japanese", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Javanese, "Javanese");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Javanese", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Javanese", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Kannada, "Kannada");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Kannada", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Kannada", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Kashmiri, "Kashmiri");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Kashmiri", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Kashmiri", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Kazakh, "Kazakh");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Kazakh", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Kazakh", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Kinyarwanda, "Kinyarwanda");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Kinyarwanda", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Kinyarwanda", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Kirghiz, "Kirghiz");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Kirghiz", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Kirghiz", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Korean, "Korean");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Korean", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Korean", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Kurdish, "Kurdish");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Kurdish", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Kurdish", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Kurundi, "Kurundi");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Kurundi", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Kurundi", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Laothian, "Laothian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Laothian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Laothian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Latin, "Latin");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Latin", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Latin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Latvian, "Latvian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Latvian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Latvian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Lingala, "Lingala");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Lingala", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Lingala", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Lithuanian, "Lithuanian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Lithuanian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Lithuanian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Macedonian, "Macedonian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Macedonian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Macedonian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Malagasy, "Malagasy");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Malagasy", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Malagasy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Malay, "Malay");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Malay", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Malay", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Malayalam, "Malayalam");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Malayalam", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Malayalam", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Maltese, "Maltese");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Maltese", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Maltese", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Maori, "Maori");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Maori", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Maori", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Marathi, "Marathi");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Marathi", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Marathi", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Moldavian, "Moldavian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Moldavian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Moldavian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Mongolian, "Mongolian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Mongolian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Mongolian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::NauruLanguage, "NauruLanguage");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "NauruLanguage", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "NauruLanguage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Nepali, "Nepali");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Nepali", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Nepali", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Norwegian, "Norwegian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Norwegian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Norwegian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::NorwegianBokmal, "NorwegianBokmal");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "NorwegianBokmal", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "NorwegianBokmal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Occitan, "Occitan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Occitan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Occitan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Oriya, "Oriya");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Oriya", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Oriya", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Pashto, "Pashto");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Pashto", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Pashto", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Persian, "Persian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Persian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Persian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Polish, "Polish");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Polish", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Polish", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Portuguese, "Portuguese");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Portuguese", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Portuguese", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Punjabi, "Punjabi");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Punjabi", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Punjabi", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Quechua, "Quechua");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Quechua", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Quechua", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::RhaetoRomance, "RhaetoRomance");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "RhaetoRomance", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "RhaetoRomance", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Romanian, "Romanian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Romanian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Romanian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Russian, "Russian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Russian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Russian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Samoan, "Samoan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Samoan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Samoan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Sangho, "Sangho");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Sangho", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Sangho", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Sanskrit, "Sanskrit");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Sanskrit", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Sanskrit", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Serbian, "Serbian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Serbian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Serbian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::SerboCroatian, "SerboCroatian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "SerboCroatian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "SerboCroatian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Sesotho, "Sesotho");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Sesotho", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Sesotho", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Setswana, "Setswana");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Setswana", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Setswana", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Shona, "Shona");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Shona", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Shona", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Sindhi, "Sindhi");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Sindhi", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Sindhi", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Singhalese, "Singhalese");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Singhalese", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Singhalese", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Siswati, "Siswati");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Siswati", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Siswati", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Slovak, "Slovak");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Slovak", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Slovak", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Slovenian, "Slovenian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Slovenian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Slovenian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Somali, "Somali");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Somali", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Somali", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Spanish, "Spanish");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Spanish", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Spanish", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Sundanese, "Sundanese");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Sundanese", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Sundanese", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Swahili, "Swahili");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Swahili", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Swahili", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Swedish, "Swedish");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Swedish", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Swedish", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Tagalog, "Tagalog");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Tagalog", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Tagalog", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Tajik, "Tajik");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Tajik", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Tajik", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Tamil, "Tamil");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Tamil", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Tamil", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Tatar, "Tatar");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Tatar", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Tatar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Telugu, "Telugu");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Telugu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Telugu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Thai, "Thai");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Thai", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Thai", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Tibetan, "Tibetan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Tibetan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Tibetan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Tigrinya, "Tigrinya");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Tigrinya", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Tigrinya", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::TongaLanguage, "TongaLanguage");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "TongaLanguage", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "TongaLanguage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Tsonga, "Tsonga");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Tsonga", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Tsonga", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Turkish, "Turkish");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Turkish", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Turkish", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Turkmen, "Turkmen");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Turkmen", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Turkmen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Twi, "Twi");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Twi", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Twi", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Uigur, "Uigur");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Uigur", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Uigur", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Ukrainian, "Ukrainian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Ukrainian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Ukrainian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Urdu, "Urdu");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Urdu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Urdu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Uzbek, "Uzbek");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Uzbek", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Uzbek", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Vietnamese, "Vietnamese");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Vietnamese", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Vietnamese", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Volapuk, "Volapuk");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Volapuk", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Volapuk", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Welsh, "Welsh");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Welsh", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Welsh", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Wolof, "Wolof");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Wolof", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Wolof", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Xhosa, "Xhosa");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Xhosa", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Xhosa", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Yiddish, "Yiddish");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Yiddish", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Yiddish", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Yoruba, "Yoruba");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Yoruba", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Yoruba", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Zhuang, "Zhuang");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Zhuang", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Zhuang", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Zulu, "Zulu");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Zulu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Zulu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::NorwegianNynorsk, "NorwegianNynorsk");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "NorwegianNynorsk", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "NorwegianNynorsk", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Nynorsk, "Nynorsk");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Nynorsk", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Nynorsk", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Bosnian, "Bosnian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Bosnian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Bosnian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Divehi, "Divehi");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Divehi", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Divehi", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Manx, "Manx");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Manx", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Manx", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Cornish, "Cornish");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Cornish", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Cornish", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Akan, "Akan");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Akan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Akan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Konkani, "Konkani");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Konkani", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Konkani", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Ga, "Ga");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Ga", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Ga", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Igbo, "Igbo");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Igbo", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Igbo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Kamba, "Kamba");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Kamba", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Kamba", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Syriac, "Syriac");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Syriac", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Syriac", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Blin, "Blin");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Blin", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Blin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Geez, "Geez");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Geez", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Geez", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Koro, "Koro");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Koro", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Koro", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Sidamo, "Sidamo");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Sidamo", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Sidamo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Atsam, "Atsam");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Atsam", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Atsam", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Tigre, "Tigre");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Tigre", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Tigre", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Jju, "Jju");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Jju", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Jju", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Friulian, "Friulian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Friulian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Friulian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Venda, "Venda");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Venda", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Venda", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Ewe, "Ewe");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Ewe", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Ewe", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Walamo, "Walamo");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Walamo", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Walamo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Hawaiian, "Hawaiian");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Hawaiian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Hawaiian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Tyap, "Tyap");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Tyap", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Tyap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::Chewa, "Chewa");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "Chewa", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "Chewa", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLocale_Language_Type,
        (long) QLocale::LastLanguage, "LastLanguage");
    PyDict_SetItemString(SbkQLocale_Type.super.ht_type.tp_dict,
        "LastLanguage", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLocale_Language_Type.tp_dict,
        "LastLanguage", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QLocale::Language");

    Shiboken::TypeResolver::createValueTypeResolver<QLocale >("QLocale");
    Shiboken::TypeResolver::createValueTypeResolver<QLocale >(typeid(QLocale).name());
}


} // extern "C"

