/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qevent_wrapper.h"

// Extra includes

using namespace Shiboken;

// Native ---------------------------------------------------------

QEventWrapper::QEventWrapper(QEvent::Type type) : QEvent(type) {
    // ... middle
}

QEventWrapper::~QEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QEvent", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[0])) {
        QEvent::Type cpp_arg0 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[0]);
        // QEvent(QEvent::Type)
        cptr = new QEventWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQEvent_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQEvent_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent.Type", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QEvent", overloads);
        return -1;
}

static PyObject* SbkQEventFunc_accept(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // accept()
    QEvent* cppSelf = Shiboken::Converter<QEvent* >::toCpp((PyObject*)self);
    cppSelf->QEvent::accept();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQEventFunc_ignore(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // ignore()
    QEvent* cppSelf = Shiboken::Converter<QEvent* >::toCpp((PyObject*)self);
    cppSelf->QEvent::ignore();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQEventFunc_isAccepted(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isAccepted()const
    QEvent* cppSelf = Shiboken::Converter<QEvent* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QEvent::isAccepted();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQEventFunc_registerEventType(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // registerEventType(int)
        int cpp_result = QEvent::registerEventType();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // registerEventType(int)
        int cpp_result = QEvent::registerEventType(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQEventFunc_registerEventType_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQEventFunc_registerEventType_TypeError:
        const char* overloads[] = {"int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QEvent.registerEventType", overloads);
        return 0;
}

static PyObject* SbkQEventFunc_setAccepted(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAccepted(bool)
        QEvent* cppSelf = Shiboken::Converter<QEvent* >::toCpp((PyObject*)self);
        cppSelf->QEvent::setAccepted(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQEventFunc_setAccepted_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQEventFunc_setAccepted_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QEvent.setAccepted", overloads);
        return 0;
}

static PyObject* SbkQEventFunc_spontaneous(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // spontaneous()const
    QEvent* cppSelf = Shiboken::Converter<QEvent* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QEvent::spontaneous();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQEventFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    QEvent* cppSelf = Shiboken::Converter<QEvent* >::toCpp((PyObject*)self);
    QEvent::Type cpp_result = cppSelf->QEvent::type();
    py_result = Shiboken::Converter<QEvent::Type >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQEvent_methods[] = {
    {"accept", (PyCFunction)SbkQEventFunc_accept, METH_NOARGS},
    {"ignore", (PyCFunction)SbkQEventFunc_ignore, METH_NOARGS},
    {"isAccepted", (PyCFunction)SbkQEventFunc_isAccepted, METH_NOARGS},
    {"registerEventType", (PyCFunction)SbkQEventFunc_registerEventType, METH_NOARGS|METH_O|METH_STATIC},
    {"setAccepted", (PyCFunction)SbkQEventFunc_setAccepted, METH_O},
    {"spontaneous", (PyCFunction)SbkQEventFunc_spontaneous, METH_NOARGS},
    {"type", (PyCFunction)SbkQEventFunc_type, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQEvent_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QEvent*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_QtCore_QEvent_Type_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QEvent_Type_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QEvent_Type_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Type",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QEvent_Type_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QEvent_Type_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QEvent_Type_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QEvent(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQEvent_Type);

    // Fill type discovery information
    SbkQEvent_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQEvent_Type));
    PyModule_AddObject(module, "QEvent",
        ((PyObject*)&SbkQEvent_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Type
    SbkPySide_QtCoreTypes[SBK_QEVENT_TYPE_IDX] = &SbkPySide_QtCore_QEvent_Type_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QEvent_Type_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QEvent_Type_Type);
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
            "Type",((PyObject*)&SbkPySide_QtCore_QEvent_Type_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::None, "None");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "None", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "None", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Timer, "Timer");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Timer", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Timer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::MouseButtonPress, "MouseButtonPress");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "MouseButtonPress", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "MouseButtonPress", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::MouseButtonRelease, "MouseButtonRelease");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "MouseButtonRelease", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "MouseButtonRelease", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::MouseButtonDblClick, "MouseButtonDblClick");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "MouseButtonDblClick", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "MouseButtonDblClick", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::MouseMove, "MouseMove");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "MouseMove", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "MouseMove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::KeyPress, "KeyPress");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "KeyPress", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "KeyPress", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::KeyRelease, "KeyRelease");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "KeyRelease", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "KeyRelease", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::FocusIn, "FocusIn");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "FocusIn", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "FocusIn", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::FocusOut, "FocusOut");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "FocusOut", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "FocusOut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Enter, "Enter");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Enter", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Enter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Leave, "Leave");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Leave", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Leave", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Paint, "Paint");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Paint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Paint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Move, "Move");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Move", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Move", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Resize, "Resize");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Resize", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Resize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Create, "Create");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Create", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Create", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Destroy, "Destroy");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Destroy", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Destroy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Show, "Show");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Show", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Show", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Hide, "Hide");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Hide", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Hide", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Close, "Close");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Close", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Close", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Quit, "Quit");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Quit", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Quit", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ParentChange, "ParentChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ParentChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ParentChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ParentAboutToChange, "ParentAboutToChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ParentAboutToChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ParentAboutToChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ThreadChange, "ThreadChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ThreadChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ThreadChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::WindowActivate, "WindowActivate");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "WindowActivate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "WindowActivate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::WindowDeactivate, "WindowDeactivate");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "WindowDeactivate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "WindowDeactivate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ShowToParent, "ShowToParent");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ShowToParent", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ShowToParent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::HideToParent, "HideToParent");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "HideToParent", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "HideToParent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Wheel, "Wheel");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Wheel", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Wheel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::WindowTitleChange, "WindowTitleChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "WindowTitleChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "WindowTitleChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::WindowIconChange, "WindowIconChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "WindowIconChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "WindowIconChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ApplicationWindowIconChange, "ApplicationWindowIconChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ApplicationWindowIconChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ApplicationWindowIconChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ApplicationFontChange, "ApplicationFontChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ApplicationFontChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ApplicationFontChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ApplicationLayoutDirectionChange, "ApplicationLayoutDirectionChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ApplicationLayoutDirectionChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ApplicationLayoutDirectionChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ApplicationPaletteChange, "ApplicationPaletteChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ApplicationPaletteChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ApplicationPaletteChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::PaletteChange, "PaletteChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "PaletteChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "PaletteChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Clipboard, "Clipboard");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Clipboard", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Clipboard", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Speech, "Speech");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Speech", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Speech", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::MetaCall, "MetaCall");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "MetaCall", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "MetaCall", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::SockAct, "SockAct");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "SockAct", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "SockAct", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::WinEventAct, "WinEventAct");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "WinEventAct", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "WinEventAct", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::DeferredDelete, "DeferredDelete");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "DeferredDelete", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "DeferredDelete", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::DragEnter, "DragEnter");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "DragEnter", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "DragEnter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::DragMove, "DragMove");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "DragMove", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "DragMove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::DragLeave, "DragLeave");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "DragLeave", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "DragLeave", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Drop, "Drop");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Drop", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Drop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::DragResponse, "DragResponse");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "DragResponse", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "DragResponse", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ChildAdded, "ChildAdded");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ChildAdded", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ChildAdded", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ChildPolished, "ChildPolished");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ChildPolished", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ChildPolished", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ChildRemoved, "ChildRemoved");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ChildRemoved", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ChildRemoved", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ShowWindowRequest, "ShowWindowRequest");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ShowWindowRequest", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ShowWindowRequest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::PolishRequest, "PolishRequest");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "PolishRequest", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "PolishRequest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Polish, "Polish");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Polish", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Polish", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::LayoutRequest, "LayoutRequest");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "LayoutRequest", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "LayoutRequest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::UpdateRequest, "UpdateRequest");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "UpdateRequest", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "UpdateRequest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::UpdateLater, "UpdateLater");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "UpdateLater", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "UpdateLater", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::EmbeddingControl, "EmbeddingControl");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "EmbeddingControl", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "EmbeddingControl", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ActivateControl, "ActivateControl");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ActivateControl", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ActivateControl", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::DeactivateControl, "DeactivateControl");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "DeactivateControl", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "DeactivateControl", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ContextMenu, "ContextMenu");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ContextMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ContextMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::InputMethod, "InputMethod");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "InputMethod", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "InputMethod", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::AccessibilityPrepare, "AccessibilityPrepare");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "AccessibilityPrepare", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "AccessibilityPrepare", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::TabletMove, "TabletMove");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "TabletMove", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "TabletMove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::LocaleChange, "LocaleChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "LocaleChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "LocaleChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::LanguageChange, "LanguageChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "LanguageChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "LanguageChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::LayoutDirectionChange, "LayoutDirectionChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "LayoutDirectionChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "LayoutDirectionChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Style, "Style");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Style", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Style", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::TabletPress, "TabletPress");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "TabletPress", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "TabletPress", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::TabletRelease, "TabletRelease");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "TabletRelease", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "TabletRelease", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::OkRequest, "OkRequest");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "OkRequest", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "OkRequest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::HelpRequest, "HelpRequest");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "HelpRequest", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "HelpRequest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::IconDrag, "IconDrag");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "IconDrag", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "IconDrag", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::FontChange, "FontChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "FontChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "FontChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::EnabledChange, "EnabledChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "EnabledChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "EnabledChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ActivationChange, "ActivationChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ActivationChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ActivationChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::StyleChange, "StyleChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "StyleChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "StyleChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::IconTextChange, "IconTextChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "IconTextChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "IconTextChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ModifiedChange, "ModifiedChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ModifiedChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ModifiedChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::MouseTrackingChange, "MouseTrackingChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "MouseTrackingChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "MouseTrackingChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::WindowBlocked, "WindowBlocked");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "WindowBlocked", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "WindowBlocked", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::WindowUnblocked, "WindowUnblocked");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "WindowUnblocked", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "WindowUnblocked", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::WindowStateChange, "WindowStateChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "WindowStateChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "WindowStateChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ToolTip, "ToolTip");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ToolTip", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ToolTip", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::WhatsThis, "WhatsThis");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "WhatsThis", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "WhatsThis", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::StatusTip, "StatusTip");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "StatusTip", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "StatusTip", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ActionChanged, "ActionChanged");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ActionChanged", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ActionChanged", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ActionAdded, "ActionAdded");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ActionAdded", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ActionAdded", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ActionRemoved, "ActionRemoved");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ActionRemoved", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ActionRemoved", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::FileOpen, "FileOpen");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "FileOpen", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "FileOpen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Shortcut, "Shortcut");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Shortcut", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Shortcut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ShortcutOverride, "ShortcutOverride");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ShortcutOverride", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ShortcutOverride", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::WhatsThisClicked, "WhatsThisClicked");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "WhatsThisClicked", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "WhatsThisClicked", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ToolBarChange, "ToolBarChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ToolBarChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ToolBarChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ApplicationActivate, "ApplicationActivate");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ApplicationActivate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ApplicationActivate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ApplicationActivated, "ApplicationActivated");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ApplicationActivated", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ApplicationActivated", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ApplicationDeactivate, "ApplicationDeactivate");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ApplicationDeactivate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ApplicationDeactivate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ApplicationDeactivated, "ApplicationDeactivated");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ApplicationDeactivated", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ApplicationDeactivated", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::QueryWhatsThis, "QueryWhatsThis");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "QueryWhatsThis", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "QueryWhatsThis", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::EnterWhatsThisMode, "EnterWhatsThisMode");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "EnterWhatsThisMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "EnterWhatsThisMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::LeaveWhatsThisMode, "LeaveWhatsThisMode");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "LeaveWhatsThisMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "LeaveWhatsThisMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ZOrderChange, "ZOrderChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ZOrderChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ZOrderChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::HoverEnter, "HoverEnter");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "HoverEnter", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "HoverEnter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::HoverLeave, "HoverLeave");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "HoverLeave", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "HoverLeave", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::HoverMove, "HoverMove");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "HoverMove", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "HoverMove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::AccessibilityHelp, "AccessibilityHelp");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "AccessibilityHelp", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "AccessibilityHelp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::AccessibilityDescription, "AccessibilityDescription");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "AccessibilityDescription", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "AccessibilityDescription", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::AcceptDropsChange, "AcceptDropsChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "AcceptDropsChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "AcceptDropsChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::MenubarUpdated, "MenubarUpdated");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "MenubarUpdated", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "MenubarUpdated", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ZeroTimerEvent, "ZeroTimerEvent");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ZeroTimerEvent", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ZeroTimerEvent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GraphicsSceneMouseMove, "GraphicsSceneMouseMove");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GraphicsSceneMouseMove", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GraphicsSceneMouseMove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GraphicsSceneMousePress, "GraphicsSceneMousePress");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GraphicsSceneMousePress", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GraphicsSceneMousePress", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GraphicsSceneMouseRelease, "GraphicsSceneMouseRelease");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GraphicsSceneMouseRelease", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GraphicsSceneMouseRelease", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GraphicsSceneMouseDoubleClick, "GraphicsSceneMouseDoubleClick");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GraphicsSceneMouseDoubleClick", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GraphicsSceneMouseDoubleClick", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GraphicsSceneContextMenu, "GraphicsSceneContextMenu");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GraphicsSceneContextMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GraphicsSceneContextMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GraphicsSceneHoverEnter, "GraphicsSceneHoverEnter");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GraphicsSceneHoverEnter", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GraphicsSceneHoverEnter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GraphicsSceneHoverMove, "GraphicsSceneHoverMove");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GraphicsSceneHoverMove", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GraphicsSceneHoverMove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GraphicsSceneHoverLeave, "GraphicsSceneHoverLeave");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GraphicsSceneHoverLeave", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GraphicsSceneHoverLeave", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GraphicsSceneHelp, "GraphicsSceneHelp");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GraphicsSceneHelp", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GraphicsSceneHelp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GraphicsSceneDragEnter, "GraphicsSceneDragEnter");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GraphicsSceneDragEnter", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GraphicsSceneDragEnter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GraphicsSceneDragMove, "GraphicsSceneDragMove");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GraphicsSceneDragMove", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GraphicsSceneDragMove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GraphicsSceneDragLeave, "GraphicsSceneDragLeave");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GraphicsSceneDragLeave", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GraphicsSceneDragLeave", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GraphicsSceneDrop, "GraphicsSceneDrop");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GraphicsSceneDrop", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GraphicsSceneDrop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GraphicsSceneWheel, "GraphicsSceneWheel");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GraphicsSceneWheel", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GraphicsSceneWheel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::KeyboardLayoutChange, "KeyboardLayoutChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "KeyboardLayoutChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "KeyboardLayoutChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::DynamicPropertyChange, "DynamicPropertyChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "DynamicPropertyChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "DynamicPropertyChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::TabletEnterProximity, "TabletEnterProximity");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "TabletEnterProximity", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "TabletEnterProximity", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::TabletLeaveProximity, "TabletLeaveProximity");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "TabletLeaveProximity", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "TabletLeaveProximity", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::NonClientAreaMouseMove, "NonClientAreaMouseMove");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "NonClientAreaMouseMove", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "NonClientAreaMouseMove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::NonClientAreaMouseButtonPress, "NonClientAreaMouseButtonPress");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "NonClientAreaMouseButtonPress", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "NonClientAreaMouseButtonPress", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::NonClientAreaMouseButtonRelease, "NonClientAreaMouseButtonRelease");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "NonClientAreaMouseButtonRelease", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "NonClientAreaMouseButtonRelease", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::NonClientAreaMouseButtonDblClick, "NonClientAreaMouseButtonDblClick");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "NonClientAreaMouseButtonDblClick", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "NonClientAreaMouseButtonDblClick", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::MacSizeChange, "MacSizeChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "MacSizeChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "MacSizeChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ContentsRectChange, "ContentsRectChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ContentsRectChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ContentsRectChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::MacGLWindowChange, "MacGLWindowChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "MacGLWindowChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "MacGLWindowChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::FutureCallOut, "FutureCallOut");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "FutureCallOut", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "FutureCallOut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GraphicsSceneResize, "GraphicsSceneResize");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GraphicsSceneResize", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GraphicsSceneResize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GraphicsSceneMove, "GraphicsSceneMove");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GraphicsSceneMove", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GraphicsSceneMove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::CursorChange, "CursorChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "CursorChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "CursorChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::ToolTipChange, "ToolTipChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "ToolTipChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "ToolTipChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::NetworkReplyUpdated, "NetworkReplyUpdated");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "NetworkReplyUpdated", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "NetworkReplyUpdated", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GrabMouse, "GrabMouse");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GrabMouse", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GrabMouse", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::UngrabMouse, "UngrabMouse");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "UngrabMouse", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "UngrabMouse", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GrabKeyboard, "GrabKeyboard");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GrabKeyboard", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GrabKeyboard", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::UngrabKeyboard, "UngrabKeyboard");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "UngrabKeyboard", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "UngrabKeyboard", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::CocoaRequestModal, "CocoaRequestModal");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "CocoaRequestModal", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "CocoaRequestModal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::MacGLClearDrawable, "MacGLClearDrawable");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "MacGLClearDrawable", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "MacGLClearDrawable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::StateMachineSignal, "StateMachineSignal");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "StateMachineSignal", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "StateMachineSignal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::StateMachineWrapped, "StateMachineWrapped");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "StateMachineWrapped", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "StateMachineWrapped", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::TouchBegin, "TouchBegin");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "TouchBegin", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "TouchBegin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::TouchUpdate, "TouchUpdate");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "TouchUpdate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "TouchUpdate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::TouchEnd, "TouchEnd");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "TouchEnd", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "TouchEnd", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::NativeGesture, "NativeGesture");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "NativeGesture", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "NativeGesture", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::RequestSoftwareInputPanel, "RequestSoftwareInputPanel");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "RequestSoftwareInputPanel", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "RequestSoftwareInputPanel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::CloseSoftwareInputPanel, "CloseSoftwareInputPanel");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "CloseSoftwareInputPanel", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "CloseSoftwareInputPanel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::UpdateSoftKeys, "UpdateSoftKeys");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "UpdateSoftKeys", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "UpdateSoftKeys", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::WinIdChange, "WinIdChange");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "WinIdChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "WinIdChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::Gesture, "Gesture");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "Gesture", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "Gesture", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::GestureOverride, "GestureOverride");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "GestureOverride", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "GestureOverride", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::User, "User");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "User", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "User", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEvent_Type_Type,
        (long) QEvent::MaxUser, "MaxUser");
    PyDict_SetItemString(SbkQEvent_Type.super.ht_type.tp_dict,
        "MaxUser", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEvent_Type_Type.tp_dict,
        "MaxUser", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QEvent::Type");

    Shiboken::TypeResolver::createObjectTypeResolver<QEvent >("QEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QEvent >(typeid(QEvent).name());
}


} // extern "C"

