/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qeasingcurve_wrapper.h"

// Extra includes
#include <qeasingcurve.h>

using namespace Shiboken;

static int
SbkQEasingCurve_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QEasingCurve* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QEasingCurve", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QEasingCurve(QEasingCurve::Type)
        cptr = new QEasingCurve();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QEasingCurve::Type >::isConvertible(pyargs[0])) {
        QEasingCurve::Type cpp_arg0 = Shiboken::Converter<QEasingCurve::Type >::toCpp(pyargs[0]);
        // QEasingCurve(QEasingCurve::Type)
        cptr = new QEasingCurve(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QEasingCurve & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QEasingCurve > cpp_arg0_auto_ptr;
        QEasingCurve* cpp_arg0 = Shiboken::Converter<QEasingCurve* >::toCpp(pyargs[0]);
        if (!SbkQEasingCurve_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QEasingCurve >(cpp_arg0);
        // QEasingCurve(QEasingCurve)
        cptr = new QEasingCurve(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQEasingCurve_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QEasingCurve >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQEasingCurve_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQEasingCurve_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEasingCurve.Type = Linear", "PySide.QtCore.QEasingCurve", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QEasingCurve", overloads);
        return -1;
}

static PyObject* SbkQEasingCurveFunc_amplitude(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // amplitude()const
    QEasingCurve* cppSelf = Shiboken::Converter<QEasingCurve* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QEasingCurve::amplitude();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQEasingCurveFunc_overshoot(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // overshoot()const
    QEasingCurve* cppSelf = Shiboken::Converter<QEasingCurve* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QEasingCurve::overshoot();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQEasingCurveFunc_period(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // period()const
    QEasingCurve* cppSelf = Shiboken::Converter<QEasingCurve* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QEasingCurve::period();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQEasingCurveFunc_setAmplitude(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setAmplitude(qreal)
        QEasingCurve* cppSelf = Shiboken::Converter<QEasingCurve* >::toCpp((PyObject*)self);
        cppSelf->QEasingCurve::setAmplitude(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQEasingCurveFunc_setAmplitude_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQEasingCurveFunc_setAmplitude_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QEasingCurve.setAmplitude", overloads);
        return 0;
}

static PyObject* SbkQEasingCurveFunc_setOvershoot(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setOvershoot(qreal)
        QEasingCurve* cppSelf = Shiboken::Converter<QEasingCurve* >::toCpp((PyObject*)self);
        cppSelf->QEasingCurve::setOvershoot(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQEasingCurveFunc_setOvershoot_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQEasingCurveFunc_setOvershoot_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QEasingCurve.setOvershoot", overloads);
        return 0;
}

static PyObject* SbkQEasingCurveFunc_setPeriod(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setPeriod(qreal)
        QEasingCurve* cppSelf = Shiboken::Converter<QEasingCurve* >::toCpp((PyObject*)self);
        cppSelf->QEasingCurve::setPeriod(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQEasingCurveFunc_setPeriod_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQEasingCurveFunc_setPeriod_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QEasingCurve.setPeriod", overloads);
        return 0;
}

static PyObject* SbkQEasingCurveFunc_setType(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEasingCurve::Type >::isConvertible(arg)) {
        QEasingCurve::Type cpp_arg0 = Shiboken::Converter<QEasingCurve::Type >::toCpp(arg);
        // setType(QEasingCurve::Type)
        QEasingCurve* cppSelf = Shiboken::Converter<QEasingCurve* >::toCpp((PyObject*)self);
        cppSelf->QEasingCurve::setType(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQEasingCurveFunc_setType_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQEasingCurveFunc_setType_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEasingCurve.Type", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QEasingCurve.setType", overloads);
        return 0;
}

static PyObject* SbkQEasingCurveFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    QEasingCurve* cppSelf = Shiboken::Converter<QEasingCurve* >::toCpp((PyObject*)self);
    QEasingCurve::Type cpp_result = cppSelf->QEasingCurve::type();
    py_result = Shiboken::Converter<QEasingCurve::Type >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQEasingCurveFunc_valueForProgress(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // valueForProgress(qreal)const
        QEasingCurve* cppSelf = Shiboken::Converter<QEasingCurve* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QEasingCurve::valueForProgress(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQEasingCurveFunc_valueForProgress_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQEasingCurveFunc_valueForProgress_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QEasingCurve.valueForProgress", overloads);
        return 0;
}

static PyMethodDef SbkQEasingCurve_methods[] = {
    {"amplitude", (PyCFunction)SbkQEasingCurveFunc_amplitude, METH_NOARGS},
    {"overshoot", (PyCFunction)SbkQEasingCurveFunc_overshoot, METH_NOARGS},
    {"period", (PyCFunction)SbkQEasingCurveFunc_period, METH_NOARGS},
    {"setAmplitude", (PyCFunction)SbkQEasingCurveFunc_setAmplitude, METH_O},
    {"setOvershoot", (PyCFunction)SbkQEasingCurveFunc_setOvershoot, METH_O},
    {"setPeriod", (PyCFunction)SbkQEasingCurveFunc_setPeriod, METH_O},
    {"setType", (PyCFunction)SbkQEasingCurveFunc_setType, METH_O},
    {"type", (PyCFunction)SbkQEasingCurveFunc_type, METH_NOARGS},
    {"valueForProgress", (PyCFunction)SbkQEasingCurveFunc_valueForProgress, METH_O},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQEasingCurve_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QEasingCurve& cpp_self = *Shiboken::Converter<QEasingCurve* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QEasingCurve & >::isConvertible(other)) {
                // operator!=(const QEasingCurve & other) const
                QEasingCurve* cpp_other = Shiboken::Converter<QEasingCurve* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QEasingCurve  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QEasingCurve >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QEasingCurve > cpp_other_auto_ptr;
                QEasingCurve* cpp_other = Shiboken::Converter<QEasingCurve* >::toCpp(other);
                if (!SbkQEasingCurve_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QEasingCurve >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQEasingCurve_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QEasingCurve & >::isConvertible(other)) {
                // operator==(const QEasingCurve & other) const
                QEasingCurve* cpp_other = Shiboken::Converter<QEasingCurve* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QEasingCurve  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QEasingCurve >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QEasingCurve > cpp_other_auto_ptr;
                QEasingCurve* cpp_other = Shiboken::Converter<QEasingCurve* >::toCpp(other);
                if (!SbkQEasingCurve_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QEasingCurve >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQEasingCurve_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQEasingCurve_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQEasingCurve_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QEasingCurve",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQEasingCurve_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQEasingCurve_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQEasingCurve_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QEasingCurve >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtCore_QEasingCurve_Type_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QEasingCurve_Type_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QEasingCurve_Type_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Type",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QEasingCurve_Type_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QEasingCurve_Type_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QEasingCurve_Type_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QEasingCurve(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QEASINGCURVE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQEasingCurve_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQEasingCurve_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQEasingCurve_Type));
    PyModule_AddObject(module, "QEasingCurve",
        ((PyObject*)&SbkQEasingCurve_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Type
    SbkPySide_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX] = &SbkPySide_QtCore_QEasingCurve_Type_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QEasingCurve_Type_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QEasingCurve_Type_Type);
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
            "Type",((PyObject*)&SbkPySide_QtCore_QEasingCurve_Type_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::Linear, "Linear");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "Linear", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "Linear", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InQuad, "InQuad");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InQuad", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InQuad", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutQuad, "OutQuad");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutQuad", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutQuad", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InOutQuad, "InOutQuad");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InOutQuad", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InOutQuad", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutInQuad, "OutInQuad");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutInQuad", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutInQuad", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InCubic, "InCubic");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InCubic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InCubic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutCubic, "OutCubic");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutCubic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutCubic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InOutCubic, "InOutCubic");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InOutCubic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InOutCubic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutInCubic, "OutInCubic");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutInCubic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutInCubic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InQuart, "InQuart");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InQuart", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InQuart", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutQuart, "OutQuart");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutQuart", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutQuart", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InOutQuart, "InOutQuart");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InOutQuart", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InOutQuart", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutInQuart, "OutInQuart");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutInQuart", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutInQuart", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InQuint, "InQuint");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InQuint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InQuint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutQuint, "OutQuint");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutQuint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutQuint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InOutQuint, "InOutQuint");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InOutQuint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InOutQuint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutInQuint, "OutInQuint");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutInQuint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutInQuint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InSine, "InSine");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InSine", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InSine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutSine, "OutSine");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutSine", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutSine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InOutSine, "InOutSine");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InOutSine", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InOutSine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutInSine, "OutInSine");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutInSine", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutInSine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InExpo, "InExpo");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InExpo", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InExpo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutExpo, "OutExpo");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutExpo", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutExpo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InOutExpo, "InOutExpo");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InOutExpo", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InOutExpo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutInExpo, "OutInExpo");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutInExpo", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutInExpo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InCirc, "InCirc");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InCirc", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InCirc", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutCirc, "OutCirc");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutCirc", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutCirc", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InOutCirc, "InOutCirc");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InOutCirc", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InOutCirc", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutInCirc, "OutInCirc");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutInCirc", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutInCirc", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InElastic, "InElastic");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InElastic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InElastic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutElastic, "OutElastic");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutElastic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutElastic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InOutElastic, "InOutElastic");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InOutElastic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InOutElastic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutInElastic, "OutInElastic");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutInElastic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutInElastic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InBack, "InBack");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InBack", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InBack", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutBack, "OutBack");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutBack", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutBack", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InOutBack, "InOutBack");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InOutBack", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InOutBack", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutInBack, "OutInBack");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutInBack", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutInBack", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InBounce, "InBounce");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InBounce", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InBounce", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutBounce, "OutBounce");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutBounce", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutBounce", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InOutBounce, "InOutBounce");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InOutBounce", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InOutBounce", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutInBounce, "OutInBounce");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutInBounce", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutInBounce", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::InCurve, "InCurve");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "InCurve", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "InCurve", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::OutCurve, "OutCurve");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "OutCurve", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "OutCurve", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::SineCurve, "SineCurve");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "SineCurve", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "SineCurve", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::CosineCurve, "CosineCurve");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "CosineCurve", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "CosineCurve", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::Custom, "Custom");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "Custom", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "Custom", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEasingCurve_Type_Type,
        (long) QEasingCurve::NCurveTypes, "NCurveTypes");
    PyDict_SetItemString(SbkQEasingCurve_Type.super.ht_type.tp_dict,
        "NCurveTypes", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEasingCurve_Type_Type.tp_dict,
        "NCurveTypes", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QEasingCurve::Type");

    Shiboken::TypeResolver::createValueTypeResolver<QEasingCurve >("QEasingCurve");
    Shiboken::TypeResolver::createValueTypeResolver<QEasingCurve >(typeid(QEasingCurve).name());
}


} // extern "C"

