/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_QTCORE_PYTHON_H
#define SBK_QTCORE_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#if defined _WIN32 || defined __CYGWIN__
    #define SHIBOKEN_QTCORE_API __declspec(dllexport)
#else
#if __GNUC__ >= 4
    #define SHIBOKEN_QTCORE_API __attribute__ ((visibility("default")))
#else
    #define SHIBOKEN_QTCORE_API
#endif
#endif

// Binded library includes
#include <qstatemachine.h>
#include <qprocess.h>
#include <qtextdocument.h>
#include <qeventtransition.h>
#include <qchar.h>
#include <qfile.h>
#include <qfilesystemwatcher.h>
#include <qbasictimer.h>
#include <qfinalstate.h>
#include <qlibraryinfo.h>
#include <qsignalmapper.h>
#include <qabstractitemmodel.h>
#include <qsettings.h>
#include <qobjectdefs.h>
#include <qabstracteventdispatcher.h>
#include <qtemporaryfile.h>
#include <qresource.h>
#include <qreadwritelock.h>
#include <qtconcurrentexception.h>
#include <qdiriterator.h>
#include <qsequentialanimationgroup.h>
#include <qmetaobject.h>
#include <qwaitcondition.h>
#include <qiodevice.h>
#include <qsystemsemaphore.h>
#include <qpoint.h>
#include <qsocketnotifier.h>
#include <QTextCodec>
#include <qthread.h>
#include <qstate.h>
#include <qabstractstate.h>
#include <qparallelanimationgroup.h>
#include <qmargins.h>
#include <qfactoryinterface.h>
#include <qcoreevent.h>
#include <qbytearraymatcher.h>
#include <qmutex.h>
#include <qsemaphore.h>
#include <qtranslator.h>
#include <qfileinfo.h>
#include <qtimeline.h>
#include <qabstractfileengine.h>
#include <quuid.h>
#include <qpropertyanimation.h>
#include <qdir.h>
#include <qhistorystate.h>
#include <qsignaltransition.h>
#include <qcryptographichash.h>
#include <qrect.h>
#include <qdatastream.h>
#include <qbitarray.h>
#include <qeasingcurve.h>
#include <qtextstream.h>
#include <qanimationgroup.h>
#include <qglobal.h>
#include <qfsfileengine.h>
#include <qabstractanimation.h>
#include <qmimedata.h>
#include <qbytearray.h>
#include <qvariantanimation.h>
#include <qstringlist.h>
#include <qtconcurrentreducekernel.h>
#include <qvariant.h>
#include <qtextboundaryfinder.h>
#include <qnamespace.h>
#include <qregexp.h>
#include <qbuffer.h>
#include <qabstracttransition.h>
#include <qtextcodec.h>
#include <qpauseanimation.h>
#include <qdatetime.h>
#include <qstringmatcher.h>
#include <qxmlstream.h>
#include <qeventloop.h>
#include <qurl.h>
#include <qstring.h>
#include <qlocale.h>
#include <qcoreapplication.h>
#include <qobject.h>
#include <qsize.h>
#include <qline.h>
#include <qtimer.h>
// Conversion Includes - Primitive Types
#include <QTextDocument>
#include <QtConcurrentFilter>

// Conversion Includes - Container Types
#include <QList>
#include <QMap>
#include <QMultiMap>
#include <QVector>
#include <QPair>
#include <pysideconversions.h>
#include <QSet>
#include <qqueue.h>

// Type indices
#define SBK_QTCONCURRENT_IDX                                         0
#define SBK_QTCONCURRENT_REDUCEOPTION_IDX                            1
#define SBK_QFLAGS_QTCONCURRENT_REDUCEOPTION__IDX                    2
#define SBK_QT_IDX                                                   3
#define SBK_QT_SHORTCUTCONTEXT_IDX                                   4
#define SBK_QT_CHECKSTATE_IDX                                        5
#define SBK_QT_FOCUSPOLICY_IDX                                       6
#define SBK_QT_GESTURETYPE_IDX                                       7
#define SBK_QT_DROPACTION_IDX                                        8
#define SBK_QFLAGS_QT_DROPACTION__IDX                                9
#define SBK_QT_WINDOWTYPE_IDX                                        10
#define SBK_QFLAGS_QT_WINDOWTYPE__IDX                                11
#define SBK_QT_DATEFORMAT_IDX                                        12
#define SBK_QT_TEXTFORMAT_IDX                                        13
#define SBK_QT_PENJOINSTYLE_IDX                                      14
#define SBK_QT_GESTUREFLAG_IDX                                       15
#define SBK_QFLAGS_QT_GESTUREFLAG__IDX                               16
#define SBK_QT_CASESENSITIVITY_IDX                                   17
#define SBK_QT_EVENTPRIORITY_IDX                                     18
#define SBK_QT_IMAGECONVERSIONFLAG_IDX                               19
#define SBK_QFLAGS_QT_IMAGECONVERSIONFLAG__IDX                       20
#define SBK_QT_GESTURESTATE_IDX                                      21
#define SBK_QT_BGMODE_IDX                                            22
#define SBK_QT_CONNECTIONTYPE_IDX                                    23
#define SBK_QT_TOOLBARAREA_IDX                                       24
#define SBK_QFLAGS_QT_TOOLBARAREA__IDX                               25
#define SBK_QT_COORDINATESYSTEM_IDX                                  26
#define SBK_QT_SIZEMODE_IDX                                          27
#define SBK_QT_FOCUSREASON_IDX                                       28
#define SBK_QT_MODIFIER_IDX                                          29
#define SBK_QT_TILERULE_IDX                                          30
#define SBK_QT_WHITESPACEMODE_IDX                                    31
#define SBK_QT_ASPECTRATIOMODE_IDX                                   32
#define SBK_QT_SIZEHINT_IDX                                          33
#define SBK_QT_ALIGNMENTFLAG_IDX                                     34
#define SBK_QFLAGS_QT_ALIGNMENTFLAG__IDX                             35
#define SBK_QT_CONTEXTMENUPOLICY_IDX                                 36
#define SBK_QT_DOCKWIDGETAREA_IDX                                    37
#define SBK_QFLAGS_QT_DOCKWIDGETAREA__IDX                            38
#define SBK_QT_UIEFFECT_IDX                                          39
#define SBK_QT_INITIALIZATION_IDX                                    40
#define SBK_QT_ANCHORPOINT_IDX                                       41
#define SBK_QT_GLOBALCOLOR_IDX                                       42
#define SBK_QT_KEYBOARDMODIFIER_IDX                                  43
#define SBK_QFLAGS_QT_KEYBOARDMODIFIER__IDX                          44
#define SBK_QT_NAVIGATIONMODE_IDX                                    45
#define SBK_QT_ITEMDATAROLE_IDX                                      46
#define SBK_QT_SCROLLBARPOLICY_IDX                                   47
#define SBK_QT_INPUTMETHODHINT_IDX                                   48
#define SBK_QFLAGS_QT_INPUTMETHODHINT__IDX                           49
#define SBK_QT_ANCHORATTRIBUTE_IDX                                   50
#define SBK_QT_WINDOWMODALITY_IDX                                    51
#define SBK_QT_SORTORDER_IDX                                         52
#define SBK_QT_PENSTYLE_IDX                                          53
#define SBK_QT_ITEMFLAG_IDX                                          54
#define SBK_QFLAGS_QT_ITEMFLAG__IDX                                  55
#define SBK_QT_AXIS_IDX                                              56
#define SBK_QT_TRANSFORMATIONMODE_IDX                                57
#define SBK_QT_WINDOWFRAMESECTION_IDX                                58
#define SBK_QT_HITTESTACCURACY_IDX                                   59
#define SBK_QT_CURSORSHAPE_IDX                                       60
#define SBK_QT_ITEMSELECTIONMODE_IDX                                 61
#define SBK_QT_ORIENTATION_IDX                                       62
#define SBK_QFLAGS_QT_ORIENTATION__IDX                               63
#define SBK_QT_INPUTMETHODQUERY_IDX                                  64
#define SBK_QT_TIMESPEC_IDX                                          65
#define SBK_QT_ARROWTYPE_IDX                                         66
#define SBK_QT_FILLRULE_IDX                                          67
#define SBK_QT_MASKMODE_IDX                                          68
#define SBK_QT_WINDOWSTATE_IDX                                       69
#define SBK_QFLAGS_QT_WINDOWSTATE__IDX                               70
#define SBK_QT_TOOLBARAREASIZES_IDX                                  71
#define SBK_QT_CORNER_IDX                                            72
#define SBK_QT_DAYOFWEEK_IDX                                         73
#define SBK_QT_CLIPOPERATION_IDX                                     74
#define SBK_QT_LAYOUTDIRECTION_IDX                                   75
#define SBK_QT_TOOLBUTTONSTYLE_IDX                                   76
#define SBK_QT_DOCKWIDGETAREASIZES_IDX                               77
#define SBK_QT_KEY_IDX                                               78
#define SBK_QT_APPLICATIONATTRIBUTE_IDX                              79
#define SBK_QT_TEXTFLAG_IDX                                          80
#define SBK_QT_BRUSHSTYLE_IDX                                        81
#define SBK_QT_WIDGETATTRIBUTE_IDX                                   82
#define SBK_QT_TOUCHPOINTSTATE_IDX                                   83
#define SBK_QT_TEXTINTERACTIONFLAG_IDX                               84
#define SBK_QFLAGS_QT_TEXTINTERACTIONFLAG__IDX                       85
#define SBK_QT_MOUSEBUTTON_IDX                                       86
#define SBK_QFLAGS_QT_MOUSEBUTTON__IDX                               87
#define SBK_QT_MATCHFLAG_IDX                                         88
#define SBK_QFLAGS_QT_MATCHFLAG__IDX                                 89
#define SBK_QT_PENCAPSTYLE_IDX                                       90
#define SBK_QT_TEXTELIDEMODE_IDX                                     91
#define SBK_QXMLSTREAMENTITYDECLARATION_IDX                          92
#define SBK_QMETAENUM_IDX                                            93
#define SBK_QREGEXP_IDX                                              94
#define SBK_QREGEXP_PATTERNSYNTAX_IDX                                95
#define SBK_QREGEXP_CARETMODE_IDX                                    96
#define SBK_QMODELINDEX_IDX                                          97
#define SBK_QXMLSTREAMNOTATIONDECLARATION_IDX                        98
#define SBK_QFACTORYINTERFACE_IDX                                    99
#define SBK_QXMLSTREAMNAMESPACEDECLARATION_IDX                       100
#define SBK_QSEMAPHORE_IDX                                           101
#define SBK_QBITARRAY_IDX                                            102
#define SBK_QABSTRACTFILEENGINEHANDLER_IDX                           103
#define SBK_QGENERICARGUMENT_IDX                                     104
#define SBK_QSTRINGLIST_IDX                                          105
#define SBK_QPOINTF_IDX                                              106
#define SBK_QMUTEX_IDX                                               107
#define SBK_QMUTEX_RECURSIONMODE_IDX                                 108
#define SBK_QVARIANT_IDX                                             109
#define SBK_QVARIANT_TYPE_IDX                                        110
#define SBK_QOBJECT_IDX                                              111
#define SBK_QFILESYSTEMWATCHER_IDX                                   112
#define SBK_QABSTRACTEVENTDISPATCHER_IDX                             113
#define SBK_QABSTRACTANIMATION_IDX                                   114
#define SBK_QABSTRACTANIMATION_DIRECTION_IDX                         115
#define SBK_QABSTRACTANIMATION_DELETIONPOLICY_IDX                    116
#define SBK_QABSTRACTANIMATION_STATE_IDX                             117
#define SBK_QVARIANTANIMATION_IDX                                    118
#define SBK_QPAUSEANIMATION_IDX                                      119
#define SBK_QSIGNALMAPPER_IDX                                        120
#define SBK_QUUID_IDX                                                121
#define SBK_QUUID_VARIANT_IDX                                        122
#define SBK_QUUID_VERSION_IDX                                        123
#define SBK_QRECT_IDX                                                124
#define SBK_QFILEINFO_IDX                                            125
#define SBK_QABSTRACTTRANSITION_IDX                                  126
#define SBK_QABSTRACTFILEENGINEITERATOR_IDX                          127
#define SBK_QEVENTTRANSITION_IDX                                     128
#define SBK_QABSTRACTFILEENGINE_IDX                                  129
#define SBK_QABSTRACTFILEENGINE_FILENAME_IDX                         130
#define SBK_QABSTRACTFILEENGINE_FILETIME_IDX                         131
#define SBK_QABSTRACTFILEENGINE_FILEOWNER_IDX                        132
#define SBK_QABSTRACTFILEENGINE_EXTENSION_IDX                        133
#define SBK_QABSTRACTFILEENGINE_FILEFLAG_IDX                         134
#define SBK_QFLAGS_QABSTRACTFILEENGINE_FILEFLAG__IDX                 135
#define SBK_QSYSTEMLOCALE_IDX                                        136
#define SBK_QSYSTEMLOCALE_QUERYTYPE_IDX                              137
#define SBK_QSYSINFO_IDX                                             138
#define SBK_QSYSINFO_ENDIAN_IDX                                      139
#define SBK_QSYSINFO_SIZES_IDX                                       140
#define SBK_QBYTEARRAY_IDX                                           141
#define SBK_QXMLSTREAMATTRIBUTES_IDX                                 142
#define SBK_QBYTEARRAYMATCHER_IDX                                    143
#define SBK_QGENERICRETURNARGUMENT_IDX                               144
#define SBK_QSIGNALTRANSITION_IDX                                    145
#define SBK_QEVENT_IDX                                               146
#define SBK_QEVENT_TYPE_IDX                                          147
#define SBK_QDYNAMICPROPERTYCHANGEEVENT_IDX                          148
#define SBK_QCHILDEVENT_IDX                                          149
#define SBK_QMETAOBJECT_IDX                                          150
#define SBK_QMETAOBJECT_CALL_IDX                                     151
#define SBK_QXMLSTREAMATTRIBUTE_IDX                                  152
#define SBK_QDATASTREAM_IDX                                          153
#define SBK_QDATASTREAM_FLOATINGPOINTPRECISION_IDX                   154
#define SBK_QDATASTREAM_VERSION_IDX                                  155
#define SBK_QDATASTREAM_STATUS_IDX                                   156
#define SBK_QLATIN1CHAR_IDX                                          157
#define SBK_QBASICTIMER_IDX                                          158
#define SBK_QREADLOCKER_IDX                                          159
#define SBK_QXMLSTREAMENTITYRESOLVER_IDX                             160
#define SBK_QSTRINGMATCHER_IDX                                       161
#define SBK_QDATE_IDX                                                162
#define SBK_QDATE_MONTHNAMETYPE_IDX                                  163
#define SBK_QRECTF_IDX                                               164
#define SBK_QSIZE_IDX                                                165
#define SBK_QTEXTSTREAMMANIPULATOR_IDX                               166
#define SBK_QTIMER_IDX                                               167
#define SBK_QTEXTBOUNDARYFINDER_IDX                                  168
#define SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX                   169
#define SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON__IDX           170
#define SBK_QTEXTBOUNDARYFINDER_BOUNDARYTYPE_IDX                     171
#define SBK_QTEXTENCODER_IDX                                         172
#define SBK_QABSTRACTITEMMODEL_IDX                                   173
#define SBK_QABSTRACTLISTMODEL_IDX                                   174
#define SBK_QABSTRACTTABLEMODEL_IDX                                  175
#define SBK_QMETACLASSINFO_IDX                                       176
#define SBK_QEASINGCURVE_IDX                                         177
#define SBK_QEASINGCURVE_TYPE_IDX                                    178
#define SBK_QLINE_IDX                                                179
#define SBK_QMARGINS_IDX                                             180
#define SBK_QCRYPTOGRAPHICHASH_IDX                                   181
#define SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX                         182
#define SBK_QTEXTCODEC_IDX                                           183
#define SBK_QTEXTCODEC_CONVERSIONFLAG_IDX                            184
#define SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG__IDX                    185
#define SBK_QTEXTCODEC_CONVERTERSTATE_IDX                            186
#define SBK_QMETAPROPERTY_IDX                                        187
#define SBK_QTIME_IDX                                                188
#define SBK_QIODEVICE_IDX                                            189
#define SBK_QIODEVICE_OPENMODEFLAG_IDX                               190
#define SBK_QFLAGS_QIODEVICE_OPENMODEFLAG__IDX                       191
#define SBK_QFILE_IDX                                                192
#define SBK_QFILE_FILEERROR_IDX                                      193
#define SBK_QFILE_MEMORYMAPFLAGS_IDX                                 194
#define SBK_QFILE_PERMISSION_IDX                                     195
#define SBK_QFLAGS_QFILE_PERMISSION__IDX                             196
#define SBK_QPROCESS_IDX                                             197
#define SBK_QPROCESS_PROCESSERROR_IDX                                198
#define SBK_QPROCESS_PROCESSCHANNELMODE_IDX                          199
#define SBK_QPROCESS_PROCESSCHANNEL_IDX                              200
#define SBK_QPROCESS_PROCESSSTATE_IDX                                201
#define SBK_QPROCESS_EXITSTATUS_IDX                                  202
#define SBK_QBUFFER_IDX                                              203
#define SBK_QSYSTEMSEMAPHORE_IDX                                     204
#define SBK_QSYSTEMSEMAPHORE_ACCESSMODE_IDX                          205
#define SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX                206
#define SBK_QTEXTSTREAM_IDX                                          207
#define SBK_QTEXTSTREAM_REALNUMBERNOTATION_IDX                       208
#define SBK_QTEXTSTREAM_NUMBERFLAG_IDX                               209
#define SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG__IDX                       210
#define SBK_QTEXTSTREAM_FIELDALIGNMENT_IDX                           211
#define SBK_QTEXTSTREAM_STATUS_IDX                                   212
#define SBK_QPOINT_IDX                                               213
#define SBK_QMUTEXLOCKER_IDX                                         214
#define SBK_QLIBRARYINFO_IDX                                         215
#define SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX                         216
#define SBK_QPERSISTENTMODELINDEX_IDX                                217
#define SBK_QLOCALE_IDX                                              218
#define SBK_QLOCALE_MEASUREMENTSYSTEM_IDX                            219
#define SBK_QLOCALE_NUMBEROPTION_IDX                                 220
#define SBK_QFLAGS_QLOCALE_NUMBEROPTION__IDX                         221
#define SBK_QLOCALE_FORMATTYPE_IDX                                   222
#define SBK_QLOCALE_COUNTRY_IDX                                      223
#define SBK_QLOCALE_LANGUAGE_IDX                                     224
#define SBK_QANIMATIONGROUP_IDX                                      225
#define SBK_QPARALLELANIMATIONGROUP_IDX                              226
#define SBK_QSEQUENTIALANIMATIONGROUP_IDX                            227
#define SBK_QABSTRACTSTATE_IDX                                       228
#define SBK_QFINALSTATE_IDX                                          229
#define SBK_QSOCKETNOTIFIER_IDX                                      230
#define SBK_QSOCKETNOTIFIER_TYPE_IDX                                 231
#define SBK_QURL_IDX                                                 232
#define SBK_QURL_PARSINGMODE_IDX                                     233
#define SBK_QURL_FORMATTINGOPTION_IDX                                234
#define SBK_QFLAGS_QURL_FORMATTINGOPTION__IDX                        235
#define SBK_QCHAR_IDX                                                236
#define SBK_QCHAR_JOINING_IDX                                        237
#define SBK_QCHAR_SPECIALCHARACTER_IDX                               238
#define SBK_QCHAR_UNICODEVERSION_IDX                                 239
#define SBK_QCHAR_DIRECTION_IDX                                      240
#define SBK_QCHAR_CATEGORY_IDX                                       241
#define SBK_QCHAR_COMBININGCLASS_IDX                                 242
#define SBK_QCHAR_DECOMPOSITION_IDX                                  243
#define SBK_QWRITELOCKER_IDX                                         244
#define SBK_QLINEF_IDX                                               245
#define SBK_QLINEF_INTERSECTTYPE_IDX                                 246
#define SBK_QTHREAD_IDX                                              247
#define SBK_QTHREAD_PRIORITY_IDX                                     248
#define SBK_QTIMELINE_IDX                                            249
#define SBK_QTIMELINE_DIRECTION_IDX                                  250
#define SBK_QTIMELINE_CURVESHAPE_IDX                                 251
#define SBK_QTIMELINE_STATE_IDX                                      252
#define SBK_QLATIN1STRING_IDX                                        253
#define SBK_QMIMEDATA_IDX                                            254
#define SBK_QDATETIME_IDX                                            255
#define SBK_QSTRINGREF_IDX                                           256
#define SBK_QEVENTLOOP_IDX                                           257
#define SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX                         258
#define SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG__IDX                 259
#define SBK_QCOREAPPLICATION_IDX                                     260
#define SBK_QCOREAPPLICATION_ENCODING_IDX                            261
#define SBK_QHISTORYSTATE_IDX                                        262
#define SBK_QHISTORYSTATE_HISTORYTYPE_IDX                            263
#define SBK_QSIZEF_IDX                                               264
#define SBK_QTEMPORARYFILE_IDX                                       265
#define SBK_QWAITCONDITION_IDX                                       266
#define SBK_QPROPERTYANIMATION_IDX                                   267
#define SBK_QSTRING_IDX                                              268
#define SBK_QSTRING_SPLITBEHAVIOR_IDX                                269
#define SBK_QSTRING_NORMALIZATIONFORM_IDX                            270
#define SBK_QSTRING_SECTIONFLAG_IDX                                  271
#define SBK_QXMLSTREAMWRITER_IDX                                     272
#define SBK_QDIR_IDX                                                 273
#define SBK_QDIR_FILTER_IDX                                          274
#define SBK_QFLAGS_QDIR_FILTER__IDX                                  275
#define SBK_QDIR_SORTFLAG_IDX                                        276
#define SBK_QFLAGS_QDIR_SORTFLAG__IDX                                277
#define SBK_QDIRITERATOR_IDX                                         278
#define SBK_QDIRITERATOR_ITERATORFLAG_IDX                            279
#define SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG__IDX                    280
#define SBK_QRESOURCE_IDX                                            281
#define SBK_QFSFILEENGINE_IDX                                        282
#define SBK_QTRANSLATOR_IDX                                          283
#define SBK_QXMLSTREAMREADER_IDX                                     284
#define SBK_QXMLSTREAMREADER_ERROR_IDX                               285
#define SBK_QXMLSTREAMREADER_TOKENTYPE_IDX                           286
#define SBK_QXMLSTREAMREADER_READELEMENTTEXTBEHAVIOUR_IDX            287
#define SBK_QPROCESSENVIRONMENT_IDX                                  288
#define SBK_QSETTINGS_IDX                                            289
#define SBK_QSETTINGS_FORMAT_IDX                                     290
#define SBK_QSETTINGS_STATUS_IDX                                     291
#define SBK_QSETTINGS_SCOPE_IDX                                      292
#define SBK_QTIMEREVENT_IDX                                          293
#define SBK_QREADWRITELOCK_IDX                                       294
#define SBK_QREADWRITELOCK_RECURSIONMODE_IDX                         295
#define SBK_QSTATE_IDX                                               296
#define SBK_QSTATE_CHILDMODE_IDX                                     297
#define SBK_QSTATEMACHINE_IDX                                        298
#define SBK_QSTATEMACHINE_ERROR_IDX                                  299
#define SBK_QSTATEMACHINE_EVENTPRIORITY_IDX                          300
#define SBK_QSTATEMACHINE_RESTOREPOLICY_IDX                          301
#define SBK_QSTATEMACHINE_WRAPPEDEVENT_IDX                           302
#define SBK_QSTATEMACHINE_SIGNALEVENT_IDX                            303
#define SBK_QTEXTDECODER_IDX                                         304
#define SBK_QTVALIDLICENSEFOROPENVGMODULE_IDX                        305
#define SBK_QTVALIDLICENSEFORMULTIMEDIAMODULE_IDX                    306
#define SBK_QTMSGTYPE_IDX                                            307
#define SBK_QtCore_IDX_COUNT                                         308

// This variable stores all python types exported by this module
extern PyTypeObject** SbkPySide_QtCoreTypes;

// Macros for type check
#define SbkPySide_QtCore_QtValidLicenseForOpenVGModule_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTVALIDLICENSEFOROPENVGMODULE_IDX])
#define SbkPySide_QtCore_QtValidLicenseForMultimediaModule_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTVALIDLICENSEFORMULTIMEDIAMODULE_IDX])
#define SbkPySide_QtCore_QtMsgType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTMSGTYPE_IDX])
#define SbkPySide_QtCore_QtConcurrent_ReduceOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTCONCURRENT_REDUCEOPTION_IDX])
#define SbkPySide_QtCore_QtConcurrent_ReduceOptions_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QTCONCURRENT_REDUCEOPTION__IDX])
#define SbkPySide_QtCore_Qt_ShortcutContext_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX])
#define SbkPySide_QtCore_Qt_CheckState_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_CHECKSTATE_IDX])
#define SbkPySide_QtCore_Qt_FocusPolicy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_FOCUSPOLICY_IDX])
#define SbkPySide_QtCore_Qt_GestureType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_GESTURETYPE_IDX])
#define SbkPySide_QtCore_Qt_DropAction_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_DROPACTION_IDX])
#define SbkPySide_QtCore_Qt_DropActions_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION__IDX])
#define SbkPySide_QtCore_Qt_WindowType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX])
#define SbkPySide_QtCore_Qt_WindowFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE__IDX])
#define SbkPySide_QtCore_Qt_DateFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_DATEFORMAT_IDX])
#define SbkPySide_QtCore_Qt_TextFormat_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_TEXTFORMAT_IDX])
#define SbkPySide_QtCore_Qt_PenJoinStyle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX])
#define SbkPySide_QtCore_Qt_GestureFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_GESTUREFLAG_IDX])
#define SbkPySide_QtCore_Qt_GestureFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_GESTUREFLAG__IDX])
#define SbkPySide_QtCore_Qt_CaseSensitivity_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX])
#define SbkPySide_QtCore_Qt_EventPriority_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_EVENTPRIORITY_IDX])
#define SbkPySide_QtCore_Qt_ImageConversionFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX])
#define SbkPySide_QtCore_Qt_ImageConversionFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG__IDX])
#define SbkPySide_QtCore_Qt_GestureState_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_GESTURESTATE_IDX])
#define SbkPySide_QtCore_Qt_BGMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_BGMODE_IDX])
#define SbkPySide_QtCore_Qt_ConnectionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_CONNECTIONTYPE_IDX])
#define SbkPySide_QtCore_Qt_ToolBarArea_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX])
#define SbkPySide_QtCore_Qt_ToolBarAreas_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_TOOLBARAREA__IDX])
#define SbkPySide_QtCore_Qt_CoordinateSystem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_COORDINATESYSTEM_IDX])
#define SbkPySide_QtCore_Qt_SizeMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_SIZEMODE_IDX])
#define SbkPySide_QtCore_Qt_FocusReason_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_FOCUSREASON_IDX])
#define SbkPySide_QtCore_Qt_Modifier_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_MODIFIER_IDX])
#define SbkPySide_QtCore_Qt_TileRule_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_TILERULE_IDX])
#define SbkPySide_QtCore_Qt_WhiteSpaceMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_WHITESPACEMODE_IDX])
#define SbkPySide_QtCore_Qt_AspectRatioMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX])
#define SbkPySide_QtCore_Qt_SizeHint_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_SIZEHINT_IDX])
#define SbkPySide_QtCore_Qt_AlignmentFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX])
#define SbkPySide_QtCore_Qt_Alignment_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG__IDX])
#define SbkPySide_QtCore_Qt_ContextMenuPolicy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_CONTEXTMENUPOLICY_IDX])
#define SbkPySide_QtCore_Qt_DockWidgetArea_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX])
#define SbkPySide_QtCore_Qt_DockWidgetAreas_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_DOCKWIDGETAREA__IDX])
#define SbkPySide_QtCore_Qt_UIEffect_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_UIEFFECT_IDX])
#define SbkPySide_QtCore_Qt_Initialization_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_INITIALIZATION_IDX])
#define SbkPySide_QtCore_Qt_AnchorPoint_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_ANCHORPOINT_IDX])
#define SbkPySide_QtCore_Qt_GlobalColor_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX])
#define SbkPySide_QtCore_Qt_KeyboardModifier_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX])
#define SbkPySide_QtCore_Qt_KeyboardModifiers_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER__IDX])
#define SbkPySide_QtCore_Qt_NavigationMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_NAVIGATIONMODE_IDX])
#define SbkPySide_QtCore_Qt_ItemDataRole_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX])
#define SbkPySide_QtCore_Qt_ScrollBarPolicy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_SCROLLBARPOLICY_IDX])
#define SbkPySide_QtCore_Qt_InputMethodHint_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX])
#define SbkPySide_QtCore_Qt_InputMethodHints_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODHINT__IDX])
#define SbkPySide_QtCore_Qt_AnchorAttribute_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_ANCHORATTRIBUTE_IDX])
#define SbkPySide_QtCore_Qt_WindowModality_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_WINDOWMODALITY_IDX])
#define SbkPySide_QtCore_Qt_SortOrder_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_SORTORDER_IDX])
#define SbkPySide_QtCore_Qt_PenStyle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_PENSTYLE_IDX])
#define SbkPySide_QtCore_Qt_ItemFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_ITEMFLAG_IDX])
#define SbkPySide_QtCore_Qt_ItemFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG__IDX])
#define SbkPySide_QtCore_Qt_Axis_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_AXIS_IDX])
#define SbkPySide_QtCore_Qt_TransformationMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX])
#define SbkPySide_QtCore_Qt_WindowFrameSection_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX])
#define SbkPySide_QtCore_Qt_HitTestAccuracy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_HITTESTACCURACY_IDX])
#define SbkPySide_QtCore_Qt_CursorShape_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX])
#define SbkPySide_QtCore_Qt_ItemSelectionMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX])
#define SbkPySide_QtCore_Qt_Orientation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_ORIENTATION_IDX])
#define SbkPySide_QtCore_Qt_Orientations_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION__IDX])
#define SbkPySide_QtCore_Qt_InputMethodQuery_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX])
#define SbkPySide_QtCore_Qt_TimeSpec_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_TIMESPEC_IDX])
#define SbkPySide_QtCore_Qt_ArrowType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_ARROWTYPE_IDX])
#define SbkPySide_QtCore_Qt_FillRule_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_FILLRULE_IDX])
#define SbkPySide_QtCore_Qt_MaskMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_MASKMODE_IDX])
#define SbkPySide_QtCore_Qt_WindowState_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_WINDOWSTATE_IDX])
#define SbkPySide_QtCore_Qt_WindowStates_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_WINDOWSTATE__IDX])
#define SbkPySide_QtCore_Qt_ToolBarAreaSizes_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_TOOLBARAREASIZES_IDX])
#define SbkPySide_QtCore_Qt_Corner_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_CORNER_IDX])
#define SbkPySide_QtCore_Qt_DayOfWeek_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX])
#define SbkPySide_QtCore_Qt_ClipOperation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX])
#define SbkPySide_QtCore_Qt_LayoutDirection_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX])
#define SbkPySide_QtCore_Qt_ToolButtonStyle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_TOOLBUTTONSTYLE_IDX])
#define SbkPySide_QtCore_Qt_DockWidgetAreaSizes_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_DOCKWIDGETAREASIZES_IDX])
#define SbkPySide_QtCore_Qt_Key_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_KEY_IDX])
#define SbkPySide_QtCore_Qt_ApplicationAttribute_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX])
#define SbkPySide_QtCore_Qt_TextFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_TEXTFLAG_IDX])
#define SbkPySide_QtCore_Qt_BrushStyle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX])
#define SbkPySide_QtCore_Qt_WidgetAttribute_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX])
#define SbkPySide_QtCore_Qt_TouchPointState_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_TOUCHPOINTSTATE_IDX])
#define SbkPySide_QtCore_Qt_TextInteractionFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX])
#define SbkPySide_QtCore_Qt_TextInteractionFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_TEXTINTERACTIONFLAG__IDX])
#define SbkPySide_QtCore_Qt_MouseButton_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX])
#define SbkPySide_QtCore_Qt_MouseButtons_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON__IDX])
#define SbkPySide_QtCore_Qt_MatchFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_MATCHFLAG_IDX])
#define SbkPySide_QtCore_Qt_MatchFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG__IDX])
#define SbkPySide_QtCore_Qt_PenCapStyle_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX])
#define SbkPySide_QtCore_Qt_TextElideMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX])
#define SbkQXmlStreamEntityDeclaration_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX])
#define SbkQMetaEnum_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QMETAENUM_IDX])
#define SbkPySide_QtCore_QRegExp_PatternSyntax_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX])
#define SbkPySide_QtCore_QRegExp_CaretMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QREGEXP_CARETMODE_IDX])
#define SbkQRegExp_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QREGEXP_IDX])
#define SbkQModelIndex_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QMODELINDEX_IDX])
#define SbkQXmlStreamNotationDeclaration_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QXMLSTREAMNOTATIONDECLARATION_IDX])
#define SbkQFactoryInterface_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFACTORYINTERFACE_IDX])
#define SbkQXmlStreamNamespaceDeclaration_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QXMLSTREAMNAMESPACEDECLARATION_IDX])
#define SbkQSemaphore_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSEMAPHORE_IDX])
#define SbkQBitArray_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QBITARRAY_IDX])
#define SbkQAbstractFileEngineHandler_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINEHANDLER_IDX])
#define SbkQGenericArgument_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QGENERICARGUMENT_IDX])
#define SbkQStringList_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSTRINGLIST_IDX])
#define SbkQPointF_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QPOINTF_IDX])
#define SbkPySide_QtCore_QMutex_RecursionMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QMUTEX_RECURSIONMODE_IDX])
#define SbkQMutex_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QMUTEX_IDX])
#define SbkPySide_QtCore_QVariant_Type_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QVARIANT_TYPE_IDX])
#define SbkQVariant_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QVARIANT_IDX])
#define SbkQObject_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])
#define SbkQFileSystemWatcher_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFILESYSTEMWATCHER_IDX])
#define SbkQAbstractEventDispatcher_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_IDX])
#define SbkPySide_QtCore_QAbstractAnimation_Direction_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTANIMATION_DIRECTION_IDX])
#define SbkPySide_QtCore_QAbstractAnimation_DeletionPolicy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTANIMATION_DELETIONPOLICY_IDX])
#define SbkPySide_QtCore_QAbstractAnimation_State_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTANIMATION_STATE_IDX])
#define SbkQAbstractAnimation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX])
#define SbkQVariantAnimation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QVARIANTANIMATION_IDX])
#define SbkQPauseAnimation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QPAUSEANIMATION_IDX])
#define SbkQSignalMapper_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSIGNALMAPPER_IDX])
#define SbkPySide_QtCore_QUuid_Variant_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QUUID_VARIANT_IDX])
#define SbkPySide_QtCore_QUuid_Version_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QUUID_VERSION_IDX])
#define SbkQUuid_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QUUID_IDX])
#define SbkQRect_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QRECT_IDX])
#define SbkQFileInfo_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFILEINFO_IDX])
#define SbkQAbstractTransition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTTRANSITION_IDX])
#define SbkQAbstractFileEngineIterator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINEITERATOR_IDX])
#define SbkQEventTransition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QEVENTTRANSITION_IDX])
#define SbkPySide_QtCore_QAbstractFileEngine_FileName_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINE_FILENAME_IDX])
#define SbkPySide_QtCore_QAbstractFileEngine_FileTime_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINE_FILETIME_IDX])
#define SbkPySide_QtCore_QAbstractFileEngine_FileOwner_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINE_FILEOWNER_IDX])
#define SbkPySide_QtCore_QAbstractFileEngine_Extension_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINE_EXTENSION_IDX])
#define SbkPySide_QtCore_QAbstractFileEngine_FileFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINE_FILEFLAG_IDX])
#define SbkPySide_QtCore_QAbstractFileEngine_FileFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QABSTRACTFILEENGINE_FILEFLAG__IDX])
#define SbkQAbstractFileEngine_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINE_IDX])
#define SbkPySide_QtCore_QSystemLocale_QueryType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSYSTEMLOCALE_QUERYTYPE_IDX])
#define SbkQSystemLocale_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSYSTEMLOCALE_IDX])
#define SbkPySide_QtCore_QSysInfo_Endian_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSYSINFO_ENDIAN_IDX])
#define SbkPySide_QtCore_QSysInfo_Sizes_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSYSINFO_SIZES_IDX])
#define SbkQSysInfo_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSYSINFO_IDX])
#define SbkQByteArray_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QBYTEARRAY_IDX])
#define SbkQXmlStreamAttributes_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX])
#define SbkQByteArrayMatcher_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QBYTEARRAYMATCHER_IDX])
#define SbkQGenericReturnArgument_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QGENERICRETURNARGUMENT_IDX])
#define SbkQSignalTransition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSIGNALTRANSITION_IDX])
#define SbkPySide_QtCore_QEvent_Type_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QEVENT_TYPE_IDX])
#define SbkQEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])
#define SbkQDynamicPropertyChangeEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QDYNAMICPROPERTYCHANGEEVENT_IDX])
#define SbkQChildEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QCHILDEVENT_IDX])
#define SbkPySide_QtCore_QMetaObject_Call_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX])
#define SbkQMetaObject_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QMETAOBJECT_IDX])
#define SbkQXmlStreamAttribute_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX])
#define SbkPySide_QtCore_QDataStream_FloatingPointPrecision_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QDATASTREAM_FLOATINGPOINTPRECISION_IDX])
#define SbkPySide_QtCore_QDataStream_Version_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX])
#define SbkPySide_QtCore_QDataStream_Status_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QDATASTREAM_STATUS_IDX])
#define SbkQDataStream_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QDATASTREAM_IDX])
#define SbkQLatin1Char_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QLATIN1CHAR_IDX])
#define SbkQBasicTimer_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QBASICTIMER_IDX])
#define SbkQReadLocker_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QREADLOCKER_IDX])
#define SbkQXmlStreamEntityResolver_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QXMLSTREAMENTITYRESOLVER_IDX])
#define SbkQStringMatcher_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSTRINGMATCHER_IDX])
#define SbkPySide_QtCore_QDate_MonthNameType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX])
#define SbkQDate_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QDATE_IDX])
#define SbkQRectF_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QRECTF_IDX])
#define SbkQSize_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSIZE_IDX])
#define SbkQTextStreamManipulator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTEXTSTREAMMANIPULATOR_IDX])
#define SbkQTimer_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTIMER_IDX])
#define SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX])
#define SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReasons_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON__IDX])
#define SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYTYPE_IDX])
#define SbkQTextBoundaryFinder_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX])
#define SbkQTextEncoder_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTEXTENCODER_IDX])
#define SbkQAbstractItemModel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX])
#define SbkQAbstractListModel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTLISTMODEL_IDX])
#define SbkQAbstractTableModel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTTABLEMODEL_IDX])
#define SbkQMetaClassInfo_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QMETACLASSINFO_IDX])
#define SbkPySide_QtCore_QEasingCurve_Type_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX])
#define SbkQEasingCurve_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QEASINGCURVE_IDX])
#define SbkQLine_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QLINE_IDX])
#define SbkQMargins_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QMARGINS_IDX])
#define SbkPySide_QtCore_QCryptographicHash_Algorithm_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX])
#define SbkQCryptographicHash_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_IDX])
#define SbkPySide_QtCore_QTextCodec_ConversionFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTEXTCODEC_CONVERSIONFLAG_IDX])
#define SbkPySide_QtCore_QTextCodec_ConversionFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG__IDX])
#define SbkQTextCodec_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTEXTCODEC_IDX])
#define SbkQTextCodec_ConverterState_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTEXTCODEC_CONVERTERSTATE_IDX])
#define SbkQMetaProperty_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QMETAPROPERTY_IDX])
#define SbkQTime_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTIME_IDX])
#define SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX])
#define SbkPySide_QtCore_QIODevice_OpenMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG__IDX])
#define SbkQIODevice_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QIODEVICE_IDX])
#define SbkPySide_QtCore_QFile_FileError_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFILE_FILEERROR_IDX])
#define SbkPySide_QtCore_QFile_MemoryMapFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFILE_MEMORYMAPFLAGS_IDX])
#define SbkPySide_QtCore_QFile_Permission_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFILE_PERMISSION_IDX])
#define SbkPySide_QtCore_QFile_Permissions_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QFILE_PERMISSION__IDX])
#define SbkQFile_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFILE_IDX])
#define SbkPySide_QtCore_QProcess_ProcessError_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QPROCESS_PROCESSERROR_IDX])
#define SbkPySide_QtCore_QProcess_ProcessChannelMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNELMODE_IDX])
#define SbkPySide_QtCore_QProcess_ProcessChannel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNEL_IDX])
#define SbkPySide_QtCore_QProcess_ProcessState_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QPROCESS_PROCESSSTATE_IDX])
#define SbkPySide_QtCore_QProcess_ExitStatus_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QPROCESS_EXITSTATUS_IDX])
#define SbkQProcess_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QPROCESS_IDX])
#define SbkQBuffer_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QBUFFER_IDX])
#define SbkPySide_QtCore_QSystemSemaphore_AccessMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_ACCESSMODE_IDX])
#define SbkPySide_QtCore_QSystemSemaphore_SystemSemaphoreError_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX])
#define SbkQSystemSemaphore_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_IDX])
#define SbkPySide_QtCore_QTextStream_RealNumberNotation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTEXTSTREAM_REALNUMBERNOTATION_IDX])
#define SbkPySide_QtCore_QTextStream_NumberFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTEXTSTREAM_NUMBERFLAG_IDX])
#define SbkPySide_QtCore_QTextStream_NumberFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG__IDX])
#define SbkPySide_QtCore_QTextStream_FieldAlignment_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTEXTSTREAM_FIELDALIGNMENT_IDX])
#define SbkPySide_QtCore_QTextStream_Status_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTEXTSTREAM_STATUS_IDX])
#define SbkQTextStream_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTEXTSTREAM_IDX])
#define SbkQPoint_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QPOINT_IDX])
#define SbkQMutexLocker_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QMUTEXLOCKER_IDX])
#define SbkPySide_QtCore_QLibraryInfo_LibraryLocation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX])
#define SbkQLibraryInfo_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QLIBRARYINFO_IDX])
#define SbkQPersistentModelIndex_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX])
#define SbkPySide_QtCore_QLocale_MeasurementSystem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QLOCALE_MEASUREMENTSYSTEM_IDX])
#define SbkPySide_QtCore_QLocale_NumberOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX])
#define SbkPySide_QtCore_QLocale_NumberOptions_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION__IDX])
#define SbkPySide_QtCore_QLocale_FormatType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX])
#define SbkPySide_QtCore_QLocale_Country_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX])
#define SbkPySide_QtCore_QLocale_Language_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX])
#define SbkQLocale_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QLOCALE_IDX])
#define SbkQAnimationGroup_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QANIMATIONGROUP_IDX])
#define SbkQParallelAnimationGroup_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QPARALLELANIMATIONGROUP_IDX])
#define SbkQSequentialAnimationGroup_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSEQUENTIALANIMATIONGROUP_IDX])
#define SbkQAbstractState_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QABSTRACTSTATE_IDX])
#define SbkQFinalState_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFINALSTATE_IDX])
#define SbkPySide_QtCore_QSocketNotifier_Type_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSOCKETNOTIFIER_TYPE_IDX])
#define SbkQSocketNotifier_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSOCKETNOTIFIER_IDX])
#define SbkPySide_QtCore_QUrl_ParsingMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])
#define SbkPySide_QtCore_QUrl_FormattingOption_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QURL_FORMATTINGOPTION_IDX])
#define SbkPySide_QtCore_QUrl_FormattingOptions_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QURL_FORMATTINGOPTION__IDX])
#define SbkQUrl_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QURL_IDX])
#define SbkPySide_QtCore_QChar_Joining_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QCHAR_JOINING_IDX])
#define SbkPySide_QtCore_QChar_SpecialCharacter_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QCHAR_SPECIALCHARACTER_IDX])
#define SbkPySide_QtCore_QChar_UnicodeVersion_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QCHAR_UNICODEVERSION_IDX])
#define SbkPySide_QtCore_QChar_Direction_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QCHAR_DIRECTION_IDX])
#define SbkPySide_QtCore_QChar_Category_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QCHAR_CATEGORY_IDX])
#define SbkPySide_QtCore_QChar_CombiningClass_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QCHAR_COMBININGCLASS_IDX])
#define SbkPySide_QtCore_QChar_Decomposition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QCHAR_DECOMPOSITION_IDX])
#define SbkQChar_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QCHAR_IDX])
#define SbkQWriteLocker_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QWRITELOCKER_IDX])
#define SbkPySide_QtCore_QLineF_IntersectType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QLINEF_INTERSECTTYPE_IDX])
#define SbkQLineF_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QLINEF_IDX])
#define SbkPySide_QtCore_QThread_Priority_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX])
#define SbkQThread_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTHREAD_IDX])
#define SbkPySide_QtCore_QTimeLine_Direction_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTIMELINE_DIRECTION_IDX])
#define SbkPySide_QtCore_QTimeLine_CurveShape_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTIMELINE_CURVESHAPE_IDX])
#define SbkPySide_QtCore_QTimeLine_State_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTIMELINE_STATE_IDX])
#define SbkQTimeLine_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTIMELINE_IDX])
#define SbkQLatin1String_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QLATIN1STRING_IDX])
#define SbkQMimeData_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QMIMEDATA_IDX])
#define SbkQDateTime_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QDATETIME_IDX])
#define SbkQStringRef_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSTRINGREF_IDX])
#define SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX])
#define SbkPySide_QtCore_QEventLoop_ProcessEventsFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG__IDX])
#define SbkQEventLoop_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QEVENTLOOP_IDX])
#define SbkPySide_QtCore_QCoreApplication_Encoding_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QCOREAPPLICATION_ENCODING_IDX])
#define SbkQCoreApplication_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QCOREAPPLICATION_IDX])
#define SbkPySide_QtCore_QHistoryState_HistoryType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QHISTORYSTATE_HISTORYTYPE_IDX])
#define SbkQHistoryState_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QHISTORYSTATE_IDX])
#define SbkQSizeF_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSIZEF_IDX])
#define SbkQTemporaryFile_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTEMPORARYFILE_IDX])
#define SbkQWaitCondition_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QWAITCONDITION_IDX])
#define SbkQPropertyAnimation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QPROPERTYANIMATION_IDX])
#define SbkPySide_QtCore_QString_SplitBehavior_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSTRING_SPLITBEHAVIOR_IDX])
#define SbkPySide_QtCore_QString_NormalizationForm_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSTRING_NORMALIZATIONFORM_IDX])
#define SbkPySide_QtCore_QString_SectionFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSTRING_SECTIONFLAG_IDX])
#define SbkQString_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSTRING_IDX])
#define SbkQXmlStreamWriter_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QXMLSTREAMWRITER_IDX])
#define SbkPySide_QtCore_QDir_Filter_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QDIR_FILTER_IDX])
#define SbkPySide_QtCore_QDir_Filters_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER__IDX])
#define SbkPySide_QtCore_QDir_SortFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX])
#define SbkPySide_QtCore_QDir_SortFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG__IDX])
#define SbkQDir_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QDIR_IDX])
#define SbkPySide_QtCore_QDirIterator_IteratorFlag_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QDIRITERATOR_ITERATORFLAG_IDX])
#define SbkPySide_QtCore_QDirIterator_IteratorFlags_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG__IDX])
#define SbkQDirIterator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QDIRITERATOR_IDX])
#define SbkQResource_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QRESOURCE_IDX])
#define SbkQFSFileEngine_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QFSFILEENGINE_IDX])
#define SbkQTranslator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTRANSLATOR_IDX])
#define SbkPySide_QtCore_QXmlStreamReader_Error_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QXMLSTREAMREADER_ERROR_IDX])
#define SbkPySide_QtCore_QXmlStreamReader_TokenType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX])
#define SbkPySide_QtCore_QXmlStreamReader_ReadElementTextBehaviour_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QXMLSTREAMREADER_READELEMENTTEXTBEHAVIOUR_IDX])
#define SbkQXmlStreamReader_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX])
#define SbkQProcessEnvironment_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QPROCESSENVIRONMENT_IDX])
#define SbkPySide_QtCore_QSettings_Format_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX])
#define SbkPySide_QtCore_QSettings_Status_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSETTINGS_STATUS_IDX])
#define SbkPySide_QtCore_QSettings_Scope_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSETTINGS_SCOPE_IDX])
#define SbkQSettings_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSETTINGS_IDX])
#define SbkQTimerEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTIMEREVENT_IDX])
#define SbkPySide_QtCore_QReadWriteLock_RecursionMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QREADWRITELOCK_RECURSIONMODE_IDX])
#define SbkQReadWriteLock_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QREADWRITELOCK_IDX])
#define SbkPySide_QtCore_QState_ChildMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSTATE_CHILDMODE_IDX])
#define SbkQState_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSTATE_IDX])
#define SbkPySide_QtCore_QStateMachine_Error_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_ERROR_IDX])
#define SbkPySide_QtCore_QStateMachine_EventPriority_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_EVENTPRIORITY_IDX])
#define SbkPySide_QtCore_QStateMachine_RestorePolicy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_RESTOREPOLICY_IDX])
#define SbkQStateMachine_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_IDX])
#define SbkQStateMachine_WrappedEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_WRAPPEDEVENT_IDX])
#define SbkQStateMachine_SignalEvent_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_SIGNALEVENT_IDX])
#define SbkQTextDecoder_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QTEXTDECODER_IDX])

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QtValidLicenseForOpenVGModule >() { return SbkPySide_QtCoreTypes[SBK_QTVALIDLICENSEFOROPENVGMODULE_IDX]; }
template<> inline PyTypeObject* SbkType<QtValidLicenseForMultimediaModule >() { return SbkPySide_QtCoreTypes[SBK_QTVALIDLICENSEFORMULTIMEDIAMODULE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMsgType >() { return SbkPySide_QtCoreTypes[SBK_QTMSGTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QtConcurrent::ReduceOption >() { return SbkPySide_QtCoreTypes[SBK_QTCONCURRENT_REDUCEOPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QtConcurrent::ReduceOption> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QTCONCURRENT_REDUCEOPTION__IDX]; }
template<> inline PyTypeObject* SbkType<Qt::ShortcutContext >() { return SbkPySide_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::CheckState >() { return SbkPySide_QtCoreTypes[SBK_QT_CHECKSTATE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::FocusPolicy >() { return SbkPySide_QtCoreTypes[SBK_QT_FOCUSPOLICY_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::GestureType >() { return SbkPySide_QtCoreTypes[SBK_QT_GESTURETYPE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::DropAction >() { return SbkPySide_QtCoreTypes[SBK_QT_DROPACTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<Qt::DropAction> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION__IDX]; }
template<> inline PyTypeObject* SbkType<Qt::WindowType >() { return SbkPySide_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<Qt::WindowType> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE__IDX]; }
template<> inline PyTypeObject* SbkType<Qt::DateFormat >() { return SbkPySide_QtCoreTypes[SBK_QT_DATEFORMAT_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::TextFormat >() { return SbkPySide_QtCoreTypes[SBK_QT_TEXTFORMAT_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::PenJoinStyle >() { return SbkPySide_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::GestureFlag >() { return SbkPySide_QtCoreTypes[SBK_QT_GESTUREFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<Qt::GestureFlag> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_GESTUREFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<Qt::CaseSensitivity >() { return SbkPySide_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::EventPriority >() { return SbkPySide_QtCoreTypes[SBK_QT_EVENTPRIORITY_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::ImageConversionFlag >() { return SbkPySide_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<Qt::ImageConversionFlag> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<Qt::GestureState >() { return SbkPySide_QtCoreTypes[SBK_QT_GESTURESTATE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::BGMode >() { return SbkPySide_QtCoreTypes[SBK_QT_BGMODE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::ConnectionType >() { return SbkPySide_QtCoreTypes[SBK_QT_CONNECTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::ToolBarArea >() { return SbkPySide_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<Qt::ToolBarArea> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_TOOLBARAREA__IDX]; }
template<> inline PyTypeObject* SbkType<Qt::CoordinateSystem >() { return SbkPySide_QtCoreTypes[SBK_QT_COORDINATESYSTEM_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::SizeMode >() { return SbkPySide_QtCoreTypes[SBK_QT_SIZEMODE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::FocusReason >() { return SbkPySide_QtCoreTypes[SBK_QT_FOCUSREASON_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::Modifier >() { return SbkPySide_QtCoreTypes[SBK_QT_MODIFIER_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::TileRule >() { return SbkPySide_QtCoreTypes[SBK_QT_TILERULE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::WhiteSpaceMode >() { return SbkPySide_QtCoreTypes[SBK_QT_WHITESPACEMODE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::AspectRatioMode >() { return SbkPySide_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::SizeHint >() { return SbkPySide_QtCoreTypes[SBK_QT_SIZEHINT_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::AlignmentFlag >() { return SbkPySide_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<Qt::AlignmentFlag> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<Qt::ContextMenuPolicy >() { return SbkPySide_QtCoreTypes[SBK_QT_CONTEXTMENUPOLICY_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::DockWidgetArea >() { return SbkPySide_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<Qt::DockWidgetArea> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_DOCKWIDGETAREA__IDX]; }
template<> inline PyTypeObject* SbkType<Qt::UIEffect >() { return SbkPySide_QtCoreTypes[SBK_QT_UIEFFECT_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::Initialization >() { return SbkPySide_QtCoreTypes[SBK_QT_INITIALIZATION_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::AnchorPoint >() { return SbkPySide_QtCoreTypes[SBK_QT_ANCHORPOINT_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::GlobalColor >() { return SbkPySide_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::KeyboardModifier >() { return SbkPySide_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<Qt::KeyboardModifier> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER__IDX]; }
template<> inline PyTypeObject* SbkType<Qt::NavigationMode >() { return SbkPySide_QtCoreTypes[SBK_QT_NAVIGATIONMODE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::ItemDataRole >() { return SbkPySide_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::ScrollBarPolicy >() { return SbkPySide_QtCoreTypes[SBK_QT_SCROLLBARPOLICY_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::InputMethodHint >() { return SbkPySide_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<Qt::InputMethodHint> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODHINT__IDX]; }
template<> inline PyTypeObject* SbkType<Qt::AnchorAttribute >() { return SbkPySide_QtCoreTypes[SBK_QT_ANCHORATTRIBUTE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::WindowModality >() { return SbkPySide_QtCoreTypes[SBK_QT_WINDOWMODALITY_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::SortOrder >() { return SbkPySide_QtCoreTypes[SBK_QT_SORTORDER_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::PenStyle >() { return SbkPySide_QtCoreTypes[SBK_QT_PENSTYLE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::ItemFlag >() { return SbkPySide_QtCoreTypes[SBK_QT_ITEMFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<Qt::ItemFlag> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<Qt::Axis >() { return SbkPySide_QtCoreTypes[SBK_QT_AXIS_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::TransformationMode >() { return SbkPySide_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::WindowFrameSection >() { return SbkPySide_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::HitTestAccuracy >() { return SbkPySide_QtCoreTypes[SBK_QT_HITTESTACCURACY_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::CursorShape >() { return SbkPySide_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::ItemSelectionMode >() { return SbkPySide_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::Orientation >() { return SbkPySide_QtCoreTypes[SBK_QT_ORIENTATION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<Qt::Orientation> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION__IDX]; }
template<> inline PyTypeObject* SbkType<Qt::InputMethodQuery >() { return SbkPySide_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::TimeSpec >() { return SbkPySide_QtCoreTypes[SBK_QT_TIMESPEC_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::ArrowType >() { return SbkPySide_QtCoreTypes[SBK_QT_ARROWTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::FillRule >() { return SbkPySide_QtCoreTypes[SBK_QT_FILLRULE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::MaskMode >() { return SbkPySide_QtCoreTypes[SBK_QT_MASKMODE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::WindowState >() { return SbkPySide_QtCoreTypes[SBK_QT_WINDOWSTATE_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<Qt::WindowState> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_WINDOWSTATE__IDX]; }
template<> inline PyTypeObject* SbkType<Qt::ToolBarAreaSizes >() { return SbkPySide_QtCoreTypes[SBK_QT_TOOLBARAREASIZES_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::Corner >() { return SbkPySide_QtCoreTypes[SBK_QT_CORNER_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::DayOfWeek >() { return SbkPySide_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::ClipOperation >() { return SbkPySide_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::LayoutDirection >() { return SbkPySide_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::ToolButtonStyle >() { return SbkPySide_QtCoreTypes[SBK_QT_TOOLBUTTONSTYLE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::DockWidgetAreaSizes >() { return SbkPySide_QtCoreTypes[SBK_QT_DOCKWIDGETAREASIZES_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::Key >() { return SbkPySide_QtCoreTypes[SBK_QT_KEY_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::ApplicationAttribute >() { return SbkPySide_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::TextFlag >() { return SbkPySide_QtCoreTypes[SBK_QT_TEXTFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::BrushStyle >() { return SbkPySide_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::WidgetAttribute >() { return SbkPySide_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::TouchPointState >() { return SbkPySide_QtCoreTypes[SBK_QT_TOUCHPOINTSTATE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::TextInteractionFlag >() { return SbkPySide_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<Qt::TextInteractionFlag> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_TEXTINTERACTIONFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<Qt::MouseButton >() { return SbkPySide_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<Qt::MouseButton> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON__IDX]; }
template<> inline PyTypeObject* SbkType<Qt::MatchFlag >() { return SbkPySide_QtCoreTypes[SBK_QT_MATCHFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<Qt::MatchFlag> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<Qt::PenCapStyle >() { return SbkPySide_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX]; }
template<> inline PyTypeObject* SbkType<Qt::TextElideMode >() { return SbkPySide_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QXmlStreamEntityDeclaration >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QXMLSTREAMENTITYDECLARATION_IDX]); }
template<> inline PyTypeObject* SbkType<QMetaEnum >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QMETAENUM_IDX]); }
template<> inline PyTypeObject* SbkType<QRegExp::PatternSyntax >() { return SbkPySide_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX]; }
template<> inline PyTypeObject* SbkType<QRegExp::CaretMode >() { return SbkPySide_QtCoreTypes[SBK_QREGEXP_CARETMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QRegExp >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QREGEXP_IDX]); }
template<> inline PyTypeObject* SbkType<QModelIndex >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QMODELINDEX_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlStreamNotationDeclaration >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QXMLSTREAMNOTATIONDECLARATION_IDX]); }
template<> inline PyTypeObject* SbkType<QFactoryInterface >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QFACTORYINTERFACE_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlStreamNamespaceDeclaration >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QXMLSTREAMNAMESPACEDECLARATION_IDX]); }
template<> inline PyTypeObject* SbkType<QSemaphore >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSEMAPHORE_IDX]); }
template<> inline PyTypeObject* SbkType<QBitArray >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QBITARRAY_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractFileEngineHandler >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINEHANDLER_IDX]); }
template<> inline PyTypeObject* SbkType<QGenericArgument >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QGENERICARGUMENT_IDX]); }
template<> inline PyTypeObject* SbkType<QStringList >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSTRINGLIST_IDX]); }
template<> inline PyTypeObject* SbkType<QPointF >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QPOINTF_IDX]); }
template<> inline PyTypeObject* SbkType<QMutex::RecursionMode >() { return SbkPySide_QtCoreTypes[SBK_QMUTEX_RECURSIONMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QMutex >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QMUTEX_IDX]); }
template<> inline PyTypeObject* SbkType<QVariant::Type >() { return SbkPySide_QtCoreTypes[SBK_QVARIANT_TYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QVariant >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QVARIANT_IDX]); }
template<> inline PyTypeObject* SbkType<QObject >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]); }
template<> inline PyTypeObject* SbkType<QFileSystemWatcher >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QFILESYSTEMWATCHER_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractEventDispatcher >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractAnimation::Direction >() { return SbkPySide_QtCoreTypes[SBK_QABSTRACTANIMATION_DIRECTION_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractAnimation::DeletionPolicy >() { return SbkPySide_QtCoreTypes[SBK_QABSTRACTANIMATION_DELETIONPOLICY_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractAnimation::State >() { return SbkPySide_QtCoreTypes[SBK_QABSTRACTANIMATION_STATE_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractAnimation >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX]); }
template<> inline PyTypeObject* SbkType<QVariantAnimation >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QVARIANTANIMATION_IDX]); }
template<> inline PyTypeObject* SbkType<QPauseAnimation >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QPAUSEANIMATION_IDX]); }
template<> inline PyTypeObject* SbkType<QSignalMapper >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSIGNALMAPPER_IDX]); }
template<> inline PyTypeObject* SbkType<QUuid::Variant >() { return SbkPySide_QtCoreTypes[SBK_QUUID_VARIANT_IDX]; }
template<> inline PyTypeObject* SbkType<QUuid::Version >() { return SbkPySide_QtCoreTypes[SBK_QUUID_VERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QUuid >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QUUID_IDX]); }
template<> inline PyTypeObject* SbkType<QRect >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QRECT_IDX]); }
template<> inline PyTypeObject* SbkType<QFileInfo >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QFILEINFO_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractTransition >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QABSTRACTTRANSITION_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractFileEngineIterator >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINEITERATOR_IDX]); }
template<> inline PyTypeObject* SbkType<QEventTransition >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QEVENTTRANSITION_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractFileEngine::FileName >() { return SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINE_FILENAME_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractFileEngine::FileTime >() { return SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINE_FILETIME_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractFileEngine::FileOwner >() { return SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINE_FILEOWNER_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractFileEngine::Extension >() { return SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINE_EXTENSION_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractFileEngine::FileFlag >() { return SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINE_FILEFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QAbstractFileEngine::FileFlag> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QABSTRACTFILEENGINE_FILEFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractFileEngine >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINE_IDX]); }
template<> inline PyTypeObject* SbkType<QSystemLocale::QueryType >() { return SbkPySide_QtCoreTypes[SBK_QSYSTEMLOCALE_QUERYTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QSystemLocale >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSYSTEMLOCALE_IDX]); }
template<> inline PyTypeObject* SbkType<QSysInfo::Endian >() { return SbkPySide_QtCoreTypes[SBK_QSYSINFO_ENDIAN_IDX]; }
template<> inline PyTypeObject* SbkType<QSysInfo::Sizes >() { return SbkPySide_QtCoreTypes[SBK_QSYSINFO_SIZES_IDX]; }
template<> inline PyTypeObject* SbkType<QSysInfo >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSYSINFO_IDX]); }
template<> inline PyTypeObject* SbkType<QByteArray >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QBYTEARRAY_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlStreamAttributes >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTES_IDX]); }
template<> inline PyTypeObject* SbkType<QByteArrayMatcher >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QBYTEARRAYMATCHER_IDX]); }
template<> inline PyTypeObject* SbkType<QGenericReturnArgument >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QGENERICRETURNARGUMENT_IDX]); }
template<> inline PyTypeObject* SbkType<QSignalTransition >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSIGNALTRANSITION_IDX]); }
template<> inline PyTypeObject* SbkType<QEvent::Type >() { return SbkPySide_QtCoreTypes[SBK_QEVENT_TYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QDynamicPropertyChangeEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QDYNAMICPROPERTYCHANGEEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QChildEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QCHILDEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QMetaObject::Call >() { return SbkPySide_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX]; }
template<> inline PyTypeObject* SbkType<QMetaObject >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QMETAOBJECT_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlStreamAttribute >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QXMLSTREAMATTRIBUTE_IDX]); }
template<> inline PyTypeObject* SbkType<QDataStream::FloatingPointPrecision >() { return SbkPySide_QtCoreTypes[SBK_QDATASTREAM_FLOATINGPOINTPRECISION_IDX]; }
template<> inline PyTypeObject* SbkType<QDataStream::Version >() { return SbkPySide_QtCoreTypes[SBK_QDATASTREAM_VERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QDataStream::Status >() { return SbkPySide_QtCoreTypes[SBK_QDATASTREAM_STATUS_IDX]; }
template<> inline PyTypeObject* SbkType<QDataStream >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QDATASTREAM_IDX]); }
template<> inline PyTypeObject* SbkType<QLatin1Char >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QLATIN1CHAR_IDX]); }
template<> inline PyTypeObject* SbkType<QBasicTimer >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QBASICTIMER_IDX]); }
template<> inline PyTypeObject* SbkType<QReadLocker >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QREADLOCKER_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlStreamEntityResolver >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QXMLSTREAMENTITYRESOLVER_IDX]); }
template<> inline PyTypeObject* SbkType<QStringMatcher >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSTRINGMATCHER_IDX]); }
template<> inline PyTypeObject* SbkType<QDate::MonthNameType >() { return SbkPySide_QtCoreTypes[SBK_QDATE_MONTHNAMETYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QDate >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QDATE_IDX]); }
template<> inline PyTypeObject* SbkType<QRectF >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QRECTF_IDX]); }
template<> inline PyTypeObject* SbkType<QSize >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSIZE_IDX]); }
template<> inline PyTypeObject* SbkType<QTextStreamManipulator >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QTEXTSTREAMMANIPULATOR_IDX]); }
template<> inline PyTypeObject* SbkType<QTimer >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QTIMER_IDX]); }
template<> inline PyTypeObject* SbkType<QTextBoundaryFinder::BoundaryReason >() { return SbkPySide_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QTextBoundaryFinder::BoundaryReason> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON__IDX]; }
template<> inline PyTypeObject* SbkType<QTextBoundaryFinder::BoundaryType >() { return SbkPySide_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QTextBoundaryFinder >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX]); }
template<> inline PyTypeObject* SbkType<QTextEncoder >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QTEXTENCODER_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractItemModel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractListModel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QABSTRACTLISTMODEL_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractTableModel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QABSTRACTTABLEMODEL_IDX]); }
template<> inline PyTypeObject* SbkType<QMetaClassInfo >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QMETACLASSINFO_IDX]); }
template<> inline PyTypeObject* SbkType<QEasingCurve::Type >() { return SbkPySide_QtCoreTypes[SBK_QEASINGCURVE_TYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QEasingCurve >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QEASINGCURVE_IDX]); }
template<> inline PyTypeObject* SbkType<QLine >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QLINE_IDX]); }
template<> inline PyTypeObject* SbkType<QMargins >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QMARGINS_IDX]); }
template<> inline PyTypeObject* SbkType<QCryptographicHash::Algorithm >() { return SbkPySide_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX]; }
template<> inline PyTypeObject* SbkType<QCryptographicHash >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_IDX]); }
template<> inline PyTypeObject* SbkType<QTextCodec::ConversionFlag >() { return SbkPySide_QtCoreTypes[SBK_QTEXTCODEC_CONVERSIONFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QTextCodec::ConversionFlag> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QTEXTCODEC_CONVERSIONFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QTextCodec >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QTEXTCODEC_IDX]); }
template<> inline PyTypeObject* SbkType<QTextCodec::ConverterState >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QTEXTCODEC_CONVERTERSTATE_IDX]); }
template<> inline PyTypeObject* SbkType<QMetaProperty >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QMETAPROPERTY_IDX]); }
template<> inline PyTypeObject* SbkType<QTime >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QTIME_IDX]); }
template<> inline PyTypeObject* SbkType<QIODevice::OpenModeFlag >() { return SbkPySide_QtCoreTypes[SBK_QIODEVICE_OPENMODEFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QIODevice::OpenModeFlag> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QIODevice >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QIODEVICE_IDX]); }
template<> inline PyTypeObject* SbkType<QFile::FileError >() { return SbkPySide_QtCoreTypes[SBK_QFILE_FILEERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QFile::MemoryMapFlags >() { return SbkPySide_QtCoreTypes[SBK_QFILE_MEMORYMAPFLAGS_IDX]; }
template<> inline PyTypeObject* SbkType<QFile::Permission >() { return SbkPySide_QtCoreTypes[SBK_QFILE_PERMISSION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QFile::Permission> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QFILE_PERMISSION__IDX]; }
template<> inline PyTypeObject* SbkType<QFile >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QFILE_IDX]); }
template<> inline PyTypeObject* SbkType<QProcess::ProcessError >() { return SbkPySide_QtCoreTypes[SBK_QPROCESS_PROCESSERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QProcess::ProcessChannelMode >() { return SbkPySide_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNELMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QProcess::ProcessChannel >() { return SbkPySide_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNEL_IDX]; }
template<> inline PyTypeObject* SbkType<QProcess::ProcessState >() { return SbkPySide_QtCoreTypes[SBK_QPROCESS_PROCESSSTATE_IDX]; }
template<> inline PyTypeObject* SbkType<QProcess::ExitStatus >() { return SbkPySide_QtCoreTypes[SBK_QPROCESS_EXITSTATUS_IDX]; }
template<> inline PyTypeObject* SbkType<QProcess >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QPROCESS_IDX]); }
template<> inline PyTypeObject* SbkType<QBuffer >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QBUFFER_IDX]); }
template<> inline PyTypeObject* SbkType<QSystemSemaphore::AccessMode >() { return SbkPySide_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_ACCESSMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QSystemSemaphore::SystemSemaphoreError >() { return SbkPySide_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_SYSTEMSEMAPHOREERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QSystemSemaphore >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSYSTEMSEMAPHORE_IDX]); }
template<> inline PyTypeObject* SbkType<QTextStream::RealNumberNotation >() { return SbkPySide_QtCoreTypes[SBK_QTEXTSTREAM_REALNUMBERNOTATION_IDX]; }
template<> inline PyTypeObject* SbkType<QTextStream::NumberFlag >() { return SbkPySide_QtCoreTypes[SBK_QTEXTSTREAM_NUMBERFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QTextStream::NumberFlag> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QTEXTSTREAM_NUMBERFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QTextStream::FieldAlignment >() { return SbkPySide_QtCoreTypes[SBK_QTEXTSTREAM_FIELDALIGNMENT_IDX]; }
template<> inline PyTypeObject* SbkType<QTextStream::Status >() { return SbkPySide_QtCoreTypes[SBK_QTEXTSTREAM_STATUS_IDX]; }
template<> inline PyTypeObject* SbkType<QTextStream >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QTEXTSTREAM_IDX]); }
template<> inline PyTypeObject* SbkType<QPoint >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QPOINT_IDX]); }
template<> inline PyTypeObject* SbkType<QMutexLocker >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QMUTEXLOCKER_IDX]); }
template<> inline PyTypeObject* SbkType<QLibraryInfo::LibraryLocation >() { return SbkPySide_QtCoreTypes[SBK_QLIBRARYINFO_LIBRARYLOCATION_IDX]; }
template<> inline PyTypeObject* SbkType<QLibraryInfo >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QLIBRARYINFO_IDX]); }
template<> inline PyTypeObject* SbkType<QPersistentModelIndex >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX]); }
template<> inline PyTypeObject* SbkType<QLocale::MeasurementSystem >() { return SbkPySide_QtCoreTypes[SBK_QLOCALE_MEASUREMENTSYSTEM_IDX]; }
template<> inline PyTypeObject* SbkType<QLocale::NumberOption >() { return SbkPySide_QtCoreTypes[SBK_QLOCALE_NUMBEROPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QLocale::NumberOption> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QLOCALE_NUMBEROPTION__IDX]; }
template<> inline PyTypeObject* SbkType<QLocale::FormatType >() { return SbkPySide_QtCoreTypes[SBK_QLOCALE_FORMATTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QLocale::Country >() { return SbkPySide_QtCoreTypes[SBK_QLOCALE_COUNTRY_IDX]; }
template<> inline PyTypeObject* SbkType<QLocale::Language >() { return SbkPySide_QtCoreTypes[SBK_QLOCALE_LANGUAGE_IDX]; }
template<> inline PyTypeObject* SbkType<QLocale >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QLOCALE_IDX]); }
template<> inline PyTypeObject* SbkType<QAnimationGroup >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QANIMATIONGROUP_IDX]); }
template<> inline PyTypeObject* SbkType<QParallelAnimationGroup >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QPARALLELANIMATIONGROUP_IDX]); }
template<> inline PyTypeObject* SbkType<QSequentialAnimationGroup >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSEQUENTIALANIMATIONGROUP_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractState >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QABSTRACTSTATE_IDX]); }
template<> inline PyTypeObject* SbkType<QFinalState >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QFINALSTATE_IDX]); }
template<> inline PyTypeObject* SbkType<QSocketNotifier::Type >() { return SbkPySide_QtCoreTypes[SBK_QSOCKETNOTIFIER_TYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QSocketNotifier >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSOCKETNOTIFIER_IDX]); }
template<> inline PyTypeObject* SbkType<QUrl::ParsingMode >() { return SbkPySide_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QUrl::FormattingOption >() { return SbkPySide_QtCoreTypes[SBK_QURL_FORMATTINGOPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QUrl::FormattingOption> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QURL_FORMATTINGOPTION__IDX]; }
template<> inline PyTypeObject* SbkType<QUrl >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QURL_IDX]); }
template<> inline PyTypeObject* SbkType<QChar::Joining >() { return SbkPySide_QtCoreTypes[SBK_QCHAR_JOINING_IDX]; }
template<> inline PyTypeObject* SbkType<QChar::SpecialCharacter >() { return SbkPySide_QtCoreTypes[SBK_QCHAR_SPECIALCHARACTER_IDX]; }
template<> inline PyTypeObject* SbkType<QChar::UnicodeVersion >() { return SbkPySide_QtCoreTypes[SBK_QCHAR_UNICODEVERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QChar::Direction >() { return SbkPySide_QtCoreTypes[SBK_QCHAR_DIRECTION_IDX]; }
template<> inline PyTypeObject* SbkType<QChar::Category >() { return SbkPySide_QtCoreTypes[SBK_QCHAR_CATEGORY_IDX]; }
template<> inline PyTypeObject* SbkType<QChar::CombiningClass >() { return SbkPySide_QtCoreTypes[SBK_QCHAR_COMBININGCLASS_IDX]; }
template<> inline PyTypeObject* SbkType<QChar::Decomposition >() { return SbkPySide_QtCoreTypes[SBK_QCHAR_DECOMPOSITION_IDX]; }
template<> inline PyTypeObject* SbkType<QChar >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QCHAR_IDX]); }
template<> inline PyTypeObject* SbkType<QWriteLocker >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QWRITELOCKER_IDX]); }
template<> inline PyTypeObject* SbkType<QLineF::IntersectType >() { return SbkPySide_QtCoreTypes[SBK_QLINEF_INTERSECTTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QLineF >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QLINEF_IDX]); }
template<> inline PyTypeObject* SbkType<QThread::Priority >() { return SbkPySide_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX]; }
template<> inline PyTypeObject* SbkType<QThread >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QTHREAD_IDX]); }
template<> inline PyTypeObject* SbkType<QTimeLine::Direction >() { return SbkPySide_QtCoreTypes[SBK_QTIMELINE_DIRECTION_IDX]; }
template<> inline PyTypeObject* SbkType<QTimeLine::CurveShape >() { return SbkPySide_QtCoreTypes[SBK_QTIMELINE_CURVESHAPE_IDX]; }
template<> inline PyTypeObject* SbkType<QTimeLine::State >() { return SbkPySide_QtCoreTypes[SBK_QTIMELINE_STATE_IDX]; }
template<> inline PyTypeObject* SbkType<QTimeLine >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QTIMELINE_IDX]); }
template<> inline PyTypeObject* SbkType<QLatin1String >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QLATIN1STRING_IDX]); }
template<> inline PyTypeObject* SbkType<QMimeData >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QMIMEDATA_IDX]); }
template<> inline PyTypeObject* SbkType<QDateTime >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QDATETIME_IDX]); }
template<> inline PyTypeObject* SbkType<QStringRef >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSTRINGREF_IDX]); }
template<> inline PyTypeObject* SbkType<QEventLoop::ProcessEventsFlag >() { return SbkPySide_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QEventLoop::ProcessEventsFlag> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QEventLoop >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QEVENTLOOP_IDX]); }
template<> inline PyTypeObject* SbkType<QCoreApplication::Encoding >() { return SbkPySide_QtCoreTypes[SBK_QCOREAPPLICATION_ENCODING_IDX]; }
template<> inline PyTypeObject* SbkType<QCoreApplication >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QCOREAPPLICATION_IDX]); }
template<> inline PyTypeObject* SbkType<QHistoryState::HistoryType >() { return SbkPySide_QtCoreTypes[SBK_QHISTORYSTATE_HISTORYTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QHistoryState >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QHISTORYSTATE_IDX]); }
template<> inline PyTypeObject* SbkType<QSizeF >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSIZEF_IDX]); }
template<> inline PyTypeObject* SbkType<QTemporaryFile >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QTEMPORARYFILE_IDX]); }
template<> inline PyTypeObject* SbkType<QWaitCondition >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QWAITCONDITION_IDX]); }
template<> inline PyTypeObject* SbkType<QPropertyAnimation >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QPROPERTYANIMATION_IDX]); }
template<> inline PyTypeObject* SbkType<QString::SplitBehavior >() { return SbkPySide_QtCoreTypes[SBK_QSTRING_SPLITBEHAVIOR_IDX]; }
template<> inline PyTypeObject* SbkType<QString::NormalizationForm >() { return SbkPySide_QtCoreTypes[SBK_QSTRING_NORMALIZATIONFORM_IDX]; }
template<> inline PyTypeObject* SbkType<QString::SectionFlag >() { return SbkPySide_QtCoreTypes[SBK_QSTRING_SECTIONFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QString >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSTRING_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlStreamWriter >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QXMLSTREAMWRITER_IDX]); }
template<> inline PyTypeObject* SbkType<QDir::Filter >() { return SbkPySide_QtCoreTypes[SBK_QDIR_FILTER_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QDir::Filter> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER__IDX]; }
template<> inline PyTypeObject* SbkType<QDir::SortFlag >() { return SbkPySide_QtCoreTypes[SBK_QDIR_SORTFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QDir::SortFlag> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QDIR_SORTFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QDir >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QDIR_IDX]); }
template<> inline PyTypeObject* SbkType<QDirIterator::IteratorFlag >() { return SbkPySide_QtCoreTypes[SBK_QDIRITERATOR_ITERATORFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QDirIterator::IteratorFlag> >() { return SbkPySide_QtCoreTypes[SBK_QFLAGS_QDIRITERATOR_ITERATORFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QDirIterator >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QDIRITERATOR_IDX]); }
template<> inline PyTypeObject* SbkType<QResource >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QRESOURCE_IDX]); }
template<> inline PyTypeObject* SbkType<QFSFileEngine >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QFSFILEENGINE_IDX]); }
template<> inline PyTypeObject* SbkType<QTranslator >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QTRANSLATOR_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlStreamReader::Error >() { return SbkPySide_QtCoreTypes[SBK_QXMLSTREAMREADER_ERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QXmlStreamReader::TokenType >() { return SbkPySide_QtCoreTypes[SBK_QXMLSTREAMREADER_TOKENTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QXmlStreamReader::ReadElementTextBehaviour >() { return SbkPySide_QtCoreTypes[SBK_QXMLSTREAMREADER_READELEMENTTEXTBEHAVIOUR_IDX]; }
template<> inline PyTypeObject* SbkType<QXmlStreamReader >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QXMLSTREAMREADER_IDX]); }
template<> inline PyTypeObject* SbkType<QProcessEnvironment >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QPROCESSENVIRONMENT_IDX]); }
template<> inline PyTypeObject* SbkType<QSettings::Format >() { return SbkPySide_QtCoreTypes[SBK_QSETTINGS_FORMAT_IDX]; }
template<> inline PyTypeObject* SbkType<QSettings::Status >() { return SbkPySide_QtCoreTypes[SBK_QSETTINGS_STATUS_IDX]; }
template<> inline PyTypeObject* SbkType<QSettings::Scope >() { return SbkPySide_QtCoreTypes[SBK_QSETTINGS_SCOPE_IDX]; }
template<> inline PyTypeObject* SbkType<QSettings >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSETTINGS_IDX]); }
template<> inline PyTypeObject* SbkType<QTimerEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QTIMEREVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QReadWriteLock::RecursionMode >() { return SbkPySide_QtCoreTypes[SBK_QREADWRITELOCK_RECURSIONMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QReadWriteLock >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QREADWRITELOCK_IDX]); }
template<> inline PyTypeObject* SbkType<QState::ChildMode >() { return SbkPySide_QtCoreTypes[SBK_QSTATE_CHILDMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QState >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSTATE_IDX]); }
template<> inline PyTypeObject* SbkType<QStateMachine::Error >() { return SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_ERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QStateMachine::EventPriority >() { return SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_EVENTPRIORITY_IDX]; }
template<> inline PyTypeObject* SbkType<QStateMachine::RestorePolicy >() { return SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_RESTOREPOLICY_IDX]; }
template<> inline PyTypeObject* SbkType<QStateMachine >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_IDX]); }
template<> inline PyTypeObject* SbkType<QStateMachine::WrappedEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_WRAPPEDEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QStateMachine::SignalEvent >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_SIGNALEVENT_IDX]); }
template<> inline PyTypeObject* SbkType<QTextDecoder >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtCoreTypes[SBK_QTEXTDECODER_IDX]); }

// Generated converters declarations ----------------------------------

template<>
struct Converter<QtValidLicenseForOpenVGModule > : EnumConverter<QtValidLicenseForOpenVGModule >
{
};

template<>
struct Converter<QtValidLicenseForMultimediaModule > : EnumConverter<QtValidLicenseForMultimediaModule >
{
};

template<>
struct Converter<QtMsgType > : EnumConverter<QtMsgType >
{
};

template<>
struct Converter<QtConcurrent::ReduceOption > : EnumConverter<QtConcurrent::ReduceOption >
{
};
template<>
struct Converter<QFlags<QtConcurrent::ReduceOption> > : EnumConverter<QFlags<QtConcurrent::ReduceOption> >
{
};

template<>
struct Converter<Qt::ShortcutContext > : EnumConverter<Qt::ShortcutContext >
{
};

template<>
struct Converter<Qt::CheckState > : EnumConverter<Qt::CheckState >
{
};

template<>
struct Converter<Qt::FocusPolicy > : EnumConverter<Qt::FocusPolicy >
{
};

template<>
struct Converter<Qt::GestureType > : EnumConverter<Qt::GestureType >
{
};

template<>
struct Converter<Qt::DropAction > : EnumConverter<Qt::DropAction >
{
};
template<>
struct Converter<QFlags<Qt::DropAction> > : EnumConverter<QFlags<Qt::DropAction> >
{
};

template<>
struct Converter<Qt::WindowType > : EnumConverter<Qt::WindowType >
{
};
template<>
struct Converter<QFlags<Qt::WindowType> > : EnumConverter<QFlags<Qt::WindowType> >
{
};

template<>
struct Converter<Qt::DateFormat > : EnumConverter<Qt::DateFormat >
{
};

template<>
struct Converter<Qt::TextFormat > : EnumConverter<Qt::TextFormat >
{
};

template<>
struct Converter<Qt::PenJoinStyle > : EnumConverter<Qt::PenJoinStyle >
{
};

template<>
struct Converter<Qt::GestureFlag > : EnumConverter<Qt::GestureFlag >
{
};
template<>
struct Converter<QFlags<Qt::GestureFlag> > : EnumConverter<QFlags<Qt::GestureFlag> >
{
};

template<>
struct Converter<Qt::CaseSensitivity > : EnumConverter<Qt::CaseSensitivity >
{
};

template<>
struct Converter<Qt::EventPriority > : EnumConverter<Qt::EventPriority >
{
};

template<>
struct Converter<Qt::ImageConversionFlag > : EnumConverter<Qt::ImageConversionFlag >
{
};
template<>
struct Converter<QFlags<Qt::ImageConversionFlag> > : EnumConverter<QFlags<Qt::ImageConversionFlag> >
{
};

template<>
struct Converter<Qt::GestureState > : EnumConverter<Qt::GestureState >
{
};

template<>
struct Converter<Qt::BGMode > : EnumConverter<Qt::BGMode >
{
};

template<>
struct Converter<Qt::ConnectionType > : EnumConverter<Qt::ConnectionType >
{
};

template<>
struct Converter<Qt::ToolBarArea > : EnumConverter<Qt::ToolBarArea >
{
};
template<>
struct Converter<QFlags<Qt::ToolBarArea> > : EnumConverter<QFlags<Qt::ToolBarArea> >
{
};

template<>
struct Converter<Qt::CoordinateSystem > : EnumConverter<Qt::CoordinateSystem >
{
};

template<>
struct Converter<Qt::SizeMode > : EnumConverter<Qt::SizeMode >
{
};

template<>
struct Converter<Qt::FocusReason > : EnumConverter<Qt::FocusReason >
{
};

template<>
struct Converter<Qt::Modifier > : EnumConverter<Qt::Modifier >
{
};

template<>
struct Converter<Qt::TileRule > : EnumConverter<Qt::TileRule >
{
};

template<>
struct Converter<Qt::WhiteSpaceMode > : EnumConverter<Qt::WhiteSpaceMode >
{
};

template<>
struct Converter<Qt::AspectRatioMode > : EnumConverter<Qt::AspectRatioMode >
{
};

template<>
struct Converter<Qt::SizeHint > : EnumConverter<Qt::SizeHint >
{
};

template<>
struct Converter<Qt::AlignmentFlag > : EnumConverter<Qt::AlignmentFlag >
{
};
template<>
struct Converter<QFlags<Qt::AlignmentFlag> > : EnumConverter<QFlags<Qt::AlignmentFlag> >
{
};

template<>
struct Converter<Qt::ContextMenuPolicy > : EnumConverter<Qt::ContextMenuPolicy >
{
};

template<>
struct Converter<Qt::DockWidgetArea > : EnumConverter<Qt::DockWidgetArea >
{
};
template<>
struct Converter<QFlags<Qt::DockWidgetArea> > : EnumConverter<QFlags<Qt::DockWidgetArea> >
{
};

template<>
struct Converter<Qt::UIEffect > : EnumConverter<Qt::UIEffect >
{
};

template<>
struct Converter<Qt::Initialization > : EnumConverter<Qt::Initialization >
{
};

template<>
struct Converter<Qt::AnchorPoint > : EnumConverter<Qt::AnchorPoint >
{
};

template<>
struct Converter<Qt::GlobalColor > : EnumConverter<Qt::GlobalColor >
{
};

template<>
struct Converter<Qt::KeyboardModifier > : EnumConverter<Qt::KeyboardModifier >
{
};
template<>
struct Converter<QFlags<Qt::KeyboardModifier> > : EnumConverter<QFlags<Qt::KeyboardModifier> >
{
};

template<>
struct Converter<Qt::NavigationMode > : EnumConverter<Qt::NavigationMode >
{
};

template<>
struct Converter<Qt::ItemDataRole > : EnumConverter<Qt::ItemDataRole >
{
};

template<>
struct Converter<Qt::ScrollBarPolicy > : EnumConverter<Qt::ScrollBarPolicy >
{
};

template<>
struct Converter<Qt::InputMethodHint > : EnumConverter<Qt::InputMethodHint >
{
};
template<>
struct Converter<QFlags<Qt::InputMethodHint> > : EnumConverter<QFlags<Qt::InputMethodHint> >
{
};

template<>
struct Converter<Qt::AnchorAttribute > : EnumConverter<Qt::AnchorAttribute >
{
};

template<>
struct Converter<Qt::WindowModality > : EnumConverter<Qt::WindowModality >
{
};

template<>
struct Converter<Qt::SortOrder > : EnumConverter<Qt::SortOrder >
{
};

template<>
struct Converter<Qt::PenStyle > : EnumConverter<Qt::PenStyle >
{
};

template<>
struct Converter<Qt::ItemFlag > : EnumConverter<Qt::ItemFlag >
{
};
template<>
struct Converter<QFlags<Qt::ItemFlag> > : EnumConverter<QFlags<Qt::ItemFlag> >
{
};

template<>
struct Converter<Qt::Axis > : EnumConverter<Qt::Axis >
{
};

template<>
struct Converter<Qt::TransformationMode > : EnumConverter<Qt::TransformationMode >
{
};

template<>
struct Converter<Qt::WindowFrameSection > : EnumConverter<Qt::WindowFrameSection >
{
};

template<>
struct Converter<Qt::HitTestAccuracy > : EnumConverter<Qt::HitTestAccuracy >
{
};

template<>
struct Converter<Qt::CursorShape > : EnumConverter<Qt::CursorShape >
{
};

template<>
struct Converter<Qt::ItemSelectionMode > : EnumConverter<Qt::ItemSelectionMode >
{
};

template<>
struct Converter<Qt::Orientation > : EnumConverter<Qt::Orientation >
{
};
template<>
struct Converter<QFlags<Qt::Orientation> > : EnumConverter<QFlags<Qt::Orientation> >
{
};

template<>
struct Converter<Qt::InputMethodQuery > : EnumConverter<Qt::InputMethodQuery >
{
};

template<>
struct Converter<Qt::TimeSpec > : EnumConverter<Qt::TimeSpec >
{
};

template<>
struct Converter<Qt::ArrowType > : EnumConverter<Qt::ArrowType >
{
};

template<>
struct Converter<Qt::FillRule > : EnumConverter<Qt::FillRule >
{
};

template<>
struct Converter<Qt::MaskMode > : EnumConverter<Qt::MaskMode >
{
};

template<>
struct Converter<Qt::WindowState > : EnumConverter<Qt::WindowState >
{
};
template<>
struct Converter<QFlags<Qt::WindowState> > : EnumConverter<QFlags<Qt::WindowState> >
{
};

template<>
struct Converter<Qt::ToolBarAreaSizes > : EnumConverter<Qt::ToolBarAreaSizes >
{
};

template<>
struct Converter<Qt::Corner > : EnumConverter<Qt::Corner >
{
};

template<>
struct Converter<Qt::DayOfWeek > : EnumConverter<Qt::DayOfWeek >
{
};

template<>
struct Converter<Qt::ClipOperation > : EnumConverter<Qt::ClipOperation >
{
};

template<>
struct Converter<Qt::LayoutDirection > : EnumConverter<Qt::LayoutDirection >
{
};

template<>
struct Converter<Qt::ToolButtonStyle > : EnumConverter<Qt::ToolButtonStyle >
{
};

template<>
struct Converter<Qt::DockWidgetAreaSizes > : EnumConverter<Qt::DockWidgetAreaSizes >
{
};

template<>
struct Converter<Qt::Key > : EnumConverter<Qt::Key >
{
};

template<>
struct Converter<Qt::ApplicationAttribute > : EnumConverter<Qt::ApplicationAttribute >
{
};

template<>
struct Converter<Qt::TextFlag > : EnumConverter<Qt::TextFlag >
{
};

template<>
struct Converter<Qt::BrushStyle > : EnumConverter<Qt::BrushStyle >
{
};

template<>
struct Converter<Qt::WidgetAttribute > : EnumConverter<Qt::WidgetAttribute >
{
};

template<>
struct Converter<Qt::TouchPointState > : EnumConverter<Qt::TouchPointState >
{
};

template<>
struct Converter<Qt::TextInteractionFlag > : EnumConverter<Qt::TextInteractionFlag >
{
};
template<>
struct Converter<QFlags<Qt::TextInteractionFlag> > : EnumConverter<QFlags<Qt::TextInteractionFlag> >
{
};

template<>
struct Converter<Qt::MouseButton > : EnumConverter<Qt::MouseButton >
{
};
template<>
struct Converter<QFlags<Qt::MouseButton> > : EnumConverter<QFlags<Qt::MouseButton> >
{
};

template<>
struct Converter<Qt::MatchFlag > : EnumConverter<Qt::MatchFlag >
{
};
template<>
struct Converter<QFlags<Qt::MatchFlag> > : EnumConverter<QFlags<Qt::MatchFlag> >
{
};

template<>
struct Converter<Qt::PenCapStyle > : EnumConverter<Qt::PenCapStyle >
{
};

template<>
struct Converter<Qt::TextElideMode > : EnumConverter<Qt::TextElideMode >
{
};

template<>
struct Converter<QXmlStreamEntityDeclaration > : ValueTypeConverter<QXmlStreamEntityDeclaration >
{
};

template<>
struct Converter<QMetaEnum > : ValueTypeConverter<QMetaEnum >
{
};

template<>
struct Converter<QRegExp::PatternSyntax > : EnumConverter<QRegExp::PatternSyntax >
{
};

template<>
struct Converter<QRegExp::CaretMode > : EnumConverter<QRegExp::CaretMode >
{
};

template<>
struct Converter<QRegExp > : ValueTypeConverter<QRegExp >
{
};

template<>
struct Converter<QModelIndex > : ValueTypeConverter<QModelIndex >
{
};

template<>
struct Converter<QXmlStreamNotationDeclaration > : ValueTypeConverter<QXmlStreamNotationDeclaration >
{
};

template<>
struct Converter<QFactoryInterface* > : ObjectTypeConverter<QFactoryInterface >
{
};

template<>
struct Converter<QFactoryInterface& > : ObjectTypeReferenceConverter<QFactoryInterface >
{
};

template<>
struct Converter<QXmlStreamNamespaceDeclaration > : ValueTypeConverter<QXmlStreamNamespaceDeclaration >
{
};

template<>
struct Converter<QSemaphore* > : ObjectTypeConverter<QSemaphore >
{
};

template<>
struct Converter<QSemaphore& > : ObjectTypeReferenceConverter<QSemaphore >
{
};

template<>
struct Converter<QBitArray > : ValueTypeConverter<QBitArray >
{
};

template<>
struct Converter<QAbstractFileEngineHandler* > : ObjectTypeConverter<QAbstractFileEngineHandler >
{
};

template<>
struct Converter<QAbstractFileEngineHandler& > : ObjectTypeReferenceConverter<QAbstractFileEngineHandler >
{
};

template<>
struct Converter<QGenericArgument > : ValueTypeConverter<QGenericArgument >
{
};

template<>
struct Converter<QStringList >
{
    static QStringList toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
    static inline PyObject* toPython(void* cppObj) { return toPython(*reinterpret_cast<QStringList* >(cppObj)); }
    static PyObject* toPython(const QStringList& cppObj);
};

template<>
struct Converter<QPointF > : ValueTypeConverter<QPointF >
{
    static QPointF toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QMutex::RecursionMode > : EnumConverter<QMutex::RecursionMode >
{
};

template<>
struct Converter<QMutex* > : ObjectTypeConverter<QMutex >
{
};

template<>
struct Converter<QMutex& > : ObjectTypeReferenceConverter<QMutex >
{
};

template<>
struct Converter<QVariant::Type > : EnumConverter<QVariant::Type >
{
};

template<>
struct Converter<QVariant >
{
    static QVariant toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
    static inline PyObject* toPython(void* cppObj) { return toPython(*reinterpret_cast<QVariant* >(cppObj)); }
    static PyObject* toPython(const QVariant& cppObj);
};

template<>
struct Converter<QObject* > : ObjectTypeConverter<QObject >
{
};

template<>
struct Converter<QObject& > : ObjectTypeReferenceConverter<QObject >
{
};

template<>
struct Converter<QFileSystemWatcher* > : ObjectTypeConverter<QFileSystemWatcher >
{
};

template<>
struct Converter<QFileSystemWatcher& > : ObjectTypeReferenceConverter<QFileSystemWatcher >
{
};

template<>
struct Converter<QAbstractEventDispatcher* > : ObjectTypeConverter<QAbstractEventDispatcher >
{
};

template<>
struct Converter<QAbstractEventDispatcher& > : ObjectTypeReferenceConverter<QAbstractEventDispatcher >
{
};

template<>
struct Converter<QAbstractAnimation::Direction > : EnumConverter<QAbstractAnimation::Direction >
{
};

template<>
struct Converter<QAbstractAnimation::DeletionPolicy > : EnumConverter<QAbstractAnimation::DeletionPolicy >
{
};

template<>
struct Converter<QAbstractAnimation::State > : EnumConverter<QAbstractAnimation::State >
{
};

template<>
struct Converter<QAbstractAnimation* > : ObjectTypeConverter<QAbstractAnimation >
{
};

template<>
struct Converter<QAbstractAnimation& > : ObjectTypeReferenceConverter<QAbstractAnimation >
{
};

template<>
struct Converter<QVariantAnimation* > : ObjectTypeConverter<QVariantAnimation >
{
};

template<>
struct Converter<QVariantAnimation& > : ObjectTypeReferenceConverter<QVariantAnimation >
{
};

template<>
struct Converter<QPauseAnimation* > : ObjectTypeConverter<QPauseAnimation >
{
};

template<>
struct Converter<QPauseAnimation& > : ObjectTypeReferenceConverter<QPauseAnimation >
{
};

template<>
struct Converter<QSignalMapper* > : ObjectTypeConverter<QSignalMapper >
{
};

template<>
struct Converter<QSignalMapper& > : ObjectTypeReferenceConverter<QSignalMapper >
{
};

template<>
struct Converter<QUuid::Variant > : EnumConverter<QUuid::Variant >
{
};

template<>
struct Converter<QUuid::Version > : EnumConverter<QUuid::Version >
{
};

template<>
struct Converter<QUuid > : ValueTypeConverter<QUuid >
{
    static QUuid toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QRect > : ValueTypeConverter<QRect >
{
};

template<>
struct Converter<QFileInfo > : ValueTypeConverter<QFileInfo >
{
    static QFileInfo toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QAbstractTransition* > : ObjectTypeConverter<QAbstractTransition >
{
};

template<>
struct Converter<QAbstractTransition& > : ObjectTypeReferenceConverter<QAbstractTransition >
{
};

template<>
struct Converter<QAbstractFileEngineIterator* > : ObjectTypeConverter<QAbstractFileEngineIterator >
{
};

template<>
struct Converter<QAbstractFileEngineIterator& > : ObjectTypeReferenceConverter<QAbstractFileEngineIterator >
{
};

template<>
struct Converter<QEventTransition* > : ObjectTypeConverter<QEventTransition >
{
};

template<>
struct Converter<QEventTransition& > : ObjectTypeReferenceConverter<QEventTransition >
{
};

template<>
struct Converter<QAbstractFileEngine::FileName > : EnumConverter<QAbstractFileEngine::FileName >
{
};

template<>
struct Converter<QAbstractFileEngine::FileTime > : EnumConverter<QAbstractFileEngine::FileTime >
{
};

template<>
struct Converter<QAbstractFileEngine::FileOwner > : EnumConverter<QAbstractFileEngine::FileOwner >
{
};

template<>
struct Converter<QAbstractFileEngine::Extension > : EnumConverter<QAbstractFileEngine::Extension >
{
};

template<>
struct Converter<QAbstractFileEngine::FileFlag > : EnumConverter<QAbstractFileEngine::FileFlag >
{
};
template<>
struct Converter<QFlags<QAbstractFileEngine::FileFlag> > : EnumConverter<QFlags<QAbstractFileEngine::FileFlag> >
{
};

template<>
struct Converter<QAbstractFileEngine* > : ObjectTypeConverter<QAbstractFileEngine >
{
};

template<>
struct Converter<QAbstractFileEngine& > : ObjectTypeReferenceConverter<QAbstractFileEngine >
{
};

template<>
struct Converter<QSystemLocale::QueryType > : EnumConverter<QSystemLocale::QueryType >
{
};

template<>
struct Converter<QSystemLocale* > : ObjectTypeConverter<QSystemLocale >
{
};

template<>
struct Converter<QSystemLocale& > : ObjectTypeReferenceConverter<QSystemLocale >
{
};

template<>
struct Converter<QSysInfo::Endian > : EnumConverter<QSysInfo::Endian >
{
};

template<>
struct Converter<QSysInfo::Sizes > : EnumConverter<QSysInfo::Sizes >
{
};

template<>
struct Converter<QSysInfo* > : ObjectTypeConverter<QSysInfo >
{
};

template<>
struct Converter<QSysInfo& > : ObjectTypeReferenceConverter<QSysInfo >
{
};

template<>
struct Converter<QByteArray > : ValueTypeConverter<QByteArray >
{
    static QByteArray toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QXmlStreamAttributes > : ValueTypeConverter<QXmlStreamAttributes >
{
};

template<>
struct Converter<QByteArrayMatcher > : ValueTypeConverter<QByteArrayMatcher >
{
};

template<>
struct Converter<QGenericReturnArgument > : ValueTypeConverter<QGenericReturnArgument >
{
};

template<>
struct Converter<QSignalTransition* > : ObjectTypeConverter<QSignalTransition >
{
};

template<>
struct Converter<QSignalTransition& > : ObjectTypeReferenceConverter<QSignalTransition >
{
};

template<>
struct Converter<QEvent::Type > : EnumConverter<QEvent::Type >
{
};

template<>
struct Converter<QEvent* > : ObjectTypeConverter<QEvent >
{
};

template<>
struct Converter<QEvent& > : ObjectTypeReferenceConverter<QEvent >
{
};

template<>
struct Converter<QDynamicPropertyChangeEvent* > : ObjectTypeConverter<QDynamicPropertyChangeEvent >
{
};

template<>
struct Converter<QDynamicPropertyChangeEvent& > : ObjectTypeReferenceConverter<QDynamicPropertyChangeEvent >
{
};

template<>
struct Converter<QChildEvent* > : ObjectTypeConverter<QChildEvent >
{
};

template<>
struct Converter<QChildEvent& > : ObjectTypeReferenceConverter<QChildEvent >
{
};

template<>
struct Converter<QMetaObject::Call > : EnumConverter<QMetaObject::Call >
{
};

template<>
struct Converter<QMetaObject* > : ObjectTypeConverter<QMetaObject >
{
};

template<>
struct Converter<QMetaObject& > : ObjectTypeReferenceConverter<QMetaObject >
{
};

template<>
struct Converter<QXmlStreamAttribute > : ValueTypeConverter<QXmlStreamAttribute >
{
};

template<>
struct Converter<QDataStream::FloatingPointPrecision > : EnumConverter<QDataStream::FloatingPointPrecision >
{
};

template<>
struct Converter<QDataStream::Version > : EnumConverter<QDataStream::Version >
{
};

template<>
struct Converter<QDataStream::Status > : EnumConverter<QDataStream::Status >
{
};

template<>
struct Converter<QDataStream* > : ObjectTypeConverter<QDataStream >
{
};

template<>
struct Converter<QDataStream& > : ObjectTypeReferenceConverter<QDataStream >
{
};

template<>
struct Converter<QLatin1Char > : ValueTypeConverter<QLatin1Char >
{
};

template<>
struct Converter<QBasicTimer > : ValueTypeConverter<QBasicTimer >
{
};

template<>
struct Converter<QReadLocker* > : ObjectTypeConverter<QReadLocker >
{
};

template<>
struct Converter<QReadLocker& > : ObjectTypeReferenceConverter<QReadLocker >
{
};

template<>
struct Converter<QXmlStreamEntityResolver* > : ObjectTypeConverter<QXmlStreamEntityResolver >
{
};

template<>
struct Converter<QXmlStreamEntityResolver& > : ObjectTypeReferenceConverter<QXmlStreamEntityResolver >
{
};

template<>
struct Converter<QStringMatcher > : ValueTypeConverter<QStringMatcher >
{
    static QStringMatcher toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QDate::MonthNameType > : EnumConverter<QDate::MonthNameType >
{
};

template<>
struct Converter<QDate > : ValueTypeConverter<QDate >
{
};

template<>
struct Converter<QRectF > : ValueTypeConverter<QRectF >
{
    static QRectF toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QSize > : ValueTypeConverter<QSize >
{
};

template<>
struct Converter<QTextStreamManipulator > : ValueTypeConverter<QTextStreamManipulator >
{
};

template<>
struct Converter<QTimer* > : ObjectTypeConverter<QTimer >
{
};

template<>
struct Converter<QTimer& > : ObjectTypeReferenceConverter<QTimer >
{
};

template<>
struct Converter<QTextBoundaryFinder::BoundaryReason > : EnumConverter<QTextBoundaryFinder::BoundaryReason >
{
};
template<>
struct Converter<QFlags<QTextBoundaryFinder::BoundaryReason> > : EnumConverter<QFlags<QTextBoundaryFinder::BoundaryReason> >
{
};

template<>
struct Converter<QTextBoundaryFinder::BoundaryType > : EnumConverter<QTextBoundaryFinder::BoundaryType >
{
};

template<>
struct Converter<QTextBoundaryFinder > : ValueTypeConverter<QTextBoundaryFinder >
{
};

template<>
struct Converter<QTextEncoder* > : ObjectTypeConverter<QTextEncoder >
{
};

template<>
struct Converter<QTextEncoder& > : ObjectTypeReferenceConverter<QTextEncoder >
{
};

template<>
struct Converter<QAbstractItemModel* > : ObjectTypeConverter<QAbstractItemModel >
{
};

template<>
struct Converter<QAbstractItemModel& > : ObjectTypeReferenceConverter<QAbstractItemModel >
{
};

template<>
struct Converter<QAbstractListModel* > : ObjectTypeConverter<QAbstractListModel >
{
};

template<>
struct Converter<QAbstractListModel& > : ObjectTypeReferenceConverter<QAbstractListModel >
{
};

template<>
struct Converter<QAbstractTableModel* > : ObjectTypeConverter<QAbstractTableModel >
{
};

template<>
struct Converter<QAbstractTableModel& > : ObjectTypeReferenceConverter<QAbstractTableModel >
{
};

template<>
struct Converter<QMetaClassInfo > : ValueTypeConverter<QMetaClassInfo >
{
};

template<>
struct Converter<QEasingCurve::Type > : EnumConverter<QEasingCurve::Type >
{
};

template<>
struct Converter<QEasingCurve > : ValueTypeConverter<QEasingCurve >
{
    static QEasingCurve toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QLine > : ValueTypeConverter<QLine >
{
};

template<>
struct Converter<QMargins > : ValueTypeConverter<QMargins >
{
};

template<>
struct Converter<QCryptographicHash::Algorithm > : EnumConverter<QCryptographicHash::Algorithm >
{
};

template<>
struct Converter<QCryptographicHash* > : ObjectTypeConverter<QCryptographicHash >
{
};

template<>
struct Converter<QCryptographicHash& > : ObjectTypeReferenceConverter<QCryptographicHash >
{
};

template<>
struct Converter<QTextCodec::ConversionFlag > : EnumConverter<QTextCodec::ConversionFlag >
{
};
template<>
struct Converter<QFlags<QTextCodec::ConversionFlag> > : EnumConverter<QFlags<QTextCodec::ConversionFlag> >
{
};

template<>
struct Converter<QTextCodec* > : ObjectTypeConverter<QTextCodec >
{
};

template<>
struct Converter<QTextCodec& > : ObjectTypeReferenceConverter<QTextCodec >
{
};

template<>
struct Converter<QTextCodec::ConverterState* > : ObjectTypeConverter<QTextCodec::ConverterState >
{
};

template<>
struct Converter<QTextCodec::ConverterState& > : ObjectTypeReferenceConverter<QTextCodec::ConverterState >
{
};

template<>
struct Converter<QMetaProperty > : ValueTypeConverter<QMetaProperty >
{
};

template<>
struct Converter<QTime > : ValueTypeConverter<QTime >
{
};

template<>
struct Converter<QIODevice::OpenModeFlag > : EnumConverter<QIODevice::OpenModeFlag >
{
};
template<>
struct Converter<QFlags<QIODevice::OpenModeFlag> > : EnumConverter<QFlags<QIODevice::OpenModeFlag> >
{
};

template<>
struct Converter<QIODevice* > : ObjectTypeConverter<QIODevice >
{
};

template<>
struct Converter<QIODevice& > : ObjectTypeReferenceConverter<QIODevice >
{
};

template<>
struct Converter<QFile::FileError > : EnumConverter<QFile::FileError >
{
};

template<>
struct Converter<QFile::MemoryMapFlags > : EnumConverter<QFile::MemoryMapFlags >
{
};

template<>
struct Converter<QFile::Permission > : EnumConverter<QFile::Permission >
{
};
template<>
struct Converter<QFlags<QFile::Permission> > : EnumConverter<QFlags<QFile::Permission> >
{
};

template<>
struct Converter<QFile* > : ObjectTypeConverter<QFile >
{
};

template<>
struct Converter<QFile& > : ObjectTypeReferenceConverter<QFile >
{
};

template<>
struct Converter<QProcess::ProcessError > : EnumConverter<QProcess::ProcessError >
{
};

template<>
struct Converter<QProcess::ProcessChannelMode > : EnumConverter<QProcess::ProcessChannelMode >
{
};

template<>
struct Converter<QProcess::ProcessChannel > : EnumConverter<QProcess::ProcessChannel >
{
};

template<>
struct Converter<QProcess::ProcessState > : EnumConverter<QProcess::ProcessState >
{
};

template<>
struct Converter<QProcess::ExitStatus > : EnumConverter<QProcess::ExitStatus >
{
};

template<>
struct Converter<QProcess* > : ObjectTypeConverter<QProcess >
{
};

template<>
struct Converter<QProcess& > : ObjectTypeReferenceConverter<QProcess >
{
};

template<>
struct Converter<QBuffer* > : ObjectTypeConverter<QBuffer >
{
};

template<>
struct Converter<QBuffer& > : ObjectTypeReferenceConverter<QBuffer >
{
};

template<>
struct Converter<QSystemSemaphore::AccessMode > : EnumConverter<QSystemSemaphore::AccessMode >
{
};

template<>
struct Converter<QSystemSemaphore::SystemSemaphoreError > : EnumConverter<QSystemSemaphore::SystemSemaphoreError >
{
};

template<>
struct Converter<QSystemSemaphore* > : ObjectTypeConverter<QSystemSemaphore >
{
};

template<>
struct Converter<QSystemSemaphore& > : ObjectTypeReferenceConverter<QSystemSemaphore >
{
};

template<>
struct Converter<QTextStream::RealNumberNotation > : EnumConverter<QTextStream::RealNumberNotation >
{
};

template<>
struct Converter<QTextStream::NumberFlag > : EnumConverter<QTextStream::NumberFlag >
{
};
template<>
struct Converter<QFlags<QTextStream::NumberFlag> > : EnumConverter<QFlags<QTextStream::NumberFlag> >
{
};

template<>
struct Converter<QTextStream::FieldAlignment > : EnumConverter<QTextStream::FieldAlignment >
{
};

template<>
struct Converter<QTextStream::Status > : EnumConverter<QTextStream::Status >
{
};

template<>
struct Converter<QTextStream* > : ObjectTypeConverter<QTextStream >
{
};

template<>
struct Converter<QTextStream& > : ObjectTypeReferenceConverter<QTextStream >
{
};

template<>
struct Converter<QPoint > : ValueTypeConverter<QPoint >
{
};

template<>
struct Converter<QMutexLocker* > : ObjectTypeConverter<QMutexLocker >
{
};

template<>
struct Converter<QMutexLocker& > : ObjectTypeReferenceConverter<QMutexLocker >
{
};

template<>
struct Converter<QLibraryInfo::LibraryLocation > : EnumConverter<QLibraryInfo::LibraryLocation >
{
};

template<>
struct Converter<QLibraryInfo* > : ObjectTypeConverter<QLibraryInfo >
{
};

template<>
struct Converter<QLibraryInfo& > : ObjectTypeReferenceConverter<QLibraryInfo >
{
};

template<>
struct Converter<QPersistentModelIndex > : ValueTypeConverter<QPersistentModelIndex >
{
    static QPersistentModelIndex toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QLocale::MeasurementSystem > : EnumConverter<QLocale::MeasurementSystem >
{
};

template<>
struct Converter<QLocale::NumberOption > : EnumConverter<QLocale::NumberOption >
{
};
template<>
struct Converter<QFlags<QLocale::NumberOption> > : EnumConverter<QFlags<QLocale::NumberOption> >
{
};

template<>
struct Converter<QLocale::FormatType > : EnumConverter<QLocale::FormatType >
{
};

template<>
struct Converter<QLocale::Country > : EnumConverter<QLocale::Country >
{
};

template<>
struct Converter<QLocale::Language > : EnumConverter<QLocale::Language >
{
};

template<>
struct Converter<QLocale > : ValueTypeConverter<QLocale >
{
    static QLocale toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QAnimationGroup* > : ObjectTypeConverter<QAnimationGroup >
{
};

template<>
struct Converter<QAnimationGroup& > : ObjectTypeReferenceConverter<QAnimationGroup >
{
};

template<>
struct Converter<QParallelAnimationGroup* > : ObjectTypeConverter<QParallelAnimationGroup >
{
};

template<>
struct Converter<QParallelAnimationGroup& > : ObjectTypeReferenceConverter<QParallelAnimationGroup >
{
};

template<>
struct Converter<QSequentialAnimationGroup* > : ObjectTypeConverter<QSequentialAnimationGroup >
{
};

template<>
struct Converter<QSequentialAnimationGroup& > : ObjectTypeReferenceConverter<QSequentialAnimationGroup >
{
};

template<>
struct Converter<QAbstractState* > : ObjectTypeConverter<QAbstractState >
{
};

template<>
struct Converter<QAbstractState& > : ObjectTypeReferenceConverter<QAbstractState >
{
};

template<>
struct Converter<QFinalState* > : ObjectTypeConverter<QFinalState >
{
};

template<>
struct Converter<QFinalState& > : ObjectTypeReferenceConverter<QFinalState >
{
};

template<>
struct Converter<QSocketNotifier::Type > : EnumConverter<QSocketNotifier::Type >
{
};

template<>
struct Converter<QSocketNotifier* > : ObjectTypeConverter<QSocketNotifier >
{
};

template<>
struct Converter<QSocketNotifier& > : ObjectTypeReferenceConverter<QSocketNotifier >
{
};

template<>
struct Converter<QUrl::ParsingMode > : EnumConverter<QUrl::ParsingMode >
{
};

template<>
struct Converter<QUrl::FormattingOption > : EnumConverter<QUrl::FormattingOption >
{
};
template<>
struct Converter<QFlags<QUrl::FormattingOption> > : EnumConverter<QFlags<QUrl::FormattingOption> >
{
};

template<>
struct Converter<QUrl > : ValueTypeConverter<QUrl >
{
    static QUrl toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QChar::Joining > : EnumConverter<QChar::Joining >
{
};

template<>
struct Converter<QChar::SpecialCharacter > : EnumConverter<QChar::SpecialCharacter >
{
};

template<>
struct Converter<QChar::UnicodeVersion > : EnumConverter<QChar::UnicodeVersion >
{
};

template<>
struct Converter<QChar::Direction > : EnumConverter<QChar::Direction >
{
};

template<>
struct Converter<QChar::Category > : EnumConverter<QChar::Category >
{
};

template<>
struct Converter<QChar::CombiningClass > : EnumConverter<QChar::CombiningClass >
{
};

template<>
struct Converter<QChar::Decomposition > : EnumConverter<QChar::Decomposition >
{
};

template<>
struct Converter<QChar >
{
    static QChar toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
    static inline PyObject* toPython(void* cppObj) { return toPython(*reinterpret_cast<QChar* >(cppObj)); }
    static PyObject* toPython(const QChar& cppObj);
};

template<>
struct Converter<QWriteLocker* > : ObjectTypeConverter<QWriteLocker >
{
};

template<>
struct Converter<QWriteLocker& > : ObjectTypeReferenceConverter<QWriteLocker >
{
};

template<>
struct Converter<QLineF::IntersectType > : EnumConverter<QLineF::IntersectType >
{
};

template<>
struct Converter<QLineF > : ValueTypeConverter<QLineF >
{
    static QLineF toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QThread::Priority > : EnumConverter<QThread::Priority >
{
};

template<>
struct Converter<QThread* > : ObjectTypeConverter<QThread >
{
};

template<>
struct Converter<QThread& > : ObjectTypeReferenceConverter<QThread >
{
};

template<>
struct Converter<QTimeLine::Direction > : EnumConverter<QTimeLine::Direction >
{
};

template<>
struct Converter<QTimeLine::CurveShape > : EnumConverter<QTimeLine::CurveShape >
{
};

template<>
struct Converter<QTimeLine::State > : EnumConverter<QTimeLine::State >
{
};

template<>
struct Converter<QTimeLine* > : ObjectTypeConverter<QTimeLine >
{
};

template<>
struct Converter<QTimeLine& > : ObjectTypeReferenceConverter<QTimeLine >
{
};

template<>
struct Converter<QLatin1String > : ValueTypeConverter<QLatin1String >
{
};

template<>
struct Converter<QMimeData* > : ObjectTypeConverter<QMimeData >
{
};

template<>
struct Converter<QMimeData& > : ObjectTypeReferenceConverter<QMimeData >
{
};

template<>
struct Converter<QDateTime > : ValueTypeConverter<QDateTime >
{
};

template<>
struct Converter<QStringRef > : ValueTypeConverter<QStringRef >
{
};

template<>
struct Converter<QEventLoop::ProcessEventsFlag > : EnumConverter<QEventLoop::ProcessEventsFlag >
{
};
template<>
struct Converter<QFlags<QEventLoop::ProcessEventsFlag> > : EnumConverter<QFlags<QEventLoop::ProcessEventsFlag> >
{
};

template<>
struct Converter<QEventLoop* > : ObjectTypeConverter<QEventLoop >
{
};

template<>
struct Converter<QEventLoop& > : ObjectTypeReferenceConverter<QEventLoop >
{
};

template<>
struct Converter<QCoreApplication::Encoding > : EnumConverter<QCoreApplication::Encoding >
{
};

template<>
struct Converter<QCoreApplication* > : ObjectTypeConverter<QCoreApplication >
{
};

template<>
struct Converter<QCoreApplication& > : ObjectTypeReferenceConverter<QCoreApplication >
{
};

template<>
struct Converter<QHistoryState::HistoryType > : EnumConverter<QHistoryState::HistoryType >
{
};

template<>
struct Converter<QHistoryState* > : ObjectTypeConverter<QHistoryState >
{
};

template<>
struct Converter<QHistoryState& > : ObjectTypeReferenceConverter<QHistoryState >
{
};

template<>
struct Converter<QSizeF > : ValueTypeConverter<QSizeF >
{
    static QSizeF toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QTemporaryFile* > : ObjectTypeConverter<QTemporaryFile >
{
};

template<>
struct Converter<QTemporaryFile& > : ObjectTypeReferenceConverter<QTemporaryFile >
{
};

template<>
struct Converter<QWaitCondition* > : ObjectTypeConverter<QWaitCondition >
{
};

template<>
struct Converter<QWaitCondition& > : ObjectTypeReferenceConverter<QWaitCondition >
{
};

template<>
struct Converter<QPropertyAnimation* > : ObjectTypeConverter<QPropertyAnimation >
{
};

template<>
struct Converter<QPropertyAnimation& > : ObjectTypeReferenceConverter<QPropertyAnimation >
{
};

template<>
struct Converter<QString::SplitBehavior > : EnumConverter<QString::SplitBehavior >
{
};

template<>
struct Converter<QString::NormalizationForm > : EnumConverter<QString::NormalizationForm >
{
};

template<>
struct Converter<QString::SectionFlag > : EnumConverter<QString::SectionFlag >
{
};

template<>
struct Converter<QString >
{
    static QString toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
    static inline PyObject* toPython(void* cppObj) { return toPython(*reinterpret_cast<QString* >(cppObj)); }
    static PyObject* toPython(const QString& cppObj);
};

template<>
struct Converter<QXmlStreamWriter* > : ObjectTypeConverter<QXmlStreamWriter >
{
};

template<>
struct Converter<QXmlStreamWriter& > : ObjectTypeReferenceConverter<QXmlStreamWriter >
{
};

template<>
struct Converter<QDir::Filter > : EnumConverter<QDir::Filter >
{
};
template<>
struct Converter<QFlags<QDir::Filter> > : EnumConverter<QFlags<QDir::Filter> >
{
};

template<>
struct Converter<QDir::SortFlag > : EnumConverter<QDir::SortFlag >
{
};
template<>
struct Converter<QFlags<QDir::SortFlag> > : EnumConverter<QFlags<QDir::SortFlag> >
{
};

template<>
struct Converter<QDir > : ValueTypeConverter<QDir >
{
    static QDir toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QDirIterator::IteratorFlag > : EnumConverter<QDirIterator::IteratorFlag >
{
};
template<>
struct Converter<QFlags<QDirIterator::IteratorFlag> > : EnumConverter<QFlags<QDirIterator::IteratorFlag> >
{
};

template<>
struct Converter<QDirIterator* > : ObjectTypeConverter<QDirIterator >
{
};

template<>
struct Converter<QDirIterator& > : ObjectTypeReferenceConverter<QDirIterator >
{
};

template<>
struct Converter<QResource* > : ObjectTypeConverter<QResource >
{
};

template<>
struct Converter<QResource& > : ObjectTypeReferenceConverter<QResource >
{
};

template<>
struct Converter<QFSFileEngine* > : ObjectTypeConverter<QFSFileEngine >
{
};

template<>
struct Converter<QFSFileEngine& > : ObjectTypeReferenceConverter<QFSFileEngine >
{
};

template<>
struct Converter<QTranslator* > : ObjectTypeConverter<QTranslator >
{
};

template<>
struct Converter<QTranslator& > : ObjectTypeReferenceConverter<QTranslator >
{
};

template<>
struct Converter<QXmlStreamReader::Error > : EnumConverter<QXmlStreamReader::Error >
{
};

template<>
struct Converter<QXmlStreamReader::TokenType > : EnumConverter<QXmlStreamReader::TokenType >
{
};

template<>
struct Converter<QXmlStreamReader::ReadElementTextBehaviour > : EnumConverter<QXmlStreamReader::ReadElementTextBehaviour >
{
};

template<>
struct Converter<QXmlStreamReader* > : ObjectTypeConverter<QXmlStreamReader >
{
};

template<>
struct Converter<QXmlStreamReader& > : ObjectTypeReferenceConverter<QXmlStreamReader >
{
};

template<>
struct Converter<QProcessEnvironment > : ValueTypeConverter<QProcessEnvironment >
{
};

template<>
struct Converter<QSettings::Format > : EnumConverter<QSettings::Format >
{
};

template<>
struct Converter<QSettings::Status > : EnumConverter<QSettings::Status >
{
};

template<>
struct Converter<QSettings::Scope > : EnumConverter<QSettings::Scope >
{
};

template<>
struct Converter<QSettings* > : ObjectTypeConverter<QSettings >
{
};

template<>
struct Converter<QSettings& > : ObjectTypeReferenceConverter<QSettings >
{
};

template<>
struct Converter<QTimerEvent* > : ObjectTypeConverter<QTimerEvent >
{
};

template<>
struct Converter<QTimerEvent& > : ObjectTypeReferenceConverter<QTimerEvent >
{
};

template<>
struct Converter<QReadWriteLock::RecursionMode > : EnumConverter<QReadWriteLock::RecursionMode >
{
};

template<>
struct Converter<QReadWriteLock* > : ObjectTypeConverter<QReadWriteLock >
{
};

template<>
struct Converter<QReadWriteLock& > : ObjectTypeReferenceConverter<QReadWriteLock >
{
};

template<>
struct Converter<QState::ChildMode > : EnumConverter<QState::ChildMode >
{
};

template<>
struct Converter<QState* > : ObjectTypeConverter<QState >
{
};

template<>
struct Converter<QState& > : ObjectTypeReferenceConverter<QState >
{
};

template<>
struct Converter<QStateMachine::Error > : EnumConverter<QStateMachine::Error >
{
};

template<>
struct Converter<QStateMachine::EventPriority > : EnumConverter<QStateMachine::EventPriority >
{
};

template<>
struct Converter<QStateMachine::RestorePolicy > : EnumConverter<QStateMachine::RestorePolicy >
{
};

template<>
struct Converter<QStateMachine* > : ObjectTypeConverter<QStateMachine >
{
};

template<>
struct Converter<QStateMachine& > : ObjectTypeReferenceConverter<QStateMachine >
{
};

template <>
struct SbkTypeInfo<QStateMachine::WrappedEvent >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QStateMachine::WrappedEvent > : ValueTypeConverter<QStateMachine::WrappedEvent >
{
};

template <>
struct SbkTypeInfo<QStateMachine::SignalEvent >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QStateMachine::SignalEvent > : ValueTypeConverter<QStateMachine::SignalEvent >
{
};

template<>
struct Converter<QTextDecoder* > : ObjectTypeConverter<QTextDecoder >
{
};

template<>
struct Converter<QTextDecoder& > : ObjectTypeReferenceConverter<QTextDecoder >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Conversion rule for: QList
namespace Shiboken {
template<typename T>
struct Converter<QList<T> > : StdListConverter<QList<T> > {};
}
// Conversion rule for: QString
namespace Shiboken {
inline bool Converter<QString>::isConvertible(PyObject* pyObj)
{
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QString>());
    return PyString_Check(pyObj)
            || PyObject_TypeCheck(pyObj, SbkType<QString>())
            || PyUnicode_Check(pyObj)
            || SbkQByteArray_Check(pyObj)
            || SbkQLatin1String_Check(pyObj)
            || pyObj == Py_None
#if PY_VERSION_HEX < 0x03000000
            || (pyObj->ob_type->tp_as_buffer
               && PyType_HasFeature(pyObj->ob_type, Py_TPFLAGS_HAVE_GETCHARBUFFER)
               && pyObj->ob_type->tp_as_buffer->bf_getcharbuffer)
#endif
            || SbkQChar_Check(pyObj)
            || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyObj));
}

inline QString Converter<QString>::toCpp(PyObject* pyObj)
{
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QString>());
    if (SbkQChar_Check(pyObj)) {
        return QString(Converter< QChar >::toCpp(pyObj));
    } else if (SbkQByteArray_Check(pyObj)) {
        return QString(Converter< QByteArray >::toCpp(pyObj));
    } else if (SbkQLatin1String_Check(pyObj)) {
        return QString(Converter< QLatin1String >::toCpp(pyObj));
    } else if (PyUnicode_Check(pyObj)) {
        Py_UNICODE* unicode = PyUnicode_AS_UNICODE(pyObj);
#if defined(Py_UNICODE_WIDE)
        // cast as Py_UNICODE can be a different type
        return QString::fromUcs4(reinterpret_cast<const uint*>(unicode));
#else
        return QString::fromUtf16(unicode, PyUnicode_GET_SIZE(pyObj));
#endif
    } else if (PyString_Check(pyObj)) {
        return QString(Converter< char * >::toCpp(pyObj));
    } else if (pyObj == Py_None) {
        return QString();
    }
#if PY_VERSION_HEX < 0x03000000
    // Support for buffer objects on QString constructor
    else if (pyObj->ob_type->tp_as_buffer
               && PyType_HasFeature(pyObj->ob_type, Py_TPFLAGS_HAVE_GETCHARBUFFER)
               && pyObj->ob_type->tp_as_buffer->bf_getcharbuffer) {
        QByteArray data;
        PyBufferProcs* bufferProcs = pyObj->ob_type->tp_as_buffer;
        int segments = bufferProcs->bf_getsegcount(pyObj, 0);
        for (int i = 0; i < segments; ++i) {
            char* segmentData;
            int length = bufferProcs->bf_getcharbuffer(pyObj, i, &segmentData);
            if (length == -1)
                break;
            data.append(segmentData, length);
        }
        return QString(data);
    }
#endif
    else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyObj)) {
        QString* cptr = reinterpret_cast<QString*>(shiboType->ext_tocpp(pyObj));
        std::auto_ptr<QString> cptr_auto_ptr(cptr);
        return *cptr;
    }
    return *Converter<QString*>::toCpp(pyObj);
}

inline PyObject* Converter<QString>::toPython(const QString& cppObj)
{
    return ValueTypeConverter<QString>::toPython(cppObj);
}
}
// Conversion rule for: QMap
namespace Shiboken {
template<typename KT, typename VT>
struct Converter<QMap<KT, VT> > : QtDictConverter<QMap<KT, VT> > {
};
}
// Conversion rule for: QMultiMap
namespace Shiboken {
template<typename KT, typename VT>
struct Converter<QMultiMap<KT, VT> > : QtMultiMapConverter<QMap<KT, VT> > {
};
}
// Conversion rule for: QVariant
// We use this thin wrapper instead of the plain PyObject pointer to avoid conflicts with specializations of T*
// in QVariant.
struct PyObjectHolder
{
    PyObject* m_me;
    PyObjectHolder(PyObject* me) : m_me(me) {}
    PyObjectHolder() : m_me(Py_None) {}
    operator PyObject*() { return m_me; }
};

/**
 * Q_DECLARE_METATYPE(PyObjectHolder);
 * Use the expanded version of Q_DECLARE_METATYPE macro to define a typename
 * compatible with PyQt4
 **/
QT_BEGIN_NAMESPACE
template <>
struct QMetaTypeId< PyObjectHolder >
{
    enum { Defined = 1 };
    static int qt_metatype_id()
    {
        static QBasicAtomicInt metatype_id = Q_BASIC_ATOMIC_INITIALIZER(0);
        if (!metatype_id)
            metatype_id =
                qRegisterMetaType<PyObjectHolder>("PyQt_PyObject");
        return metatype_id;
    }
};
QT_END_NAMESPACE

namespace Shiboken {

// all types are convertible to QVariant
inline bool Converter<QVariant>::isConvertible(PyObject* pyObj)
{
    return true;
}

inline QVariant Converter<QVariant>::toCpp(PyObject* pyObj)
{
    if (SbkQVariant_Check(pyObj))
        return *Converter<QVariant*>::toCpp(pyObj);

    // Primitive types
    if (PyBool_Check(pyObj)) {
        // QVariant(bool)
        return QVariant(Shiboken::Converter<bool>::toCpp(pyObj));
    } else if (PyString_CheckExact(pyObj)) {
        // QVariant(const char*)
        return QVariant(Shiboken::Converter<const char *>::toCpp(pyObj));
    } else if (PyFloat_CheckExact(pyObj)) {
        // QVariant(double)
        return QVariant(Shiboken::Converter<double>::toCpp(pyObj));
    } else if (PyInt_CheckExact(pyObj)) {
        // QVariant(int)
        return QVariant(Shiboken::Converter<int>::toCpp(pyObj));
    } else if (PyLong_CheckExact(pyObj)) {
        // QVariant(qlonglong)
        return QVariant(Shiboken::Converter<qlonglong>::toCpp(pyObj));
    } else if (Shiboken::isShibokenEnum(pyObj)) {
        // QVariant(enum)
        return QVariant(Shiboken::Converter<int>::toCpp(pyObj));
    } else if (!Shiboken::isShibokenType(pyObj) || Shiboken::isUserType(pyObj)) {
        // QVariant(User class)
        Py_INCREF(pyObj);
        return QVariant::fromValue<PyObjectHolder>(pyObj);
    } else {
        // a class supported by QVariant?
        const char* typeName = pyObj->ob_type->tp_name;
        // check if the name starts with PySide.
        if (!strncmp("PySide.", typeName, 7)) {
            // get the type name
            const char* lastDot = typeName;
            for (int i = 8; typeName[i]; ++i) {
                if (typeName[i] == '.')
                    lastDot = &typeName[i];
            }
            lastDot++;
            uint typeCode = QMetaType::type(lastDot);
            if (!typeCode) {// Try with star at end, for QObject*, QWidget* and QAbstractKinectScroller*
                QString typeName(lastDot);
                typeName += '*';
                typeCode = QMetaType::type(typeName.toAscii());
            }
            if (typeCode)
                return QVariant(typeCode, reinterpret_cast<SbkBaseWrapper*>(pyObj)->cptr[0]);
        }
        // Is a shiboken type not known by Qt
        Py_INCREF(pyObj);
        return QVariant::fromValue<PyObjectHolder>(pyObj);
    }
}

inline PyObject* Converter<QVariant>::toPython(const QVariant& cppObj)
{
    return ValueTypeConverter<QVariant>::toPython(cppObj);
}

}
// Conversion rule for: QVector
namespace Shiboken {
template<typename T>
struct Converter<QVector<T> > : StdListConverter<QVector<T> > {};
}
// Conversion rule for: QBool
namespace Shiboken {
template <>
struct Converter<QBool> : public ValueTypeConverter<QBool>
{
    using ValueTypeConverter<QBool>::toPython;

    static PyObject* toPython(const QBool& cppobj)
    {
        return PyBool_FromLong((bool) cppobj);
    }
    static QBool toCpp(PyObject* pyobj)
    {
        return QBool(pyobj == Py_True);
    }
};
}
// Conversion rule for: QPair
namespace Shiboken {
template<typename FT, typename ST>
struct Converter<QPair<FT, ST> > : StdPairConverter<QPair<FT, ST> > {};
}
// Conversion rule for: QHash
namespace Shiboken {
template<typename KT, typename VT>
struct Converter<QHash<KT, VT> > : QtDictConverter<QHash<KT, VT> > {};
}
// Conversion rule for: QSet
namespace Shiboken {
template<typename T>
struct Converter<QSet<T> > : QSequenceConverter<QSet<T> > {};
}
// Conversion rule for: QStringList
namespace Shiboken
{
inline bool Converter<QStringList>::isConvertible(PyObject* pyObj)
{
    return StdListConverter<QStringList>::isConvertible(pyObj);
}

inline QStringList Converter<QStringList>::toCpp(PyObject* pyObj)
{
    return StdListConverter<QStringList>::toCpp(pyObj);
}

inline PyObject* Converter<QStringList>::toPython(const QStringList& cppObj)
{
    return ValueTypeConverter<QStringList>::toPython(cppObj);
}
}
// Conversion rule for: QChar
namespace Shiboken {
inline bool Shiboken::Converter<QChar >::isConvertible(PyObject* pyObj)
{
    return PyObject_TypeCheck(pyObj, SbkType<QChar>())
         || SbkPySide_QtCore_QChar_SpecialCharacter_Check(pyObj)
         || SbkQLatin1Char_Check(pyObj)
         || (PyString_Check(pyObj) && (PyString_Size(pyObj) == 1))
         || PyInt_Check(pyObj);
}

inline QChar Shiboken::Converter<QChar >::toCpp(PyObject* pyObj)
{
    if (!Shiboken_TypeCheck(pyObj, QChar)) {
        if (SbkPySide_QtCore_QChar_SpecialCharacter_Check(pyObj))
            return QChar(Shiboken::Converter<QChar::SpecialCharacter >::toCpp(pyObj));
        else if (SbkQLatin1Char_Check(pyObj))
            return QChar(Shiboken::Converter<QLatin1Char >::toCpp(pyObj));
        else if (PyString_Check(pyObj) && PyString_Size(pyObj) == 1)
            return QChar(Shiboken::Converter<char >::toCpp(pyObj));
        else if (PyInt_Check(pyObj))
            return QChar(Shiboken::Converter<int >::toCpp(pyObj));
    }
    return *Converter<QChar*>::toCpp(pyObj);
}

inline PyObject* Converter<QChar>::toPython(const QChar& cppObj)
{
    return ValueTypeConverter<QChar>::toPython(cppObj);
}
}
// Generated converters implemantations -------------------------------

inline bool Shiboken::Converter<QPointF >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QPointF >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QPointF >());
    return Shiboken::Converter<QPoint & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QPointF Shiboken::Converter<QPointF >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QPointF)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QPointF >());
        if (Shiboken::Converter<QPoint & >::isConvertible(pyobj))
            return QPointF(Shiboken::Converter<QPoint & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QPointF* cptr = reinterpret_cast<QPointF*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QPointF > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QPointF* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QUuid >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QUuid >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QUuid >());
    return Shiboken::Converter<QString & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QUuid Shiboken::Converter<QUuid >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QUuid)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QUuid >());
        if (Shiboken::Converter<QString & >::isConvertible(pyobj))
            return QUuid(Shiboken::Converter<QString & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QUuid* cptr = reinterpret_cast<QUuid*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QUuid > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QUuid* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QFileInfo >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QFileInfo >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QFileInfo >());
    return Shiboken::Converter<QFile & >::isConvertible(pyobj)
         || Shiboken::Converter<QString & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QFileInfo Shiboken::Converter<QFileInfo >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QFileInfo)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QFileInfo >());
        if (Shiboken::Converter<QFile & >::isConvertible(pyobj))
            return QFileInfo(Shiboken::Converter<QFile & >::toCpp(pyobj));
        else if (Shiboken::Converter<QString & >::isConvertible(pyobj))
            return QFileInfo(Shiboken::Converter<QString & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QFileInfo* cptr = reinterpret_cast<QFileInfo*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QFileInfo > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QByteArray >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QByteArray >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QByteArray >());
    return Shiboken::Converter<const char * >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QByteArray Shiboken::Converter<QByteArray >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QByteArray)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QByteArray >());
        if (Shiboken::Converter<const char * >::isConvertible(pyobj))
            return QByteArray(Shiboken::Converter<const char * >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QByteArray* cptr = reinterpret_cast<QByteArray*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QByteArray > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QByteArray* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QStringMatcher >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QStringMatcher >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStringMatcher >());
    return Shiboken::Converter<QString & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QStringMatcher Shiboken::Converter<QStringMatcher >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QStringMatcher)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QStringMatcher >());
        if (Shiboken::Converter<QString & >::isConvertible(pyobj))
            return QStringMatcher(Shiboken::Converter<QString & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QStringMatcher* cptr = reinterpret_cast<QStringMatcher*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QStringMatcher > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QStringMatcher* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QRectF >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QRectF >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QRectF >());
    return Shiboken::Converter<QRect & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QRectF Shiboken::Converter<QRectF >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QRectF)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QRectF >());
        if (Shiboken::Converter<QRect & >::isConvertible(pyobj))
            return QRectF(Shiboken::Converter<QRect & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QRectF* cptr = reinterpret_cast<QRectF*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QRectF > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QRectF* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QEasingCurve >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QEasingCurve >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QEasingCurve >());
    return Shiboken::Converter<QEasingCurve::Type >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QEasingCurve Shiboken::Converter<QEasingCurve >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QEasingCurve)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QEasingCurve >());
        if (Shiboken::Converter<QEasingCurve::Type >::isConvertible(pyobj))
            return QEasingCurve(Shiboken::Converter<QEasingCurve::Type >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QEasingCurve* cptr = reinterpret_cast<QEasingCurve*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QEasingCurve > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QEasingCurve* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QPersistentModelIndex >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QPersistentModelIndex >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QPersistentModelIndex >());
    return Shiboken::Converter<QModelIndex & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QPersistentModelIndex Shiboken::Converter<QPersistentModelIndex >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QPersistentModelIndex)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QPersistentModelIndex >());
        if (Shiboken::Converter<QModelIndex & >::isConvertible(pyobj))
            return QPersistentModelIndex(Shiboken::Converter<QModelIndex & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QPersistentModelIndex* cptr = reinterpret_cast<QPersistentModelIndex*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QPersistentModelIndex > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QPersistentModelIndex* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QLocale >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QLocale >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QLocale >());
    return Shiboken::Converter<QLocale::Language >::isConvertible(pyobj)
         || Shiboken::Converter<QString & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QLocale Shiboken::Converter<QLocale >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QLocale)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QLocale >());
        if (Shiboken::Converter<QLocale::Language >::isConvertible(pyobj))
            return QLocale(Shiboken::Converter<QLocale::Language >::toCpp(pyobj));
        else if (Shiboken::Converter<QString & >::isConvertible(pyobj))
            return QLocale(Shiboken::Converter<QString & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QLocale* cptr = reinterpret_cast<QLocale*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QLocale > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QLocale* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QUrl >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QUrl >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QUrl >());
    return Shiboken::Converter<QString & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QUrl Shiboken::Converter<QUrl >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QUrl)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QUrl >());
        if (Shiboken::Converter<QString & >::isConvertible(pyobj))
            return QUrl(Shiboken::Converter<QString & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QUrl* cptr = reinterpret_cast<QUrl*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QUrl > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QUrl* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QLineF >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QLineF >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QLineF >());
    return Shiboken::Converter<QLine & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QLineF Shiboken::Converter<QLineF >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QLineF)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QLineF >());
        if (Shiboken::Converter<QLine & >::isConvertible(pyobj))
            return QLineF(Shiboken::Converter<QLine & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QLineF* cptr = reinterpret_cast<QLineF*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QLineF > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QLineF* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QSizeF >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QSizeF >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QSizeF >());
    return Shiboken::Converter<QSize & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QSizeF Shiboken::Converter<QSizeF >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QSizeF)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QSizeF >());
        if (Shiboken::Converter<QSize & >::isConvertible(pyobj))
            return QSizeF(Shiboken::Converter<QSize & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QSizeF* cptr = reinterpret_cast<QSizeF*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QSizeF > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QSizeF* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QDir >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QDir >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QDir >());
    return Shiboken::Converter<QString & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QDir Shiboken::Converter<QDir >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QDir)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QDir >());
        if (Shiboken::Converter<QString & >::isConvertible(pyobj))
            return QDir(Shiboken::Converter<QString & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QDir* cptr = reinterpret_cast<QDir*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QDir > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QDir* >::toCpp((PyObject*)pyobj);
}


#endif // SBK_QTCORE_PYTHON_H

