/*
 * This file is part of pwsafe
 *
 * Copyright (C) 2005 HolisTech Limited.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef CRYPTO_H
#define CRYPTO_H

#include <src/interface.h>

void trashMemory(char *start, unsigned int length); /* scrubs from start for length bytes... doesn't free */
void trashFreeMemory(char *start, int length); /* trashMemory, and free it. <0 length=string. */
void read_pwsafe_file(MainView* mainview);  /* parses in the mainview->file_name file */
void write_pwsafe_file(MainView* main); /* saves the data in the recs list into mainview->file_name  */
void close_file(MainView *mainview); /* scrub everything and free it */
void resort_rec(rec *entry); /* resort the record into the list */
rec * add_new_record(gchar *title, gchar *group); /* add a new record to the list with teh specified title */
void delete_rec(rec *arec); /* secure deletes record, removing it from the list */

#endif
