#include "smily.h"

#include <QPainter>
#include <QDebug>
#include <QApplication>

QMap<int, QImage*> Smily::mMap;

void Smily::loadImages()
{
    QImage* image =0 ;

    {
        image = new QImage();
        image->load(":/blue.png");
        mMap[0] = image;
    }

    {
        image = new QImage();
        image->load(":/green.png");
        mMap[1] = image;
    }

    {
        image = new QImage();
        image->load(":/red.png");
        mMap[2] = image;
    }

    {
        image = new QImage();
        image->load(":/purple.png");
        mMap[3] = image;
    }
}

void Smily::unloadImages()
{
    foreach(int i, mMap.keys()) {
        delete mMap.value(i);
    }
    mMap.clear();
}

Smily::Smily( int aColor,BoardPos aBoardPos )
    :mBoardPos(aBoardPos),mColor(aColor),mImage(0)
{
    qDebug() << "Smily::Smily() " << aColor;

    mImage = mMap.value(aColor);    
    mSize = SMILY_SIZE;
    updatePixelPos();    
}

void Smily::fall()
{
    //qDebug() << "Smily::fall()";
    mBoardPos.setRow( mBoardPos.row() + 1 );
    updatePixelPos();    
}

void Smily::slide( int aDirection )
{    
    mBoardPos.setColumn( mBoardPos.column() + aDirection );
    updatePixelPos();
}

void Smily::draw(  QPainter& aPainter)
{    
    aPainter.drawImage( QRect( mPos.x(),mPos.y(), mSize,mSize) , *mImage);
}

bool Smily::animate()
{
    if( mSize > 0 ) {
        mSize -= 20;
        mPos.setX( mPos.x() + ( mSize / 4 ) );
        mPos.setY( mPos.y() + ( mSize / 4 ) );
        return false;
    }
    else {
        return true;
    }
}

