#include "menuwidget.h"

#include <QPushButton>
#include <QVBoxLayout>
#include <QLayout>
#include <QCoreApplication>
#include <QLabel>

MenuWidget::MenuWidget( QWidget* aParent )
    :QWidget(aParent)
{   
    setAttribute(Qt::WA_Maemo5PortraitOrientation, true);

    mStatusLabel = new QLabel(this);
    mStatusLabel->setAlignment(Qt::AlignCenter);

    QPushButton* newGameBtn = new QPushButton("New Game",this);
    mResumeGameBtn = new QPushButton("Resume Game",this);
    mResumeGameBtn->setEnabled( false );
    QPushButton* quitGameBtn = new QPushButton("Quit Game",this);
    QLabel* image = new QLabel(this);
    //image->setPixmap(QPixmap(":/puyo.png"));
    image->setPixmap(QPixmap(":/puyo_title.png"));

    QHBoxLayout* labelLayout = new QHBoxLayout;
    labelLayout->addStretch();
    labelLayout->addWidget( image );
    labelLayout->addStretch();

    QVBoxLayout* btnLayout = new QVBoxLayout(this);
    btnLayout->addStretch();
    btnLayout->addWidget(mStatusLabel);
    btnLayout->addLayout(labelLayout);
    btnLayout->addSpacing(50);
    btnLayout->addWidget(newGameBtn);
    btnLayout->addWidget(mResumeGameBtn);
    btnLayout->addWidget(quitGameBtn);
    btnLayout->addStretch();

    QObject::connect(newGameBtn,SIGNAL(clicked()),this,SIGNAL(newGame()));
    QObject::connect(mResumeGameBtn,SIGNAL(clicked()),this,SIGNAL(resumeGame()));
    QObject::connect(quitGameBtn,SIGNAL(clicked()),QCoreApplication::instance(),SLOT(quit()));

}

void MenuWidget::pauseGame()
{
    mResumeGameBtn->setEnabled(true);
    mStatusLabel->setText("Game Paused");
}

void MenuWidget::gameEnded(int aPoints)
{
    mResumeGameBtn->setEnabled(false);
    mStatusLabel->setText("Game Over!!\n your points="+QString::number(aPoints));
}
