#include "gamewidget.h"

#include "gamewindow.h"
#include <QLabel>
#include <QVBoxLayout>
#include <QHBoxLayout>

GameWidget::GameWidget(QWidget *aParent)
    :QWidget(aParent),mPoints(0)
{
    setupUi();
    this->resize(480,800);
}

void GameWidget::setupUi()
{
    mGameWindow = new GameWindow(this);
    mGameWindow->setFocus();

    QLabel* scoreLabel = new QLabel("Score:");
    scoreLabel->setAlignment(Qt::AlignRight);
    mScoreDisplay = new QLabel("0");
    mScoreDisplay->setAlignment(Qt::AlignLeft);

    QHBoxLayout* labelLayout = new QHBoxLayout;
    labelLayout->addWidget(scoreLabel);
    labelLayout->addWidget(mScoreDisplay);

    QVBoxLayout* labelVLayout = new QVBoxLayout;
    labelVLayout->addStretch();
    labelVLayout->addLayout( labelLayout );
    labelVLayout->addStretch();

    QVBoxLayout* mainLayout = new QVBoxLayout(this);
    mainLayout->addLayout(labelVLayout);
    mainLayout->addStretch(700);

    mGameWindow->setGeometry(QRect(0,80,480,720));

    QObject::connect(mGameWindow,SIGNAL(pauseGame()),this,SIGNAL(pauseGame()));
    QObject::connect(mGameWindow,SIGNAL(gameEnded()),this,SLOT(slotGameEnded()));
    QObject::connect(mGameWindow,SIGNAL(pointsEarned(int)),this,SLOT(pointsEarned(int)));
}


void GameWidget::newGame()
{
    mPoints = 0;
    pointsEarned(mPoints);
    mGameWindow->newGame();
}

void GameWidget::resumeGame()
{
    mGameWindow->resumeGame();
}

void GameWidget::pointsEarned(int aPoints)
{
    mPoints += aPoints;
    mScoreDisplay->setText(QString::number(mPoints));
}

void GameWidget::slotGameEnded()
{
   emit gameEnded( mPoints);
}
