#include <QTest>
#include "basicunittests.h"
#include "graphicsstroke.h"

BasicUnitTests::BasicUnitTests(QObject *parent)
    : QObject(parent)
{
}

BasicUnitTests::~BasicUnitTests()
{

}

void BasicUnitTests::stroke_save_load(){
    QString xml = "<stroke points=\"149,9 149,10 150,13 151,14 153,17 157,22 161,28 165,36 170,43 175,51 180,58 184,66 190,74 194,84 199,92 204,101 208,109 211,117 215,123 216,124 217,126 218,128 220,130 220,131 221,133 222,134 223,136 224,138 225,140 226,142 227,143 228,144 228,145\"/>";

    QDomDocument doc;
    QVERIFY (doc.setContent(xml) );

    QDomElement elem = doc.firstChildElement("stroke");
    QString input_points = elem.attribute("points","");

    GraphicsStroke *stroke = new GraphicsStroke();

    QVERIFY (stroke->setFromDomElement(elem) );

    elem = stroke->createDomElement(doc);

    QVERIFY(!elem.isNull());

    QString output_points = elem.attribute("points","");

    QCOMPARE(output_points,input_points);

    delete stroke;
}
